/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import org.apache.commons.lang3.StringUtils;

public class CommOrgRelationPlugin
extends HRDataBaseEdit
implements AfterF7SelectListener {
    private static final Log logger = LogFactory.getLog(CommOrgRelationPlugin.class);
    private static final String COMM_CLOSE = "commClose";
    private static final String CERTIFICATION_CLOSE = "certificationClose";
    private static final String BUTTON_AP = "buttonap";
    private static final String CERT_LABEL = "certlabel";
    private static final String COMM_LABEL = "commlabel";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"certificationgroup", "commmember", BUTTON_AP});
        BasedataEdit commOrgBase = (BasedataEdit)this.getControl("commorgbase");
        commOrgBase.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long commOrgId = HRJSONUtils.getLongValOfCustomParam((Object)formShowParameter.getCustomParam("commOrgId"));
        if (commOrgId == null || commOrgId.equals(0L)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4e13\u59d4\u4f1a\u4fe1\u606f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"CommOrgRelationPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().getPageCache().put("commOrgId", String.valueOf(commOrgId));
        }
        String commOrg = (String)formShowParameter.getCustomParam("commOrgName");
        Label commOrgLabel = (Label)this.getView().getControl("commorg");
        commOrgLabel.setText(commOrg);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String clickItem = (String)formShowParameter.getCustomParam("clickItem");
        this.createBaseListShowParameter(clickItem);
    }

    private void createBaseListShowParameter(String clickItem) {
        Long commOrgId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getPageCache().get("commOrgId"));
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (HRStringUtils.equals((String)clickItem, (String)"certificationgroup")) {
            tab.activeTab("certificationgroup");
        } else {
            tab.activeTab("commmember");
        }
        this.setParameter(commOrgId, "tdcs_certificationgroup", new CloseCallBack((IFormPlugin)this, CERTIFICATION_CLOSE), "commOrgId", new QFilter("commorg", "=", (Object)commOrgId), "certificationgroup");
        this.setParameter(commOrgId, "tdcs_commorguser", new CloseCallBack((IFormPlugin)this, COMM_CLOSE), "commOrgId", new QFilter("comm", "=", (Object)commOrgId), "commmember");
    }

    private void setParameter(Long commOrgId, String billFormId, CloseCallBack closeCallBack, String customParamKey, QFilter filter, String targetKey) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setBillFormId(billFormId);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParam(customParamKey, (Object)commOrgId);
        showParameter.getListFilterParameter().setFilter(filter);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String closeData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsAny((CharSequence)actionId, (CharSequence[])new CharSequence[]{COMM_CLOSE, CERTIFICATION_CLOSE}) && closedCallBackEvent.getReturnData() != null && HRStringUtils.equals((String)(closeData = (String)closedCallBackEvent.getReturnData()), (String)"CommOrgUserClose")) {
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String itemKey = source.getKey();
        if (HRStringUtils.equals((String)"certificationgroup", (String)itemKey) || HRStringUtils.equals((String)"commmember", (String)itemKey)) {
            this.createBaseListShowParameter(itemKey);
        }
        if (HRStringUtils.equals((String)itemKey, (String)BUTTON_AP)) {
            BasedataEdit commOrgBase = (BasedataEdit)this.getControl("commorgbase");
            commOrgBase.click();
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        ListSelectedRow listSelectedRow = afterF7SelectEvent.getListSelectedRow();
        this.getView().getPageCache().put("commOrgId", String.valueOf(listSelectedRow.getPrimaryKeyValue()));
        Label commOrgLabel = (Label)this.getView().getControl("commorg");
        commOrgLabel.setText(listSelectedRow.getName() + '(' + listSelectedRow.getNumber() + ')');
        this.createBaseListShowParameter(null);
    }
}

