/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CommFrameApplicationService;
import kd.tdc.tdcs.bussiness.application.CommOrgApplicationService;
import kd.tdc.tdcs.bussiness.formservice.comm.CommOrgService;
import kd.tdc.tdcs.common.bo.NodeBo;
import kd.tdc.tdcs.common.util.CommUtils;
import kd.tdc.tdcs.common.util.TreeViewHelper;

public class CommOrgStdTreeListPlugin
extends StandardTreeListPlugin
implements TreeNodeClickListener {
    private Map<String, String> existsOrgCommFrameIdMap = new HashMap<String, String>(16);
    private List<NodeBo> commFrameBolist = new ArrayList<NodeBo>(16);
    private Map<String, List<NodeBo>> fartherNodeListMap = new HashMap<String, List<NodeBo>>(16);
    private final CommOrgApplicationService commOrgApplicationService = (CommOrgApplicationService)ServiceFactory.getService(CommOrgApplicationService.class);
    private final CommFrameApplicationService commFrameApplicationService = (CommFrameApplicationService)ServiceFactory.getService(CommFrameApplicationService.class);
    private final CommOrgService commOrgService = (CommOrgService)ServiceFactory.getService(CommOrgService.class);

    public void initializeTree(EventObject args) {
        this.refreshCommOrgLeftTree();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("refresh".equals(operateKey)) {
            this.refreshCommOrgLeftTree();
            if (this.getTreeListView().getTreeModel().getRoot() != null) {
                this.getTreeListView().getTreeModel().getRoot().setId(null);
            }
        }
    }

    public boolean isSameCommFrameId() {
        IPageCache pageCache = this.getView().getPageCache();
        String cacheFrameIdList = pageCache.get("commFrameIdList");
        IFormView view = this.getView();
        String billFormId = "";
        if (view instanceof ListView) {
            billFormId = ((ListView)this.getView()).getBillFormId();
        }
        return this.commOrgService.isSameCommFrameId(cacheFrameIdList, billFormId);
    }

    private TreeNode refreshCommOrgLeftTree() {
        IPageCache pageCache = this.getView().getPageCache();
        Map<String, NodeBo> commFrameIdMaps = this.getCommFrameIdMap();
        if (CollectionUtils.isEmpty(commFrameIdMaps)) {
            TreeView treeview = (TreeView)this.getControl("treeview");
            treeview.deleteAllNodes();
            pageCache.put("commFrameIdList", null);
            return new TreeNode();
        }
        Set commFrameIdSet = commFrameIdMaps.keySet().stream().map(Long::parseLong).collect(Collectors.toSet());
        pageCache.put("commFrameIdList", SerializationUtils.serializeToBase64(commFrameIdSet));
        DynamicObject[] dynamicObjects = this.commOrgApplicationService.queryCommFramJobData(commFrameIdSet);
        if (pageCache.get("minCommOrgTypeId") == null) {
            CommUtils.getMinCommOrtTypeIdAndNum((IFormView)this.getView());
        }
        this.parseDynamicObjects(dynamicObjects, pageCache);
        for (Map.Entry<String, NodeBo> frame : commFrameIdMaps.entrySet()) {
            if (this.existsOrgCommFrameIdMap.get(frame.getKey()) != null) continue;
            this.commFrameBolist.add(frame.getValue());
        }
        this.commFrameBolist = this.commFrameBolist.stream().sorted(Comparator.comparing(NodeBo::getParentNumber)).collect(Collectors.toList());
        TreeViewHelper treeViewHelper = new TreeViewHelper(this.getTreeModel(), this.commFrameBolist, this.fartherNodeListMap);
        TreeView treeview = (TreeView)this.getControl("treeview");
        if (this.getTreeModel().getRoot() != null) {
            List treeNodeList = this.getTreeModel().getRoot().getChildren();
            ArrayList<String> nodeIds = new ArrayList<String>(16);
            if (!CollectionUtils.isEmpty((Collection)treeNodeList)) {
                for (TreeNode node : treeNodeList) {
                    nodeIds.add(node.getId());
                }
                treeview.deleteNodes(nodeIds);
            }
        }
        TreeNode treeNode = treeViewHelper.initTreeView();
        treeview.addNodes(treeNode.getChildren());
        String mapString = SerializationUtils.toJsonString(this.fartherNodeListMap);
        pageCache.put("treeListMap", mapString);
        String treeNodeStr = SerializationUtils.toJsonString((Object)treeNode.getChildren());
        pageCache.put("treeNodeString", treeNodeStr);
        String allTreeNodeStr = SerializationUtils.toJsonString((Object)treeNode);
        pageCache.put("allTreeNodeString", allTreeNodeStr);
        return treeNode;
    }

    public void afterCreateNewData(EventObject eventObject) {
        String treeListMapStr = this.getView().getPageCache().get("treeNodeString");
        if (StringUtils.isEmpty((Object)treeListMapStr)) {
            return;
        }
        List treeNodes = SerializationUtils.fromJsonStringToList((String)treeListMapStr, TreeNode.class);
        TreeView treeView = (TreeView)this.getControl("treeview");
        if ("tdcs_commorgtreelist".equals(this.getView().getEntityId()) && treeNodes.size() > 0) {
            Object id = this.getView().getFormShowParameter().getCustomParams().get("id");
            if (id != null) {
                List collect = treeNodes.stream().filter(treeNode -> treeNode.getId().equalsIgnoreCase(id.toString())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    treeView.setRootVisible(true);
                    treeView.focusNode(this.getTreeModel().getRoot());
                } else {
                    treeView.focusNode((TreeNode)collect.get(0));
                }
            } else {
                treeView.setRootVisible(true);
                treeView.focusNode(this.getTreeModel().getRoot());
            }
        }
        IPageCache pageCache = this.getView().getPageCache();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (StringUtils.isEmpty((Object)pageCache.get("id")) && customParams.get("id") != null) {
            pageCache.put("id", customParams.get("id").toString());
        }
        if (StringUtils.isEmpty((Object)pageCache.get("framejobscmId")) && customParams.get("framejobscmId") != null) {
            pageCache.put("framejobscmId", customParams.get("framejobscmId").toString());
        }
    }

    private Map<String, NodeBo> getCommFrameIdMap() {
        DynamicObject[] dynamicObjects;
        HashMap<String, NodeBo> commFrameIdMaps = new HashMap<String, NodeBo>(16);
        IFormView view = this.getView();
        String billFormId = "";
        if (view instanceof ListView) {
            billFormId = ((ListView)this.getView()).getBillFormId();
        }
        for (DynamicObject dynamicObject : dynamicObjects = this.commOrgApplicationService.queryAllCommFrame(billFormId)) {
            String frameId = dynamicObject.getString("id");
            NodeBo nodeBo = new NodeBo(frameId, dynamicObject.getString("name"), dynamicObject.getString("number"));
            commFrameIdMaps.put(frameId, nodeBo);
        }
        return commFrameIdMaps;
    }

    private void parseDynamicObjects(DynamicObject[] dynamicObjects, IPageCache pageCache) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection dynamicObjectCollection;
            String commOrgTypeId = CommUtils.parseId((DynamicObject)dynamicObject, (String)"commorgtype");
            NodeBo bo = new NodeBo();
            if (commOrgTypeId.equals(pageCache.get("minCommOrgTypeId"))) {
                bo.setParentId(String.valueOf(CommUtils.parseId((DynamicObject)dynamicObject, (String)"commframe")));
                bo.setParentName(CommUtils.parseName((DynamicObject)dynamicObject, (String)"commframe"));
                bo.setParentNumber(dynamicObject.getDynamicObject("commframe").getString("number"));
                bo.setName(dynamicObject.getString("name"));
                bo.setId(String.valueOf(dynamicObject.getString("id")));
                if (this.fartherNodeListMap.get(bo.getParentId()) == null) {
                    this.commFrameBolist.add(bo);
                    this.existsOrgCommFrameIdMap.put(bo.getParentId(), bo.getParentId());
                }
                CommUtils.setFatherNodeListMap((NodeBo)bo, this.fartherNodeListMap);
            }
            if ((dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("parentcomm")) == null || dynamicObjectCollection.size() < 1) continue;
            for (DynamicObject dynaObject : dynamicObjectCollection) {
                DynamicObject object = (DynamicObject)dynaObject.get("fbasedataid");
                if (object == null) continue;
                bo.setParentId(object.getString("id"));
                bo.setParentName(object.getString("name"));
                bo.setParentNumber(object.getString("number"));
                bo.setName(dynamicObject.getString("name"));
                bo.setId(String.valueOf(dynamicObject.getString("id")));
                CommUtils.setFatherNodeListMap((NodeBo)bo, this.fartherNodeListMap);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (!this.isSameCommFrameId()) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u201c\u4e13\u59d4\u4f1a\u67b6\u6784\u201d\u6743\u9650\u6216\u6570\u636e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CommOrgStdTreeListPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            return;
        }
        String nodeId = evt.getNodeId().toString();
        String parentId = evt.getParentNodeId().toString();
        if (StringUtils.isEmpty((Object)nodeId)) {
            return;
        }
        String treeListMapStr = this.getView().getPageCache().get("treeNodeString");
        if (StringUtils.isEmpty((Object)treeListMapStr)) {
            return;
        }
        List treeNodes = SerializationUtils.fromJsonStringToList((String)treeListMapStr, TreeNode.class);
        Set frameIdSet = treeNodes.stream().map(TreeNode::getId).collect(Collectors.toSet());
        if (frameIdSet.contains(nodeId)) {
            this.setFrameIdAndJobScmId(nodeId);
            this.getView().getPageCache().put("orgTypeId", null);
        } else if (!(nodeId.equals(this.getTreeModel().getRoot().getId()) || "null".equalsIgnoreCase(nodeId) || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(nodeId))) {
            DynamicObject dynamicObject = this.commOrgApplicationService.queryOneCommOrg(Long.valueOf(Long.parseLong(nodeId)));
            if (dynamicObject != null) {
                String orgTypeId = dynamicObject.getString("commorgtype_id");
                this.getView().getPageCache().put("orgTypeId", orgTypeId);
                this.setFrameIdAndJobScmId(dynamicObject.getString("commframe_id"));
            }
        } else if (nodeId.equals(this.getTreeModel().getRoot().getId()) || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(nodeId)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("id", null);
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("id", null);
        }
        this.getView().getPageCache().put("clickId", nodeId);
        this.getView().getPageCache().put("treeParentId", parentId);
    }

    private void setFrameIdAndJobScmId(String frameId) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("id", frameId);
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("id", frameId);
        DynamicObject commFrameObj = this.commFrameApplicationService.getCommFrameById((Object)Long.parseLong(frameId))[0];
        DynamicObjectCollection framejobscm = commFrameObj.getDynamicObjectCollection("framejobscm");
        if (!CollectionUtils.isEmpty((Collection)framejobscm)) {
            String jobScmIds = CommUtils.appendMulitBaseId((DynamicObjectCollection)framejobscm, (String)";");
            pageCache.put("framejobscmId", jobScmIds);
            customParams.put("framejobscmId", jobScmIds);
        }
    }
}

