/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.commorguser.service.CommOrgUserDomainService;

public class CommOrgUserPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private final CommOrgUserDomainService commOrgUserService = (CommOrgUserDomainService)ServiceFactory.getService(CommOrgUserDomainService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit commRole = (BasedataEdit)this.getControl("commrole");
        commRole.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bosUser = (BasedataEdit)this.getControl("bosuser");
        bosUser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Object commOrg = this.getView().getFormShowParameter().getCustomParam("commOrgId");
        if (commOrg != null) {
            this.getModel().setValue("comm", commOrg);
        }
        this.showIsEmp();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.EDIT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
        }
        this.commOrgUserService.checkNameIsChange(Long.valueOf(this.getModel().getDataEntity().getLong("id")));
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean changePage = this.isChangePage();
        if (changePage) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"isemp", "person"});
            DynamicObjectCollection roleObjs = this.getModel().getEntryEntity("roleentry");
            for (int i = 0; i < roleObjs.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"commrole", "ismain", "roleeffectdate"});
            }
            this.getView().getPageCache().put("roleEntryNum", String.valueOf(roleObjs.size()));
        }
    }

    private boolean isChangePage() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object fromPageValue = customParams.get("fromPage");
        return fromPageValue != null && "fromHisAction".equals(fromPageValue.toString());
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"isemp")) {
            this.showIsEmp();
        }
    }

    private void showIsEmp() {
        boolean isEmp = HRStringUtils.equals((String)((String)this.getModel().getValue("isemp")), (String)"1");
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(isEmp), new String[]{"person"});
        view.setVisible(Boolean.valueOf(!isEmp), new String[]{"name", "phonenum", "email", "country", "bosuser"});
        if (isEmp) {
            this.getModel().setValue("name", null);
            this.getModel().setValue("phonenum", null);
            this.getModel().setValue("email", null);
            this.getModel().setValue("country", null);
            this.getModel().setValue("bosuser", null);
        } else {
            this.getModel().setValue("person", null);
        }
        BasedataEdit person = (BasedataEdit)view.getControl("person");
        TextEdit name = (TextEdit)view.getControl("name");
        TextEdit phone = (TextEdit)view.getControl("phonenum");
        person.setMustInput(isEmp);
        name.setMustInput(!isEmp);
        phone.setMustInput(!isEmp);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs args) {
        boolean changePage = this.isChangePage();
        if (changePage) {
            int[] rowIndexs = args.getRowIndexs();
            Integer oldNum = Integer.parseInt(this.getView().getPageCache().get("roleEntryNum"));
            for (int i : rowIndexs) {
                if (i > oldNum - 1) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u5df2\u5b58\u5728\u7684\u4e13\u59d4\u4f1a\u89d2\u8272\u3002", (String)"CommOrgUserPlugin_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection roleentry;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("save".equals(opKey) && (roleentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("roleentry")).isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u4e3a\u6210\u5458\u5206\u914d\u81f3\u5c11\u4e00\u4e2a\u89d2\u8272\u3002", (String)"CommOrgUserPlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean success;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        boolean bl = success = args.getOperationResult() == null || args.getOperationResult().isSuccess();
        if (success && operateKey.equals("newentry")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("roleentry");
            if (rowIndex != 0) {
                this.getModel().setValue("ismain", (Object)"0", rowIndex);
            } else {
                this.getModel().setValue("ismain", (Object)"1", rowIndex);
            }
        } else if (success && operateKey.equals("save")) {
            this.getView().updateView();
        }
        if (("confirmchangenoaudit".equals(operateKey) || "confirmchange".equals(operateKey)) && args.getOperationResult().isSuccess()) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"hisversionbtn"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListFilterParameter listFilterParameter;
        ListShowParameter showParameter;
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"commrole")) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listFilterParameter = showParameter.getListFilterParameter();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("roleentry");
            Date now = HRDateTimeUtils.dateFormatDate((Date)new Date());
            List commRoleId = entryEntity.stream().filter(d -> d.getDate("roleexpiredate") == null || now.compareTo(d.getDate("roleexpiredate")) <= 0).map(item -> item.getLong("commrole.id")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "not in", commRoleId);
            listFilterParameter.getQFilters().add(qFilter);
            DynamicObject comm = (DynamicObject)this.getModel().getValue("comm");
            if (comm != null) {
                QFilter currentCommFilter = new QFilter("commorg.fbasedataid", "in", (Object)Lists.newArrayList((Object[])new Long[]{comm.getLong("id")}));
                QFilter allFilter = new QFilter("commorg.fbasedataid", "is null", null);
                QFilter commFilter = currentCommFilter.or(allFilter);
                listFilterParameter.getQFilters().add(commFilter);
            }
        }
        if (HRStringUtils.equals((String)name, (String)"bosuser")) {
            showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listFilterParameter = showParameter.getListFilterParameter();
            QFilter qFilter = new QFilter("source", "!=", (Object)"HR");
            listFilterParameter.getQFilters().add(qFilter);
        }
    }
}

