/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.certgroup.service.CertGroupDomainService;
import kd.tdc.tdcs.bussiness.domain.commorguser.enums.CommUserStatusEnum;
import kd.tdc.tdcs.bussiness.domain.commorguser.service.CommOrgUserDomainService;

public class CommUserDisabledPlugin
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(CommUserDisabledPlugin.class);
    private static final String BTN_OK = "btnok";
    private final CommOrgUserDomainService commOrgUserDomainService = (CommOrgUserDomainService)ServiceFactory.getService(CommOrgUserDomainService.class);
    private final CertGroupDomainService certGroupDomainService = (CertGroupDomainService)ServiceFactory.getService(CertGroupDomainService.class);

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String minDateStr = (String)formShowParameter.getCustomParam("minDate");
        String maxDateStr = (String)formShowParameter.getCustomParam("maxDate");
        Date minDate = null;
        Date maxDate = null;
        try {
            minDate = HRDateTimeUtils.parseDate((String)minDateStr);
            if (maxDateStr != null) {
                maxDate = HRDateTimeUtils.parseDate((String)maxDateStr);
            }
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
        }
        DateEdit dateEdit = (DateEdit)this.getControl("disableddate");
        if (minDate != null) {
            dateEdit.setMinDate(minDate);
        }
        if (maxDate != null) {
            dateEdit.setMaxDate(maxDate);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperationResult disabled;
        boolean success;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)BTN_OK) && !(success = (disabled = this.getView().getParentView().invokeOperation("rightofdisabled")).isSuccess())) {
            args.setCancel(true);
            this.getView().showErrorNotification(((OperateErrorInfo)((ValidateResult)disabled.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (HRStringUtils.equals((String)afterDoOperationEventArgs.getOperateKey(), (String)BTN_OK) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            List selectIds = (List)this.getView().getFormShowParameter().getCustomParam("selectIds");
            DynamicObject[] commOrgUsers = this.commOrgUserDomainService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)selectIds)});
            if (commOrgUsers.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\uff0c\u6267\u884c\u5931\u8d25\u3002", (String)"CommUserDisabledPlugin_4", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<DynamicObject> successList = new ArrayList<DynamicObject>(commOrgUsers.length);
            ArrayList<HisVersionParamBo> commUserHisList = new ArrayList<HisVersionParamBo>(commOrgUsers.length);
            ArrayList<String> failMsgList = new ArrayList<String>(commOrgUsers.length);
            for (DynamicObject commOrgUser : commOrgUsers) {
                String userStatus = commOrgUser.getString("userstatus");
                String userName = commOrgUser.getString("name");
                if (HRStringUtils.equals((String)userStatus, (String)"0") || HRStringUtils.equals((String)userStatus, (String)"00")) {
                    failMsgList.add(ResManager.loadKDString((String)"{0}\uff1a\u6210\u5458\u5df2\u9000\u51fa\uff0c\u4e0d\u53ef\u91cd\u590d\u64cd\u4f5c\u3002", (String)"CommUserDisabledPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{userName}));
                    continue;
                }
                List sortedRoleObjs = commOrgUser.getDynamicObjectCollection("roleentry").stream().sorted(Comparator.comparing(r -> r.getDate("roleeffectdate"))).collect(Collectors.toList());
                Date minRoleEffectDate = ((DynamicObject)sortedRoleObjs.get(0)).getDate("roleeffectdate");
                commOrgUser.set("bsed", (Object)minRoleEffectDate);
                Date disabledDate = HRDateTimeUtils.truncateDate((Date)((Date)this.getModel().getValue("disableddate")));
                Date nowTime = new Date();
                if (minRoleEffectDate.compareTo(disabledDate) <= 0) {
                    Date nowDate = HRDateTimeUtils.truncateDate((Date)nowTime);
                    if (disabledDate.compareTo(nowDate) <= 0) {
                        commOrgUser.set("userstatus", (Object)CommUserStatusEnum.EXIT.getNumber());
                    }
                    DynamicObjectCollection roleCollection = commOrgUser.getDynamicObjectCollection("roleentry");
                    for (DynamicObject roleObj : roleCollection) {
                        Date roleExpireDate = roleObj.getDate("roleexpiredate");
                        if (roleExpireDate != null && roleExpireDate.compareTo(nowDate) <= 0) continue;
                        roleObj.set("roleexpiredate", (Object)disabledDate);
                    }
                    commOrgUser.set("brled", (Object)nowTime);
                    commOrgUser.set("modifytime", (Object)nowTime);
                    commOrgUser.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    commOrgUser.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
                    commOrgUser.set("quitdate", (Object)disabledDate);
                    successList.add(commOrgUser);
                    HisVersionParamBo bo = new HisVersionParamBo();
                    bo.setEntityNumber("tdcs_commorguser");
                    bo.setHisDyns(new DynamicObject[]{commOrgUser});
                    commUserHisList.add(bo);
                    continue;
                }
                failMsgList.add(ResManager.loadKDString((String)"{0}\uff1a\u9000\u51fa\u65e5\u671f\u65e9\u4e8e\u89d2\u8272\u6700\u65e9\u751f\u6548\u65e5\u671f\u3002", (String)"CommUserDisabledPlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{userName}));
            }
            if (successList.size() > 0) {
                this.commOrgUserDomainService.saveComUserHisVersion(commUserHisList, "tdcs_commorguser");
            }
            if (!CollectionUtils.isEmpty(successList)) {
                DynamicObject commOrgUser = (DynamicObject)successList.get(0);
                HashMap<Long, ArrayList> certmemberMap = new HashMap<Long, ArrayList>(4);
                certmemberMap.put(commOrgUser.getDynamicObject("comm").getLong("id"), Lists.newArrayList((Object[])new Long[]{commOrgUser.getLong("boid")}));
                this.certGroupDomainService.quit(certmemberMap);
            }
            this.showSimpleDisabledMsg(failMsgList);
        }
    }

    private void showSimpleDisabledMsg(List<String> failMsgList) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (!CollectionUtils.isEmpty(failMsgList)) {
            result.put("result", Boolean.FALSE);
            result.put("msg", failMsgList.get(0));
        } else {
            result.put("result", Boolean.TRUE);
            result.put("msg", ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"CommUserDisabledPlugin_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
        }
        this.getView().returnDataToParent(result);
    }
}

