/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;

public class EducationPlugin
extends HRCoreBaseBillList {
    private static final String EDUCATION = "education";
    private static final String DEGREE = "degree";
    private static final String MAJOR = "major";
    private static final String IS_FULL_TIME = "isfulltime";
    private static final String IS_HIGHEST_DEGREE = "ishighestdegree";
    private static final String ADMISSION_DATE = "admissiondate";
    private static final String GRADUATION_DATE = "gradutiondate";
    private static final String GRADUATE_SCHOOL = "graduateschool";
    private static final String FORM_PLUGIN = "tdc-tdcs-formplugin";
    private static final Log logger = LogFactory.getLog(EducationPlugin.class);
    private static final List<String> labelList = Arrays.asList("admissiondate", "gradutiondate", "graduateschool", "ishighestdegree", "isfulltime", "major", "education", "degree");

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = (Long)formShowParameter.getCustomParam("person");
        this.showEducationInfo(personId);
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    private void showEducationInfo(long personId) {
        List<Map<String, String>> list = this.getEducationInfo(personId);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List sortedList = list.stream().sorted((a, b) -> ((String)b.get(ADMISSION_DATE)).compareTo((String)a.get(ADMISSION_DATE))).collect(Collectors.toList());
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", sortedList.size());
        for (int i = 0; i < sortedList.size(); ++i) {
            for (String s : labelList) {
                this.getModel().setValue(s, ((Map)sortedList.get(i)).get(s), rowIndex[i]);
                int showLineInt = sortedList.size() == 1 ? 1 : sortedList.size() - 1 - i;
                this.getModel().setValue("isshowline", (Object)showLineInt, rowIndex[i]);
            }
        }
    }

    private List<Map<String, String>> getEducationInfo(long personId) {
        List result = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listPersonAttachs", (Object[])new Object[]{personId, "hrpi_pereduexp"});
        logger.info("hrpi-->IHRPIPersonService-->listPersonAttachs,personId:{},result:{}", (Object)personId, (Object)result);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(result.size());
        for (Map resultMap : result) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(ADMISSION_DATE, resultMap.get(ADMISSION_DATE) == null ? "" : HRDateTimeUtils.format((Date)((Date)resultMap.get(ADMISSION_DATE)), (String)"yyyy-MM-dd"));
            map.put(GRADUATION_DATE, resultMap.get(GRADUATION_DATE) == null ? "" : HRDateTimeUtils.format((Date)((Date)resultMap.get(GRADUATION_DATE)), (String)"yyyy-MM-dd"));
            map.put(GRADUATE_SCHOOL, resultMap.get(GRADUATE_SCHOOL) == null ? "" : resultMap.get(GRADUATE_SCHOOL).toString());
            if ("1".equals(resultMap.get(IS_HIGHEST_DEGREE))) {
                map.put(IS_HIGHEST_DEGREE, ResManager.loadKDString((String)"\u6700\u9ad8\u5b66\u5386", (String)"EducationPlugin_0", (String)FORM_PLUGIN, (Object[])new Object[0]));
            } else {
                map.put(IS_HIGHEST_DEGREE, "0");
            }
            if ("1".equals(resultMap.get(IS_FULL_TIME))) {
                map.put(IS_FULL_TIME, ResManager.loadKDString((String)"\u5168\u65e5\u5236", (String)"EducationPlugin_1", (String)FORM_PLUGIN, (Object[])new Object[0]));
            } else {
                map.put(IS_FULL_TIME, "0");
            }
            map.put(MAJOR, resultMap.get(MAJOR) == null ? "" : resultMap.get(MAJOR).toString());
            map.put(EDUCATION, resultMap.get(EDUCATION) == null ? "" : resultMap.get(EDUCATION).toString());
            map.put(DEGREE, resultMap.get(DEGREE) == null ? "" : resultMap.get(DEGREE).toString());
            list.add(map);
        }
        return list;
    }
}

