/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;

public class EmpPosOrgRelPlugin
extends HRCoreBaseBillList {
    private static final String FORM_PLUGIN = "tdc-tdcs-formplugin";
    private static final String HRPI_EMPPOSORGREL = "hrpi_empposorgrel";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String START_PROBATION = "startprobation";
    private static final String END_PROBATION = "endprobation";
    private static final String COMPANY = "company";
    private static final String ADMIN_ORG = "adminorg";
    private static final String POSITION = "position";
    private static final String JOB = "job";
    private static final String WORKPLACE = "workplace";
    private static final String POS_TYPE = "postype";
    private static final String POS_STATUS = "posstatus";
    private static final String IS_PRIMARY = "isprimary";
    private static final List<String> labelList = Arrays.asList("startdate", "enddate", "company", "adminorg", "position", "job", "isprimary", "postype", "posstatus", "workplace", "startprobation", "endprobation");

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long employeeId = (Long)formShowParameter.getCustomParam("employee");
        this.getView().setStatus(OperationStatus.VIEW);
        this.showEmpPosOrgRelInfo(employeeId);
        this.getModel().setDataChanged(false);
    }

    private void showEmpPosOrgRelInfo(long employeeId) {
        List<Map<String, String>> list = this.getEmpPosOrgRelInfo(employeeId);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List sortedList = list.stream().sorted((a, b) -> ((String)b.get(START_DATE)).compareTo((String)a.get(START_DATE))).collect(Collectors.toList());
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", sortedList.size());
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        for (int i = 0; i < sortedList.size(); ++i) {
            for (String s : labelList) {
                if (((Map)sortedList.get(i)).get(s) == null) {
                    cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{s});
                } else {
                    this.getModel().setValue(s, ((Map)sortedList.get(i)).get(s), rowIndex[i]);
                }
                int showLineInt = sortedList.size() == 1 ? 1 : sortedList.size() - 1 - i;
                this.getModel().setValue("isshowline", (Object)showLineInt, rowIndex[i]);
            }
        }
        this.getView().updateView("entryentity");
    }

    private List<Map<String, String>> getEmpPosOrgRelInfo(long employeeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(HRPI_EMPPOSORGREL);
        QFilter qFilterPersonId = new QFilter("employee", "=", (Object)employeeId);
        QFilter qFilterIsCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter qFilterDataStatus = new QFilter("datastatus", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilterPersonId, qFilterIsCurrentVersion, qFilterDataStatus};
        String selectFiled = "startdate,enddate,company,adminorg,position,job,isprimary,postype,posstatus,workplace,startprobation,endprobation";
        DynamicObject[] result = helper.query(selectFiled, qFilters);
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(result.length);
        for (DynamicObject dynamicObject : result) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(START_DATE, dynamicObject.get(START_DATE) == null ? "" : HRDateTimeUtils.format((Date)dynamicObject.getDate(START_DATE), (String)"yyyy-MM-dd"));
            map.put(END_DATE, dynamicObject.get(END_DATE) == null ? "" : HRDateTimeUtils.format((Date)dynamicObject.getDate(END_DATE), (String)"yyyy-MM-dd"));
            map.put(START_PROBATION, dynamicObject.get(START_PROBATION) == null ? "" : HRDateTimeUtils.format((Date)dynamicObject.getDate(START_PROBATION), (String)"yyyy-MM-dd"));
            map.put(END_PROBATION, dynamicObject.get(END_PROBATION) == null ? "" : HRDateTimeUtils.format((Date)dynamicObject.getDate(END_PROBATION), (String)"yyyy-MM-dd"));
            DynamicObject company = (DynamicObject)dynamicObject.get(COMPANY);
            map.put(COMPANY, company == null ? "" : company.getString("name"));
            DynamicObject adminOrg = (DynamicObject)dynamicObject.get(ADMIN_ORG);
            map.put(ADMIN_ORG, adminOrg == null ? "" : adminOrg.getString("name"));
            DynamicObject position = (DynamicObject)dynamicObject.get(POSITION);
            map.put(POSITION, position == null ? "" : position.getString("name"));
            DynamicObject job = (DynamicObject)dynamicObject.get(JOB);
            map.put(JOB, job == null ? "" : job.getString("name"));
            DynamicObject workplace = (DynamicObject)dynamicObject.get(WORKPLACE);
            map.put(WORKPLACE, workplace == null ? "" : workplace.getString("name"));
            DynamicObject posType = (DynamicObject)dynamicObject.get(POS_TYPE);
            map.put(POS_TYPE, posType == null ? "" : posType.getString("name"));
            DynamicObject posStatus = (DynamicObject)dynamicObject.get(POS_STATUS);
            map.put(POS_STATUS, posStatus == null ? "" : posStatus.getString("name"));
            String isPrimary = dynamicObject.getString(IS_PRIMARY);
            if ("1".equals(isPrimary)) {
                map.put(IS_PRIMARY, ResManager.loadKDString((String)"\u4e3b\u4efb\u804c", (String)"EmpPosOrgRelPlugin_0", (String)FORM_PLUGIN, (Object[])new Object[0]));
            }
            list.add(map);
        }
        return list;
    }
}

