/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;

public class EmpTrainPlugin
extends HRCoreBaseBillList {
    private static final ExternalService EXTERNAL_SERVICE = (ExternalService)ServiceFactory.getService(ExternalService.class);
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String IS_INNER_TRAINING = "isinnertraining";
    private static final String TRAIN_TYPE = "traintype";
    private static final String TRAIN_MODE = "trainmode";
    private static final String TRAINING_CERTIFICATE = "trainingcertificate";
    private static final String PERIOD = "period";
    private static final String CLASS_HOUR = "classhour";
    private static final List<String> labelList = Arrays.asList("startdate", "enddate", "name", "isinnertraining", "trainmode", "trainingcertificate", "period", "classhour");

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = (Long)formShowParameter.getCustomParam("person");
        this.showTrainInfo(personId);
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    private void showTrainInfo(long personId) {
        List<Map<String, String>> list = this.getTrainInfo(personId);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List sortedList = list.stream().sorted((a, b) -> ((String)b.get(START_DATE)).compareTo((String)a.get(START_DATE))).collect(Collectors.toList());
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", sortedList.size());
        for (int i = 0; i < sortedList.size(); ++i) {
            for (String s : labelList) {
                this.getModel().setValue(s, ((Map)sortedList.get(i)).get(s), rowIndex[i]);
                int showLineInt = sortedList.size() == 1 ? 1 : sortedList.size() - 1 - i;
                this.getModel().setValue("isshowline", (Object)showLineInt, rowIndex[i]);
            }
        }
    }

    private List<Map<String, String>> getTrainInfo(long personId) {
        List result = EXTERNAL_SERVICE.getEmpTrainInfo(personId);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(result.size());
        for (Map dynamicObject : result) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(START_DATE, dynamicObject.get(START_DATE) == null ? "" : HRDateTimeUtils.format((Date)((Date)dynamicObject.get(START_DATE)), (String)"yyyy-MM-dd"));
            map.put(END_DATE, dynamicObject.get(END_DATE) == null ? "" : HRDateTimeUtils.format((Date)((Date)dynamicObject.get(END_DATE)), (String)"yyyy-MM-dd"));
            map.put("name", dynamicObject.get("name") == null ? "" : dynamicObject.get("name").toString());
            if (!HRObjectUtils.isEmpty(dynamicObject.get(TRAIN_TYPE))) {
                map.put(IS_INNER_TRAINING, dynamicObject.get(TRAIN_TYPE).toString());
            } else {
                map.put(IS_INNER_TRAINING, "0");
            }
            map.put(TRAINING_CERTIFICATE, dynamicObject.get(TRAINING_CERTIFICATE) == null ? "" : dynamicObject.get(TRAINING_CERTIFICATE).toString());
            map.put(PERIOD, dynamicObject.get(PERIOD) == null ? "" : dynamicObject.get(PERIOD).toString());
            map.put(CLASS_HOUR, dynamicObject.get(CLASS_HOUR) == null ? "" : dynamicObject.get(CLASS_HOUR).toString());
            map.put(TRAIN_MODE, dynamicObject.get(TRAIN_MODE) == null ? "" : dynamicObject.get(TRAIN_MODE).toString());
            list.add(map);
        }
        return list;
    }
}

