/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.commorguser.service.CommOrgUserDomainService;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportFileCommOrgUserPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ExportFileCommOrgUserPlugin.class);
    private final CommOrgUserDomainService commOrgUserDomainService = (CommOrgUserDomainService)ServiceFactory.getService(CommOrgUserDomainService.class);

    public void afterExportFile(ExportFileEvent event) {
        File file = event.getFile();
        if (file != null) {
            try (FileInputStream fis = new FileInputStream(file);){
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                if (sheet == null) {
                    return;
                }
                Row row = sheet.getRow(0);
                int lastCellNum = row.getLastCellNum();
                int roleColumn = 0;
                for (int index = 0; index < lastCellNum; ++index) {
                    if (!HRStringUtils.equals((String)ResManager.loadKDString((String)"\u89d2\u8272", (String)"ExportFileCommOrgUserPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), (String)row.getCell(index).getStringCellValue())) continue;
                    roleColumn = index;
                    break;
                }
                this.setRoleColumn(sheet, roleColumn);
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    private void setRoleColumn(Sheet sheet, int roleColumn) {
        List selectIds = (List)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get("exportIds"));
        DynamicObject[] users = this.commOrgUserDomainService.query("id, name, roleentry, commrole", new QFilter[]{new QFilter("id", "in", (Object)selectIds)});
        if (users.length == 0) {
            logger.info(MessageFormat.format("\u5bfc\u51fa\u52a8\u6001\u6dfb\u52a0\u89d2\u8272\u5b57\u6bb5\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u4e13\u59d4\u4f1a\u6210\u5458\uff0c\u5355\u636eID \uff1a {0}", selectIds));
            return;
        }
        Map<Long, DynamicObject> userMap = Arrays.stream(users).collect(Collectors.toMap(key -> key.getLong("id"), vale -> vale));
        for (int index = 1; index < sheet.getLastRowNum() + 1; ++index) {
            Row row = sheet.getRow(index);
            if (row == null) continue;
            DynamicObject user = userMap.get(selectIds.get(index - 1));
            DynamicObjectCollection roleEntry = user.getDynamicObjectCollection("roleentry");
            String roleName = Joiner.on((String)";").join((Iterable)roleEntry.stream().map(item -> item.getString("commrole.name")).collect(Collectors.toSet()));
            Cell cell = row.getCell(roleColumn);
            if (cell == null) {
                row.createCell(roleColumn).setCellValue(roleName);
                continue;
            }
            row.getCell(roleColumn).setCellValue(roleName);
        }
    }
}

