/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class OutRepRecodeAddPlugin
extends HRDynamicFormBasePlugin {
    private static final String OUT_DEC_DATE = "outdecdate";
    private static final String RETURN_DEC_DATE = "returndecdate";
    private static final String OUT_REAL_DATE = "outrealdate";
    private static final String RETURN_REAL_DATE = "returnrealdate";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long employeeId = (Long)formShowParameter.getCustomParam("employee");
        this.getView().getModel().setValue("employee", (Object)employeeId);
        this.setDateRange();
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) || OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"close"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"cancel"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"save"});
        }
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"close"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"save"});
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        List<String> dateList = Arrays.asList(OUT_DEC_DATE, RETURN_DEC_DATE, OUT_REAL_DATE, RETURN_REAL_DATE);
        if (dateList.contains(e.getProperty().getName())) {
            this.setDateRange();
        }
    }

    private void setDateRange() {
        Date outDecDate = (Date)this.getModel().getValue(OUT_DEC_DATE);
        Date returnDecDate = (Date)this.getModel().getValue(RETURN_DEC_DATE);
        Date outRealDate = (Date)this.getModel().getValue(OUT_REAL_DATE);
        Date returnRealDate = (Date)this.getModel().getValue(RETURN_REAL_DATE);
        DateEdit dateEdit = (DateEdit)this.getControl(RETURN_DEC_DATE);
        if (outDecDate != null) {
            dateEdit.setMinDate(outDecDate);
        } else {
            dateEdit.setMinDate(new Date(-9223372036854775807L));
        }
        DateEdit outerDecDateEdit = (DateEdit)this.getControl(OUT_DEC_DATE);
        if (returnDecDate != null) {
            outerDecDateEdit.setMaxDate(returnDecDate);
        } else {
            outerDecDateEdit.setMaxDate(new Date(Long.MAX_VALUE));
        }
        DateEdit returnRealDateEdit = (DateEdit)this.getControl(RETURN_REAL_DATE);
        if (outRealDate != null) {
            returnRealDateEdit.setMinDate(outRealDate);
        } else {
            returnRealDateEdit.setMinDate(new Date(-9223372036854775807L));
        }
        DateEdit outRealDateEdit = (DateEdit)this.getControl(OUT_REAL_DATE);
        if (returnRealDate != null) {
            outRealDateEdit.setMaxDate(returnRealDate);
        } else {
            outRealDateEdit.setMaxDate(new Date(Long.MAX_VALUE));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("addorupdate".equals(operateKey)) {
            OperationResult operationResult = this.getView().getParentView().invokeOperation("savepermission");
            if (operationResult.isSuccess()) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                long employeeId = (Long)formShowParameter.getCustomParam("employee");
                this.getView().getModel().setValue("employee", (Object)employeeId);
                OperationResult operationResultSave = this.getView().invokeOperation("save");
                if (operationResultSave.isSuccess()) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"OutRepRecodeAddPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                    this.getView().getParentView().invokeOperation("refresh");
                    this.getView().sendFormAction(this.getView().getParentView());
                    this.getView().close();
                } else {
                    List operateInfos = operationResultSave.getAllErrorOrValidateInfo();
                    if (!CollectionUtils.isEmpty((Collection)operateInfos) && operateInfos.size() == 1) {
                        this.getView().showErrorNotification(((IOperateInfo)operateInfos.get(0)).getMessage());
                    }
                }
            } else {
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                allErrorOrValidateInfo.forEach(iOperateInfo -> this.getView().showErrorNotification(iOperateInfo.getMessage()));
            }
        }
    }
}

