/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.TenureApplicationService;

public class OutRepRecodePlugin
extends HRDynamicFormBasePlugin {
    private static final String TDCS_OUTREPRECORD = "tdcs_outreprecord";
    private static final String OUT_REP_RECORD = "outreprecord";
    private static final String ATTACHMENT = "attachment";
    private static final String OUT_TYPE_PRIVATE = "outtypeprivate";
    private static final String OUT_TYPE_PUBLIC = "outtypepublic";
    private static final String OUT_TYPE = "outtype";
    private static final String SELECT_FIELD = "recorddate,outdestid,outtype,outdecdate,returndecdate,outrealdate,returnrealdate,outreason,attachment";
    private static final String IS_TENURE_LEAVE = "isTenureLeave";
    private static final String BEFORE_DELETE = "beforeDelete";
    private final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long employeeId = (Long)formShowParameter.getCustomParam("employee");
        String isTenureLeave = (String)formShowParameter.getCustomParam(IS_TENURE_LEAVE);
        this.getPageCache().put("employee", employeeId.toString());
        this.getPageCache().put(IS_TENURE_LEAVE, isTenureLeave);
        this.getView().setStatus(OperationStatus.VIEW);
        this.showOutInfo(employeeId);
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        BaseShowParameter formShowParameter;
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("newrecode".equals(operateKey) && args.getOperationResult().isSuccess()) {
            formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId(TDCS_OUTREPRECORD);
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCustomParam("employee", (Object)Long.parseLong(this.getPageCache().get("employee")));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
        if ("delete".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5916\u51fa\u62a5\u544a\u8bb0\u5f55\u5417\uff1f", (String)"OutRepRecodePlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BEFORE_DELETE, (IFormPlugin)this));
        }
        if ("update".equals(operateKey) && args.getOperationResult().isSuccess()) {
            formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId(TDCS_OUTREPRECORD);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setCustomParam("employee", (Object)Long.parseLong(this.getPageCache().get("employee")));
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryCurrentRowIndex);
            long id = ((DynamicObject)dynamicObject.get(OUT_REP_RECORD)).getLong("id");
            formShowParameter.setCustomParam("id", (Object)id);
            formShowParameter.setPkId((Object)id);
            formShowParameter.setCustomParam("operation", (Object)"edit");
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (BEFORE_DELETE.equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("entryentity").get(entryCurrentRowIndex);
            long id = ((DynamicObject)dynamicObject.get(OUT_REP_RECORD)).getLong("id");
            this.tenureApplicationService.deleteOutRepRecord(id);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"OutRepRecodePlugin_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            this.getModel().setDataChanged(false);
            this.getView().invokeOperation("refresh");
        }
    }

    private void showOutInfo(long employeeId) {
        this.getModel().deleteEntryData("entryentity");
        String isTenureLeave = this.getPageCache().get(IS_TENURE_LEAVE);
        if ("1".equals(isTenureLeave)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cardentryfixrowap"});
        }
        this.getModel().updateCache();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(TDCS_OUTREPRECORD);
        QFilter qFilterPersonId = new QFilter("employee", "=", (Object)employeeId);
        QFilter[] qFilters = new QFilter[]{qFilterPersonId};
        DynamicObject[] result = helper.query(SELECT_FIELD, qFilters, "recorddate desc");
        if (result.length == 0) {
            return;
        }
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", result.length);
        for (int i = 0; i < result.length; ++i) {
            DynamicObject dynamicObject = result[i];
            this.getModel().setValue(OUT_REP_RECORD, dynamicObject.getPkValue(), rowIndex[i]);
            String countryAndCity = dynamicObject.getString("outdestid.country.name") + "-" + dynamicObject.getString("outdestid.name");
            this.getModel().setValue("destination", (Object)countryAndCity, rowIndex[i]);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OUT_TYPE_PUBLIC});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OUT_TYPE_PRIVATE});
            this.getModel().setValue("isshowtimelineouter", (Object)(result.length == 1 ? 1 : result.length - 1 - i), rowIndex[i]);
            this.getModel().setValue("isshowbutton", (Object)("1".equals(isTenureLeave) ? 0 : 1), rowIndex[i]);
            if ("1".equals(dynamicObject.getString(OUT_TYPE))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{OUT_TYPE_PRIVATE});
            }
            if ("2".equals(dynamicObject.getString(OUT_TYPE))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{OUT_TYPE_PUBLIC});
            }
            MulBasedataDynamicObjectCollection dynamicObjects = (MulBasedataDynamicObjectCollection)dynamicObject.get(ATTACHMENT);
            this.getModel().setValue(ATTACHMENT, (Object)dynamicObjects.stream().map(value -> value.get("fbasedataid.id")).toArray(), rowIndex[i]);
        }
    }
}

