/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;

public class PerRpRecordPlugin
extends HRCoreBaseBillList {
    private static final ExternalService EXTERNAL_SERVICE = (ExternalService)ServiceFactory.getService(ExternalService.class);
    private static final String REWARD_DATE = "rewarddate";
    private static final String LEVEL = "level";
    private static final String WITNESS = "witness";
    private static final String CONTENT = "content";
    private static final String COMMENT = "comment";
    private static final String UNIT = "unit";
    private static final String TYPE = "type";
    private static final List<String> labelList = Arrays.asList("rewarddate", "type", "level", "unit", "witness", "content", "comment");

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = (Long)formShowParameter.getCustomParam("person");
        this.showPerRpInfo(personId);
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    private void showPerRpInfo(long personId) {
        List<Map<String, String>> list = this.getPerRpInfo(personId);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List sortedList = list.stream().sorted((a, b) -> ((String)b.get(REWARD_DATE)).compareTo((String)a.get(REWARD_DATE))).collect(Collectors.toList());
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", sortedList.size());
        for (int i = 0; i < sortedList.size(); ++i) {
            for (String s : labelList) {
                this.getModel().setValue(s, ((Map)sortedList.get(i)).get(s), rowIndex[i]);
                int showLineInt = sortedList.size() == 1 ? 1 : sortedList.size() - 1 - i;
                this.getModel().setValue("isshowline", (Object)showLineInt, rowIndex[i]);
            }
        }
    }

    private List<Map<String, String>> getPerRpInfo(long personId) {
        List result = EXTERNAL_SERVICE.listPersonAttachs(personId, "hrpi_perrprecord");
        if (CollectionUtils.isEmpty((Collection)result)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(result.size());
        for (Map dynamicObject : result) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(REWARD_DATE, dynamicObject.get(REWARD_DATE) == null ? "" : HRDateTimeUtils.format((Date)((Date)dynamicObject.get(REWARD_DATE)), (String)"yyyy-MM-dd"));
            map.put(UNIT, dynamicObject.get(UNIT) == null ? "" : dynamicObject.get(UNIT).toString());
            map.put(WITNESS, dynamicObject.get(WITNESS) == null ? "" : dynamicObject.get(WITNESS).toString());
            map.put(CONTENT, dynamicObject.get(CONTENT) == null ? "" : dynamicObject.get(CONTENT).toString());
            map.put(COMMENT, dynamicObject.get(COMMENT) == null ? "" : dynamicObject.get(COMMENT).toString());
            map.put(TYPE, dynamicObject.get(TYPE) == null ? "" : dynamicObject.get(TYPE).toString());
            map.put(LEVEL, dynamicObject.get(LEVEL) == null ? "" : dynamicObject.get(LEVEL).toString());
            list.add(map);
        }
        return list;
    }
}

