/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.TenureApplicationService;

public class PerformancePlugin
extends HRDynamicFormBasePlugin {
    private static final TenureApplicationService TENURE = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final String TDCS_PERFORMANCE = "tdcs_performance";
    private static List<String> COLUMN_LIST;
    private static final String EDIT = "rowedit";
    private static final String SAVE = "rowsave";
    private static final String ADD_ROW = "addrow";
    private static final String DELETE_ROW = "deleterow";
    private static final String CANCEL = "cancel";
    private static final String HANDLER_INPUT = "10";
    private static final String SYSTEM_INPUT = "20";
    private static final String MODIFY_LIMIT_ID = "4715a0df000000ac";
    private static final List<String> OPERATE_LIST;
    private static final String CHECK_NAME = "checkname";
    private static final String RANGE_TYPE = "rangetype";
    private static final String CHECK_MODE = "checkmode";
    private static final String SCORE = "score";
    private static final String LEVEL = "level";
    private static final String SOURCE = "source";
    private static final String CHECK_START_DATE = "check_startdate";
    private static final String CHECK_END_DATE = "check_enddate";
    private static final String PERFORMANCE = "performance";
    private static final String[] fieldArray;

    public PerformancePlugin() {
        COLUMN_LIST = Lists.newArrayList((Object[])new String[]{RANGE_TYPE, CHECK_NAME, "daterangefield", CHECK_MODE, SCORE, LEVEL, SOURCE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long employeeId = (Long)formShowParameter.getCustomParam("employee");
        this.getPageCache().put("employeeId", String.valueOf(employeeId));
        this.getView().getPageCache().remove("deleteRowIdList");
        this.showPerformanceInfo(employeeId);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{EDIT});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE, ADD_ROW, DELETE_ROW, CANCEL});
        this.getModel().setDataChanged(false);
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_tenure", (String)MODIFY_LIMIT_ID);
        if (!hasPerm) {
            this.getView().setVisible(Boolean.FALSE, new String[]{EDIT});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String message;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (!OPERATE_LIST.contains(key)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_tenure", (String)MODIFY_LIMIT_ID);
        String systemType = "tdc-tdcs-formplugin";
        if (!hasPerm) {
            message = ResManager.loadKDString((String)"\u65e0\"\u5e72\u90e8\u4efb\u671f\u7ba1\u7406\"\u7684\"\u4fee\u6539\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PerformancePlugin_2", (String)systemType, (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            args.setCancel(true);
        }
        if (CANCEL.equals(key)) {
            message = ResManager.loadKDString((String)"\u786e\u8ba4\u53d6\u6d88\u4fdd\u5b58\uff1f", (String)"PerformancePlugin_5", (String)systemType, (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CANCEL, (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CANCEL.equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (EDIT.equals(operateKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SAVE, ADD_ROW, DELETE_ROW, CANCEL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EDIT});
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                Object source = this.getModel().getValue(SOURCE, i);
                this.getView().setEnable(Boolean.valueOf(HANDLER_INPUT.equals(source)), i, COLUMN_LIST.toArray(new String[0]));
            }
        }
        if (SAVE.equals(operateKey)) {
            boolean success = afterDoOperationEventArgs.getOperationResult().isSuccess();
            if (!success) {
                return;
            }
            String employeeId = this.getPageCache().get("employeeId");
            IDataModel model = this.getView().getModel();
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                return;
            }
            String deleteRowIdList = this.getView().getPageCache().get("deleteRowIdList");
            boolean save = TENURE.save(entryEntity, Long.parseLong(employeeId), deleteRowIdList);
            if (save) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"PerformancePlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"PerformancePlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            }
            this.getView().getPageCache().remove("deleteRowIdList");
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] selectRows = e.getRowIndexs();
        String deleteRowIdList = this.getView().getPageCache().get("deleteRowIdList");
        List deleteIdList = HRStringUtils.isEmpty((String)deleteRowIdList) ? Lists.newArrayList() : (List)SerializationUtils.deSerializeFromBase64((String)deleteRowIdList);
        ArrayList nonDeleteSeq = Lists.newArrayList();
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(PERFORMANCE, selectRow);
            if (null == dynamicObject) continue;
            String source = (String)this.getModel().getValue(SOURCE, selectRow);
            if (SYSTEM_INPUT.equals(source)) {
                nonDeleteSeq.add(selectRow + 1);
                continue;
            }
            Object value = dynamicObject.getPkValue();
            if (null == value) continue;
            deleteIdList.add(value);
        }
        if (deleteIdList.size() > 0) {
            this.getView().getPageCache().put("deleteRowIdList", SerializationUtils.serializeToBase64(deleteIdList));
        }
        if (!CollectionUtils.isEmpty((Collection)nonDeleteSeq)) {
            String nonDeleteStr = ((Object)nonDeleteSeq).toString();
            String replace = nonDeleteStr.replace("[", "").replace("]", "");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PerformancePlugin_4", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{replace}));
            e.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    private void showPerformanceInfo(long employeeId) {
        this.getModel().updateCache();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(TDCS_PERFORMANCE);
        QFilter qFilterPersonId = new QFilter("employee", "=", (Object)employeeId);
        QFilter[] qFilters = new QFilter[]{qFilterPersonId};
        String selectProperties = "id,employee,checktype,checkname,rangetype,check_startdate,check_enddate,checkmode,score,level,source";
        DynamicObject[] result = helper.query(selectProperties, qFilters, "check_startdate desc");
        if (result.length == 0) {
            return;
        }
        model.deleteEntryData("entryentity");
        TableValueSetter tableValueSetter = new TableValueSetter(fieldArray);
        model.beginInit();
        for (int i = 0; i < result.length; ++i) {
            DynamicObject dynamicObject = result[i];
            tableValueSetter.addRow(new Object[]{dynamicObject.getString(CHECK_NAME), dynamicObject.getString(RANGE_TYPE), dynamicObject.getString(CHECK_MODE), dynamicObject.getString(SCORE), dynamicObject.getString(LEVEL), dynamicObject.getString(SOURCE), dynamicObject.getDate(CHECK_START_DATE), dynamicObject.getDate(CHECK_END_DATE), dynamicObject.get("id")});
            this.getView().setEnable(Boolean.valueOf(false), i, COLUMN_LIST.toArray(new String[0]));
        }
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    static {
        OPERATE_LIST = Lists.newArrayList((Object[])new String[]{EDIT, SAVE, ADD_ROW, DELETE_ROW, CANCEL});
        fieldArray = new String[]{CHECK_NAME, RANGE_TYPE, CHECK_MODE, SCORE, LEVEL, SOURCE, CHECK_START_DATE, CHECK_END_DATE, PERFORMANCE};
    }
}

