/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.comm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;

public class ProjectPlugin
extends HRCoreBaseBillList {
    private static final ExternalService EXTERNAL_SERVICE = (ExternalService)ServiceFactory.getService(ExternalService.class);
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String AREA = "area";
    private static final String PROJECT_TYPE = "projecttype";
    private static final String ROLE = "role";
    private static final String CERTIFIER = "certifier";
    private static final String DUTY = "duty";
    private static final String DESCRIPTION = "description";
    private static final List<String> labelList = Arrays.asList("startdate", "enddate", "name", "area", "projecttype", "role", "certifier", "duty", "description");

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long personId = (Long)formShowParameter.getCustomParam("person");
        this.showProjectInfo(personId);
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    private void showProjectInfo(long personId) {
        List<Map<String, String>> list = this.getProjectInfo(personId);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List sortedList = list.stream().sorted((a, b) -> ((String)b.get(START_DATE)).compareTo((String)a.get(START_DATE))).collect(Collectors.toList());
        int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", sortedList.size());
        for (int i = 0; i < sortedList.size(); ++i) {
            for (String s : labelList) {
                this.getModel().setValue(s, ((Map)sortedList.get(i)).get(s), rowIndex[i]);
                int showLineInt = sortedList.size() == 1 ? 1 : sortedList.size() - 1 - i;
                this.getModel().setValue("isshowline", (Object)showLineInt, rowIndex[i]);
            }
        }
    }

    private List<Map<String, String>> getProjectInfo(long personId) {
        List result = EXTERNAL_SERVICE.listPersonAttachs(personId, "hrpi_empproexp");
        if (CollectionUtils.isEmpty((Collection)result)) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(result.size());
        for (Map dynamicObject : result) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(START_DATE, dynamicObject.get(START_DATE) == null ? "" : HRDateTimeUtils.format((Date)((Date)dynamicObject.get(START_DATE)), (String)"yyyy-MM-dd"));
            map.put(END_DATE, dynamicObject.get(END_DATE) == null ? "" : HRDateTimeUtils.format((Date)((Date)dynamicObject.get(END_DATE)), (String)"yyyy-MM-dd"));
            map.put("name", dynamicObject.get("name") == null ? "" : dynamicObject.get("name").toString());
            map.put(CERTIFIER, dynamicObject.get(CERTIFIER) == null ? "" : dynamicObject.get(CERTIFIER).toString());
            map.put(DUTY, dynamicObject.get(DUTY) == null ? "" : dynamicObject.get(DUTY).toString());
            map.put(DESCRIPTION, dynamicObject.get(DESCRIPTION) == null ? "" : dynamicObject.get(DESCRIPTION).toString());
            map.put(AREA, dynamicObject.get(AREA) == null ? "" : dynamicObject.get(AREA).toString());
            map.put(PROJECT_TYPE, dynamicObject.get(PROJECT_TYPE) == null ? "" : dynamicObject.get(PROJECT_TYPE).toString());
            map.put(ROLE, dynamicObject.get(ROLE) == null ? "" : dynamicObject.get(ROLE).toString());
            list.add(map);
        }
        return list;
    }
}

