/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.coordination;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CoordinationApplicationService;

public class CoordinationPreOpenEdit
extends HRDataBaseEdit {
    private static final CoordinationApplicationService coordinationApplicationService = (CoordinationApplicationService)ServiceFactory.getService(CoordinationApplicationService.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadLogsData();
    }

    private void loadLogsData() {
        String number = (String)this.getModel().getValue("number");
        DynamicObject[] taskLogs = coordinationApplicationService.queryLogByTaskNumber(number);
        if (taskLogs.length == 0) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        int[] indexArr = this.getModel().batchCreateNewEntryRow("entryentity", taskLogs.length);
        for (int i = 0; i < indexArr.length; ++i) {
            DynamicObject taskLog = taskLogs[i];
            this.getModel().setValue("taskname", (Object)HRDyObjectPropUtil.getString((DynamicObject)taskLog, (String)"task.name"), indexArr[i]);
            this.getModel().setValue("traceid", (Object)HRDyObjectPropUtil.getString((DynamicObject)taskLog, (String)"traceid"), indexArr[i]);
            this.getModel().setValue("logtaskstatus", (Object)HRDyObjectPropUtil.getString((DynamicObject)taskLog, (String)"taskstatus"), indexArr[i]);
            this.getModel().setValue("exectype", (Object)HRDyObjectPropUtil.getString((DynamicObject)taskLog, (String)"exectype"), indexArr[i]);
            this.getModel().setValue("operatorname", (Object)HRDyObjectPropUtil.getString((DynamicObject)taskLog, (String)"creator.name"), indexArr[i]);
            this.getModel().setValue("operatornumber", (Object)HRDyObjectPropUtil.getString((DynamicObject)taskLog, (String)"creator.number"), indexArr[i]);
            this.getModel().setValue("logstarttime", (Object)HRInteDateTimeUtil.formatDate((String)"tdcs_coordinationtask", (String)"startdate", (Date)taskLog.getDate("startdate")), indexArr[i]);
            this.getModel().setValue("logendtime", (Object)HRInteDateTimeUtil.formatDate((String)"tdcs_coordinationtask", (String)"enddate", (Date)taskLog.getDate("enddate")), indexArr[i]);
            this.getModel().setValue("logdescription", (Object)HRDyObjectPropUtil.getString((DynamicObject)taskLog, (String)"description"), indexArr[i]);
        }
        this.getView().updateView("entryentity");
    }
}

