/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.coordination;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class CoordinationSubscriberEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        OperationStatus status = args.getFormShowParameter().getStatus();
        if (!status.equals((Object)OperationStatus.ADDNEW)) {
            args.getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit msgPublisherControl = (BasedataEdit)this.getControl("msgpublisher");
        msgPublisherControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.showEventInfo();
        this.hideViewInAddNew();
    }

    private void hideViewInAddNew() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexcrosscloud", "flexincloud"});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (name.equals("msgpublisher")) {
            this.showEventInfo();
        }
        if (name.equals("crosscloudsub")) {
            DynamicObject crossCloudSub = (DynamicObject)this.getModel().getValue("crosscloudsub");
            this.getModel().setValue("crosscloudevent", (Object)crossCloudSub.getLong("msgpublisher.id"));
        }
    }

    private void showEventInfo() {
        DynamicObject msgPublisher = (DynamicObject)this.getModel().getValue("msgpublisher");
        if (HRObjectUtils.isEmpty((Object)msgPublisher)) {
            return;
        }
        long msgId = HRDyObjectPropUtil.getId((DynamicObject)msgPublisher);
        String msgPublisherType = (String)this.getModel().getValue("msgpublishertype");
        if (msgPublisherType.equals("tdcs_coordpublisher")) {
            this.getModel().setValue("incloudevent", (Object)msgId);
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexincloud"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexcrosscloud"});
            return;
        }
        if (msgPublisherType.equals("hrcs_msgsubscriber")) {
            this.getModel().setValue("crosscloudsub", (Object)msgId);
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexcrosscloud"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexincloud"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (operateKey.equals("save")) {
            DynamicObject msgPublisher = (DynamicObject)this.getModel().getValue("msgpublisher");
            String msgPubNo = msgPublisher.getString("number");
            this.getModel().setValue("msgsubno", (Object)msgPubNo);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.equals("msgpublisher")) {
            String msgPublisherType = (String)this.getModel().getValue("msgpublishertype");
            if (msgPublisherType.equals("tdcs_coordpublisher")) {
                QFilter dataFilter = new QFilter("pubstatus", "=", (Object)"P");
                beforeF7SelectEvent.getCustomQFilters().add(dataFilter);
                return;
            }
            if (msgPublisherType.equals("hrcs_msgsubscriber")) {
                QFilter numberFilter = new QFilter("consumerapp.number", "=", (Object)"tdcs");
                QFilter subFilter = new QFilter("substatus", "=", (Object)"1");
                QFilter serviceFilter = new QFilter("consumerservice", "ftlike", (Object)"ITDCSBizMsgConsumerService");
                beforeF7SelectEvent.getCustomQFilters().add(numberFilter);
                beforeF7SelectEvent.getCustomQFilters().add(subFilter);
                beforeF7SelectEvent.getCustomQFilters().add(serviceFilter);
            }
        }
    }
}

