/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.fieldmap;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.tdcs.formplugin.web.fieldmap.FieldMapConfDrawPageUtil;

public class FileMapManagerEdit
extends HRDataBaseEdit
implements TreeNodeClickListener,
CellClickListener,
SearchEnterListener,
BeforeF7SelectListener,
RowClickEventListener {
    private static final String TREE_ID_ROOT = "root";
    private static final String STATUS_SELECTED = "selected";
    private static final String STATUS_UNSELECTED = "unselected";
    private static final String ISMAPPED_TRUE = String.valueOf(true);
    private static final String ISMAPPED_FALSE = String.valueOf(false);
    private static final String CONTROL_KEY_FLEX_SOURCEFIELDS = "flex_sourcefields";
    private static final String CONTROL_KEY_FLEX_TARGETFIELDS = "flex_targetfields";
    private static final String CONTROL_KEY_PAIRTREE = "pairtree";
    private static final String CONTROL_KEY_BTN_MAP = "btn_map";
    private static final String CONTROL_KEY_BTN_UNMAP = "btn_unmap";
    private static final String CONTROL_KEY_FLEX_MAPPEDFIELDS = "flex_mappedfields";
    private static final String CONTROL_KEY_SEARCH_SOURCE = "search_source";
    private static final String CONTROL_KEY_SEARCH_TARGET = "search_target";
    private static final String CONTROL_KEY_SEARCH_MAPPED = "search_mapped";
    private static final String CONTROL_KEY_LBL_SOUCEHEAD = "lbl_soucehead";
    private static final String CONTROL_KEY_LBL_TARGETHEAD = "lbl_targethead";
    private static final String CONTROL_KEY_ENEITYCONF = "entityconf";
    private HRPageCache hrPageCache;
    private static final String CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE = "current_field_unmapped_source";
    private static final String CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET = "current_field_unmapped_target";
    private static final String CACHE_KEY_SELECTED_MAPPED_FIELDS = "selected_mapped_fields";
    private static final String CACHE_KEY_LAST_INITED_COMBO = "last_inited_combo";
    private static final String MAP_KEY_ENTITY_NUMBER = "entity_number";
    private static final String MAP_KEY_FIELD_NUMBER = "field_number";
    private static final String MAP_KEY_FIELD_NAME = "field_name";
    private static final String MAP_KEY_FIELD_TYPE = "field_type";
    private static final String MAP_KEY_POSITION = "position";
    private static final String MAP_KEY_ISMAPPED = "ismapped";
    private static final String MAP_KEY_SOURCE_PROP = "source_prop";
    private static final String MAP_KEY_SOURCE_ENTITY = "source_entity";
    private static final String MAP_KEY_TARGET_PROP = "target_prop";
    private static final String MAP_KEY_TARGET_ENTITY = "target_entity";
    private static final String UNMAP = "unmap";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.initHRPageCache();
    }

    private void initHRPageCache() {
        HRPageCache pageCache = this.getHRPageCache();
        LinkedList selectedFields = new LinkedList();
        pageCache.put(CACHE_KEY_SELECTED_MAPPED_FIELDS, selectedFields);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        TreeView treeView = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Button btnMap = (Button)this.getView().getControl(CONTROL_KEY_BTN_MAP);
        btnMap.addClickListener((ClickListener)this);
        Button btnUnmap = (Button)this.getView().getControl(CONTROL_KEY_BTN_UNMAP);
        btnUnmap.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Search searchSource = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_SOURCE);
        searchSource.addEnterListener((SearchEnterListener)this);
        Search searchTarget = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_TARGET);
        searchTarget.addEnterListener((SearchEnterListener)this);
        Search searchMapped = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_MAPPED);
        searchMapped.addEnterListener((SearchEnterListener)this);
        BasedataEdit sourceEntityF7 = (BasedataEdit)this.getView().getControl("sourceentity");
        sourceEntityF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetEntityF7 = (BasedataEdit)this.getView().getControl("targetentity");
        targetEntityF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey;
        switch (fieldKey = evt.getFieldKey()) {
            case "sourceprikey": {
                this.setMapKeyComboProp("sourceentity", "sourceprikey", evt.getRow());
                break;
            }
            case "targetprikey": {
                this.setMapKeyComboProp("targetentity", "targetprikey", evt.getRow());
                break;
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (this.isUnmappedFieldFlex(key)) {
            this.changeUnmappedFieldSelectStatus(key);
        }
        if (this.isMappedMainFieldFlex(key)) {
            this.changeMappedFieldSelectStatus(key);
        }
        switch (key) {
            case "btn_map": {
                this.mapSelectedFields();
                this.updateTreeView();
                break;
            }
            case "btn_unmap": {
                this.showUnmapConfirm();
                break;
            }
        }
    }

    private void showUnmapConfirm() {
        if (this.isTreeNoData()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u89e3\u9664\u5173\u8054\u7684\u5b57\u6bb5\u3002", (String)"FileMapManagerEdit_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u89e3\u9664\u5173\u8054\u5417\uff1f", (String)"FileMapManagerEdit_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(UNMAP, (IFormPlugin)this));
    }

    public boolean isTreeNoData() {
        HRPageCache pageCache = this.getHRPageCache();
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_PAIRTREE);
        String nodeId = this.getSelectedTreeNode(tree);
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
        return HRStringUtils.isEmpty((String)nodeId) || HRStringUtils.equals((String)nodeId, (String)TREE_ID_ROOT) || null == treeNodeInfo || treeNodeInfo.isEmpty();
    }

    private void unmapSelectedFields() {
        HRPageCache pageCache = this.getHRPageCache();
        List<String> selectedFields = this.getSelectedMappedFields(pageCache);
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_PAIRTREE);
        String nodeId = this.getSelectedTreeNode(tree);
        this.selectTableEntityRow(nodeId);
        for (String fieldFlexKey : selectedFields) {
            Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
            Map mappedFieldsInfo = (Map)treeNodeInfo.get(fieldFlexKey);
            String sourceProp = (String)mappedFieldsInfo.get(MAP_KEY_SOURCE_PROP);
            String targetProp = (String)mappedFieldsInfo.get(MAP_KEY_TARGET_PROP);
            String sourceFieldKey = FieldMapConfDrawPageUtil.getUnmappedFlexKey(FieldMapConfDrawPageUtil.getUnmappedCommonKey("source", sourceProp));
            String targetFieldKey = FieldMapConfDrawPageUtil.getUnmappedFlexKey(FieldMapConfDrawPageUtil.getUnmappedCommonKey("target", targetProp));
            Map sourceFieldInfo = (Map)treeNodeInfo.get(sourceFieldKey);
            Map targetFieldInfo = (Map)treeNodeInfo.get(targetFieldKey);
            sourceFieldInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_FALSE);
            targetFieldInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_FALSE);
            treeNodeInfo.put(sourceFieldKey, sourceFieldInfo);
            treeNodeInfo.put(targetFieldKey, targetFieldInfo);
            treeNodeInfo.remove(fieldFlexKey);
            this.deleteMappedField(sourceProp, targetProp);
            pageCache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
        }
        selectedFields.clear();
        pageCache.put(CACHE_KEY_SELECTED_MAPPED_FIELDS, selectedFields);
        this.drawAllFieldContainers(nodeId);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals(UNMAP) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.unmapSelectedFields();
            this.updateTreeView();
        }
    }

    private void deleteMappedField(String sourcePropKey, String targetPropKey) {
        DynamicObjectCollection mappedFields = this.getModel().getEntryEntity("subentryentity");
        ArrayList<Integer> indexToDelete = new ArrayList<Integer>();
        for (int i = 0; i < mappedFields.size(); ++i) {
            DynamicObject mappedField = (DynamicObject)mappedFields.get(i);
            if (!HRStringUtils.equals((String)sourcePropKey, (String)mappedField.getString("sourcefield")) || !HRStringUtils.equals((String)targetPropKey, (String)mappedField.getString("targetfield"))) continue;
            indexToDelete.add(i);
        }
        int size = indexToDelete.size();
        int[] indexToDeleteArray = new int[size];
        for (int index = 0; index < size; ++index) {
            indexToDeleteArray[index] = (Integer)indexToDelete.get(index);
        }
        this.getModel().deleteEntryRows("subentryentity", indexToDeleteArray);
    }

    private void mapSelectedFields() {
        HRPageCache cache = this.getHRPageCache();
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(cache);
        String sourceFieldKey = (String)cache.get(CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE, String.class);
        String targetFieldKey = (String)cache.get(CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET, String.class);
        if (null == treeNodeInfo || treeNodeInfo.isEmpty() || HRStringUtils.isEmpty((String)sourceFieldKey) || HRStringUtils.isEmpty((String)targetFieldKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5173\u8054\u7684\u5b57\u6bb5\u3002", (String)"FileMapManagerEdit_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.selectTableEntityRow(this.getSelectedTreeNodeId());
        Map sourceFieldInfo = (Map)treeNodeInfo.get(sourceFieldKey);
        Map targetFieldInfo = (Map)treeNodeInfo.get(targetFieldKey);
        String sourceField = (String)sourceFieldInfo.get(MAP_KEY_FIELD_NUMBER);
        String targetField = (String)targetFieldInfo.get(MAP_KEY_FIELD_NUMBER);
        sourceFieldInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_TRUE);
        targetFieldInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_TRUE);
        treeNodeInfo.put(sourceFieldKey, sourceFieldInfo);
        treeNodeInfo.put(targetFieldKey, targetFieldInfo);
        TreeView tree = (TreeView)this.getControl(CONTROL_KEY_PAIRTREE);
        String nodeId = this.getSelectedTreeNode(tree);
        this.addMappedFieldsToEntry(sourceField, targetField);
        cache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET);
        this.drawAllFieldContainers(nodeId);
    }

    public void addMappedFieldsToEntry(String sourceField, String targetField) {
        int fieldRowIndex = this.getModel().createNewEntryRow("subentryentity");
        this.getModel().setValue("sourcefield", (Object)sourceField, fieldRowIndex);
        this.getModel().setValue("targetfield", (Object)targetField, fieldRowIndex);
    }

    public void drawAllFieldContainers(String nodeId) {
        this.clearFieldsCache();
        String[] tableNumbers = nodeId.split("\\|");
        String sourceTable = tableNumbers[0];
        String targetTable = tableNumbers[1];
        this.drawUnmappedFieldContainer(sourceTable, CONTROL_KEY_FLEX_SOURCEFIELDS, "source", "");
        this.drawUnmappedFieldContainer(targetTable, CONTROL_KEY_FLEX_TARGETFIELDS, "target", "");
        this.drawMappedFieldContainer(sourceTable, targetTable, "");
    }

    private void clearFieldsCache() {
        HRPageCache cache = this.getHRPageCache();
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE);
        cache.remove(CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET);
        cache.remove(CACHE_KEY_SELECTED_MAPPED_FIELDS);
    }

    private boolean isUnmappedFieldFlex(String key) {
        return key.contains("flex_fieldum");
    }

    private boolean isMappedMainFieldFlex(String key) {
        return key.contains("flex_fieldmm");
    }

    private void changeMappedFieldSelectStatus(String key) {
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
        Map mappedFieldsInfo = (Map)treeNodeInfo.get(key);
        List<String> selectedFields = this.getSelectedMappedFields(pageCache);
        boolean isSelected = selectedFields.contains(key);
        if (isSelected) {
            selectedFields.remove(key);
        } else {
            selectedFields.add(key);
        }
        isSelected = !isSelected;
        this.changeMappedFieldBorderLineColor(key, isSelected, mappedFieldsInfo);
        pageCache.put(CACHE_KEY_SELECTED_MAPPED_FIELDS, selectedFields);
        pageCache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
    }

    private List<String> getSelectedMappedFields(HRPageCache pageCache) {
        ArrayList selectedFields = (ArrayList)pageCache.get(CACHE_KEY_SELECTED_MAPPED_FIELDS, List.class);
        if (null == selectedFields) {
            selectedFields = new ArrayList();
        }
        return selectedFields;
    }

    private void changeMappedFieldBorderLineColor(String fieldFlexKey, boolean isSelected, Map<String, String> mappedFieldsInfo) {
        if (mappedFieldsInfo == null) {
            return;
        }
        String sourceProp = mappedFieldsInfo.get(MAP_KEY_SOURCE_PROP);
        String sourceEntity = mappedFieldsInfo.get(MAP_KEY_SOURCE_ENTITY);
        String targetProp = mappedFieldsInfo.get(MAP_KEY_TARGET_PROP);
        String targetEntity = mappedFieldsInfo.get(MAP_KEY_TARGET_ENTITY);
        MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)sourceEntity);
        DataEntityPropertyCollection sourceProps = sourceEntityType.getProperties();
        DynamicProperty sourceProperty = (DynamicProperty)sourceProps.get((Object)sourceProp);
        MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        DataEntityPropertyCollection targetProps = targetEntityType.getProperties();
        DynamicProperty targetProperty = (DynamicProperty)targetProps.get((Object)targetProp);
        FlexPanelAp mappedFieldAp = null;
        mappedFieldAp = isSelected ? FieldMapConfDrawPageUtil.combineSelectedMappedFieldAp(sourceProperty, sourceEntityType.getDisplayName().getLocaleValue(), true, targetProperty, targetEntityType.getDisplayName().getLocaleValue(), true) : FieldMapConfDrawPageUtil.combineUnselectedMappedFieldAp(sourceProperty, sourceEntityType.getDisplayName().getLocaleValue(), true, targetProperty, targetEntityType.getDisplayName().getLocaleValue(), true);
        this.getView().updateControlMetadata(fieldFlexKey, mappedFieldAp.createControl());
    }

    public void onGetControl(OnGetControlArgs evt) {
        super.onGetControl(evt);
        String key = evt.getKey();
        if (this.isClickableFieldFlex(key)) {
            this.bindFieldFlexClick(key, evt);
        }
    }

    public boolean isClickableFieldFlex(String key) {
        return key.contains("flex_fieldum") || key.contains("flex_fieldmm");
    }

    private void bindFieldFlexClick(String key, OnGetControlArgs evt) {
        Container container = new Container();
        container.setKey(key);
        container.setView(this.getView());
        container.addClickListener((ClickListener)this);
        evt.setControl((Control)container);
    }

    public void changeUnmappedFieldSelectStatus(String newKey) {
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, String> newFieldInfo = this.getUnmappedFieldInfo(newKey, pageCache);
        if (newFieldInfo == null) {
            return;
        }
        String position = newFieldInfo.get(MAP_KEY_POSITION);
        String currentSelectedFileKeyPosition = "";
        currentSelectedFileKeyPosition = HRStringUtils.equals((String)position, (String)"source") ? CACHE_KEY_CURRENT_FIELD_UNMAPPED_SOURCE : CACHE_KEY_CURRENT_FIELD_UNMAPPED_TARGET;
        String currentSelectedFlexKey = (String)pageCache.get(currentSelectedFileKeyPosition, String.class);
        if (!HRStringUtils.isEmpty((String)currentSelectedFlexKey)) {
            this.changeUnmappedFieldBorderLineColor(currentSelectedFlexKey, STATUS_UNSELECTED);
        }
        this.changeUnmappedFieldBorderLineColor(newKey, STATUS_SELECTED);
        pageCache.put(currentSelectedFileKeyPosition, (Object)newKey);
    }

    private void changeUnmappedFieldBorderLineColor(String fieldFlexKey, String selectedStatus) {
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, String> fieldInfo = this.getUnmappedFieldInfo(fieldFlexKey, pageCache);
        String entityNumber = fieldInfo.get(MAP_KEY_ENTITY_NUMBER);
        String fieldNumber = fieldInfo.get(MAP_KEY_FIELD_NUMBER);
        String position = fieldInfo.get(MAP_KEY_POSITION);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        DynamicProperty property = (DynamicProperty)properties.get((Object)fieldNumber);
        FlexPanelAp selectedUnmappedFieldAp = null;
        if (STATUS_SELECTED.equals(selectedStatus)) {
            selectedUnmappedFieldAp = FieldMapConfDrawPageUtil.combineSelectedUnmappedFieldAp(property, entityType.getDisplayName().getLocaleValue(), position, true);
        }
        if (STATUS_UNSELECTED.equals(selectedStatus)) {
            selectedUnmappedFieldAp = FieldMapConfDrawPageUtil.combineUnselectedUnmappedFieldAp(property, entityType.getDisplayName().getLocaleValue(), position, true);
        }
        if (null != selectedUnmappedFieldAp) {
            this.getView().updateControlMetadata(fieldFlexKey, selectedUnmappedFieldAp.createControl());
        }
    }

    public void showFields(String nodeId) {
        this.drawAllFieldContainers(nodeId);
    }

    public void cleanFields() {
        this.drawEmptyUnmappedFiledContainer(CONTROL_KEY_FLEX_SOURCEFIELDS, "source");
        this.drawEmptyUnmappedFiledContainer(CONTROL_KEY_FLEX_TARGETFIELDS, "target");
        this.drawEmptyMappedFiledContainer(CONTROL_KEY_FLEX_MAPPEDFIELDS);
    }

    public void drawEmptyUnmappedFiledContainer(String containerKey, String position) {
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createUnmappedFieldsContainerFlex(containerKey);
        Container fieldsContainerFlex = (Container)this.getControl(containerKey);
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(containerKey, fieldsContainerFlexAp.createControl());
    }

    public void drawUnmappedFieldContainer(String entityName, String containerKey, String position, String searchText) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DataEntityPropertyCollection properties = entityType.getProperties();
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createUnmappedFieldsContainerFlex(containerKey);
        Container fieldsContainerFlex = (Container)this.getControl(containerKey);
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, Object> tableInfo = this.getSelectedNodeInfo(pageCache);
        properties.forEach(property -> this.appendUnmappedField(entityType, fieldsContainerFlexAp, fieldsContainerFlex, (IDataEntityProperty)property, position, searchText, tableInfo));
        pageCache.put(this.getSelectedTreeNodeId(), tableInfo);
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(containerKey, fieldsContainerFlexAp.createControl());
        int fieldAmount = items.size();
        if ("source".equals(position)) {
            Label lblHead = (Label)this.getView().getControl(CONTROL_KEY_LBL_SOUCEHEAD);
            lblHead.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6e90\u5b57\u6bb5(%s)", (String)"FileMapManagerEdit_3", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), fieldAmount));
        } else {
            Label lblHead = (Label)this.getView().getControl(CONTROL_KEY_LBL_TARGETHEAD);
            lblHead.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u76ee\u6807\u5b57\u6bb5(%s)", (String)"FileMapManagerEdit_4", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), fieldAmount));
        }
    }

    public void appendUnmappedField(MainEntityType sourceEntityType, FlexPanelAp fieldsContainerFlexAp, Container fieldsContainerFlex, IDataEntityProperty property, String position, String searchText, Map<String, Object> tableInfo) {
        if (!this.isFieldShouldShow(property)) {
            return;
        }
        FlexPanelAp unmappedFieldFlexAp = FieldMapConfDrawPageUtil.combineUnselectedUnmappedFieldAp((DynamicProperty)property, sourceEntityType.getDisplayName().getLocaleValue(), position, true);
        String fieldFlexKey = unmappedFieldFlexAp.getKey();
        boolean isMapped = this.isFieldMapped(fieldFlexKey, property.getName());
        this.cacheUnmappedFieldInfo(fieldFlexKey, sourceEntityType, property, position, false, tableInfo);
        if (!this.isFieldMapped(fieldFlexKey, property.getName()) && this.matchSearch(property, searchText)) {
            fieldsContainerFlexAp.getItems().add(unmappedFieldFlexAp);
        }
    }

    private boolean matchSearch(IDataEntityProperty property, String searchText) {
        if (HRStringUtils.isEmpty((String)searchText)) {
            return true;
        }
        LocaleString displayName = property.getDisplayName();
        return property.getName().contains(searchText) || null != displayName && null != displayName.getLocaleValue() && displayName.getLocaleValue().contains(searchText);
    }

    private void cacheUnmappedFieldInfo(String fieldFlexKey, MainEntityType sourceEntityType, IDataEntityProperty property, String position, boolean isMapped, Map<String, Object> tableInfo) {
        HashMap<String, String> fieldFlexInfo = (HashMap<String, String>)tableInfo.get(fieldFlexKey);
        if (null != fieldFlexInfo) {
            return;
        }
        fieldFlexInfo = new HashMap<String, String>();
        fieldFlexInfo.put(MAP_KEY_ENTITY_NUMBER, sourceEntityType.getName());
        fieldFlexInfo.put(MAP_KEY_FIELD_NUMBER, property.getName());
        LocaleString displayName = property.getDisplayName();
        if (null == displayName) {
            fieldFlexInfo.put(MAP_KEY_FIELD_NAME, property.getName());
        } else {
            fieldFlexInfo.put(MAP_KEY_FIELD_NAME, property.getDisplayName().getLocaleValue());
        }
        fieldFlexInfo.put(MAP_KEY_FIELD_TYPE, property.getClass().getName());
        fieldFlexInfo.put(MAP_KEY_POSITION, position);
        if (isMapped) {
            fieldFlexInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_TRUE);
        } else {
            fieldFlexInfo.put(MAP_KEY_ISMAPPED, ISMAPPED_FALSE);
        }
        tableInfo.put(fieldFlexKey, fieldFlexInfo);
    }

    public Map<String, String> getUnmappedFieldInfo(String fieldFlexKey, HRPageCache pageCache) {
        Map<String, Object> tableInfo = this.getSelectedNodeInfo(pageCache);
        Map fieldInfo = (Map)tableInfo.get(fieldFlexKey);
        return fieldInfo;
    }

    public Map<String, Object> getNodeInfo(String sourceEntityId, String targetEntityId, String hisStatus) {
        HRPageCache cache = this.getHRPageCache();
        HashMap tableInfo = (HashMap)cache.get(this.getNodeId(sourceEntityId, targetEntityId, hisStatus), Map.class);
        if (null == tableInfo) {
            tableInfo = new HashMap();
        }
        return tableInfo;
    }

    public Map<String, Object> getNodeInfo(String sourceEntityId, String targetEntityId) {
        HRPageCache cache = this.getHRPageCache();
        HashMap tableInfo = (HashMap)cache.get(this.getNodeId(sourceEntityId, targetEntityId), Map.class);
        if (null == tableInfo) {
            tableInfo = new HashMap();
        }
        return tableInfo;
    }

    public String getNodeId(String sourceEntityId, String targetEntityId, String hisStatus) {
        return sourceEntityId + "|" + targetEntityId + "|" + hisStatus;
    }

    public String getNodeId(String sourceEntityId, String targetEntityId) {
        return sourceEntityId + "|" + targetEntityId;
    }

    public Map<String, Object> getSelectedNodeInfo() {
        HRPageCache cache = this.getHRPageCache();
        return this.getSelectedNodeInfo(cache);
    }

    public Map<String, Object> getSelectedNodeInfo(HRPageCache pageCache) {
        HashMap tableInfo = (HashMap)pageCache.get(this.getSelectedTreeNodeId(), Map.class);
        if (null == tableInfo) {
            tableInfo = new HashMap();
        }
        return tableInfo;
    }

    public void drawMappedFieldContainer(String sourceTable, String targetTable, String searchText) {
        DynamicObjectCollection mappedFields = this.getModel().getEntryEntity("subentryentity");
        MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)sourceTable);
        MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)targetTable);
        DataEntityPropertyCollection sourceProperties = sourceEntityType.getProperties();
        DataEntityPropertyCollection targetProperties = targetEntityType.getProperties();
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createMappedFieldsContainerFlex(CONTROL_KEY_FLEX_MAPPEDFIELDS);
        Container fieldsContainerFlex = (Container)this.getControl(CONTROL_KEY_FLEX_MAPPEDFIELDS);
        for (DynamicObject mappedField : mappedFields) {
            String sourceField = mappedField.getString("sourcefield");
            String targetField = mappedField.getString("targetfield");
            if (HRStringUtils.isEmpty((String)sourceField) || HRStringUtils.isEmpty((String)targetField)) continue;
            DynamicProperty sourceFieldProp = (DynamicProperty)sourceProperties.get((Object)sourceField);
            DynamicProperty targetFieldProp = (DynamicProperty)targetProperties.get((Object)targetField);
            this.appendMappedField(sourceFieldProp, sourceEntityType, targetFieldProp, targetEntityType, fieldsContainerFlexAp, searchText);
        }
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(CONTROL_KEY_FLEX_MAPPEDFIELDS, fieldsContainerFlexAp.createControl());
    }

    public void drawEmptyMappedFiledContainer(String containerKey) {
        FlexPanelAp fieldsContainerFlexAp = FieldMapConfDrawPageUtil.createMappedFieldsContainerFlex(containerKey);
        Container fieldsContainerFlex = (Container)this.getControl(containerKey);
        List items = ((Container)fieldsContainerFlexAp.buildRuntimeControl()).getItems();
        fieldsContainerFlex.getItems().addAll(items);
        this.getView().createControlIndex(fieldsContainerFlex.getItems());
        this.getView().updateControlMetadata(containerKey, fieldsContainerFlexAp.createControl());
    }

    private void appendMappedField(DynamicProperty sourceFieldProp, MainEntityType sourceEntityType, DynamicProperty targetFieldProp, MainEntityType targetEntityType, FlexPanelAp fieldsContainerFlexAp, String searchText) {
        if (sourceFieldProp == null || targetFieldProp == null) {
            return;
        }
        FlexPanelAp fieldFlexAp = FieldMapConfDrawPageUtil.combineUnselectedMappedFieldAp(sourceFieldProp, sourceEntityType.getDisplayName().getLocaleValue(), true, targetFieldProp, targetEntityType.getDisplayName().getLocaleValue(), false);
        this.cacheMappedFieldInfo(fieldFlexAp.getKey(), sourceEntityType.getName(), (IDataEntityProperty)sourceFieldProp, targetEntityType.getName(), (IDataEntityProperty)targetFieldProp);
        if (this.matchSearch(sourceFieldProp, targetFieldProp, searchText)) {
            fieldsContainerFlexAp.getItems().add(fieldFlexAp);
        }
    }

    private boolean matchSearch(DynamicProperty sourceFieldProp, DynamicProperty targetFieldProp, String searchText) {
        return this.matchSearch((IDataEntityProperty)sourceFieldProp, searchText) || this.matchSearch((IDataEntityProperty)targetFieldProp, searchText);
    }

    private void cacheMappedFieldInfo(String fieldFlexKey, String sourceEntityType, IDataEntityProperty sourceProperty, String targetEntityType, IDataEntityProperty targetProperty) {
        HRPageCache pageCache = this.getHRPageCache();
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo(pageCache);
        HashMap<String, String> fieldFlexInfo = (HashMap<String, String>)treeNodeInfo.get(fieldFlexKey);
        if (null != fieldFlexInfo) {
            return;
        }
        fieldFlexInfo = new HashMap<String, String>();
        fieldFlexInfo.put(MAP_KEY_SOURCE_ENTITY, sourceEntityType);
        fieldFlexInfo.put(MAP_KEY_SOURCE_PROP, sourceProperty.getName());
        fieldFlexInfo.put(MAP_KEY_TARGET_ENTITY, targetEntityType);
        fieldFlexInfo.put(MAP_KEY_TARGET_PROP, targetProperty.getName());
        treeNodeInfo.put(fieldFlexKey, fieldFlexInfo);
        pageCache.put(this.getSelectedTreeNodeId(), treeNodeInfo);
    }

    private boolean isFieldShouldShow(IDataEntityProperty property) {
        LocaleString chineseName = property.getDisplayName();
        String dbName = property.getAlias();
        String name = property.getName();
        return null != chineseName || "id".equals(name);
    }

    private boolean isFieldMapped(String fieldKey, String propertyNumber) {
        Map<String, Object> treeNodeInfo = this.getSelectedNodeInfo();
        Map fieldInfo = (Map)treeNodeInfo.get(fieldKey);
        if (null == fieldInfo) {
            DynamicObjectCollection mappedFields = this.getModel().getEntryEntity("subentryentity");
            for (DynamicObject mappedField : mappedFields) {
                if (!HRStringUtils.equals((String)mappedField.getString("sourcefield"), (String)propertyNumber)) continue;
                return true;
            }
            return false;
        }
        String isMapped = (String)fieldInfo.get(MAP_KEY_ISMAPPED);
        return ISMAPPED_TRUE.equals(isMapped);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String nodeId = (String)evt.getNodeId();
        if (HRStringUtils.equals((String)CONTROL_KEY_PAIRTREE, (String)treeView.getKey())) {
            if (TREE_ID_ROOT.equals(nodeId)) {
                evt.setCancel(true);
                return;
            }
            this.clearSearchText();
            this.selectTableEntityRow(nodeId);
            this.showFields(nodeId);
        }
    }

    private void clearSearchText() {
        Search searchSource = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_SOURCE);
        searchSource.setSearchKey("");
        Search searchTarget = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_TARGET);
        searchTarget.setSearchKey("");
        Search searchMapped = (Search)this.getView().getControl(CONTROL_KEY_SEARCH_MAPPED);
        searchMapped.setSearchKey("");
    }

    private void selectTableEntityRow(String nodeId) {
        DynamicObjectCollection mappedTables = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < mappedTables.size(); ++i) {
            DynamicObject mappedTable = (DynamicObject)mappedTables.get(i);
            String[] tableNumbers = nodeId.split("\\|");
            DynamicObject sourceEntity = mappedTable.getDynamicObject("sourceentity");
            DynamicObject targetEntity = mappedTable.getDynamicObject("targetentity");
            if (null == sourceEntity || null == targetEntity || !HRStringUtils.equals((String)sourceEntity.getString("number"), (String)tableNumbers[0]) || !HRStringUtils.equals((String)targetEntity.getString("number"), (String)tableNumbers[1])) continue;
            EntryGrid tableEntityGrid = (EntryGrid)this.getControl("entryentity");
            tableEntityGrid.selectRows(i);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.initPairTreeView();
        this.updateTreeView();
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String propertyName;
        switch (propertyName = evt.getProperty().getName()) {
            case "sourceentity": {
                this.updateTreeView();
                break;
            }
            case "targetentity": {
                this.updateTreeView();
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs evt) {
        if (HRStringUtils.equals((String)"entryentity", (String)evt.getEntryProp().getName())) {
            this.updateTreeView();
        }
    }

    private void setMapKeyComboProp(String entityKey, String comboKey, int rowIndex) {
        HRPageCache cache;
        MulComboEdit fieldEditor = (MulComboEdit)this.getView().getControl(comboKey);
        DynamicObject entity = (DynamicObject)this.getModel().getValue(entityKey, rowIndex);
        if (null == entity) {
            return;
        }
        String entityNumber = entity.getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String initedComboName = entityNumber + comboKey;
        if (HRStringUtils.equals((String)initedComboName, (String)((String)(cache = this.getHRPageCache()).get(CACHE_KEY_LAST_INITED_COMBO, String.class)))) {
            return;
        }
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        ArrayList<ComboItem> fieldCombos = new ArrayList<ComboItem>();
        for (IDataEntityProperty property : properties) {
            if (!this.isFieldShouldShow(property)) continue;
            ComboItem item = new ComboItem();
            String name = property.getName();
            LocaleString chineseNameLS = property.getDisplayName();
            String chineseName = null == chineseNameLS ? name : chineseNameLS.getLocaleValue();
            item.setValue(name);
            item.setCaption(new LocaleString(name + "(" + chineseName + ")"));
            fieldCombos.add(item);
        }
        fieldEditor.setComboItems(fieldCombos);
        EntryGrid tableEntry = (EntryGrid)this.getControl("entryentity");
        cache.put(CACHE_KEY_LAST_INITED_COMBO, (Object)initedComboName);
        tableEntry.focusCell(rowIndex, comboKey);
    }

    private void updateTreeView() {
        HRPageCache pageCache = this.getHRPageCache();
        TreeNode root = (TreeNode)pageCache.get(TREE_ID_ROOT, TreeNode.class);
        TreeView pairTree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        String selectedTreeNodeId = this.getSelectedTreeNode(pairTree);
        boolean isSelectedTreeNodeAlive = false;
        root.setChildren(new ArrayList());
        DynamicObjectCollection entityPairEntry = this.getModel().getEntryEntity("entryentity");
        int mappedFieldAmmount = 0;
        for (DynamicObject entityPair : entityPairEntry) {
            DynamicObject sourceEntity = entityPair.getDynamicObject("sourceentity");
            DynamicObject targetEntity = entityPair.getDynamicObject("targetentity");
            if (null == sourceEntity || null == targetEntity) continue;
            String sourceEntityNumber = sourceEntity.getString("number");
            String targetEntityNumber = targetEntity.getString("number");
            String targetEntityName = targetEntity.getString("name");
            this.selectTableEntityRow(this.getNodeId(sourceEntityNumber, targetEntityNumber));
            int rowAmount = this.getModel().getEntryRowCount("subentryentity");
            mappedFieldAmmount += rowAmount;
            String nodeId = this.getNodeId(sourceEntityNumber, targetEntityNumber);
            TreeNode treeNode = new TreeNode(TREE_ID_ROOT, nodeId, targetEntityName + "(" + rowAmount + ")");
            root.addChild(treeNode);
            if (!HRStringUtils.equals((String)selectedTreeNodeId, (String)nodeId)) continue;
            isSelectedTreeNodeAlive = true;
        }
        root.setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5168\u90e8(%s)", (String)"FileMapManagerEdit_5", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), mappedFieldAmmount));
        pairTree.updateNode(root);
        pairTree.expand(TREE_ID_ROOT);
        if (isSelectedTreeNodeAlive) {
            pairTree.treeNodeClick(TREE_ID_ROOT, selectedTreeNodeId);
            TreeNode treeNode = root.getTreeNode(selectedTreeNodeId, 2);
            pairTree.focusNode(treeNode);
            this.selectTableEntityRow(treeNode.getId());
        } else {
            this.cleanFields();
        }
        this.saveRootNode(root);
    }

    private String getSelectedTreeNodeId() {
        TreeView pairTree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        return this.getSelectedTreeNode(pairTree);
    }

    public String getSelectedTreeNode(TreeView pairTree) {
        List selectedNodeIds = pairTree.getTreeState().getSelectedNodeId();
        if (null == selectedNodeIds || selectedNodeIds.isEmpty()) {
            return "";
        }
        return (String)selectedNodeIds.get(0);
    }

    public HRPageCache getHRPageCache() {
        if (null == this.hrPageCache) {
            this.hrPageCache = new HRPageCache(this.getPageCache());
        }
        return this.hrPageCache;
    }

    public void initPairTreeView() {
        TreeView pairTree = (TreeView)this.getView().getControl(CONTROL_KEY_PAIRTREE);
        TreeNode root = new TreeNode("", TREE_ID_ROOT, ResManager.loadKDString((String)"\u5168\u90e8", (String)"FileMapManagerEdit_6", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
        root.setCheckable(false);
        this.saveRootNode(root);
        pairTree.addNode(root);
    }

    public void saveRootNode(TreeNode root) {
        HRPageCache pageCache = this.getHRPageCache();
        pageCache.put(TREE_ID_ROOT, (Object)root);
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String key = search.getKey();
        String searchText = evt.getText();
        String nodeId = this.getSelectedTreeNodeId();
        if (this.isTreeNoData()) {
            return;
        }
        String[] tableNumbers = nodeId.split("\\|");
        String sourceTable = tableNumbers[0];
        String targetTable = tableNumbers[1];
        switch (key) {
            case "search_source": {
                this.drawUnmappedFieldContainer(sourceTable, CONTROL_KEY_FLEX_SOURCEFIELDS, "source", searchText);
                break;
            }
            case "search_target": {
                this.drawUnmappedFieldContainer(targetTable, CONTROL_KEY_FLEX_TARGETFIELDS, "target", searchText);
                break;
            }
            case "search_mapped": {
                this.drawMappedFieldContainer(sourceTable, targetTable, searchText);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject entityConf = (DynamicObject)this.getModel().getValue(CONTROL_KEY_ENEITYCONF);
        if ("sourceentity".equals(fieldKey)) {
            showParameter.getListFilterParameter().getQFilters().add(this.getSourceEntityFilter(entityConf));
        }
        if ("targetentity".equals(fieldKey)) {
            showParameter.getListFilterParameter().getQFilters().add(this.getTargetEntityFilter(entityConf));
        }
    }

    private QFilter getSourceEntityFilter(DynamicObject entityConf) {
        if (null == entityConf) {
            return this.getDefaultEntityFilter();
        }
        DynamicObjectCollection sourceEntities = entityConf.getDynamicObjectCollection("sourceentryentity");
        ArrayList sourceEntityIds = new ArrayList(sourceEntities.size());
        sourceEntities.forEach(sourceEntity -> sourceEntityIds.add(sourceEntity.getString("sourceentity.id")));
        QFilter entityFilter = new QFilter("id", "in", sourceEntityIds);
        return entityFilter;
    }

    public QFilter getDefaultEntityFilter() {
        return new QFilter("modeltype", "=", (Object)"BaseFormModel").or(new QFilter("modeltype", "=", (Object)"BillFormModel"));
    }

    private QFilter getTargetEntityFilter(DynamicObject entityConf) {
        if (null == entityConf) {
            return this.getDefaultEntityFilter();
        }
        DynamicObjectCollection sourceEntities = entityConf.getDynamicObjectCollection("targetentryentity");
        ArrayList sourceEntityIds = new ArrayList(sourceEntities.size());
        sourceEntities.forEach(sourceEntity -> sourceEntityIds.add(sourceEntity.getString("targetentity.id")));
        QFilter entityFilter = new QFilter("id", "in", sourceEntityIds);
        return entityFilter;
    }
}

