/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.reviewresult;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class ShowReviewResultPlugin
extends HRDynamicFormBasePlugin {
    private static final String CONTROL_TALENTMAP = "talentmapcontrol";

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        Map<String, Object> resultGridInfo = this.getReviewResultGridInfo();
        this.loadReviewResultGridView(resultGridInfo);
    }

    private Map<String, Object> getReviewResultGridInfo() {
        Map reviewResultGridInfo = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object reviewResultIdObj = customParams.get("reviewResultId");
        if (reviewResultIdObj != null && Long.parseLong(reviewResultIdObj.toString()) != 0L) {
            Long reviewResultId = Long.valueOf(reviewResultIdObj.toString());
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tdcs_reviewresult");
            DynamicObject reviewResult = serviceHelper.queryOne("person,xdimname,ydimname,positionnumber,reviewposition,gridmap_tag", (Object)reviewResultId);
            String positionNumber = reviewResult.getString("positionnumber");
            String personName = reviewResult.getString("person.name");
            String headSculpture = reviewResult.getString("person.headsculpture");
            String gridMapConfig = reviewResult.getString("gridmap_tag");
            String xDimName = reviewResult.getString("xdimname");
            String yDimName = reviewResult.getString("ydimname");
            reviewResultGridInfo = (Map)SerializationUtils.fromJsonString((String)gridMapConfig, Map.class);
            HashMap<String, String> personInfo = new HashMap<String, String>(5);
            personInfo.put("number", positionNumber);
            personInfo.put("personName", personName);
            personInfo.put("headSculpture", HRImageUrlUtil.getImageFullUrl((String)headSculpture));
            reviewResultGridInfo.put("personInfo", personInfo);
            Map xAxisInfo = (Map)reviewResultGridInfo.get("xAxisInfo");
            Map yAxisInfo = (Map)reviewResultGridInfo.get("yAxisInfo");
            xAxisInfo.put("name", xDimName);
            yAxisInfo.put("name", yDimName);
        }
        return reviewResultGridInfo;
    }

    private void loadReviewResultGridView(Map<String, Object> resultGridInfo) {
        CustomControl gridControl = (CustomControl)this.getView().getControl(CONTROL_TALENTMAP);
        Map<String, Object> mapData = this.getCustomEventParams();
        mapData.put("data", resultGridInfo);
        gridControl.setData(mapData);
    }

    private Map<String, Object> getCustomEventParams() {
        HashMap mapData = Maps.newHashMapWithExpectedSize((int)10);
        mapData.put("code", 200);
        mapData.put("success", true);
        mapData.put("eventName", "loadData");
        mapData.put("eventStatus", "init");
        mapData.put("times", System.currentTimeMillis());
        return mapData;
    }
}

