/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.talentpool.common;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;

public class TalentInPoolInfoPanelPlugin
extends HRDynamicFormBasePlugin
implements ClickListener {
    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter fsp = args.getFormShowParameter();
        fsp.setStatus(OperationStatus.VIEW);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label outOfBillNoLabel = (Label)this.getControl("billno");
        outOfBillNoLabel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        model.setValue("talentpool", customParams.get("talentpool"));
        model.setValue("intopooldate", customParams.get("intopooldate"));
        model.setValue("intopoolreason", customParams.get("intopoolreason"));
        Label billNoLabel = (Label)this.getControl("billno");
        billNoLabel.setText(String.valueOf(customParams.get("billno")));
        model.setValue("intopooltype", customParams.get("intopooltype"));
        model.setValue("supervisor", customParams.get("supervisor"));
        model.setValue("targetcompetency", customParams.get("targetcompetency"));
        model.setValue("currmatchdegree", customParams.get("currmatchdegree"));
        Label label = (Label)this.getControl("inpooltime");
        Object inPoolTime = customParams.get("inpooltime");
        if (Objects.isNull(inPoolTime)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inpooltime"});
        } else {
            label.setText(ResManager.loadKDString((String)"\u3010\u5728\u6c60{0}\u5929\u3011", (String)"TalentInPoolInfoPanelEdit_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{inPoolTime}));
        }
    }

    public void afterBindData(EventObject e) {
        List attachments;
        Object pkId;
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object tag = fsp.getCustomParam("talp_entrypoolbill");
        if (!Objects.isNull(tag) && "true".equals(tag)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billno", "intobillnolabel"});
            Label label = (Label)this.getControl("labelap");
            if (!Objects.isNull(label)) {
                label.setText(ResManager.loadKDString((String)"\u5165\u6c60\u4fe1\u606f", (String)"TalentInPoolInfoPanelPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            }
        }
        if (Objects.isNull(pkId = fsp.getCustomParam("id"))) {
            Object billNo = fsp.getCustomParam("billno");
            DynamicObject entryExitPoolBill = TalentPoolQueryHelper.queryOriginalOneByBillNo((String)"id", (String)String.valueOf(billNo));
            if (Objects.isNull(entryExitPoolBill)) {
                return;
            }
            pkId = entryExitPoolBill.getLong("id");
        }
        if (CollectionUtils.isEmpty((Collection)(attachments = AttachmentServiceHelper.getAttachments((String)"talp_entrypoolbill", (Object)pkId, (String)"attachmentpanel")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanel"});
            return;
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.bindData(attachments);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("billno".equals(key)) {
            BillShowParameter bsp = new BillShowParameter();
            bsp.setStatus(OperationStatus.VIEW);
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.setFormId("talp_entrypoolbill");
            Object pkId = this.getView().getFormShowParameter().getCustomParam("id");
            if (Objects.isNull(pkId)) {
                Object billNo = this.getView().getFormShowParameter().getCustomParam("billno");
                DynamicObject entryExitPoolBill = TalentPoolQueryHelper.queryOriginalOneByBillNo((String)"id", (String)String.valueOf(billNo));
                if (Objects.isNull(entryExitPoolBill)) {
                    return;
                }
                pkId = entryExitPoolBill.getLong("id");
            }
            bsp.setPkId(pkId);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }
}

