/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.talentpool.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.common.perchange.APositionTypeEnum;
import kd.tdc.tdcs.enums.common.StatusStyleEnum;
import kd.tdc.tdcs.enums.talentpool.InPoolStatusEnum;

public class TalentPoolPersonInfoPlugin
extends HRDynamicFormBasePlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(TalentPoolPersonInfoPlugin.class);
    private final ExternalService EXTERNAL_SERVICE = (ExternalService)ServiceFactory.getService(ExternalService.class);
    private static final HrpiService HRPI_SERVICE = (HrpiService)ServiceFactory.getService(HrpiService.class);
    private static final String SHOW_MORE_INFO = "showmoreinfo";
    private static final String VECTOR_AP = "vectorap";
    private static final String OPE_SHOW_MORE_INFO = "show_more_info";
    private static final String SCENE_NUMBER = "sceneNumber";

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter fsp = args.getFormShowParameter();
        fsp.setStatus(OperationStatus.VIEW);
    }

    public void registerListener(EventObject e) {
        Vector vector;
        super.registerListener(e);
        Label showMoreInfo = (Label)this.getControl(SHOW_MORE_INFO);
        if (!Objects.isNull(showMoreInfo)) {
            showMoreInfo.addClickListener((ClickListener)this);
        }
        if (!Objects.isNull(vector = (Vector)this.getControl(VECTOR_AP))) {
            vector.addClickListener((ClickListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String inPoolStatus = (String)fsp.getCustomParam("inpoolstatus");
        if (Objects.isNull(inPoolStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inpoolstatus"});
        } else {
            InPoolStatusEnum statusEnum = InPoolStatusEnum.getEnumByStatus((String)inPoolStatus);
            Label label = (Label)this.getControl("inpoolstatus");
            label.setText(InPoolStatusEnum.getEnumByStatus((String)inPoolStatus).getDesc());
            Map customStyles = StatusStyleEnum.buildStyleMap((StatusStyleEnum)statusEnum.getStyleEnum(), (int)1, null);
            this.getView().updateControlMetadata("inpoolstatus", customStyles);
        }
        long personId = (Long)fsp.getCustomParam("person");
        this.showBaseInfo(personId);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String clickKey = source.getKey();
        if (SHOW_MORE_INFO.equals(clickKey) || VECTOR_AP.equals(clickKey)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String parentPageId = (String)fsp.getCustomParam("pageId");
            IFormView parentView = SessionManager.getCurrent().getViewNoPlugin(parentPageId);
            String entityId = parentView.getEntityId();
            if (HRStringUtils.equals((String)entityId, (String)"tdcs_reservetalent") || HRStringUtils.equals((String)entityId, (String)"talp_entrypoolbill") || HRStringUtils.equals((String)entityId, (String)"talp_exitpoolbill")) {
                if (parentView.getFormShowParameter().getCancelRight() != 0) {
                    String msg = ResManager.loadKDString((String)"\u60a8\u7684\u201c{0}\u201d\u529f\u80fd\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"TalentPoolPersonInfoEdit_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{parentView.getFormShowParameter().getFormConfig().getCaption().toString()});
                    this.getView().showConfirm(msg, MessageBoxOptions.None);
                    return;
                }
                OperationResult operationResult = parentView.invokeOperation(OPE_SHOW_MORE_INFO);
                parentView.sendFormAction(parentView);
                if (!operationResult.isSuccess()) {
                    List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                    for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                        this.getView().showErrorNotification(iOperateInfo.getMessage());
                    }
                    return;
                }
            }
            HashMap customParamMap = Maps.newHashMap();
            customParamMap.put("employee", fsp.getCustomParam("employee"));
            customParamMap.put("person", fsp.getCustomParam("person"));
            customParamMap.put(SCENE_NUMBER, "TALP_1010_S");
            HRMServiceResult hrmServiceResult = (HRMServiceResult)HRMServiceHelper.invokeHRMPService((String)"hrti", (String)"IHRTIService", (String)"showTalentPortrait", (Object[])new Object[]{customParamMap});
            if (hrmServiceResult.isSuccess()) {
                this.getView().showForm((FormShowParameter)hrmServiceResult.getReturnData());
            } else {
                this.getView().showErrorNotification(hrmServiceResult.getMessage());
            }
        }
    }

    private void showBaseInfo(long personId) {
        Long gender_id;
        Object education;
        List perInfoList = HRPI_SERVICE.listBatchPropPersonAttach((List)Lists.newArrayList((Object[])new Long[]{personId}), "person,education", new QFilter("ishighestdegree", "=", (Object)"1"), "hrpi_pereduexp");
        boolean isVisible = Boolean.FALSE;
        if (!CollectionUtils.isEmpty((Collection)perInfoList) && !Objects.isNull(education = ((Map)perInfoList.get(0)).get("education")) && Long.parseLong(education.toString()) != 0L) {
            this.getModel().setValue("edu", education);
            isVisible = Boolean.TRUE;
        }
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"edu_icon", "edu"});
        Map perInfoMap = this.EXTERNAL_SERVICE.getPersonInfo(personId);
        if (CollectionUtils.isEmpty((Map)perInfoMap)) {
            return;
        }
        Object entServiceLen = perInfoMap.get("entservicelen");
        if (!Objects.isNull(entServiceLen)) {
            Label label = (Label)this.getControl("entservicelen");
            DecimalFormat decimalFormat = new DecimalFormat("0.0");
            String formatResult = decimalFormat.format(Float.parseFloat(entServiceLen.toString()));
            formatResult = formatResult.endsWith(".0") ? formatResult.substring(0, formatResult.length() - 2) : formatResult;
            String formatStr = ResManager.loadKDString((String)"\u53f8\u9f84{0}\u5e74", (String)"TalentPoolPersonInfoEdit_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{formatResult});
            label.setText(formatStr);
        }
        if (Objects.isNull(gender_id = (Long)perInfoMap.get("gender_id")) || gender_id == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"gender_icon", "gender"});
        } else {
            this.getModel().setValue("gender", (Object)gender_id);
        }
        this.getView().getModel().setValue("headsculpture", (Object)(perInfoMap.get("headsculpture") == null ? "" : perInfoMap.get("headsculpture")));
        Label numberLabel = (Label)this.getControl("number");
        numberLabel.setText(perInfoMap.get("number") == null ? "" : perInfoMap.get("number").toString());
        Label nameLabel = (Label)this.getControl("name");
        nameLabel.setText(perInfoMap.get("name") == null ? "" : perInfoMap.get("name").toString());
        Map primaryEmpPosOrgRelByPersonIds = HRPI_SERVICE.getPrimaryEmpPosOrgRelByPersonIds("adminorg,company,apositiontype,stdposition,position,job,person", Collections.singletonList(personId));
        List primaryEmpPosOrgRelList = (List)primaryEmpPosOrgRelByPersonIds.get(personId);
        if (CollectionUtils.isEmpty((Collection)primaryEmpPosOrgRelList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"company_icon", "company", "adminorg_icon", "adminorg", "position_icon", "position"});
        } else {
            DynamicObject primaryEmpPosOrgRel = (DynamicObject)primaryEmpPosOrgRelList.get(0);
            long companyId = primaryEmpPosOrgRel.getLong("company_id");
            if (companyId == 0L) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"company_icon", "company"});
            } else {
                this.getModel().setValue("company", (Object)companyId);
            }
            long adminOrgId = primaryEmpPosOrgRel.getLong("adminorg_id");
            if (adminOrgId == 0L) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"adminorg_icon", "adminorg"});
            } else {
                this.getModel().setValue("adminorg", (Object)adminOrgId);
            }
            APositionTypeEnum aPositionType = APositionTypeEnum.getEnumByType((String)primaryEmpPosOrgRel.getString("apositiontype"));
            DynamicObject positionObj = primaryEmpPosOrgRel.getDynamicObject(aPositionType.getFiled());
            Vector posVectorIcon = (Vector)this.getControl("position_icon");
            if (positionObj == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"position_icon", "position"});
            } else {
                Tips tips = new Tips();
                LocaleString localeString = new LocaleString();
                localeString.setLocaleValue(aPositionType.getDesc());
                tips.setContent(localeString);
                tips.setType("text");
                tips.setTriggerType("hover");
                tips.setShowIcon(false);
                posVectorIcon.addTips(tips);
                Label pos = (Label)this.getControl("position");
                pos.setText(positionObj.getString("name"));
            }
        }
    }
}

