/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.talentpool.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;

public class TalentRecommendInfoPlugin
extends HRDynamicFormBasePlugin {
    private final TalentPoolApplicationService talentPoolApplicationService = (TalentPoolApplicationService)ServiceFactory.getService(TalentPoolApplicationService.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        FormShowParameter fsp = args.getFormShowParameter();
        fsp.setStatus(OperationStatus.VIEW);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        List recommendIds = (List)fsp.getCustomParam("id");
        Map recommendInfo = this.talentPoolApplicationService.queryRecommendInfoByIds("id,recommendemp,recommendintopool,recommenddate,recommendreason", recommendIds);
        if (!CollectionUtils.isEmpty((Map)recommendInfo)) {
            ArrayList recommendInfoIds = Lists.newArrayList(recommendInfo.keySet());
            int[] rows = this.getModel().batchCreateNewEntryRow("entryentity", recommendInfo.size());
            for (int i = 0; i < rows.length; ++i) {
                Map recommendDyMap = (Map)recommendInfo.get(recommendInfoIds.get(i));
                if (!CollectionUtils.isEmpty((Map)recommendDyMap)) {
                    this.getModel().setValue("recommenddate", recommendDyMap.get("recommenddate"), rows[i]);
                    this.getModel().setValue("recommendemp", recommendDyMap.get("recommendemp"), rows[i]);
                    this.getModel().setValue("recommendintopool", recommendDyMap.get("recommendintopool"), rows[i]);
                    Object recommendReason = recommendDyMap.get("recommendreason");
                    if (HRStringUtils.isNotEmpty((String)String.valueOf(recommendReason))) {
                        this.getModel().setValue("recommendreason", recommendReason, rows[i]);
                    } else {
                        this.getModel().setValue("isshowreason", (Object)false, rows[i]);
                    }
                }
                if (i != rows.length - 1) continue;
                this.getModel().setValue("isshowline", (Object)false, rows[i]);
            }
        }
    }
}

