/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.talentpool.pool;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;
import kd.tdc.tdcs.common.constants.talentpool.pool.TalentPoolConstants;

public class TalentPoolEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
TalentPoolConstants {
    private static final FormCommonService FORM_COMMON_SERVICE = (FormCommonService)ServiceFactory.getService(FormCommonService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit applyAdminOrg = (BasedataEdit)this.getControl("applyadminorg");
        applyAdminOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject value = (DynamicObject)this.getModel().getValue("group");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status) && !Objects.isNull(value)) {
            this.getModel().setValue("group", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldKey = args.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)"islimitpersonnum")) {
            String newValue = (String)args.getChangeSet()[0].getNewValue();
            this.showPersonLimit(HRStringUtils.equals((String)newValue, (String)"1"));
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.showFieldControl();
    }

    private void showFieldControl() {
        String limitPerson = (String)this.getModel().getValue("islimitpersonnum");
        this.showPersonLimit(HRStringUtils.equals((String)limitPerson, (String)"1"));
    }

    private void showPersonLimit(Boolean isDisplay) {
        DecimalEdit personNum = (DecimalEdit)this.getControl("personnumlimit");
        if (isDisplay.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"personnumlimit"});
            personNum.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"personnumlimit"});
            personNum.setMustInput(false);
            this.getModel().setValue("personnumlimit", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection collection;
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("applyadminorg".equals(name) && HRCollUtil.isNotEmpty((Collection)(collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity")))) {
            List ids = collection.stream().filter(item -> !Objects.isNull(item.getDynamicObject("applyadminorg"))).map(item -> item.getDynamicObject("applyadminorg").getLong("id")).collect(Collectors.toList());
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", ids));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        FORM_COMMON_SERVICE.setPropertyNotDataChanged(this.getModel(), new String[]{"clickadminorg", "allapplyadminorg"});
    }
}

