/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.talentpool.reservetalent;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.tdcs.bussiness.application.TalentPoolApplicationService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;
import kd.tdc.tdcs.common.constants.talentpool.reservetalent.ReserveTalentConstant;
import kd.tdc.tdcs.enums.talentpool.InPoolStatusEnum;

public class ReserveTalentEdit
extends HRDataBaseEdit
implements ReserveTalentConstant {
    private static final Log LOG = LogFactory.getLog(ReserveTalentEdit.class);
    private static final String OP_MODIFYINPOOLINFO = "modifyinpoolinfo";
    private static final String OP_MODIFYOUTOFPOOLINFO = "modifyoutofpoolinfo";

    public void preOpenForm(PreOpenFormEventArgs args) {
        DynamicObject reserveTalent;
        super.preOpenForm(args);
        FormShowParameter fsp = args.getFormShowParameter();
        Object pkId = fsp.getCustomParam("id");
        if (!Objects.isNull(pkId) && !Objects.isNull(reserveTalent = TalentPoolQueryHelper.queryOneReserveTalentById((String)"person.name", (Object)pkId))) {
            fsp.setCaption(ResManager.loadKDString((String)"\u50a8\u5907\u4eba\u624d\u7ba1\u7406\u8be6\u60c5-{0}", (String)"ReserveTalentEdit_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{reserveTalent.getString("person.name")}));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dataEntity = model.getDataEntity();
        long employeeId = dataEntity.getLong("employee_id");
        long perId = dataEntity.getLong("person_id");
        FormShowParameter fsp = TalentPoolApplicationService.buildPersonInfoFSP((String)"person_info_flex", (long)employeeId, (long)perId, (String)this.getView().getPageId());
        fsp.setCustomParam("inpoolstatus", (Object)dataEntity.getString("inpoolstatus"));
        view.showForm(fsp);
        this.showIntoPoolPanel();
        this.showOutOfPoolPanel();
        this.showRecommendPanel();
        FormShowParameter poolFsp = TalentPoolApplicationService.buildTalentPoolInfoFSP((String)"pool_info_flex", (Object)dataEntity.get("talentpool_id"));
        view.showForm(poolFsp);
        this.getView().setVisible(Boolean.FALSE, new String[]{"incompanyexpflex", "qualificationflex"});
        model.setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OP_MODIFYINPOOLINFO.equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.showModifyInPoolInfoView();
        }
        if (OP_MODIFYOUTOFPOOLINFO.equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.showModifyOutOfPoolInfoView();
        }
        if ("new_exit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            BillShowParameter bsp = (BillShowParameter)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"buildEntryExitPoolFsp", (Object[])new Object[]{operateKey});
            bsp.setCustomParam("talentpool", (Object)this.getModel().getDataEntity().getLong("talentpool_id"));
            bsp.setCustomParam("reservetalent", (Object)this.getModel().getDataEntity().getLong("id"));
            bsp.setCustomParam("formId", (Object)"tdcs_reservetalent");
            bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm((FormShowParameter)bsp);
        }
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        if (!CollectionUtils.isEmpty((Map)returnData)) {
            if (OP_MODIFYINPOOLINFO.equals(actionId)) {
                this.getModel().setValue("currmatchdegree", returnData.get("currmatchdegree"));
                this.getModel().setValue("targetcompetency", returnData.get("targetcompetency"));
                this.getModel().setValue("supervisor", returnData.get("supervisor"));
                this.getModel().setValue("intopooltype", returnData.get("intopooltype"));
                this.getModel().setValue("intopoolreason", returnData.get("intopoolreason"));
            }
            if (OP_MODIFYOUTOFPOOLINFO.equals(actionId)) {
                this.getModel().setValue("outofpooltype", returnData.get("outofpooltype"));
                this.getModel().setValue("outofpoolreason", returnData.get("outofpoolreason"));
            }
            this.getView().invokeOperation("save");
        }
        if ("new_exit".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showIntoPoolPanel() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        HashMap customParams = Maps.newHashMap();
        customParams.put("talentpool", dataEntity.get("talentpool_id"));
        customParams.put("billno", dataEntity.getString("intobillno"));
        customParams.put("intopooltype", dataEntity.get("intopooltype_id"));
        customParams.put("intopooldate", dataEntity.getDate("intopooldate"));
        customParams.put("intopoolreason", dataEntity.getString("intopoolreason"));
        customParams.put("inpooltime", dataEntity.get("inpooltime"));
        customParams.put("targetcompetency", dataEntity.get("targetcompetency_id"));
        customParams.put("currmatchdegree", dataEntity.get("currmatchdegree_id"));
        DynamicObject supervisor = dataEntity.getDynamicObject("supervisor");
        if (!Objects.isNull(supervisor)) {
            customParams.put("supervisor", supervisor.getPkValue());
        }
        FormShowParameter fsp = TalentPoolApplicationService.buildInPoolInfoFSP((String)"in_pool_info_show", (Map)customParams);
        this.getView().showForm(fsp);
    }

    private void showModifyOutOfPoolInfoView() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("tdcs_modifyoutofpoolinfo");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_MODIFYOUTOFPOOLINFO));
        this.getView().showForm(fsp);
    }

    private void showModifyInPoolInfoView() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("tdcs_modifyinpoolinfo");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_MODIFYINPOOLINFO));
        this.getView().showForm(fsp);
    }

    private void showRecommendPanel() {
        DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)collection)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"recommend_show_flex"});
        } else {
            HashMap customParams = Maps.newHashMap();
            List recommendIds = collection.stream().map(item -> item.getLong("recommendid")).collect(Collectors.toList());
            customParams.put("id", recommendIds);
            FormShowParameter fsp = TalentPoolApplicationService.buildRecommendInfoFSP((String)"recommend_show_flex", (Map)customParams);
            this.getView().showForm(fsp);
        }
    }

    private void showOutOfPoolPanel() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String inPoolStatus = dataEntity.getString("inpoolstatus");
        if (HRStringUtils.equals((String)inPoolStatus, (String)InPoolStatusEnum.IN_POOL.getStatus())) {
            return;
        }
        HashMap customParams = Maps.newHashMap();
        customParams.put("billno", dataEntity.getString("outofbillno"));
        customParams.put("outofpooltype", dataEntity.get("outofpooltype_id"));
        customParams.put("outofpoolreason", dataEntity.getString("outofpoolreason"));
        customParams.put("outofpooldate", dataEntity.getDate("outofpooldate"));
        FormShowParameter fsp = TalentPoolApplicationService.buildOutPoolInfoFSP((String)"out_pool_info_show", (Map)customParams);
        this.getView().showForm(fsp);
    }
}

