/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.talentpool.reservetalent;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;
import kd.tdc.tdcs.common.constants.talentpool.reservetalent.ReserveTalentConstant;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;
import kd.tdc.tdcs.enums.talentpool.InPoolStatusEnum;

public class ReserveTalentList
extends HRDataBaseList
implements ReserveTalentConstant {
    private static final FormCommonService FORM_BASIC_SERVICE = (FormCommonService)ServiceFactory.getService(FormCommonService.class);
    private static final String ALL_NODE_STRING = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("targetcompetency asc,intopooldate desc,group.number asc");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        FORM_BASIC_SERVICE.beforeCreateListColumns(args, "person.number");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String inPoolStatus;
        DynamicObject dynamicObject;
        boolean isInPoolPage;
        super.billListHyperLinkClick(args);
        String applyType = this.getPageCache().get("applytype");
        boolean bl = isInPoolPage = HRStringUtils.isEmpty((String)applyType) || ApplyTypeEnum.IN_POOL_PAGE.getStatus().equals(applyType);
        if (isInPoolPage && !HRObjectUtils.isEmpty((Object)(dynamicObject = TalentPoolQueryHelper.queryOneReserveTalentById((String)"id,inpoolstatus", (Object)this.getFocusRowPkId()))) && HRStringUtils.equals((String)(inPoolStatus = dynamicObject.getString("inpoolstatus")), (String)InPoolStatusEnum.OUT_POOL.getStatus())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5458\u5de5\u5728\u6c60\u72b6\u6001\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u624b\u52a8\u5237\u65b0\u9875\u9762\u3002", (String)"ReserveTalentList_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean hasExitPoolPerm;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if ("new_exit".equals(operateKey) && selectedRows.size() > 0 && (hasExitPoolPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"3=0WAUGB+EOW", (String)"tdcs_reservetalent", (String)"37LT8JOUT1XW"))) {
            Set collect;
            DynamicObject[] reserveTalentInfo = TalentPoolQueryHelper.queryReserveTalentByPkValue((String)"id,talentpool,org,inpoolstatus", (List)Lists.newArrayList((Object[])selectedRows.getPrimaryKeyValues()));
            String inPoolStatus = reserveTalentInfo[0].getString("inpoolstatus");
            if (InPoolStatusEnum.OUT_POOL.getStatus().equals(inPoolStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u5728\u6c60\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\u6216\u4e3a\u5df2\u51fa\u6c60\u72b6\u6001\uff0c\u4e0d\u80fd\u53d1\u8d77\u51fa\u6c60\u3002", (String)"ReserveTalentList_3", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                this.getView().invokeOperation("refresh");
            } else if (selectedRows.size() > 1 && !CollectionUtils.isEmpty(collect = Arrays.stream(reserveTalentInfo).map(item -> item.get("org")).collect(Collectors.toSet())) && collect.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u53d1\u8d77\u51fa\u6c60\u3002\u5f53\u524d\u6240\u9009\u62e9\u4eba\u5458\u7684\u6240\u5728\u50a8\u5907\u6c60\u4e0d\u662f\u540c\u4e00\u4e2a\u4eba\u624d\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"ReserveTalentList_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (!Objects.isNull(args.getOperationResult()) && args.getOperationResult().isSuccess()) {
            BillShowParameter bsp;
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            DynamicObject[] reserveTalentInfo = new DynamicObject[primaryKeyValues.length];
            if ("new_exit".equals(operateKey) && primaryKeyValues.length > 0) {
                reserveTalentInfo = TalentPoolQueryHelper.queryReserveTalentByPkValue((String)"id,group,talentpool", (List)Lists.newArrayList((Object[])primaryKeyValues));
                if (primaryKeyValues.length > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u524d\u53ea\u652f\u6301\u5355\u9009\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReserveTalentList_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!Objects.isNull(bsp = (BillShowParameter)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"buildEntryExitPoolFsp", (Object[])new Object[]{operateKey}))) {
                IPageCache pageCache = this.getPageCache();
                String nodeIds = pageCache.get("talentpool");
                if (HRStringUtils.isNotEmpty((String)nodeIds) && !ALL_NODE_STRING.equals(nodeIds)) {
                    bsp.setCustomParam("talentpool", (Object)Long.parseLong(nodeIds));
                }
                if ("new_exit".equals(operateKey) && primaryKeyValues.length == 1) {
                    bsp.setCustomParam("talentpool", (Object)reserveTalentInfo[0].getLong("talentpool"));
                    bsp.setCustomParam("reservetalent", (Object)reserveTalentInfo[0].getLong("id"));
                } else if ("batch_exit".equals(operateKey)) {
                    ArrayList talentList = Lists.newArrayListWithExpectedSize((int)reserveTalentInfo.length);
                    Arrays.stream(reserveTalentInfo).forEach(reserveTalent -> {
                        HashMap talentMap = Maps.newHashMap();
                        talentMap.put("talentpool", reserveTalent.getLong("talentpool"));
                        talentMap.put("reservetalent", reserveTalent.getLong("id"));
                        talentList.add(talentMap);
                    });
                    bsp.setCustomParam("person", (Object)talentList);
                }
                bsp.setCustomParam("formId", (Object)"tdcs_reservetalent");
                bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
                this.getView().showForm((FormShowParameter)bsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        String actionId;
        super.closedCallBack(callBackEvent);
        switch (actionId = callBackEvent.getActionId()) {
            case "new_entry": 
            case "batch_entry": 
            case "new_exit": 
            case "batch_exit": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }
}

