/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.talentpool.reservetalent;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.TemplateGroupBaseDataPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.application.PermissionApplicationService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;
import kd.tdc.tdcs.common.constants.talentpool.reservetalent.ReserveTalentConstant;
import kd.tdc.tdcs.enums.talentpool.ApplyTypeEnum;
import kd.tdc.tdcs.enums.talentpool.InPoolStatusEnum;

public class ReserveTalentTreeListPlugin
extends TemplateGroupBaseDataPlugin
implements RowClickEventListener,
TipsListener,
ReserveTalentConstant {
    private static final Log LOG = LogFactory.getLog(ReserveTalentTreeListPlugin.class);
    private static final String ALL_NODE_STRING = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"in_pool_page", "out_pool_page"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map filterCacheMap;
        IPageCache pageCache;
        String filterCache;
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        Object pageKey = this.getModel().getValue("applytype");
        if (ApplyTypeEnum.IN_POOL_PAGE.getStatus().equals(pageKey)) {
            commonFilterColumns.removeIf(item -> "outofpooldate".equals(item.getFieldName()) || "outofpooltype.name".equals(item.getFieldName()));
            args.getSchemeFilterColumns().removeIf(item -> "outofpooldate".equals(item.getFieldName()) || "outofpooltype.name".equals(item.getFieldName()));
        }
        if (HRStringUtils.isNotEmpty((String)(filterCache = (pageCache = this.getPageCache()).get("filterCache"))) && !CollectionUtils.isEmpty((Map)(filterCacheMap = (Map)SerializationUtils.deSerializeFromBase64((String)filterCache)))) {
            commonFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                List filterValue = (List)filterCacheMap.get(fieldName);
                if (!CollectionUtils.isEmpty((Collection)filterValue)) {
                    item.setDefaultValues(filterValue.stream().map(Object::toString).toArray());
                }
            });
            pageCache.remove("filterCache");
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String isFirstLoadPage = pageCache.get("isFirstLoadPage");
        if (HRStringUtils.isEmpty((String)isFirstLoadPage)) {
            pageCache.put("talentpool", ALL_NODE_STRING);
            String orgId = (String)fsp.getCustomParam("org");
            String talentPoolIds = (String)fsp.getCustomParam("talentpool");
            commonFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                if ("org.name".equals(fieldName) && !Objects.isNull(orgId)) {
                    item.setDefaultValues(Lists.newArrayList((Object[])new String[]{orgId}).stream().map(Object::toString).toArray());
                }
                if ("talentpool.name".equals(fieldName) && !Objects.isNull(talentPoolIds)) {
                    List poolIds = (List)SerializationUtils.deSerializeFromBase64((String)talentPoolIds);
                    item.setDefaultValues(poolIds.stream().map(Object::toString).toArray());
                }
            });
            pageCache.put("isFirstLoadPage", "false");
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        List qFilters = event.getQFilters();
        Object pageKey = this.getModel().getValue("applytype");
        boolean isOutPoolPage = ApplyTypeEnum.OUT_POOL_PAGE.getStatus().equals(pageKey);
        if (!isOutPoolPage) {
            qFilters.removeIf(item -> "outofpooldate".equals(item.getProperty()));
            qFilters.removeIf(item -> "outofpooltype.id".equals(item.getProperty()));
            qFilters.removeIf(item -> "outofpooltype.name".equals(item.getProperty()));
        }
        InPoolStatusEnum statusEnum = isOutPoolPage ? InPoolStatusEnum.OUT_POOL : InPoolStatusEnum.IN_POOL;
        qFilters.removeIf(item -> "inpoolstatus".equals(item.getProperty()));
        qFilters.add(new QFilter("inpoolstatus", "=", (Object)statusEnum.getStatus()));
        qFilters.removeIf(item -> "group".equals(item.getProperty()));
        String currentNodeId = String.valueOf(this.getTreeModel().getCurrentNodeId());
        if (!ALL_NODE_STRING.equals(currentNodeId)) {
            List<Long> allNodeIds = this.getAllNodeIds(currentNodeId);
            QFilter groupFilter = new QFilter("group", "in", allNodeIds);
            qFilters.add(groupFilter);
        }
        IPageCache pageCache = this.getPageCache();
        String talentPoolId = pageCache.get("talentpool");
        qFilters.removeIf(item -> "talentpool".equals(item.getProperty()));
        if (HRStringUtils.isNotEmpty((String)talentPoolId)) {
            if (ALL_NODE_STRING.equals(talentPoolId)) {
                List poolIds;
                String cacheIds = pageCache.get("nodeIds");
                if (HRStringUtils.isNotEmpty((String)cacheIds) && !CollectionUtils.isEmpty((Collection)(poolIds = (List)SerializationUtils.deSerializeFromBase64((String)cacheIds)))) {
                    qFilters.add(new QFilter("talentpool", "in", (Object)poolIds));
                }
            } else {
                qFilters.add(new QFilter("talentpool", "=", (Object)Long.parseLong(talentPoolId)));
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if ("talentpool.id".equals(fieldName)) {
            String currentNodeId = String.valueOf(this.getTreeModel().getCurrentNodeId());
            if (!ALL_NODE_STRING.equals(currentNodeId)) {
                List<Long> allNodeIds = this.getAllNodeIds(currentNodeId);
                args.getQfilters().add(new QFilter("group", "in", allNodeIds));
            }
            this.getPageCache().remove("talentpool");
        }
    }

    private List<Long> getAllNodeIds(String currentNodeId) {
        TreeNode root = this.getTreeModel().getRoot();
        AtomicReference<TreeNode> initNode = new AtomicReference<TreeNode>(root);
        this.findNode(root.getChildren(), currentNodeId, initNode);
        ArrayList allNodeIds = Lists.newArrayList();
        this.getAllNodeId(allNodeIds, initNode.get());
        return allNodeIds;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        Object pageKey = this.getModel().getValue("applytype");
        boolean isVisible = ApplyTypeEnum.OUT_POOL_PAGE.getStatus().equals(pageKey);
        List listColumns = args.getListColumns();
        if (isVisible) {
            if (!CollectionUtils.isEmpty((Collection)listColumns) && listColumns.stream().noneMatch(listColumn -> listColumn.getListFieldKey().equals("outofpooldate"))) {
                Optional<IListColumn> inPoolDataCol = listColumns.stream().filter(listColumn -> listColumn.getListFieldKey().equals("intopooldate")).findFirst();
                int intoPoolDate = inPoolDataCol.orElseGet(() -> (IListColumn)listColumns.get(0)).getSeq();
                ListColumn colText1 = this.createListColumn("outofpooltype.name", ResManager.loadKDString((String)"\u51fa\u6c60\u7c7b\u578b", (String)"ReserveTalentTreeListPlugin_0", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), intoPoolDate + 1);
                ListColumn colText2 = this.createListColumn("outofpooldate", ResManager.loadKDString((String)"\u51fa\u6c60\u65e5\u671f", (String)"ReserveTalentTreeListPlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), intoPoolDate + 2);
                int initSize = listColumns.size();
                for (int i = 0; i < listColumns.size(); ++i) {
                    IListColumn iListColumn = (IListColumn)listColumns.get(i);
                    if (!iListColumn.getListFieldKey().equals("intopooldate")) continue;
                    initSize = i + 1;
                    break;
                }
                listColumns.add(initSize, colText2);
                listColumns.add(initSize, colText1);
            }
        } else {
            listColumns.removeIf(listColumn -> listColumn.getListFieldKey().equals("outofpooltype.name") || listColumn.getListFieldKey().equals("outofpooldate"));
        }
    }

    public void beforeBindData(EventObject h) {
        QFilter dataRuleFilter;
        ArrayList initPoolQFilters = Lists.newArrayList();
        String currentNodeId = String.valueOf(this.getTreeModel().getCurrentNodeId());
        if (!ALL_NODE_STRING.equals(currentNodeId)) {
            List<Long> allNodeIds = this.getAllNodeIds(currentNodeId);
            initPoolQFilters.add(new QFilter("group", "in", allNodeIds));
        }
        if (!Objects.isNull(dataRuleFilter = PermissionApplicationService.getDataRule((String)"3=0WAUGB+EOW", (String)"tdcs_reservetalent", (String)"47150e89000000ac"))) {
            String property = dataRuleFilter.getProperty();
            if ("talentpool.adminorg".equals(property)) {
                initPoolQFilters.add(new QFilter(property.replace("talentpool.", ""), "in", dataRuleFilter.getValue()));
            } else {
                List nests = dataRuleFilter.getNests(true);
                for (QFilter.QFilterNest nest : nests) {
                    QFilter filter = nest.getFilter();
                    String propertyName = filter.getProperty();
                    if (!"talentpool.adminorg".equals(propertyName)) continue;
                    initPoolQFilters.add(new QFilter(propertyName.replace("talentpool.", ""), "in", filter.getValue()));
                }
            }
        }
        this.buildEntryRow(initPoolQFilters);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object value = this.getModel().getValue("applytype");
        boolean isOutPoolPage = ApplyTypeEnum.OUT_POOL_PAGE.getStatus().equals(String.valueOf(value));
        this.getView().setVisible(Boolean.valueOf(!isOutPoolPage), new String[]{"new_exit"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        ApplyTypeEnum applyTypeEnum = ApplyTypeEnum.getApplyTypeEnum((String)key);
        Object pageKey = this.getModel().getValue("applytype");
        if (!Objects.isNull(applyTypeEnum) && !applyTypeEnum.getStatus().equals(pageKey)) {
            this.getModel().setValue("applytype", (Object)applyTypeEnum.getStatus());
            Arrays.stream(ApplyTypeEnum.values()).forEach(item -> {
                HashMap customStyles = Maps.newHashMap();
                HashMap style = new HashMap();
                HashMap<String, String> border = new HashMap<String, String>();
                if (item.getLabelKey().equals(key)) {
                    customStyles.put("fc", "themeColor");
                    border.put("r", "1px_solid_themeColor");
                    border.put("l", "1px_solid_themeColor");
                    border.put("t", "1px_solid_themeColor");
                    border.put("b", "1px_solid_themeColor");
                } else {
                    customStyles.put("fc", "#212121");
                    border.put("r", "1px_solid_#D9D9D9");
                    border.put("l", "1px_solid_#D9D9D9");
                    border.put("t", "1px_solid_#D9D9D9");
                    border.put("b", "1px_solid_#D9D9D9");
                }
                style.put("b", border);
                customStyles.put("s", style);
                this.getView().updateControlMetadata(item.getLabelKey(), (Map)customStyles);
            });
            Object applyType = this.getModel().getValue("applytype");
            String applyTypeCache = this.getView().getPageCache().get("applytype");
            IListView listView = (IListView)this.getView();
            if (HRStringUtils.isEmpty((String)applyTypeCache) || !applyTypeCache.equals(applyType)) {
                this.getView().getPageCache().put("applytype", String.valueOf(applyType));
                listView.refresh();
            }
            Map filters = listView.getControlFilters().getFilters();
            HashMap filterCache = Maps.newHashMapWithExpectedSize((int)filters.size());
            filters.forEach((filed, controlFilter) -> filterCache.put(filed.replaceAll(".id", ".name"), controlFilter.getValue()));
            this.getPageCache().put("filterCache", SerializationUtils.serializeToBase64((Object)filterCache));
            this.getView().updateView("filtercontainerap");
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        super.treeNodeClick(treeNodeEvent);
        if (ALL_NODE_STRING.equals(treeNodeEvent.getNodeId())) {
            this.getPageCache().put("talentpool", ALL_NODE_STRING);
        } else {
            this.getPageCache().remove("talentpool");
        }
        IListView listView = (IListView)this.getView();
        Map filters = listView.getControlFilters().getFilters();
        HashMap filterCache = Maps.newHashMapWithExpectedSize((int)filters.size());
        filters.forEach((filed, controlFilter) -> {
            if ("talentpool.id".equals(filed)) {
                filterCache.put(filed.replaceAll(".id", ".name"), Lists.newArrayList());
                return;
            }
            if (filed.endsWith(".id")) {
                filterCache.put(filed.replaceAll(".id", ".name"), controlFilter.getValue());
            }
        });
        filters.remove("talentpool.id");
        this.getPageCache().put("filterCache", SerializationUtils.serializeToBase64((Object)filterCache));
        this.getView().updateView("filtercontainerap");
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid source = (EntryGrid)evt.getSource();
        if (HRStringUtils.equals((String)source.getEntryKey(), (String)"entryentity")) {
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            int currClickRow = evt.getRow();
            String cardType = (String)this.getModel().getValue("cardtype", currClickRow);
            IPageCache pageCache = this.getPageCache();
            if (CardTypeEnum.ALL_CARD.getCardType().equals(cardType)) {
                pageCache.put("talentpool", ALL_NODE_STRING);
                List poolIds = entryEntity.stream().filter(item -> CardTypeEnum.VIEW_CARD.cardType.equals(item.getString("cardtype"))).map(item -> item.getDynamicObject("talentpool").getLong("id")).collect(Collectors.toList());
                pageCache.put("nodeIds", SerializationUtils.serializeToBase64(poolIds));
            } else {
                DynamicObject talentPool = (DynamicObject)this.getModel().getValue("talentpool", currClickRow);
                long currPoolId = talentPool.getLong("id");
                pageCache.put("talentpool", String.valueOf(currPoolId));
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                Boolean isSelect = i == currClickRow ? Boolean.TRUE : Boolean.FALSE;
                this.getModel().setValue("isselect", (Object)isSelect, i);
            }
            IListView listView = (IListView)this.getView();
            listView.refresh();
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("one_pool_label".equals(key) || "filtercontainerap".equals(key)) {
            FormShowParameter fsp = evt.getFormshowParameter();
            if (fsp == null) {
                fsp = new FormShowParameter();
                evt.setFormshowParameter(fsp);
            }
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            fsp.setCustomParam("id", currentNodeId);
        }
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
        LOG.info("kd.tdc.tdcs.formplugin.web.talentpool.reservetalent.ReserveTalentTreeListPlugin.afterShowTips");
    }

    private void buildEntryRow(List<QFilter> initPoolQFilters) {
        Object[] poolDys = TalentPoolQueryHelper.queryPoolByFilters((String)"id,group,inpoolnum", initPoolQFilters, this.getOrgIds());
        String currPoolId = this.getPageCache().get("talentpool");
        this.getModel().deleteEntryData("entryentity");
        AtomicBoolean setVisible = new AtomicBoolean(false);
        if (!HRArrayUtils.isEmpty((Object[])poolDys)) {
            String currentNodeId = String.valueOf(this.getTreeModel().getCurrentNodeId());
            if (ALL_NODE_STRING.equals(currentNodeId)) {
                int[] addRow = this.getModel().batchCreateNewEntryRow("entryentity", 1);
                int allTalentNum = Arrays.stream(poolDys).mapToInt(item -> item.getInt("inpoolnum")).sum();
                this.getModel().setValue("isselect", (Object)currentNodeId.equals(currPoolId), addRow[0]);
                this.getModel().setValue("cardtype", (Object)CardTypeEnum.ALL_CARD.getCardType(), addRow[0]);
                this.getModel().setValue("all_pool_num", (Object)ResManager.loadKDString((String)"{0}\u4e2a", (String)"ReserveTalentTreeListPlugin_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{poolDys.length}), addRow[0]);
                this.getModel().setValue("all_talent_num", (Object)allTalentNum, addRow[0]);
            }
            Map<Long, List<DynamicObject>> groupByTypeIds = Arrays.stream(poolDys).collect(Collectors.groupingBy(item -> item.getLong("group")));
            groupByTypeIds.forEach((groupId, groupPoolDys) -> {
                int[] addRow = this.getModel().batchCreateNewEntryRow("entryentity", groupPoolDys.size() + 1);
                for (int i = 0; i < addRow.length; ++i) {
                    if (i == 0) {
                        this.getModel().setValue("talentpool", ((DynamicObject)groupPoolDys.get(0)).get("id"), addRow[i]);
                        this.getModel().setValue("cardtype", (Object)CardTypeEnum.GROUP_CARD.getCardType(), addRow[i]);
                        continue;
                    }
                    Object currId = ((DynamicObject)groupPoolDys.get(i - 1)).get("id");
                    boolean isSelect = HRStringUtils.isNotEmpty((String)currPoolId) && currPoolId.equals(String.valueOf(currId));
                    this.getModel().setValue("isselect", (Object)isSelect, addRow[i]);
                    this.getModel().setValue("talentpool", currId, addRow[i]);
                    this.getModel().setValue("cardtype", (Object)CardTypeEnum.VIEW_CARD.getCardType(), addRow[i]);
                }
                setVisible.set(true);
            });
        }
        this.getView().updateView("entryentity");
        this.getView().setVisible(Boolean.valueOf(setVisible.get()), new String[]{"customflex"});
    }

    private List<Long> getOrgIds() {
        ControlFilter controlFilter;
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)currUserId, (String)"34", (String)"3=0WAUGB+EOW", (String)"tdcs_reservetalent", (String)"47150e89000000ac", (boolean)true);
        IListView listView = (IListView)this.getView();
        ControlFilters controlFilters = listView.getControlFilters();
        if (!Objects.isNull(controlFilters) && !Objects.isNull(controlFilter = (ControlFilter)controlFilters.getFilters().get("org.id")) && !CollectionUtils.isEmpty((Collection)controlFilter.getValue()) && HRStringUtils.isNotEmpty((String)String.valueOf(controlFilter.getValue().get(0)))) {
            return controlFilter.getValue().stream().map(Object::toString).map(Long::parseLong).collect(Collectors.toList());
        }
        return hasPermOrgResult.getHasPermOrgs();
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setVisible(11);
        col.setColumnFilter(true);
        col.setColumnOrder(true);
        return col;
    }

    private void getAllNodeId(List<Long> allNodeIds, TreeNode treeNode) {
        List children;
        if (!treeNode.getId().equals(ALL_NODE_STRING)) {
            allNodeIds.add(Long.parseLong(treeNode.getId()));
        }
        if (!CollectionUtils.isEmpty((Collection)(children = treeNode.getChildren()))) {
            for (TreeNode child : children) {
                this.getAllNodeId(allNodeIds, child);
            }
        }
    }

    private void findNode(List<TreeNode> treeNodeList, String nodeId, AtomicReference<TreeNode> treeNode) {
        if (treeNode.get().getId().equals(nodeId)) {
            return;
        }
        if (treeNode.get().getId().equals(ALL_NODE_STRING)) {
            for (TreeNode currNode : treeNodeList) {
                if (nodeId.equals(currNode.getId())) {
                    treeNode.set(currNode);
                    return;
                }
                List children = currNode.getChildren();
                if (CollectionUtils.isEmpty((Collection)children)) continue;
                this.findNode(children, nodeId, treeNode);
            }
        }
    }

    static enum CardTypeEnum {
        ALL_CARD("10"),
        GROUP_CARD("20"),
        VIEW_CARD("30");

        private final String cardType;

        private CardTypeEnum(String cardType) {
            this.cardType = cardType;
        }

        public String getCardType() {
            return this.cardType;
        }
    }
}

