/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.talentsearch;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.tdcs.bussiness.application.CommCfgParamApplicationService;
import kd.tdc.tdcs.bussiness.application.TalentSearchApplicationService;

public class TalentDetailViewPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(TalentDetailViewPlugin.class);
    private TalentSearchApplicationService service = new TalentSearchApplicationService();
    private CommCfgParamApplicationService commCfgParamService = new CommCfgParamApplicationService();
    private static final String FLEX_GROUP_1 = "flexpanelgroup1";
    private static final String BTN_GRP1_SELECT_TALENTPORTRAIT = "btntalentportrait";
    private static final String BTN_GRP1_TALENTFILE = "btntalentfile";
    private static final String FLEX_GROUP_2 = "flexpanelgroup2";
    private static final String BTN_GRP2_TALENTPORTRAIT = "btntalentportrait2";
    private static final String BTN_GRP2_SELECT_TALENTFILE = "btntalentfile2";
    private static final String FLEX_GROUP = "flexpanelgroup";
    private static final String LABEL_TALENTPOOL = "labeltalentpool";
    private static final String LABEL_RECOMMEND = "labelrecommend";
    private static final String LABEL_ATTENTION = "labelattention";
    private static final String LABEL_CANCELATTENTION = "labelcancelattention";
    private static final String FLEX_TALENTPORTRAIT = "flextalentportrait";
    private static final String FLEX_CONTENT = "flexcontent";
    private static final String FLEX_PANELTOOLS = "flexpaneltools";
    private static final String ICON_XING = "vectorattention";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_GRP1_SELECT_TALENTPORTRAIT, BTN_GRP1_TALENTFILE, BTN_GRP2_TALENTPORTRAIT, BTN_GRP2_SELECT_TALENTFILE, LABEL_TALENTPOOL, LABEL_RECOMMEND, LABEL_ATTENTION, LABEL_CANCELATTENTION});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map parameter = showParameter.getCustomParams();
        Long employeeId = (Long)parameter.get("talentDetailView_employeeId");
        logger.info("employeeId = {}", (Object)employeeId);
        this.getView().getModel().setValue("empid", (Object)employeeId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map parameter = showParameter.getCustomParams();
        List configParam = JSON.parseArray((String)((String)parameter.get("talentDetailView_views")), String.class);
        logger.info("configParam = {}", (Object)JSON.toJSONString((Object)configParam));
        Long employeeId = (Long)parameter.get("talentDetailView_employeeId");
        boolean containPortait = configParam.contains("2");
        boolean containTalentFile = configParam.contains("1");
        if (containPortait) {
            if (containTalentFile) {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_GRP1_SELECT_TALENTPORTRAIT, BTN_GRP1_TALENTFILE});
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_GROUP_2});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_GRP1_SELECT_TALENTPORTRAIT});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_GRP1_TALENTFILE, FLEX_GROUP_2});
            }
            this.showTalentPortrait(employeeId);
        } else if (containTalentFile) {
            this.showTalentFile(employeeId);
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_GRP2_SELECT_TALENTFILE});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_GRP2_TALENTPORTRAIT, FLEX_GROUP_1});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_GROUP_1, FLEX_GROUP_2});
        }
        this.initViewVisible();
        this.refershAttention(employeeId);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        OperationResult operationResult = eventArgs.getOperationResult();
        String key = eventArgs.getOperateKey();
        if (operationResult.isSuccess()) {
            Long employeeId = (Long)this.getView().getModel().getDataEntity().getDynamicObject("empid").getPkValue();
            ArrayList<Long> empIds = new ArrayList<Long>();
            empIds.add(employeeId);
            if ("attention".equals(key)) {
                this.service.attentionByEmpIds((AbstractFormPlugin)this, empIds, key);
                this.refershAttention((Long)empIds.get(0));
                this.getView().updateView(FLEX_PANELTOOLS);
            } else if ("cancelattention".equals(key)) {
                this.service.cancelAttention(this.getView(), empIds);
                this.refershAttention((Long)empIds.get(0));
                this.getView().updateView(FLEX_PANELTOOLS);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("attention")) {
            Map result = (Map)returnData;
            List empIds = (List)result.get("employeeList");
            if (CollectionUtils.isEmpty((Collection)empIds)) {
                return;
            }
            this.refershAttention((Long)empIds.get(0));
            this.getView().updateView(FLEX_PANELTOOLS);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Long employeeId = (Long)this.getView().getModel().getDataEntity().getDynamicObject("empid").getPkValue();
        ArrayList<Long> empIds = new ArrayList<Long>();
        empIds.add(employeeId);
        if (BTN_GRP1_SELECT_TALENTPORTRAIT.equals(key) || BTN_GRP2_TALENTPORTRAIT.equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_GROUP_1});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_GROUP_2});
            this.showTalentPortrait((Long)empIds.get(0));
            this.getView().updateView(FLEX_GROUP);
            this.getView().updateView(FLEX_CONTENT);
        } else if (BTN_GRP1_TALENTFILE.equals(key) || BTN_GRP2_SELECT_TALENTFILE.equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_GROUP_1});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_GROUP_2});
            this.showTalentFile((Long)empIds.get(0));
            this.getView().updateView(FLEX_GROUP);
            this.getView().updateView(FLEX_CONTENT);
        } else if (LABEL_TALENTPOOL.equals(key)) {
            this.service.showTalentPoolForm(this.getView(), empIds);
        } else if (LABEL_RECOMMEND.equals(key)) {
            this.service.showTalpTalentrecommend(this.getView(), empIds);
        }
    }

    private void showTalentPortrait(Long employeeId) {
        HRMServiceResult hrmServiceResult = this.service.getTalentPortraitForm(employeeId);
        if (hrmServiceResult.isSuccess()) {
            logger.info("showTalentPortrait-1>Success");
            FormShowParameter formShowParameter = (FormShowParameter)hrmServiceResult.getReturnData();
            if (formShowParameter != null) {
                formShowParameter.setStatus(OperationStatus.VIEW);
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                formShowParameter.getOpenStyle().setTargetKey(FLEX_TALENTPORTRAIT);
                this.getView().showForm(formShowParameter);
            }
        } else {
            logger.info("showTalentPortrait-2>{}", (Object)hrmServiceResult.getMessage());
        }
    }

    private void showTalentFile(Long employeeId) {
        BaseShowParameter formShowParameter;
        HRMServiceResult hrmServiceResult;
        Long talentFileId = this.service.getTalentFileIdByEmployeeId(employeeId);
        if (talentFileId > 0L && (hrmServiceResult = this.service.getTalentForm(talentFileId)).isSuccess() && (formShowParameter = (BaseShowParameter)hrmServiceResult.getReturnData()) != null) {
            formShowParameter.setStatus(OperationStatus.VIEW);
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(FLEX_TALENTPORTRAIT);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    private void refershAttention(Long employeeId) {
        if (!this.commCfgParamService.hasAttention().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_ATTENTION, LABEL_CANCELATTENTION, ICON_XING});
            return;
        }
        DynamicObject attention = this.service.getAttention(employeeId);
        if (attention != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_ATTENTION});
            this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_CANCELATTENTION});
            Vector vector = (Vector)this.getView().getControl(ICON_XING);
            vector.setFontClass("kdfont kdfont-xingxing4");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_ATTENTION});
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_CANCELATTENTION});
            Vector vector = (Vector)this.getView().getControl(ICON_XING);
            vector.setFontClass("kdfont kdfont-xingxing3");
        }
    }

    private void initVisible(IFormView view) {
        view.setVisible(this.service.hasNewEntryPoolPerm(), new String[]{LABEL_TALENTPOOL});
        view.setVisible(this.service.hasNewRecommendPerm(), new String[]{LABEL_RECOMMEND});
    }

    private void initViewVisible() {
        this.getView().setVisible(this.commCfgParamService.hasTalentpool(), new String[]{LABEL_TALENTPOOL});
        this.getView().setVisible(this.commCfgParamService.hasTalentrecommend(), new String[]{LABEL_RECOMMEND});
    }
}

