/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.formplugin.web.talentsearch;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.openservicehelper.search.SearchServiceHelper;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.enums.smartsearch.FilterFieldTypeEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchKeyLogicEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchModeEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchTargetTypeEnum;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFilterBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchRangFieldBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchSceneBo;
import kd.hr.hbp.common.model.smartsearch.search.LabelValCompParam;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchResp;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.tdcs.bussiness.application.CommCfgParamApplicationService;
import kd.tdc.tdcs.bussiness.application.TalentSearchApplicationService;
import kd.tdc.tdcs.bussiness.application.TalentSearchCalculatorApplication;
import kd.tdc.tdcs.bussiness.application.external.BosLogService;
import kd.tdc.tdcs.bussiness.application.external.ExtSearchService;
import kd.tdc.tdcs.bussiness.queryhelper.SearchFilterSchemeQueryHelper;
import kd.tdc.tdcs.bussiness.search.SearchBuryPointService;
import kd.tdc.tdcs.common.bo.talentsearch.SearchPage;
import kd.tdc.tdcs.common.bo.talentsearch.SearchResultVO;
import kd.tdc.tdcs.common.bo.talentsearch.SearchSceneVo;
import org.apache.commons.lang3.StringUtils;

public class TalentSearchPlugin
extends HRDynamicFormBasePlugin {
    private static final String FLEXPANELLABEL = "flexpanellabel";
    private static final String FLEXPANELHIGHFREGUENT = "flexpanelhighfreguent";
    private static final String ATTENTIONNUMBER = "attentionnumber";
    private static final String FLEXPANELMYATTENTION = "flexpanelmyattention";
    private static final String ARROW = "arrow";
    private static final String LABELSUGGEST = "labelsuggest";
    private TalentSearchApplicationService service = new TalentSearchApplicationService();
    private TalentSearchCalculatorApplication calculatorService = new TalentSearchCalculatorApplication();
    private CommCfgParamApplicationService commCfgParamService = new CommCfgParamApplicationService();
    private static final Log logger = LogFactory.getLog(TalentSearchPlugin.class);
    private static final Map<String, Boolean> permEvenKeyMap = Maps.newHashMap();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnattention", "btnattentionreason", "btncancelattention", "btnforwardhome", "btnaddpool", "btntalentrecommend", "btntalentdetail", LABELSUGGEST});
        Label attention = (Label)this.getControl(ATTENTIONNUMBER);
        attention.addClickListener((ClickListener)this);
        Vector viewBtn = (Vector)this.getControl(ARROW);
        viewBtn.addClickListener((ClickListener)this);
        Label settingLabel = (Label)this.getControl("setting_label");
        settingLabel.addClickListener((ClickListener)this);
        Label advancedSearchLabel = (Label)this.getControl("advanced_search_label");
        advancedSearchLabel.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        logger.info("beforeBindData -> begin");
        if (this.commCfgParamService.hasHome().booleanValue()) {
            String searchPageType = this.getPageCache().get("searchPageType");
            String eventKey = "change";
            if (Objects.isNull(searchPageType)) {
                eventKey = "init";
                this.getPageCache().put("searchPageType", "1");
            }
            HrApiResponse response = ExtSearchService.querySearchScene((String)"tdcs_talentsearch", (String)this.service.getAppNumber());
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELMYATTENTION});
            if (Objects.isNull(searchPageType) || "1".equals(searchPageType)) {
                String primaryKey;
                Map data;
                if (EnumResponseCode.SUCCESS.getCode().equals(response.getCode())) {
                    data = this.service.querySearchSceneHome(response, eventKey);
                    String defCategory = this.getPageCache().get("defCategory");
                    if (HRStringUtils.isNotEmpty((String)defCategory)) {
                        SearchSceneVo searchSceneVo = (SearchSceneVo)data.get("data");
                        searchSceneVo.setDefSearchKeyLogic(this.getPageCache().get("defSearchKeyLogic"));
                        searchSceneVo.setDefCategory(defCategory);
                    }
                    if (HRStringUtils.isEmpty((String)(primaryKey = this.getPageCache().get("primaryKey")))) {
                        primaryKey = "1";
                    }
                } else {
                    throw new KDBizException(response.getErrorMessage());
                }
                data.put("primaryKey", primaryKey);
                String searchControlKey = this.getSearchControlKey();
                CustomControl controlSearchResult = (CustomControl)this.getView().getControl(searchControlKey);
                controlSearchResult.setData((Object)data);
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelhome"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelsearch"});
                if (this.commCfgParamService.hasAttention().booleanValue()) {
                    try {
                        logger.info("beforeBindData -> statistic");
                        Map statisticData = this.calculatorService.getTalentSearchStatistics(response);
                        logger.info("statis data:{}", (Object)statisticData);
                        this.initMyAttentionPanel(statisticData);
                    }
                    catch (Exception exception) {
                        logger.error((Throwable)exception);
                    }
                }
            } else if ("2".equals(searchPageType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelhome"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelsearch"});
                this.showTalentSearchFlexPanel(this.getView(), null);
            }
        } else {
            this.getPageCache().put("searchPageType", "2");
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelhome", FLEXPANELMYATTENTION});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelsearch"});
            this.getPageCache().remove("showtype");
            this.showTalentSearchFlexPanel(this.getView(), null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (ATTENTIONNUMBER.equals(key) || ARROW.equals(key)) {
            this.showMyAttentionForm(this.getView());
        } else if (LABELSUGGEST.equals(key)) {
            this.showMySuggest(this.getView());
        } else if ("setting_label".equals(key)) {
            CustomControl controlSearchHome = (CustomControl)this.getView().getControl("tdcstalentsearchhome");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("eventName", "event_showSearchSetting");
            data.put("eventStatus", "init");
            data.put("times", System.currentTimeMillis());
            controlSearchHome.setData(data);
        } else if ("advanced_search_label".equals(key)) {
            String searchControlKey = this.getSearchControlKey();
            CustomControl controlSearchControl = (CustomControl)this.getView().getControl(searchControlKey);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("eventName", "event_forwardtalentsearch");
            data.put("eventStatus", "init");
            data.put("times", System.currentTimeMillis());
            this.getPageCache().put("isOnlyForwardResult", "true");
            controlSearchControl.setData(data);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        logger.info("customEvent ->{}", (Object)eventName);
        if (permEvenKeyMap.getOrDefault(eventName, Boolean.FALSE).booleanValue()) {
            OperateOption operation = OperateOption.create();
            operation.setVariableValue("eventName", eventName);
            operation.setVariableValue("eventArgs", eventArgs);
            this.getView().invokeOperation("search", operation);
        } else if ("event_addtalentpool".equals(eventName)) {
            Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            List employeeList = (List)eventParam.get("employeeids");
            this.service.showTalentPoolForm(this.getView(), this.convertLong(employeeList));
        } else if ("event_addtalentrecommend".equals(eventName)) {
            Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            List employeeList = (List)eventParam.get("employeeids");
            this.service.showTalpTalentrecommend(this.getView(), this.convertLong(employeeList));
        } else if ("event_get_rowid".equals(eventName)) {
            Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            List employeeList = (List)eventParam.get("employeeids");
            this.getPageCache().put("row_id_cache", JSON.toJSONString((Object)employeeList));
            logger.info("customEvent {}, getRowIds->{}", (Object)eventName, (Object)JSON.toJSONString((Object)employeeList));
        } else if ("event_suggest".equals(eventName)) {
            this.showMySuggest(this.getView());
        } else if ("event_changematching".equals(eventName)) {
            Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            this.getPageCache().put("primaryKey", eventParam.getOrDefault("value", "1"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult.isSuccess()) {
            FormOperate formOperate = (FormOperate)args.getSource();
            OperateOption operateOption = formOperate.getOption();
            Map parameter = operateOption.getVariables();
            String eventName = (String)parameter.get("eventName");
            String eventArgs = (String)parameter.get("eventArgs");
            if ("event_searchscene".equals(eventName)) {
                Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                String searchEntityNumber = (String)eventParam.get("searchEntityNumber");
                if (StringUtils.isEmpty((CharSequence)searchEntityNumber)) {
                    searchEntityNumber = "tdcs_talentsearch";
                }
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.setEntryProperty("tdcstalentsearchresult", "data", (Object)this.service.querySearchScene(searchEntityNumber, this.service.getAppNumber()));
            } else if ("event_attention".equals(eventName)) {
                this.getView().showLoading(new LocaleString());
                this.service.tableAttentionByEmpIds((AbstractFormPlugin)this, eventArgs, eventName);
                this.getView().hideLoading();
            } else if ("event_cancelattention".equals(eventName)) {
                this.getView().showLoading(new LocaleString());
                this.service.tableCancelAttention(this.getView(), eventArgs, eventName);
                this.getView().hideLoading();
            } else if ("event_showtalentdetail".equals(eventName)) {
                Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                String empId = (String)eventParam.get("employeeid");
                this.showTalentDetailView(this.getView(), Long.valueOf(empId));
            } else if ("event_searchfilterf7".equals(eventName)) {
                Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                this.showSearchF7(eventParam);
            } else if ("event_search".equals(eventName)) {
                this.getView().showLoading(new LocaleString());
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                SearchPage page = (SearchPage)JSON.parseObject((String)eventArgs, (TypeReference)new TypeReference<SearchPage<SearchResultVO>>(){}, (Feature[])new Feature[0]);
                this.service.search(page, eventParam, this.getView());
                this.service.dealShowTable(page);
                proxy.setEntryProperty("tdcstalentsearchresult", "data", (Object)page);
                this.getView().hideLoading();
            } else if ("event_showSearchSetting".equals(eventName)) {
                Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                this.showSearchSetting(eventParam);
            } else if (!"event_forwardtalentsearchhome".equals(eventName)) {
                if ("event_forwardtalentsearch".equals(eventName)) {
                    this.getPageCache().put("searchPageType", "2");
                    this.getPageCache().remove("showtype");
                    Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                    this.showTalentSearchFlexPanel(this.getView(), eventParam);
                } else if ("event_refresh_home".equals(eventName)) {
                    this.getView().showLoading(new LocaleString());
                    this.refresh(this.getView());
                    this.getView().hideLoading();
                } else if ("event_search_association".equals(eventName)) {
                    Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                    if (!Objects.isNull(eventParam)) {
                        this.showSearchAssociation(eventParam);
                    }
                } else if ("event_deletehisrecord".equals(eventName)) {
                    Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                    if (!Objects.isNull(eventParam)) {
                        String hisRecordText = (String)((Map)((List)eventParam.get("data")).get(0)).get("hisRecordText");
                        long sceneId = Long.parseLong(String.valueOf(eventParam.get("sceneId")));
                        String searchEntityNumber = String.valueOf(eventParam.get("searchEntityNumber"));
                        ExtSearchService.deleteHisRecord((long)sceneId, (String)searchEntityNumber, (String)hisRecordText);
                        this.showHisRecords(sceneId, searchEntityNumber);
                    }
                } else if ("event_clearhisrecords".equals(eventName)) {
                    Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                    if (!Objects.isNull(eventParam)) {
                        long sceneId = Long.parseLong(String.valueOf(eventParam.get("sceneId")));
                        String searchEntityNumber = String.valueOf(eventParam.get("searchEntityNumber"));
                        ExtSearchService.clearHisRecords((long)sceneId, (String)searchEntityNumber);
                        this.showHisRecords(sceneId, searchEntityNumber);
                    }
                } else if ("event_showhisrecords".equals(eventName)) {
                    Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                    if (!Objects.isNull(eventParam)) {
                        long sceneId = Long.parseLong(String.valueOf(eventParam.get("sceneId")));
                        String searchEntityNumber = String.valueOf(eventParam.get("searchEntityNumber"));
                        this.showHisRecords(sceneId, searchEntityNumber);
                    }
                } else if ("saveScheme".equals(eventName)) {
                    this.saveScheme(eventArgs, eventName);
                } else if ("deleteScheme".equals(eventName)) {
                    this.getPageCache().put("deleteSchemeData", eventArgs);
                    Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
                    long schemeNameId = Long.parseLong((String)eventParam.get("schemeNameId"));
                    boolean exists = SearchFilterSchemeQueryHelper.isExists((long)schemeNameId);
                    if (!exists) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8fc7\u6ee4\u65b9\u6848\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TalentSearchPlugin_9", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u8be5\u8fc7\u6ee4\u65b9\u6848\u5c06\u88ab\u5220\u9664\u4e14\u4e0d\u53ef\u64a4\u56de\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"TalentSearchPlugin_6", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteScheme", (IFormPlugin)this));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScheme(String eventArgs, String eventName) {
        String saveTip = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TalentSearchPlugin_10", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]);
        try {
            Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
            Object schemeNameId = eventParam.get("schemeNameId");
            List schemeSelectedFilter = (List)eventParam.get("schemeSelectedFilter");
            schemeSelectedFilter.removeIf(item -> "0".equals(((Map)((List)item.get("selected")).get(0)).get("id")));
            schemeSelectedFilter.removeIf(item -> !(!"3".equals(item.get("type")) || !"number".equals(item.get("filedType")) && !"datetime".equals(item.get("filedType")) || !"-1".equals(((Map)((List)item.get("selected")).get(0)).get("id")) || !HRStringUtils.isEmpty((String)((Map)((List)item.get("selected")).get(0)).getOrDefault("small", "")) && !HRStringUtils.isEmpty((String)((Map)((List)item.get("selected")).get(0)).getOrDefault("large", ""))));
            if (HRCollUtil.isEmpty((Collection)schemeSelectedFilter)) {
                saveTip = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u8fc7\u6ee4\u9879\u6761\u4ef6\u3002", (String)"TalentSearchPlugin_3", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(saveTip);
                return;
            }
            String schemeName = eventParam.getOrDefault("schemeName", "");
            if (HRStringUtils.isEmpty((String)schemeName)) {
                saveTip = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65b9\u6848\u540d\u79f0\u3002", (String)"TalentSearchPlugin_4", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(saveTip);
                return;
            }
            if (schemeName.length() > 100) {
                saveTip = ResManager.loadKDString((String)"\u8fc7\u6ee4\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7100\u5b57\u7b26\u3002", (String)"TalentSearchPlugin_11", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(saveTip);
                return;
            }
            List schemeFilters = schemeSelectedFilter.stream().filter(item -> "string".equals(item.get("filedType")) && String.valueOf(((Map)((List)item.get("selected")).get(0)).getOrDefault("value", "")).length() > 255).collect(Collectors.toList());
            if (HRCollUtil.isNotEmpty(schemeFilters)) {
                Object[] displayNames = (String[])schemeFilters.stream().map(item -> "\"" + item.get("displayName") + "\"").toArray(String[]::new);
                String str = HRStringUtils.arrayToString((Object[])displayNames, (String)"\u3001");
                saveTip = ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u8d85\u8fc7255\u5b57\u7b26\u3002", (String)"TalentSearchPlugin_12", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{str});
                this.getView().showTipNotification(saveTip);
                return;
            }
            long sceneId = Long.parseLong((String)eventParam.get("sceneId"));
            Long schemeId = Objects.isNull(schemeNameId) ? null : Long.valueOf(Long.parseLong((String)schemeNameId));
            boolean isExists = SearchFilterSchemeQueryHelper.isExists((Long)schemeId, (long)sceneId, (long)RequestContext.get().getCurrUserId(), (String)schemeName);
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (isExists) {
                saveTip = ResManager.loadKDString((String)"\u8be5\u8fc7\u6ee4\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"TalentSearchPlugin_5", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(saveTip);
                return;
            }
            Map<String, String> fieldNameMapping = schemeSelectedFilter.stream().collect(Collectors.toMap(item -> (String)item.get("number"), item -> (String)item.get("displayName"), (v1, v2) -> v1));
            HrApiResponse searchScene = ExtSearchService.querySearchScene((long)sceneId);
            List searchFilterList = ((SearchSceneBo)searchScene.getData()).getSearchFilterList();
            List currFields = searchFilterList.stream().map(SearchFilterBo::getFieldAlias).collect(Collectors.toList());
            List deletedItemList = fieldNameMapping.keySet().stream().filter(fieldNumber -> !currFields.contains(fieldNumber)).map(fieldNameMapping::get).collect(Collectors.toList());
            if (HRCollUtil.isNotEmpty(deletedItemList)) {
                StringBuilder strBuilder = new StringBuilder();
                for (int i = 0; i < deletedItemList.size(); ++i) {
                    strBuilder.append("\u201c\u3010").append((String)deletedItemList.get(i)).append("\u3011\u201d");
                    if (deletedItemList.size() <= 1 || i >= deletedItemList.size() - 1) continue;
                    strBuilder.append("\u3001");
                }
                saveTip = ResManager.loadKDString((String)"{0}\u5728\u201c\u641c\u7d22\u573a\u666f-\u4e8c\u6b21\u8fc7\u6ee4\u6761\u4ef6\u201d\u4e2d\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u4eba\u624d\u641c\u7d22\u9875\u9762\u5df2\u83b7\u53d6\u6700\u65b0\u641c\u7d22\u573a\u666f\u914d\u7f6e\u3002", (String)"TalentSearchPlugin_7", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{strBuilder.toString()});
                this.getView().showTipNotification(saveTip);
                return;
            }
            long saveSchemeId = this.service.saveScheme(schemeId, sceneId, schemeName, SerializationUtils.toJsonString((Object)schemeSelectedFilter));
            this.getView().showSuccessNotification(saveTip);
            CustomControl resultCustomControl = (CustomControl)this.getControl("tdcstalentsearchresult");
            data.put("eventName", "updateScheme");
            data.put("verification", true);
            data.put("schemeNameId", String.valueOf(saveSchemeId));
            List myFilterSchemes = SearchFilterSchemeQueryHelper.getMyFilterSchemes((long)sceneId, (long)RequestContext.get().getCurrUserId());
            data.put("schemeList", myFilterSchemes);
            if (Objects.isNull(schemeId) || schemeId != saveSchemeId) {
                data.put("updateType", "1");
            } else {
                data.put("updateType", "3");
            }
            Map updateScheme = myFilterSchemes.stream().filter(item -> String.valueOf(saveSchemeId).equals(item.get("schemeNameId"))).findFirst().orElse(null);
            data.put("updateScheme", updateScheme);
            resultCustomControl.setData(data);
        }
        finally {
            BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)eventName, (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58", "TalentSearchPlugin_14", "tdc-tdcs-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fdd\u5b58\u6210\u529f\u3002", "TalentSearchPlugin_10", "tdc-tdcs-formplugin"));
        }
    }

    private void showSearchAssociation(Map<String, Object> eventParam) {
        long searchObjId = Long.parseLong(String.valueOf(eventParam.get("searchObjId")));
        String searchTargetType = String.valueOf(eventParam.get("searchTargetType"));
        String associationText = String.valueOf(eventParam.get("associationText"));
        List searchRangFieldList = (List)eventParam.get("searchRangFieldList");
        LinkedList SearchRangFieldBoList = Lists.newLinkedList();
        if (HRCollUtil.isNotEmpty((Collection)searchRangFieldList)) {
            for (Map objectMap : searchRangFieldList) {
                SearchRangFieldBo searchRangFieldBo = new SearchRangFieldBo((String)objectMap.get("rangeNumber"), SearchModeEnum.of((String)((String)objectMap.get("searchMode"))));
                SearchRangFieldBoList.add(searchRangFieldBo);
            }
        }
        LabelValCompParam labelValCompParam = new LabelValCompParam();
        labelValCompParam.setSearchRangFieldList((List)SearchRangFieldBoList);
        labelValCompParam.setSearchObjId(Long.valueOf(searchObjId));
        labelValCompParam.setInputText(associationText);
        labelValCompParam.setSearchTargetType(SearchTargetTypeEnum.of((String)searchTargetType));
        String searchControlKey = this.getSearchControlKey();
        CustomControl talentSearchHome = (CustomControl)this.getView().getControl(searchControlKey);
        HashMap sendData = Maps.newHashMap();
        sendData.put("code", 200);
        sendData.put("success", Boolean.TRUE);
        sendData.put("eventName", "event_search_association");
        sendData.put("eventStatus", "init");
        sendData.put("times", System.currentTimeMillis());
        HrApiResponse searchAnnotation = ExtSearchService.searchAnnotation((LabelValCompParam)labelValCompParam);
        ArrayList dataList = Lists.newArrayList();
        if (searchAnnotation.isSuccess()) {
            String associationDefaultSize = this.commCfgParamService.getAssociationDefaultSize();
            List searchAnnotationData = (List)searchAnnotation.getData();
            if (HRStringUtils.isNotEmpty((String)associationDefaultSize) && searchAnnotationData.size() > Integer.parseInt(associationDefaultSize)) {
                searchAnnotationData = searchAnnotationData.subList(0, Integer.parseInt(associationDefaultSize));
            }
            searchAnnotationData.forEach(labelValCompResp -> {
                HashMap dataMap = Maps.newHashMap();
                dataMap.put("associationText", labelValCompResp.getDisplayName());
                dataMap.put("associationId", String.valueOf(labelValCompResp.getLabelValKey()));
                dataMap.put("labelFilterProp", labelValCompResp.getLabelFilterProp());
                dataMap.put("fieldAlias", labelValCompResp.getFieldAlias());
                dataList.add(dataMap);
            });
        }
        sendData.put("data", dataList);
        talentSearchHome.setData((Object)sendData);
    }

    private void showHisRecords(long sceneId, String searchEntityNumber) {
        String searchControlKey = this.getSearchControlKey();
        CustomControl talentSearchHome = (CustomControl)this.getView().getControl(searchControlKey);
        HashMap sendData = Maps.newHashMap();
        sendData.put("code", 200);
        sendData.put("success", Boolean.TRUE);
        sendData.put("eventName", "event_showhisrecords");
        sendData.put("eventStatus", "init");
        sendData.put("times", System.currentTimeMillis());
        HrApiResponse hisRecords = ExtSearchService.getHisRecords((long)sceneId, (String)searchEntityNumber);
        ArrayList dataList = Lists.newArrayList();
        if (hisRecords.isSuccess()) {
            List hisRecordList = (List)hisRecords.getData();
            String hisRecordDefaultSize = this.commCfgParamService.getHisRecordDefaultSize();
            if (HRStringUtils.isNotEmpty((String)hisRecordDefaultSize) && hisRecordList.size() > Integer.parseInt(hisRecordDefaultSize)) {
                hisRecordList = hisRecordList.subList(0, Integer.parseInt(hisRecordDefaultSize));
            }
            hisRecordList.forEach(value -> {
                HashMap dataMap = Maps.newHashMap();
                dataMap.put("hisRecordText", value);
                dataMap.put("hisRecordId", value);
                dataList.add(dataMap);
            });
        }
        sendData.put("data", dataList);
        talentSearchHome.setData((Object)sendData);
    }

    private String getSearchControlKey() {
        String pageKey = this.getPageCache().get("searchPageType");
        String searchControlKey = "1".equals(pageKey) ? "tdcsTalentSearchHome" : ("2".equals(pageKey) ? "tdcsTalentSearchResult" : "tdcsTalentSearchHome");
        return searchControlKey;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (returnData == null) {
            if (actionId.equals("event_searchfilterf7")) {
                CustomControl controlSearchResult = (CustomControl)this.getView().getControl("tdcstalentsearchresult");
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("fieldAlias", this.getPageCache().get("filterFieldAlias"));
                data.put("eventKey", "searchfilterf7");
                controlSearchResult.setData(data);
            }
            return;
        }
        if (actionId.equals("tdcs_searchsetting")) {
            Map result = (Map)returnData;
            this.getPageCache().put("defCategory", (String)result.get("defCategory"));
            this.getPageCache().put("defSearchKeyLogic", (String)result.get("defSearchKeyLogic"));
            String searchControlKey = this.getSearchControlKey();
            CustomControl controlSearchResult = (CustomControl)this.getView().getControl(searchControlKey);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("data", result);
            data.put("eventName", "search_setting");
            controlSearchResult.setData(data);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u6210\u529f\u3002", (String)"TalentSearchPlugin_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]));
            return;
        }
        if (actionId.equals("event_searchfilterf7")) {
            CustomControl controlSearchResult = (CustomControl)this.getView().getControl("tdcstalentsearchresult");
            ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
            List idList = list.stream().map(o -> o.getPrimaryKeyValue().toString()).collect(Collectors.toList());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("data", idList);
            data.put("fieldAlias", this.getPageCache().get("filterFieldAlias"));
            data.put("eventKey", "searchfilterf7");
            String entryEntityKey = list.get(0).getEntryEntityKey();
            Map<String, String> nameMap = HRStringUtils.isNotEmpty((String)entryEntityKey) && "entryentitylabelvalue".equals(entryEntityKey) ? ExtSearchService.getLabelValue((Object)list.getPrimaryKeyValues()) : list.stream().collect(Collectors.toMap(o -> o.getPrimaryKeyValue().toString(), ListSelectedRow::getName, (v1, v2) -> v1));
            data.put("filterName", nameMap);
            controlSearchResult.setData(data);
            return;
        }
        if (actionId.equals("event_attention")) {
            Map result = (Map)returnData;
            List employeeList = (List)result.get("employeeList");
            this.service.setSearchFowareData(this.getView(), actionId, (String)result.get("attentionEventArgs"), employeeList);
        }
    }

    private void showSearchF7(Map eventParam) {
        String searchEntityNumber = (String)eventParam.get("searchEntityNumber");
        String sceneId = (String)eventParam.get("sceneId");
        String searchObjId = (String)eventParam.get("searchObjId");
        if (StringUtils.isEmpty((CharSequence)searchEntityNumber)) {
            searchEntityNumber = "tdcs_talentsearch";
        }
        String fieldAlias = (String)eventParam.get("fieldAlias");
        String realEntityNumber = (String)eventParam.get("realEntityNumber");
        List idList = (List)eventParam.get("idList");
        String filedType = (String)eventParam.get("filedType");
        if (HRStringUtils.isNotEmpty((String)filedType) && filedType.equals(FilterFieldTypeEnum.LABEL.getValue())) {
            ListShowParameter showParameter = SearchServiceHelper.getLabelValueF7ShowForm((String)fieldAlias, (Long)Long.valueOf(searchObjId));
            this.showMoreForm(fieldAlias, showParameter, idList);
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)realEntityNumber, (boolean)true, (int)0, (boolean)true);
        HrApiResponse filter = this.service.getPermQFilters(Long.valueOf(sceneId), fieldAlias, searchEntityNumber, this.service.getAppNumber());
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        if (filter.getData() != null) {
            listFilterParameter.setFilter((QFilter)filter.getData());
            logger.info("realEntityNumber:{},getPermQFilters:{}", (Object)realEntityNumber, filter.getData());
        }
        this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", (Object)"tdcs_talentsearch");
        if (fieldAlias.contains("hrpi_empposorgrel.adminorg")) {
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"hrpi_empposorgrel.adminorg");
        } else if (fieldAlias.contains("hrpi_empposorgrel.company")) {
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"hrpi_empposorgrel.company");
        } else if (fieldAlias.contains("hrpi_empposorgrel.position")) {
            this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"hrpi_empposorgrel.position.adminorg");
        } else {
            this.getView().getFormShowParameter().getCustomParams().remove("custom_parent_f7_prop");
        }
        this.getView().getFormShowParameter().setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
        this.getView().cacheFormShowParameter();
        this.showMoreForm(fieldAlias, showParameter, idList);
    }

    private void showMoreForm(String fieldAlias, ListShowParameter showParameter, List<String> idList) {
        if (!CollectionUtils.isEmpty(idList)) {
            showParameter.setSelectedRows(idList.toArray());
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "event_searchfilterf7"));
        this.getPageCache().put("filterFieldAlias", fieldAlias);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Deprecated
    private void showTalentSearchForm(IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tdcs_talentsearchhome");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(showParameter);
        this.getView().close();
    }

    private void refresh(IFormView view) {
        view.updateView();
    }

    private void showTalentDetailView(IFormView view, Long employeeId) {
        SearchBuryPointService.viewDetail((long)employeeId, (IFormView)view);
        Boolean hasTalentFilePermission = Boolean.FALSE;
        HRMServiceResult result = null;
        logger.info("showTalentDetailView empId ={} start", (Object)employeeId);
        List configParam = this.commCfgParamService.getTalentDetailViewConfigParam();
        if (configParam != null && configParam.size() > 0) {
            Boolean flag;
            logger.info("showTalentDetailView empId ={} configParm={}", (Object)employeeId, (Object)JSON.toJSONString((Object)configParam));
            if (configParam.contains("1")) {
                hasTalentFilePermission = this.service.hasOpenTalentFilePerm(employeeId);
                logger.info("showTalentDetailView empId ={} hasOpenTalentFilePerm={}", (Object)employeeId, (Object)hasTalentFilePermission);
                if (!hasTalentFilePermission.booleanValue()) {
                    configParam.remove("1");
                }
            }
            if (configParam.contains("2")) {
                result = this.service.getTalentPortraitForm(employeeId);
                logger.info("showTalentDetailView empId ={} result msg={}", (Object)employeeId, (Object)result.getMessage());
                if (!result.isSuccess()) {
                    configParam.remove("2");
                }
            }
            if ((flag = Boolean.valueOf(hasTalentFilePermission == false && result != null && !result.isSuccess())).booleanValue()) {
                if (result != null) {
                    this.getView().showErrorNotification(result.getMessage());
                }
                return;
            }
            if (configParam != null && configParam.size() > 0) {
                String name = this.service.getEmployeeNameById(employeeId);
                FormShowParameter showParameter = new FormShowParameter();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("talentDetailView_employeeId", employeeId);
                param.put("talentDetailView_views", JSON.toJSONString((Object)configParam));
                showParameter.setCustomParams(param);
                if (StringUtils.isNotEmpty((CharSequence)name)) {
                    String caption = FormMetadataCache.getFormConfig((String)"tdcs_talentdetailview").getCaption().getLocaleValue() + "-" + name;
                    showParameter.setCaption(caption);
                }
                showParameter.setFormId("tdcs_talentdetailview");
                String pageId = this.getView().getPageId() + "|" + employeeId;
                showParameter.setPageId(pageId);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                view.showForm(showParameter);
            }
        }
    }

    private List<Long> convertLong(List<String> employeeList) {
        return employeeList.stream().map(item -> Long.valueOf(item)).collect(Collectors.toList());
    }

    private void showMyAttentionForm(IFormView view) {
        this.getPageCache().put("showtype", "0");
        HashMap<String, String> eventParam = new HashMap<String, String>(16);
        eventParam.put("homeToMyAttention", "true");
        this.showTalentSearchFlexPanel(this.getView(), eventParam);
    }

    private void showTalentSearchFlexPanel(IFormView view, Map eventParam) {
        IClientViewProxy proxy;
        CustomControl controlSearchResult = (CustomControl)this.getView().getControl("tdcstalentsearchresult");
        Map data = this.service.querySearchScene("tdcs_talentsearch", this.service.getAppNumber());
        if (!data.get("code").equals("200")) {
            controlSearchResult.setData((Object)data);
            return;
        }
        this.getPageCache().put("searchPageType", "2");
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelhome"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelsearch"});
        this.getView().getPageCache().put("searchSceneBo", SerializationUtils.toJsonString(data.get("data")));
        SearchSceneVo dataData = (SearchSceneVo)data.get("data");
        String defCategory = this.getPageCache().get("defCategory");
        if (HRStringUtils.isNotEmpty((String)defCategory)) {
            dataData.setDefCategory(defCategory);
            dataData.setDefSearchKeyLogic(this.getPageCache().get("defSearchKeyLogic"));
        }
        List myFilterSchemes = SearchFilterSchemeQueryHelper.getMyFilterSchemes((long)Long.parseLong(dataData.getSceneId()), (long)RequestContext.get().getCurrUserId());
        dataData.setSchemeList(myFilterSchemes);
        String primaryKey = view.getPageCache().get("primaryKey");
        if (HRStringUtils.isEmpty((String)primaryKey)) {
            primaryKey = "1";
        }
        data.put("primaryKey", primaryKey);
        if (Objects.isNull(eventParam)) {
            data.put("inputName", "");
            data.put("searchTargetType", "");
            data.put("searchRangFieldList", new ArrayList());
            data.put("showTap", "all");
            data.put("type", "2");
            IClientViewProxy proxy2 = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy2.setEntryProperty("tdcstalentsearchresult", "data", (Object)data);
            return;
        }
        String homeToMyAttention = (String)eventParam.get("homeToMyAttention");
        if (HRStringUtils.isNotEmpty((String)homeToMyAttention)) {
            data.put("primaryKey", "1");
            data.put("inputName", "");
        } else {
            String valueName = (String)eventParam.get("value");
            data.put("inputName", valueName);
        }
        String sceneVersion = (String)eventParam.get("sceneVersion");
        if (HRStringUtils.isNotEmpty((String)sceneVersion)) {
            dataData.setSceneVersion(sceneVersion);
        }
        String showtype = this.getPageCache().get("showtype");
        String type = (String)eventParam.get("type");
        this.getView().getPageCache().put("searchSceneBo", SerializationUtils.toJsonString((Object)dataData));
        String searchTargetType = (String)eventParam.get("searchTargetType");
        List searchRangFieldList = (List)eventParam.get("searchRangFieldList");
        if (EnumResponseCode.SUCCESS.getCode().equals(data.get("code"))) {
            String associationText;
            String hisRecordText = (String)eventParam.get("hisRecordText");
            if (HRStringUtils.isNotEmpty((String)hisRecordText)) {
                data.put("hisRecordId", eventParam.get("hisRecordId"));
                data.put("hisRecordText", hisRecordText);
            }
            if (HRStringUtils.isNotEmpty((String)(associationText = (String)eventParam.get("associationText")))) {
                data.put("associationId", eventParam.get("associationId"));
                data.put("associationText", associationText);
                data.put("fieldAlias", eventParam.get("fieldAlias"));
                data.put("labelFilterProp", eventParam.get("labelFilterProp"));
            }
            data.put("searchTargetType", searchTargetType);
            data.put("searchRangFieldList", searchRangFieldList);
            data.put("showTap", this.getShowType(showtype, type));
            data.put("type", HRStringUtils.isEmpty((String)showtype) ? "1" : "2");
            proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            String isOnlyForwardResult = this.getPageCache().get("isOnlyForwardResult");
            if (HRStringUtils.isNotEmpty((String)isOnlyForwardResult)) {
                data.put("isOnlyForwardResult", true);
                this.getPageCache().remove("isOnlyForwardResult");
                SearchPage searchPage = new SearchPage();
                Long sceneId = Long.parseLong(dataData.getSceneId());
                Long searchObjId = Long.parseLong(dataData.getSearchObjId());
                SearchCategoryEnum category = SearchCategoryEnum.PHRASE_SEARCH.getValue().equals(dataData.getDefCategory()) ? SearchCategoryEnum.PHRASE_SEARCH : SearchCategoryEnum.WORD_SEG_SEARCH;
                SearchParam searchParam = new SearchParam(sceneId, searchObjId, category, SearchKeyLogicEnum.OR);
                searchParam.setPermCtlDymNum("tdcs_talentsearch");
                searchParam.setPermCtlAppNum(this.service.getAppNumber());
                searchParam.setSearchContent("");
                searchPage.setSearchParam(searchParam);
                Object[] qFilters = this.service.setUserQfilter(searchPage.getqFilters());
                long attentionNumber = 0L;
                if (HRArrayUtils.isNotEmpty((Object[])qFilters)) {
                    searchPage.setqFilters((QFilter[])qFilters);
                    HrApiResponse myAttionResponse = ExtSearchService.search((SearchParam)searchPage.getSearchParam(), (List)searchPage.getSearchField(), (QFilter[])searchPage.getqFilters(), (String)"<span class='highLight' style='color: red'>", (String)"</span>", (int)searchPage.getStart().intValue(), (int)searchPage.getPagerows().intValue());
                    attentionNumber = ((SmartSearchResp)myAttionResponse.getData()).getTotalHits();
                }
                data.put(ATTENTIONNUMBER, attentionNumber);
            } else {
                data.put("isOnlyForwardResult", false);
            }
        } else {
            throw new KDBizException((String)data.get("errorMessage"));
        }
        proxy.setEntryProperty("tdcstalentsearchresult", "data", (Object)data);
    }

    private void showSearchSetting(Map eventParam) {
        String defCategory = (String)eventParam.get("defCategory");
        String defSearchKeyLogic = (String)eventParam.get("defSearchKeyLogic");
        if (HRStringUtils.isNotEmpty((String)this.getPageCache().get("defCategory"))) {
            defCategory = this.getPageCache().get("defCategory");
            defSearchKeyLogic = this.getPageCache().get("defSearchKeyLogic");
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tdcs_searchsetting");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("defCategory", (Object)defCategory);
        showParameter.setCustomParam("defSearchKeyLogic", (Object)defSearchKeyLogic);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tdcs_searchsetting"));
        this.getView().showForm(showParameter);
    }

    private String getShowType(String showtype, String type) {
        if (HRStringUtils.isNotEmpty((String)showtype) || type.equals("2")) {
            return "myattention";
        }
        return "all";
    }

    private void initMyAttentionPanel(Map<String, Object> statisticData) {
        List labelList;
        FlexPanelAp highFreguentFlexPanelAp;
        List dimList = (List)statisticData.get("dim");
        FlexPanelAp flexPanelAp = this.createDimLabelFlexPanelAp(dimList);
        if (flexPanelAp != null) {
            Container container = (Container)this.getView().getControl(FLEXPANELLABEL);
            container.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
            this.getView().updateControlMetadata(FLEXPANELLABEL, flexPanelAp.createControl());
        }
        if ((highFreguentFlexPanelAp = this.createLabelFlexPanelAp(labelList = (List)statisticData.get("label"))) != null) {
            Container highFreguentContainer = (Container)this.getView().getControl(FLEXPANELHIGHFREGUENT);
            highFreguentContainer.getItems().addAll(((Container)highFreguentFlexPanelAp.buildRuntimeControl()).getItems());
            this.getView().updateControlMetadata(FLEXPANELHIGHFREGUENT, highFreguentFlexPanelAp.createControl());
        }
        Label num = (Label)this.getControl(ATTENTIONNUMBER);
        Long total = (Long)statisticData.get("total");
        num.setText(ResManager.loadKDString((String)"%s\u4eba", (String)"TalentSearchHome_2", (String)"tdc-tdcs-formplugin", (Object[])new Object[]{total}));
        Boolean visibleFlag = total != null && total > 0L ? Boolean.TRUE : Boolean.FALSE;
        logger.info("visibleFlag->{}", (Object)visibleFlag);
        this.getView().setVisible(visibleFlag, new String[]{FLEXPANELMYATTENTION});
    }

    public FlexPanelAp createDimLabelFlexPanelAp(List<String> dimList) {
        if (dimList != null && dimList.size() > 0) {
            FlexPanelAp labePanelAp = new FlexPanelAp();
            labePanelAp.setKey(FLEXPANELLABEL);
            for (String name : dimList) {
                LabelAp label = this.createDimLabel(ID.genStringId(), name);
                labePanelAp.getItems().add(label);
            }
            return labePanelAp;
        }
        return null;
    }

    public LabelAp createDimLabel(String key, String name) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setName(new LocaleString("\"" + name + "\""));
        labelAp.setForeColor("#666666");
        labelAp.setFontSize(12);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("8px");
        margin.setLeft("0px");
        margin.setRight("20px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        labelAp.setAutoTextWrap(true);
        labelAp.setClickable(false);
        return labelAp;
    }

    public FlexPanelAp createLabelFlexPanelAp(List<Map<String, Object>> list) {
        if (list != null && list.size() > 0) {
            FlexPanelAp labePanelAp = new FlexPanelAp();
            labePanelAp.setKey(ID.genStringId());
            String title = ResManager.loadKDString((String)"\u9ad8\u9891\u6807\u7b7e", (String)"TalentSearchHome_1", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]);
            title = title + "\uff1a";
            LabelAp highFrequentLabel = this.createLabelTitle(ID.genStringId(), title);
            labePanelAp.getItems().add(highFrequentLabel);
            for (Map<String, Object> row : list) {
                String name = (String)row.get("description");
                LabelAp label = this.createLabel(ID.genStringId(), name);
                labePanelAp.getItems().add(label);
            }
            return labePanelAp;
        }
        return null;
    }

    public LabelAp createLabelTitle(String key, String name) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(name));
        labelAp.setForeColor("#999999");
        labelAp.setFontSize(14);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("8px");
        margin.setRight("8px");
        style.setMargin(margin);
        labelAp.setStyle(style);
        labelAp.setClickable(false);
        return labelAp;
    }

    public LabelAp createLabel(String key, String name) {
        LabelAp labelAp = new LabelAp();
        labelAp.setKey(key);
        labelAp.setName(new LocaleString(name));
        labelAp.setForeColor("#666666");
        labelAp.setBackColor("rgba(102,102,102,0.08)");
        labelAp.setFontSize(12);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setTop("8px");
        margin.setRight("8px");
        style.setMargin(margin);
        Padding padding = new Padding();
        padding.setLeft("8px");
        padding.setRight("8px");
        padding.setTop("2px");
        padding.setBottom("2px");
        style.setPadding(padding);
        labelAp.setStyle(style);
        labelAp.setClickable(false);
        return labelAp;
    }

    private void showMySuggest(IFormView view) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tdcs_mysuggest");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm((FormShowParameter)showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        String callBackId = closedEvent.getCallBackId();
        if ("deleteScheme".equals(callBackId)) {
            String deleteSchemeData = this.getPageCache().get("deleteSchemeData");
            this.getPageCache().remove("deleteSchemeData");
            if (closedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
                Map eventParam = (Map)SerializationUtils.fromJsonString((String)deleteSchemeData, Map.class);
                long schemeNameId = Long.parseLong((String)eventParam.get("schemeNameId"));
                this.service.deleteFilterScheme(schemeNameId);
                String deleteSuccessTip = ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TalentSearchPlugin_8", (String)"tdc-tdcs-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(deleteSuccessTip);
                BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)callBackId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664", "TalentSearchPlugin_13", "tdc-tdcs-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664\u6210\u529f\u3002", "TalentSearchPlugin_8", "tdc-tdcs-formplugin"));
                long sceneId = Long.parseLong((String)eventParam.get("sceneId"));
                List myFilterSchemes = SearchFilterSchemeQueryHelper.getMyFilterSchemes((long)sceneId, (long)RequestContext.get().getCurrUserId());
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("eventName", "updateScheme");
                data.put("verification", true);
                data.put("schemeNameId", String.valueOf(schemeNameId));
                data.put("updateType", "2");
                data.put("schemeList", myFilterSchemes);
                CustomControl resultCustomControl = (CustomControl)this.getControl("tdcstalentsearchresult");
                resultCustomControl.setData(data);
            }
        }
    }

    static {
        permEvenKeyMap.put("event_searchscene", Boolean.TRUE);
        permEvenKeyMap.put("event_attention", Boolean.TRUE);
        permEvenKeyMap.put("event_cancelattention", Boolean.TRUE);
        permEvenKeyMap.put("event_showtalentdetail", Boolean.TRUE);
        permEvenKeyMap.put("event_searchfilterf7", Boolean.TRUE);
        permEvenKeyMap.put("event_search", Boolean.TRUE);
        permEvenKeyMap.put("event_showSearchSetting", Boolean.TRUE);
        permEvenKeyMap.put("event_forwardtalentsearchhome", Boolean.TRUE);
        permEvenKeyMap.put("event_forwardtalentsearch", Boolean.TRUE);
        permEvenKeyMap.put("event_refresh_home", Boolean.TRUE);
        permEvenKeyMap.put("event_showhisrecords", Boolean.TRUE);
        permEvenKeyMap.put("event_clearhisrecords", Boolean.TRUE);
        permEvenKeyMap.put("event_deletehisrecord", Boolean.TRUE);
        permEvenKeyMap.put("event_search_association", Boolean.TRUE);
        permEvenKeyMap.put("saveScheme", Boolean.TRUE);
        permEvenKeyMap.put("deleteScheme", Boolean.TRUE);
    }
}

