/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.mservice;

import java.text.MessageFormat;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CoordinationApplicationService;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;
import kd.tdc.tdcs.mservice.api.ITDCSBizMsgConsumerService;

public class TDCSBizMsgConsumerService
implements ITDCSBizMsgConsumerService {
    private static final Log LOG = LogFactory.getLog(TDCSBizMsgConsumerService.class);
    private final CoordinationApplicationService coordinationApplicationService = (CoordinationApplicationService)ServiceFactory.getService(CoordinationApplicationService.class);
    private final ExternalService externalService = (ExternalService)ServiceFactory.getService(ExternalService.class);

    public HRMServiceResult consumerSaveMsg(DynamicObject coordinationLog) {
        DynamicObject coordinationMsg;
        Map msgContent = (Map)SerializationUtils.deSerializeFromBase64((String)coordinationLog.getString("msgcontent"));
        LOG.info(MessageFormat.format("TDCSBizMsgConsumerService.consumerSaveMsg(): msgContent is {0}", msgContent));
        Long msgCenterBoId = coordinationLog.getLong("msgcenterbo");
        DLock lock = DLock.create((String)("TDCSBizMsgConsumerService.consumerSaveMsg_" + msgCenterBoId));
        HRMServiceResult result = HRMServiceResult.success();
        if (!lock.tryLock()) {
            LOG.error("TDCSBizMsgConsumerService.consumerSaveMsg(): try lock time out");
            throw new RuntimeException("consumer save msg fail");
        }
        try {
            boolean isExistsMsg = this.coordinationApplicationService.isCoordinationMsgExists(msgCenterBoId);
            if (isExistsMsg) {
                HRMServiceResult hRMServiceResult = result;
                return hRMServiceResult;
            }
            coordinationMsg = this.coordinationApplicationService.saveHRBizCoordinationMsg(coordinationLog);
            this.externalService.updateConsumeMsgInfo(coordinationLog);
            LOG.info("TDCSBizMsgConsumerService.consumerSaveMsg(): consumer save msg success");
        }
        catch (Exception exp) {
            LOG.error("TDCSBizMsgConsumerService.consumerSaveMsg(): consumer save msg error,", (Throwable)exp);
            throw exp;
        }
        finally {
            lock.unlock();
        }
        this.coordinationApplicationService.createCoordinationTasks(coordinationMsg);
        return result;
    }
}

