/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.mservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper;
import kd.tdc.tdcs.mservice.api.ITDCSLicenseService;
import org.apache.commons.lang.StringUtils;

public class TDCSLicenseService
implements ITDCSLicenseService {
    private static final Log logger = LogFactory.getLog(TDCSLicenseService.class);
    private static final String EXE_FLAG = "exeFlag";
    private static final String MESSAGE = "msg";
    private static ThreadPool threadPool;

    public Map<String, Object> verifyCert(String bizAppID, String bizObjID) {
        return TDCSCertCommonHelper.verifyCert((String)bizAppID, (String)bizObjID);
    }

    public Map<String, Object> verifyCertByPid(String bizAppID, String bizObjID, List<Long> pids) {
        return TDCSCertCommonHelper.verifyCertByPid((String)bizAppID, (String)bizObjID, pids);
    }

    public Map<String, Object> verifyCertByPersonId(String bizAppID, String bizObjID, List<Long> personIds) {
        return TDCSCertCommonHelper.verifyCertByPersonId((String)bizAppID, (String)bizObjID, personIds);
    }

    public Map<String, Object> updateCertDetail(String groupId) {
        Map map = HRCertCommonHelper.verifyCertCount((String)groupId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (null == map || StringUtils.equals((String)((String)map.get("infoType")), (String)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            resultMap.put(EXE_FLAG, Boolean.FALSE);
            resultMap.put(MESSAGE, "check infotype is FORBIDDEN");
        } else {
            resultMap.put(EXE_FLAG, Boolean.TRUE);
            resultMap.put(MESSAGE, "success");
            threadPool.execute(() -> TDCSCertCommonHelper.updateCertDetailShaStr((String)groupId));
        }
        return resultMap;
    }

    static {
        try {
            threadPool = ThreadPools.newFixedThreadPool((String)"TDC_TDCS_LICENSE_SERVICE_POOL", (int)1);
        }
        catch (Exception e) {
            logger.error("LICENSE_SERVICE_POOL create error", (Throwable)e);
        }
    }
}

