/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.common.bo.talentsearch;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class AnalysisResult {
    private Integer capacity;
    private Map<String, Map<Object, Long>> data = new HashMap<String, Map<Object, Long>>();
    private Map<String, Long> total = new HashMap<String, Long>();
    private Long rowCount = 0L;
    private Map<String, List<Pair<Object, BigDecimal>>> sortdata = new HashMap<String, List<Pair<Object, BigDecimal>>>();

    public AnalysisResult(Integer capacity) {
        this.capacity = capacity;
    }

    public Long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(Long rowCount) {
        this.rowCount = rowCount;
    }

    public void plusRowCount() {
        AnalysisResult analysisResult = this;
        Long l = analysisResult.rowCount;
        Long l2 = analysisResult.rowCount = Long.valueOf(analysisResult.rowCount + 1L);
    }

    public Map<String, List<Pair<Object, BigDecimal>>> getSortdata() {
        return this.sortdata;
    }

    public void setSortdata(Map<String, List<Pair<Object, BigDecimal>>> sortdata) {
        this.sortdata = sortdata;
    }

    public void sumDim(String dimCode, Object value) {
        if (value != null) {
            if (this.data.get(dimCode) == null) {
                this.data.put(dimCode, new HashMap(this.capacity));
            }
            if (this.data.get(dimCode).containsKey(value)) {
                this.data.get(dimCode).put(value, this.data.get(dimCode).get(value) + 1L);
            } else {
                this.data.get(dimCode).put(value, 1L);
            }
        }
    }

    public void sumDim(String dimCode, List<String> values) {
        if (values != null && values.size() > 0) {
            if (this.data.get(dimCode) == null) {
                this.data.put(dimCode, new HashMap(this.capacity));
            }
            for (String item : values) {
                if (this.data.get(dimCode).containsKey(item)) {
                    this.data.get(dimCode).put(item, this.data.get(dimCode).get(item) + 1L);
                    continue;
                }
                this.data.get(dimCode).put(item, 1L);
            }
        }
    }

    public void calacTotal() {
        if (this.data.size() > 0) {
            for (Map.Entry<String, Map<Object, Long>> entry : this.data.entrySet()) {
                String key = entry.getKey();
                Map<Object, Long> dimCollection = entry.getValue();
                if (dimCollection == null || dimCollection.size() <= 0) continue;
                Long count = 0L;
                for (Map.Entry<Object, Long> dim : dimCollection.entrySet()) {
                    count = count + dim.getValue();
                }
                this.total.put(key, count);
            }
        }
    }

    public void sortDim(String dimCode, Integer type, Integer topCount) {
        Long totalCount;
        Long l = totalCount = type == 1 ? this.rowCount : this.total.get(dimCode);
        if (this.data.get(dimCode) != null && !this.data.get(dimCode).isEmpty()) {
            ArrayList<Map.Entry<Object, Long>> list = new ArrayList<Map.Entry<Object, Long>>(this.data.get(dimCode).entrySet());
            Collections.sort(list, new Comparator<Map.Entry<Object, Long>>(){

                @Override
                public int compare(Map.Entry<Object, Long> o1, Map.Entry<Object, Long> o2) {
                    return o2.getValue().intValue() - o1.getValue().intValue();
                }
            });
            int index = this.amendTopCount(list, topCount);
            ArrayList<Pair> sortItemList = new ArrayList<Pair>(index);
            for (int i = 0; i < index; ++i) {
                BigDecimal percent = new BigDecimal((Long)((Map.Entry)list.get(i)).getValue()).divide(new BigDecimal(totalCount), 2, RoundingMode.HALF_UP);
                Pair item = Pair.of(((Map.Entry)list.get(i)).getKey(), (Object)percent);
                sortItemList.add(item);
            }
            this.sortdata.put(dimCode, sortItemList);
        }
    }

    private int amendTopCount(List<Map.Entry<Object, Long>> list, Integer topCount) {
        if (list.size() < topCount) {
            return list.size();
        }
        int index = topCount;
        Long val = list.get(topCount - 1).getValue();
        for (int i = topCount.intValue(); i < list.size(); ++i) {
            if (!val.equals(list.get(i).getValue())) continue;
            ++index;
        }
        return index;
    }
}

