/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.common.perchange;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public enum ChangeTypeEnum {
    HIRE_PEOPLE_ON_BOARD(1010L),
    TURNOVER(1020L),
    INTRA_COMPANY_TRANSFER(1050L),
    CROSS_COMPANY_TRANSFER(1060L),
    PART_TIME_JOB(1070L),
    PART_TIME_TERMINATION(1100L),
    EXPATRIATE(1130L),
    EXPATRIATE_TERMINATE(1140L),
    EXPATRIATE_CHANGE(1260L),
    RETIRED(1200L);

    private static final List<Long> updateRelationalEnums;
    private static final List<Long> failureRelationalEnums;
    private final long number;

    private ChangeTypeEnum(long number) {
        this.number = number;
    }

    public long getNumber() {
        return this.number;
    }

    public static ChangeTypeEnum getEnumByNumber(long number) {
        return Arrays.stream(ChangeTypeEnum.values()).filter(entity -> entity.getNumber() == number).findFirst().orElse(null);
    }

    public static boolean isUpdateRelational(long number) {
        return updateRelationalEnums.contains(number);
    }

    public static boolean isFailureRelational(long number) {
        return failureRelationalEnums.contains(number);
    }

    static {
        updateRelationalEnums = Lists.newArrayList((Object[])new Long[]{ChangeTypeEnum.HIRE_PEOPLE_ON_BOARD.number, ChangeTypeEnum.INTRA_COMPANY_TRANSFER.number, ChangeTypeEnum.CROSS_COMPANY_TRANSFER.number, ChangeTypeEnum.PART_TIME_JOB.number});
        failureRelationalEnums = Lists.newArrayList((Object[])new Long[]{ChangeTypeEnum.PART_TIME_TERMINATION.number, ChangeTypeEnum.INTRA_COMPANY_TRANSFER.number, ChangeTypeEnum.CROSS_COMPANY_TRANSFER.number, ChangeTypeEnum.TURNOVER.number, ChangeTypeEnum.RETIRED.number});
    }
}

