/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.common.util;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tdc.tdcs.common.bo.NodeBo;

public class CommUtils {
    private static final Log logger = LogFactory.getLog(CommUtils.class);

    public static String appendMulitBaseId(DynamicObjectCollection collection, String split) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        logger.info(MessageFormat.format("\u5206\u9694\u7b26\u662f\uff1a{0}", split));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject dynamicObject = ((DynamicObject)collection.get(i)).getDynamicObject("fbasedataid");
            if (dynamicObject == null) continue;
            if (i == 0) {
                result = new StringBuilder(((DynamicObject)collection.get(i)).getDynamicObject("fbasedataid").getString("id"));
                continue;
            }
            String id = ((DynamicObject)collection.get(i)).getDynamicObject("fbasedataid").getString("id");
            logger.info(MessageFormat.format("\u5f53\u524d\u662f\u7b2c{0}\u6b21\u5faa\u73af\uff0c\u804c\u4f4d\u4f53\u7cfbid\u662f\uff1a{1}\uff0cresult\u662f\uff1a{2}", i, id, result.toString()));
            result.append(split).append(id);
        }
        return result.toString();
    }

    public static String appendStr(String ... strs) {
        StringBuilder buffer = new StringBuilder();
        for (String str : strs) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public static String appendIds(List<Long> ids) {
        StringBuilder buffer = new StringBuilder();
        if (CollectionUtils.isEmpty(ids)) {
            return "";
        }
        for (int i = 0; i < ids.size(); ++i) {
            buffer.append(ids.get(i));
            if (i == ids.size() - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    public static List<String> getAllTreeIdFromTreeNode(List<TreeNode> treeNodeList) {
        ArrayList<String> allTreeIdList = new ArrayList<String>(treeNodeList.size());
        for (TreeNode treeNode : treeNodeList) {
            allTreeIdList.add(treeNode.getId());
            CommUtils.getTreePathIds(treeNode, allTreeIdList);
        }
        return allTreeIdList;
    }

    public static List<String> getChildIdFromTreeNode(TreeNode treeNode) {
        ArrayList<String> allTreeIdList = new ArrayList<String>();
        if (treeNode != null) {
            CommUtils.getTreePathIds(treeNode, allTreeIdList);
        }
        return allTreeIdList;
    }

    private static void getTreePathIds(TreeNode fatherTreeNode, List<String> allTreeIdList) {
        if (CollectionUtils.isEmpty((Collection)fatherTreeNode.getChildren())) {
            return;
        }
        for (TreeNode treeNode : fatherTreeNode.getChildren()) {
            allTreeIdList.add(treeNode.getId());
            CommUtils.getTreePathIds(treeNode, allTreeIdList);
        }
    }

    public static String parseId(DynamicObject dynamicObject, String controlName) {
        if (dynamicObject.get(controlName) == null) {
            return "0";
        }
        return ((DynamicObject)dynamicObject.get(controlName)).getString("id");
    }

    public static String parseName(DynamicObject dynamicObject, String controlName) {
        if (dynamicObject.get(controlName) == null) {
            return "";
        }
        return ((DynamicObject)dynamicObject.get(controlName)).getString("name");
    }

    public static void setFatherNodeListMap(NodeBo bo, Map<String, List<NodeBo>> fartherNodeListMap) {
        if (fartherNodeListMap.get(bo.getParentId()) == null) {
            fartherNodeListMap.put(bo.getParentId(), Lists.newArrayList((Object[])new NodeBo[]{bo}));
        } else {
            fartherNodeListMap.get(bo.getParentId()).add(bo);
        }
    }

    public static void setTreeNodeListMap(TreeNode treeNode, Map<String, List<TreeNode>> fartherNodeListMap) {
        if (fartherNodeListMap.get(treeNode.getParentid()) == null) {
            fartherNodeListMap.put(treeNode.getParentid(), Lists.newArrayList((Object[])new TreeNode[]{treeNode}));
        } else {
            fartherNodeListMap.get(treeNode.getParentid()).add(treeNode);
        }
    }

    public static void setListMap(String key, Long value, Map<String, List<Long>> listMap) {
        if (listMap.get(key) == null) {
            listMap.put(key, Lists.newArrayList((Object[])new Long[]{value}));
        } else {
            listMap.get(key).add(value);
        }
    }

    public static void getMinCommOrtTypeIdAndNum(IFormView view) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tdcs_commorgtype", (String)"number,name,index", (QFilter[])new QFilter[0]);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u201c\u4e13\u59d4\u4f1a\u7ec4\u7ec7\u7c7b\u578b\u201d\u4e3a\u7a7a,\u8bf7\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u589e\u52a0\u3002", (String)"CommUtils_0", (String)"tdc-tdcs-common", (Object[])new Object[0]));
            return;
        }
        HashMap<Integer, Long> indexIdMap = new HashMap<Integer, Long>(dynamicObjects.length);
        int minIndex = Integer.MAX_VALUE;
        IPageCache pageCache = view.getPageCache();
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.getInt("index") < minIndex) {
                minIndex = dynamicObject.getInt("index");
                pageCache.put("minCommOrgTypeId", dynamicObject.getString("id"));
                pageCache.put("minCommOrgTypeNumber", dynamicObject.getString("number"));
            }
            indexIdMap.put(dynamicObject.getInt("index"), dynamicObject.getLong("id"));
        }
        pageCache.put("indexIdMap", SerializationUtils.toJsonString(indexIdMap));
    }

    public static boolean unfoldTreeContainKey(TreeNode fatherTreeNode, String searchText, boolean containSearchTextFlag) {
        if (CollectionUtils.isEmpty((Collection)fatherTreeNode.getChildren())) {
            return false;
        }
        for (TreeNode treeNode : fatherTreeNode.getChildren()) {
            containSearchTextFlag = CommUtils.unfoldTreeContainKey(treeNode, searchText, containSearchTextFlag);
            if (containSearchTextFlag) {
                treeNode.setIsOpened(true);
                continue;
            }
            if (!containSearchTextFlag && treeNode.getText().contains(searchText)) {
                containSearchTextFlag = true;
            }
            return containSearchTextFlag;
        }
        return containSearchTextFlag;
    }
}

