/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.common.util;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class CommonUtils {
    private static final Log LOG = LogFactory.getLog(CommonUtils.class);
    private static final String YYYY_MM_DD = "yyyy-MM-dd";

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object object : (List)obj) {
                result.add(clazz.cast(object));
            }
        }
        return result;
    }

    public static <T> List<Map<T, Object>> castListMap(Object obj, Class<T> keyClazz) {
        ArrayList<Map<T, Object>> result = new ArrayList<Map<T, Object>>();
        if (obj instanceof List) {
            for (Object object : (List)obj) {
                result.add(CommonUtils.castMap(object, keyClazz));
            }
        }
        return result;
    }

    public static <T> Map<T, Object> castMap(Object obj, Class<T> keyClazz) {
        HashMap maps = new HashMap(16);
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.forEach((key, val) -> maps.put(keyClazz.cast(key), val));
        }
        return maps;
    }

    public static <T, E> Map<T, E> castMap(Object obj, Class<T> clazz, Class<E> eClass) {
        HashMap maps = new HashMap(16);
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.forEach((key, val) -> maps.put(clazz.cast(key), eClass.cast(val)));
        }
        return maps;
    }

    public static <T> Set<T> castSet(Object obj, Class<T> clazz) {
        HashSet<T> set = new HashSet<T>();
        if (obj instanceof Set) {
            for (Object object : (Set)obj) {
                set.add(clazz.cast(object));
            }
        }
        return set;
    }

    public static Date truncateDate(Date date) {
        String format = HRDateTimeUtils.format((Date)date, (String)YYYY_MM_DD);
        try {
            date = HRDateTimeUtils.parseDate((String)format, (String)YYYY_MM_DD);
        }
        catch (ParseException exc) {
            LOG.error("date,truncateDate simpleDateFormat error:{},{}", (Object)date, (Object)exc);
        }
        return date;
    }

    public static LocalDateTime dateToLocalDate(Date date) {
        return date.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDateTime();
    }

    public static long dayDiff(Date date1, Date date2) {
        Duration between = Duration.between(CommonUtils.dateToLocalDate(date1), CommonUtils.dateToLocalDate(date2));
        return between.toDays();
    }

    public static String substringInteger(int dividend, int divisor) {
        if (divisor == 0) {
            return "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        float result = (float)dividend / (float)divisor;
        String formatResult = decimalFormat.format(result);
        return formatResult.endsWith(".0") ? formatResult.substring(0, formatResult.length() - 2) : formatResult;
    }

    public static String substringInteger(double dividend, int divisor) {
        if (divisor == 0) {
            return "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        float result = (float)dividend / (float)divisor;
        String formatResult = decimalFormat.format(result);
        return formatResult.endsWith(".0") ? formatResult.substring(0, formatResult.length() - 2) : formatResult;
    }

    public static List<String> countPercent(List<Integer> numList) {
        int sum = numList.stream().mapToInt(item -> item).sum();
        ArrayList result = Lists.newArrayListWithExpectedSize((int)numList.size());
        if (sum == 0) {
            numList.forEach(item -> result.add("0%"));
            return result;
        }
        if (numList.size() == 1) {
            numList.forEach(item -> result.add("100%"));
            return result;
        }
        for (Integer integer : numList) {
            result.add(CommonUtils.substringInteger(integer * 100, sum));
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        double countSum = result.subList(0, result.size() - 1).stream().mapToDouble(Double::parseDouble).sum();
        double lastNum = 100.0 - countSum;
        String formatResult = decimalFormat.format(lastNum);
        formatResult = formatResult.endsWith(".0") ? formatResult.substring(0, formatResult.length() - 2) : formatResult;
        ArrayList finalResult = Lists.newArrayListWithExpectedSize((int)numList.size());
        for (int i = 0; i < result.size(); ++i) {
            if (i == result.size() - 1) {
                finalResult.add(formatResult + "%");
                return finalResult;
            }
            finalResult.add((String)result.get(i) + "%");
        }
        return result;
    }

    public static Comparator<Date> dateComparator() {
        return (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o2.compareTo((Date)o1);
        };
    }

    public static <V> boolean isSameElement(Set<V> set1, Set<V> set2) {
        if (set1 == null || set2 == null) {
            return set1 == null && set2 == null;
        }
        if (set1.size() != set2.size()) {
            return false;
        }
        List set1HaveSet2Not = set1.stream().filter(v -> !set2.contains(v)).collect(Collectors.toList());
        List set2HaveSet1Not = set2.stream().filter(v -> !set1.contains(v)).collect(Collectors.toList());
        return HRCollUtil.isEmpty(set1HaveSet2Not) && HRCollUtil.isEmpty(set2HaveSet1Not);
    }
}

