/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LogicExpressionParserUtils {
    private static final String LEFT_BRACKET = "(";
    private static final String RIGHT_BRACKET = ")";
    private static final String DEFAULT_AND_SYMBOL = "and";
    private static final String DEFAULT_OR_SYMBOL = "or";

    public static List<List<String>> parse(String logicExpression) throws ParseException {
        return LogicExpressionParserUtils.parse(logicExpression, DEFAULT_AND_SYMBOL, DEFAULT_OR_SYMBOL);
    }

    public static List<List<String>> parse(String logicExpression, String logicalAndSymbol, String logicalOrSymbol) throws ParseException {
        LogicExpressionParserUtils.validateExpressionFormat(logicExpression, logicalAndSymbol, logicalOrSymbol);
        ExpressionTreeNode expressionTree = LogicExpressionParserUtils.parseExpressionTree(logicExpression, logicalAndSymbol, logicalOrSymbol);
        return LogicExpressionParserUtils.generateExpressionGroup(expressionTree, logicalAndSymbol, logicalOrSymbol);
    }

    private static ExpressionTreeNode parseExpressionTree(String logicExpression, String logicalAndSymbol, String logicalOrSymbol) {
        String[] expressionElements = LogicExpressionParserUtils.splitExpression(logicExpression, logicalAndSymbol, logicalOrSymbol);
        if (expressionElements.length == 1) {
            return new ExpressionTreeNode(expressionElements[0]);
        }
        return LogicExpressionParserUtils.buildExpressionTree(expressionElements, 0, expressionElements.length - 1, logicalAndSymbol, logicalOrSymbol);
    }

    private static String[] splitExpression(String logicExpression, String logicalAndSymbol, String logicalOrSymbol) {
        String leftBracketWithSpace = " ( ";
        String rightBracketWithSpace = " ) ";
        String logicAndWithSpace = " " + logicalAndSymbol + " ";
        String logicOrWithSpace = " " + logicalOrSymbol + " ";
        String[] expressionEleArray = logicExpression.replace(logicalAndSymbol, logicAndWithSpace).replace(logicalOrSymbol, logicOrWithSpace).replace(LEFT_BRACKET, leftBracketWithSpace).replace(RIGHT_BRACKET, rightBracketWithSpace).split(" ");
        return (String[])Arrays.stream(expressionEleArray).filter(StringUtils::isNotEmpty).toArray(String[]::new);
    }

    private static List<List<String>> generateExpressionGroup(ExpressionTreeNode node, String logicalAndSymbol, String logicalOrSymbol) {
        ArrayList expressionList = Lists.newArrayList();
        if (node == null) {
            return expressionList;
        }
        if (node.getLeft() == null) {
            expressionList.add(new ArrayList<String>(Collections.singletonList(node.getName())));
            return expressionList;
        }
        List<List<String>> leftSubExpressionList = LogicExpressionParserUtils.generateExpressionGroup(node.getLeft(), logicalAndSymbol, logicalOrSymbol);
        List<List<String>> rightSubExpressionList = LogicExpressionParserUtils.generateExpressionGroup(node.getRight(), logicalAndSymbol, logicalOrSymbol);
        if (node.getName().equalsIgnoreCase(logicalOrSymbol)) {
            expressionList.addAll(leftSubExpressionList);
            expressionList.addAll(rightSubExpressionList);
            return expressionList;
        }
        if (node.getName().equalsIgnoreCase(logicalAndSymbol)) {
            for (List<String> leftSubExpList : leftSubExpressionList) {
                for (List<String> rightSubExpList : rightSubExpressionList) {
                    HashSet subExpressionSet = Sets.newHashSetWithExpectedSize((int)(leftSubExpList.size() + rightSubExpList.size()));
                    subExpressionSet.addAll(leftSubExpList);
                    subExpressionSet.addAll(rightSubExpList);
                    expressionList.add(new ArrayList(subExpressionSet));
                }
            }
        }
        return expressionList;
    }

    private static ExpressionTreeNode buildExpressionTree(String[] expressionElements, int from, int end, String logicalAndSymbol, String logicalOrSymbol) {
        if (from > end) {
            return null;
        }
        if (from == end) {
            return new ExpressionTreeNode(expressionElements[from]);
        }
        int rootTreeNodeIndex = LogicExpressionParserUtils.electRootTreeNodeIndex(expressionElements, from, end, logicalAndSymbol, logicalOrSymbol);
        if (rootTreeNodeIndex == -1) {
            return LogicExpressionParserUtils.buildExpressionTree(expressionElements, from + 1, end - 1, logicalAndSymbol, logicalOrSymbol);
        }
        ExpressionTreeNode root = new ExpressionTreeNode(expressionElements[rootTreeNodeIndex]);
        root.setLeft(LogicExpressionParserUtils.buildExpressionTree(expressionElements, from, rootTreeNodeIndex - 1, logicalAndSymbol, logicalOrSymbol));
        root.setRight(LogicExpressionParserUtils.buildExpressionTree(expressionElements, rootTreeNodeIndex + 1, end, logicalAndSymbol, logicalOrSymbol));
        return root;
    }

    private static int electRootTreeNodeIndex(String[] expressionElements, int from, int end, String logicalAndSymbol, String logicalOrSymbol) {
        int leftParenthesisNumber = 0;
        int lowPriorityOperatorIndex = -1;
        int highPriorityOperatorIndex = -1;
        for (int i = from; i <= end; ++i) {
            String element = expressionElements[i];
            if (logicalAndSymbol.equals(element)) {
                if (leftParenthesisNumber != 0) continue;
                highPriorityOperatorIndex = i;
                continue;
            }
            if (logicalOrSymbol.equals(element)) {
                if (leftParenthesisNumber != 0) continue;
                lowPriorityOperatorIndex = i;
                break;
            }
            if (LEFT_BRACKET.equals(element)) {
                ++leftParenthesisNumber;
                continue;
            }
            if (!RIGHT_BRACKET.equals(element)) continue;
            --leftParenthesisNumber;
        }
        if (lowPriorityOperatorIndex < 0) {
            lowPriorityOperatorIndex = highPriorityOperatorIndex;
        }
        return lowPriorityOperatorIndex;
    }

    private static void validateExpressionFormat(String logicExpression, String logicalAndSymbol, String logicalOrSymbol) throws ParseException {
        LogicExpressionParserUtils.validateParam(logicExpression, logicalAndSymbol, logicalOrSymbol);
        LogicExpressionParserUtils.validateBracket(logicExpression, logicalAndSymbol, logicalOrSymbol);
        LogicExpressionParserUtils.validateOperatorOperand(logicExpression, logicalAndSymbol, logicalOrSymbol);
    }

    private static void validateParam(String logicExpression, String logicalAndSymbol, String logicalOrSymbol) throws ParseException {
        if (StringUtils.isEmpty((CharSequence)logicExpression) || StringUtils.isEmpty((CharSequence)logicalAndSymbol) || StringUtils.isEmpty((CharSequence)logicalOrSymbol) || logicalAndSymbol.equals(logicalOrSymbol)) {
            throw new ParseException("param is empty, or operators are the same", 0);
        }
    }

    private static void validateBracket(String logicExpression, String logicalAndSymbol, String logicalOrSymbol) throws ParseException {
        String removeSpaceExpression = logicExpression.replace(" ", "");
        if (removeSpaceExpression.contains(LEFT_BRACKET + logicalAndSymbol) || removeSpaceExpression.contains(LEFT_BRACKET + logicalOrSymbol) || removeSpaceExpression.contains(logicalAndSymbol + RIGHT_BRACKET) || removeSpaceExpression.contains(logicalOrSymbol + RIGHT_BRACKET)) {
            throw new ParseException("bracket position is incorrect", 0);
        }
        String removeBracketExpression = logicExpression.replace(LEFT_BRACKET, "").replace(RIGHT_BRACKET, "");
        int bracketNum = logicExpression.length() - removeBracketExpression.length();
        if (bracketNum % 2 != 0) {
            throw new ParseException("bracket number is incorrect", 0);
        }
    }

    private static void validateOperatorOperand(String logicExpression, String logicalAndSymbol, String logicalOrSymbol) throws ParseException {
        String leftBracketWithSpace = " ( ";
        String rightBracketWithSpace = " ) ";
        String logicAndWithSpace = " " + logicalAndSymbol + " ";
        String logicOrWithSpace = " " + logicalOrSymbol + " ";
        String noBracketExpression = logicExpression.replace(LEFT_BRACKET, leftBracketWithSpace).replace(RIGHT_BRACKET, rightBracketWithSpace).replace(logicalAndSymbol, logicAndWithSpace).replace(logicalOrSymbol, logicOrWithSpace).replace(LEFT_BRACKET, "").replace(RIGHT_BRACKET, "");
        String[] noBracketExprArray = noBracketExpression.split(" ");
        List operatorOperandList = Arrays.stream(noBracketExprArray).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (operatorOperandList.size() % 2 == 0) {
            throw new ParseException("operator or operand is incorrect", 0);
        }
        HashSet logicOperatorSet = Sets.newHashSet();
        for (int i = 0; i < operatorOperandList.size(); ++i) {
            if (i % 2 != 0) {
                logicOperatorSet.add(operatorOperandList.get(i));
                continue;
            }
            String operand = (String)operatorOperandList.get(i);
            if (!operand.equals(logicalAndSymbol) && !operand.equals(logicalOrSymbol)) continue;
            throw new ParseException("operand is the same as operator", 0);
        }
        if (logicOperatorSet.size() > 2) {
            throw new ParseException("cannot separate out operator from the expression", 0);
        }
    }

    private static class ExpressionTreeNode {
        private String name;
        private ExpressionTreeNode left;
        private ExpressionTreeNode right;

        public ExpressionTreeNode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ExpressionTreeNode getLeft() {
            return this.left;
        }

        public void setLeft(ExpressionTreeNode left) {
            this.left = left;
        }

        public ExpressionTreeNode getRight() {
            return this.right;
        }

        public void setRight(ExpressionTreeNode right) {
            this.right = right;
        }
    }
}

