/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.tdc.tdcs.common.bo.NodeBo;
import kd.tdc.tdcs.common.bo.TreeNodeBo;
import kd.tdc.tdcs.common.util.CommUtils;

public class TreeViewHelper {
    private ITreeModel treeModel;
    private List<NodeBo> bolist;
    private Map<String, List<NodeBo>> fartherNodeListMap;
    private TreeNode root;

    public TreeViewHelper(ITreeModel treeModel, List<NodeBo> bolist, Map<String, List<NodeBo>> fartherNodeListMap) {
        this.treeModel = treeModel;
        this.bolist = bolist;
        this.fartherNodeListMap = fartherNodeListMap;
    }

    public TreeViewHelper(TreeNode root, List<NodeBo> bolist, Map<String, List<NodeBo>> fartherNodeListMap) {
        this.bolist = bolist;
        this.fartherNodeListMap = fartherNodeListMap;
        this.root = root;
    }

    public TreeNode initTreeView() {
        TreeNode treeRoot = this.treeModel.getRoot();
        if (treeRoot == null || treeRoot.getId() == null) {
            treeRoot = this.treeModel.createRootNode();
        }
        if (treeRoot.getChildren().size() > 0) {
            List<String> childIdFromTreeNode = CommUtils.getChildIdFromTreeNode(treeRoot);
            for (String treeId : childIdFromTreeNode) {
                treeRoot.deleteChildNode(treeId);
            }
        }
        this.root = treeRoot;
        this.doInitTreeView();
        this.treeModel.setRoot(this.root);
        this.treeModel.setRootVisable(true);
        this.treeModel.setCurrentNodeId((Object)this.root.getId());
        return this.root;
    }

    public TreeNode doInitTreeView() {
        List<TreeNodeBo> listTreeNodeBo = this.getTreeNodeBos();
        if (listTreeNodeBo.size() > 0) {
            this.treeviewLoad(listTreeNodeBo);
        }
        return this.root;
    }

    public List<TreeNodeBo> getTreeNodeBos() {
        ArrayList<TreeNodeBo> listTreeNodeBo = new ArrayList<TreeNodeBo>(this.bolist.size());
        for (NodeBo nodeBo : this.bolist) {
            TreeNodeBo rootBo = new TreeNodeBo(nodeBo.getParentId(), nodeBo.getParentName(), false);
            this.constructTree(rootBo, nodeBo.getParentId());
            listTreeNodeBo.add(rootBo);
        }
        return listTreeNodeBo;
    }

    private void constructTree(TreeNodeBo parentBo, String parentId) {
        if (parentId == null || this.fartherNodeListMap.get(parentId) == null) {
            return;
        }
        List<NodeBo> nodeBoList = this.fartherNodeListMap.get(parentId);
        for (NodeBo nodeBo : nodeBoList) {
            TreeNodeBo treeNodeBo = new TreeNodeBo(nodeBo.getId(), nodeBo.getName(), false);
            parentBo.setTreeNodeBoList(treeNodeBo);
            this.constructTree(treeNodeBo, nodeBo.getId());
        }
    }

    private void treeviewLoad(List<TreeNodeBo> listTreeNodeBo) {
        this.root.setIsOpened(true);
        for (TreeNodeBo bo : listTreeNodeBo) {
            TreeNode treeNode = new TreeNode(this.root.getId(), bo.getId(), bo.getName(), false);
            this.root.addChild(treeNode);
            treeNode.setIsOpened(true);
            this.setTreeNode(treeNode, bo, bo.getId());
        }
    }

    private void setTreeNode(TreeNode fatherNode, TreeNodeBo bo, String id) {
        if (bo.getTreeNodeBoList() == null || bo.getTreeNodeBoList().size() == 0) {
            return;
        }
        for (TreeNodeBo treeNodeBo : bo.getTreeNodeBoList()) {
            if (Objects.equals(treeNodeBo.getId(), id)) continue;
            TreeNode tn = new TreeNode(fatherNode.getId(), treeNodeBo.getId(), treeNodeBo.getName(), treeNodeBo.isParent());
            fatherNode.addChild(tn);
            this.setTreeNode(tn, treeNodeBo, id);
        }
    }
}

