/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.enums.common;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.hr.hbp.common.util.HRStringUtils;

public enum StatusStyleEnum {
    UNDERWAY("#276FF5", "#F2F9FF", "#85B8FF"),
    COMPLETE("#1BA854", "#F2FFF5", "#6DD18E"),
    WARN("#FF991C", "#FFFBF2", "#FFCB78"),
    DANGER("#FB2323", "#FFF2F4", "#FF8088"),
    INVALID("#666666", "#F5F5F5", "#CCCCCC");

    private final String fc;
    private final String bc;
    private final String borderColor;

    private StatusStyleEnum(String fc, String bc, String borderColor) {
        this.fc = fc;
        this.bc = bc;
        this.borderColor = borderColor;
    }

    public String getFc() {
        return this.fc;
    }

    public String getBc() {
        return this.bc;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public static Map<String, Object> buildStyleMap(StatusStyleEnum styleEnum, int borderWidth, String borderLine) {
        HashMap customStyles = Maps.newHashMap();
        HashMap style = new HashMap();
        HashMap<String, String> borderMap = new HashMap<String, String>();
        customStyles.put("fc", styleEnum.getFc());
        customStyles.put("bc", styleEnum.getBc());
        style.put("b", borderMap);
        if (HRStringUtils.isEmpty((String)borderLine)) {
            borderLine = "solid";
        }
        String solidColor = borderWidth + "px_" + borderLine + "_" + styleEnum.getBorderColor();
        borderMap.put("b", solidColor);
        borderMap.put("l", solidColor);
        borderMap.put("t", solidColor);
        borderMap.put("r", solidColor);
        customStyles.put("s", style);
        return customStyles;
    }
}

