/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.certgroup.service.CertGroupDomainService;

public class CertGroupApplicationService {
    private final CertGroupDomainService certGroupDomainService = ServiceFactory.getService(CertGroupDomainService.class);

    public int getCertGroupSize(Long pkId) {
        return this.certGroupDomainService.getCertGroupSize(pkId);
    }

    public Map<Long, Integer> getCertGroupSizes(List<Long> ids) {
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>(8);
        DynamicObject[] certGroupSizes = this.certGroupDomainService.getCertGroupSizes(ids);
        if (certGroupSizes == null || certGroupSizes.length == 0) {
            return resultMap;
        }
        Map<Long, List<DynamicObject>> map = Arrays.stream(certGroupSizes).collect(Collectors.groupingBy(k -> k.getDynamicObject("commorg").getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().size());
        }
        return resultMap;
    }

    public void quit(Long employeeId, List<Long> quitCommOrgUserBoIds) {
        this.certGroupDomainService.quit(employeeId, quitCommOrgUserBoIds);
    }

    public DynamicObject[] queryByPersonId(String selectProperties, Long personId) {
        return this.certGroupDomainService.queryByPersonId(selectProperties, personId);
    }

    public void updateCerGroupEntryUserNameByPersonId(String afterName, Long afterPersonId) {
        this.updateCerGroupEntryUserByPersonId("membername", afterName, afterPersonId);
    }

    public void updateCerGroupEntryUserNumberByPersonId(String afterNumber, Long afterPersonId) {
        this.updateCerGroupEntryUserByPersonId("membernumber", afterNumber, afterPersonId);
    }

    private void updateCerGroupEntryUserByPersonId(String field, String afterValue, Long afterPersonId) {
        DynamicObject[] cerGroups;
        QFilter personQFilter = new QFilter("person.person.id", "=", (Object)afterPersonId);
        QFilter userNameQFilter = new QFilter(field, "!=", (Object)afterValue);
        DynamicObject[] memberEntries = this.certGroupDomainService.queryCertGroupEntry("boid", new QFilter[]{personQFilter, userNameQFilter});
        if (memberEntries == null || memberEntries.length == 0) {
            return;
        }
        List cerGroupList = Arrays.stream(memberEntries).map(row -> row.getLong("boid")).distinct().collect(Collectors.toList());
        String selectProperties = String.join((CharSequence)",", "certcentry.person", "certcentry.membername", "certcentry.membernumber");
        QFilter idQFilter = new QFilter("id", "in", cerGroupList);
        for (DynamicObject cerGroup : cerGroups = this.certGroupDomainService.queryCerGroup(selectProperties, new QFilter[]{idQFilter})) {
            DynamicObjectCollection memberEntry = cerGroup.getDynamicObjectCollection("certcentry");
            memberEntry.stream().filter(row -> row.getLong("person.person.id") == afterPersonId.longValue()).forEach(row -> row.set(field, (Object)afterValue));
        }
        this.certGroupDomainService.saveCerGroup(cerGroups);
    }
}

