/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CommUserApplicationService;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;
import kd.tdc.tdcs.bussiness.domain.certgroup.service.CertGroupDomainService;
import kd.tdc.tdcs.bussiness.domain.commorg.entityservice.CommOrgFrameService;
import kd.tdc.tdcs.bussiness.domain.commorg.service.CommOrgDomainService;
import kd.tdc.tdcs.bussiness.domain.commorguser.enums.CommUserStatusEnum;
import kd.tdc.tdcs.bussiness.domain.commorguser.service.CommOrgUserDomainService;
import kd.tdc.tdcs.common.util.CommUtils;
import kd.tdc.tdcs.common.util.CommonUtils;

public class CommOrgApplicationService {
    private static final String END_DATE = "enddate";
    private final CertGroupDomainService certGroupDomainService = ServiceFactory.getService(CertGroupDomainService.class);
    private final CommOrgUserDomainService commOrgUserDomainService = ServiceFactory.getService(CommOrgUserDomainService.class);
    private final CommOrgDomainService commOrgDomainService = ServiceFactory.getService(CommOrgDomainService.class);
    private final CommOrgFrameService commOrgFrameService = ServiceFactory.getService(CommOrgFrameService.class);
    private final ExternalService externalService = ServiceFactory.getService(ExternalService.class);

    public DynamicObject getCommOrgDO(Long orgId) {
        return this.commOrgDomainService.queryOne(orgId);
    }

    public DynamicObjectCollection getCertificationGroupMember(Long certGroupId) {
        DynamicObject cert;
        if (certGroupId != null && !certGroupId.equals(0L) && !HRObjectUtils.isEmpty((Object)(cert = this.certGroupDomainService.queryOne(certGroupId)))) {
            return cert.getDynamicObjectCollection("certcentry");
        }
        return new DynamicObjectCollection();
    }

    public DynamicObject queryOneCertificationGroup(Long certGroupId) {
        return this.certGroupDomainService.queryOne(certGroupId);
    }

    public DynamicObject queryOneCommOrg(Long pkId) {
        return this.commOrgDomainService.queryOne(pkId);
    }

    public int getCommOrgSize(Long id) {
        int resultCount = 0;
        DynamicObject[] commOrgObjs = this.commOrgDomainService.queryCommOrgObjs(id);
        if (commOrgObjs == null || commOrgObjs.length == 0) {
            return resultCount;
        }
        Set commOrgIdSet = Arrays.stream(commOrgObjs).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        block0: for (DynamicObject commOrgObj : commOrgObjs) {
            DynamicObjectCollection parentCommObjs = commOrgObj.getDynamicObjectCollection("parentcomm");
            if (HRCollUtil.isEmpty((Collection)parentCommObjs)) {
                ++resultCount;
                continue;
            }
            for (DynamicObject parentCommObj : parentCommObjs) {
                Long fbasedataid = parentCommObj.getLong("fbasedataid_id");
                if (!commOrgIdSet.contains(fbasedataid)) continue;
                ++resultCount;
                continue block0;
            }
        }
        return resultCount;
    }

    public void update(DynamicObject dynamicObject) {
        this.commOrgFrameService.update(dynamicObject);
    }

    public List<Long> getCertGroupUserById(Long certGroupId) {
        DynamicObject[] orgUsers;
        if (certGroupId == 0L) {
            return new ArrayList<Long>();
        }
        DynamicObjectCollection members = this.certGroupDomainService.queryCertMember(certGroupId);
        if (members.size() == 0) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> result = new ArrayList<Long>(members.size());
        ArrayList<Long> employeeList = new ArrayList<Long>();
        ArrayList<Long> ctteeperList = new ArrayList<Long>();
        for (DynamicObject[] member : members) {
            if (member.getLong("ctteeper.id") == 0L) {
                employeeList.add(member.getLong("person.id"));
                continue;
            }
            ctteeperList.add(member.getLong("ctteeper.id"));
        }
        for (DynamicObject orgUser : orgUsers = this.commOrgUserDomainService.queryOriginalArray("isemp,person,bosuser", new QFilter[]{new QFilter("id", "in", ctteeperList)})) {
            if ("1".equals(orgUser.getString("isemp"))) {
                employeeList.add(orgUser.getLong("person"));
                continue;
            }
            result.add(orgUser.getLong("bosuser"));
        }
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("employee", employeeList);
        Map<Long, Object> dataResult = this.externalService.queryBosUserBy(params);
        if (dataResult == null) {
            return result;
        }
        for (Object values : dataResult.values()) {
            result.add((Long)((Map)values).get("user"));
        }
        return result;
    }

    public List<Map<String, Object>> getCertGroupRoleMember(Long certGroupId) {
        DynamicObject cert;
        ArrayList<Map<String, Object>> roleMember = new ArrayList<Map<String, Object>>();
        if (certGroupId != null && !certGroupId.equals(0L) && !HRObjectUtils.isEmpty((Object)(cert = this.certGroupDomainService.queryOne(certGroupId)))) {
            DynamicObjectCollection members = cert.getDynamicObjectCollection("certcentry");
            ArrayList<String> roleIds = new ArrayList<String>();
            for (DynamicObject member : members) {
                DynamicObjectCollection roleCollection = member.getDynamicObjectCollection("certmbrrole");
                this.setRoleMember(roleIds, roleMember, member, roleCollection);
            }
        }
        return roleMember;
    }

    private void setRoleMember(List<String> roleIds, List<Map<String, Object>> roleMember, DynamicObject member, DynamicObjectCollection roleCollection) {
        for (DynamicObject role : roleCollection) {
            ArrayList<Map<String, Object>> userMaps;
            int index = roleIds.indexOf(role.getString("fbasedataid.id"));
            if (index != -1) {
                Map<String, Object> roleMap = roleMember.get(index);
                userMaps = CommonUtils.castListMap((Object)roleMap.get("user"), String.class);
                this.buildUserMap(member, (List<Map<String, Object>>)userMaps);
                roleMap.put("user", userMaps);
                roleMember.set(index, roleMap);
                continue;
            }
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", role.getString("fbasedataid.id"));
            map.put("name", role.getString("fbasedataid.name"));
            map.put("number", role.getString("fbasedataid.number"));
            userMaps = new ArrayList<Map<String, Object>>();
            this.buildUserMap(member, userMaps);
            map.put("user", userMaps);
            roleMember.add(map);
            roleIds.add(role.getString("fbasedataid.id"));
        }
    }

    private void buildUserMap(DynamicObject member, List<Map<String, Object>> userMaps) {
        HashMap<String, Object> user = new HashMap<String, Object>(16);
        user.put("source", member.getString("source"));
        user.put("person", member.getLong("person.id"));
        user.put("ctteeper", member.getLong("ctteeper.id"));
        userMaps.add(user);
    }

    public Map<String, List<Long>> getCommOrgMember(Long commOrgId) {
        QFilter hisVersionFilter;
        QFilter commOrgIdFilter;
        QFilter[] filters;
        DynamicObject[] commOrgUserObjArr;
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>(16);
        if (commOrgId != null && !commOrgId.equals(0L) && (commOrgUserObjArr = this.commOrgUserDomainService.query("id,isemp", filters = new QFilter[]{commOrgIdFilter = new QFilter("comm", "=", (Object)commOrgId), hisVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1")})) != null && commOrgUserObjArr.length != 0) {
            for (DynamicObject object : commOrgUserObjArr) {
                String isEmp = object.getString("isemp");
                if ("0".equals(isEmp)) {
                    CommUtils.setListMap((String)"noEMp", (Long)object.getLong("id"), resultMap);
                    continue;
                }
                if (!"1".equals(isEmp)) continue;
                CommUtils.setListMap((String)"emp", (Long)object.getLong("id"), resultMap);
            }
        }
        return resultMap;
    }

    public DynamicObject[] queryParentCommOrgJobData(List<Long> parentCommIdList) {
        return this.commOrgDomainService.queryParentCommOrgJobData(parentCommIdList);
    }

    public DynamicObject[] queryCommOrgDataByPkId(String selectProperties, List<Long> ids) {
        return this.commOrgDomainService.queryCommOrgDataByPkId(selectProperties, ids);
    }

    public DynamicObject[] queryCommFramJobData(Set<Long> commFrameIdSet) {
        return this.commOrgDomainService.queryCommFramJobData(commFrameIdSet);
    }

    public DynamicObject[] queryAllCommFrame(String bizObjName) {
        return this.commOrgDomainService.queryAllCommFrame(bizObjName);
    }

    public DynamicObject queryOneCommFrame(Long frameId) {
        return this.commOrgDomainService.queryOneCommFrame(frameId);
    }

    public DynamicObject[] getCommFrameById(Object id) {
        return this.commOrgFrameService.getCommFrameById(id);
    }

    public void updateCommOrgSize(Long pkId, DynamicObject dynamicObject) {
        int count = this.getCommOrgSize(pkId);
        dynamicObject.set("total", (Object)count);
        this.update(dynamicObject);
    }

    public int getCommOrgUserSize(Long id) {
        return this.commOrgUserDomainService.getCommOrgUserSize(id);
    }

    public Map<Long, Integer> getCommOrgUserSizes(List<Long> ids) {
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>(8);
        DynamicObject[] commOrgUserSizes = this.commOrgUserDomainService.getCommOrgUserSizes(ids);
        if (commOrgUserSizes == null || commOrgUserSizes.length == 0) {
            return resultMap;
        }
        Map<Long, List<DynamicObject>> map = Arrays.stream(commOrgUserSizes).collect(Collectors.groupingBy(k -> k.getLong("comm")));
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().size());
        }
        return resultMap;
    }

    public List<Map<String, Object>> getPersonCommWorkRecord(Long personId) {
        DynamicObject[] dynamicObjects;
        ArrayList<Map<String, Object>> allRecord = new ArrayList<Map<String, Object>>(8);
        if (personId == null || personId == 0L) {
            return allRecord;
        }
        for (DynamicObject recordObj : dynamicObjects = this.commOrgUserDomainService.getPersonCommWorkRecord(personId)) {
            HashMap<String, Object> recordMap = new HashMap<String, Object>(8);
            recordMap.put("userStatus", recordObj.getString("userstatus"));
            if (recordObj.getDynamicObject("comm") != null) {
                String commId = recordObj.getDynamicObject("comm").getString("id");
                String commName = recordObj.getDynamicObject("comm").getString("name");
                recordMap.put("commId", commId);
                recordMap.put("commName", commName);
            }
            DynamicObjectCollection roleObjList = recordObj.getDynamicObjectCollection("roleentry");
            ArrayList roleMapList = new ArrayList(4);
            for (DynamicObject roleObj : roleObjList) {
                HashMap<String, Object> roleMap = new HashMap<String, Object>(4);
                String roleName = roleObj.getDynamicObject("commrole").getString("name");
                Date effDate = roleObj.getDate("roleeffectdate");
                Date expireDate = roleObj.getDate("roleexpiredate");
                roleMap.put("roleName", roleName);
                roleMap.put("effectDate", effDate);
                roleMap.put("expireDate", expireDate);
                roleMapList.add(roleMap);
            }
            recordMap.put("roleEntry", roleMapList);
            allRecord.add(recordMap);
        }
        return allRecord;
    }

    public DynamicObject[] getNeedEffectCommUser(Date effectDate) {
        return this.commOrgUserDomainService.getNeedEffectCommUser(effectDate);
    }

    public DynamicObject[] getNeedExpireCommUser(Date expireDate) {
        return this.commOrgUserDomainService.getNeedExpireCommUser(expireDate);
    }

    public void commUserStatusExit(Date currentDate, DynamicObject[] commUsers) {
        ArrayList<DynamicObject> needExpireCommUserList = new ArrayList<DynamicObject>(commUsers.length);
        ArrayList<HisVersionParamBo> hisVersionParamList = new ArrayList<HisVersionParamBo>(commUsers.length);
        for (DynamicObject needExpireCommUser : commUsers) {
            this.dealHasExpireUser(needExpireCommUser, currentDate, needExpireCommUserList, hisVersionParamList);
        }
        if (CollectionUtils.isEmpty(hisVersionParamList)) {
            return;
        }
        HashMap<Long, List<Long>> certmemberMap = new HashMap<Long, List<Long>>(commUsers.length);
        for (DynamicObject certmembers : needExpireCommUserList) {
            Long commId = certmembers.getDynamicObject("comm").getLong("id");
            Long certMemberId = certmembers.getLong("boid");
            if (certmemberMap.get(commId) == null) {
                certmemberMap.put(commId, Lists.newArrayList((Object[])new Long[]{certMemberId}));
                continue;
            }
            ((List)certmemberMap.get(commId)).add(certMemberId);
        }
        this.commOrgUserDomainService.saveComUserHisVersion(hisVersionParamList, "tdcs_commorguser");
        this.certGroupDomainService.quit(certmemberMap);
    }

    private void dealHasExpireUser(DynamicObject userObj, Date currentDate, List<DynamicObject> commMembers, List<HisVersionParamBo> hisVersionParamList) {
        Date quitDate = userObj.getDate("quitdate");
        DynamicObjectCollection roleCollection = userObj.getDynamicObjectCollection("roleentry");
        if (quitDate != null && quitDate.compareTo(currentDate) <= 0) {
            hisVersionParamList.add(this.setCommUserHisBo(userObj, currentDate, quitDate));
            for (DynamicObject roleObj : roleCollection) {
                Date roleExpireDate = roleObj.getDate("roleexpiredate");
                if (roleExpireDate != null && roleExpireDate.compareTo(currentDate) <= 0) continue;
                roleObj.set("roleexpiredate", (Object)quitDate);
            }
            commMembers.add(userObj);
            return;
        }
        List sortedRoleObjs = roleCollection.stream().filter(r -> r.getDate("roleexpiredate") != null).sorted(Comparator.comparing(r -> r.getDate("roleexpiredate"))).collect(Collectors.toList());
        if (sortedRoleObjs.size() > 0) {
            Date maxExpireDate = ((DynamicObject)sortedRoleObjs.get(sortedRoleObjs.size() - 1)).getDate("roleexpiredate");
            if (sortedRoleObjs.size() == roleCollection.size() && maxExpireDate.compareTo(currentDate) <= 0) {
                hisVersionParamList.add(this.setCommUserHisBo(userObj, currentDate, maxExpireDate));
                commMembers.add(userObj);
            }
        }
    }

    public HisVersionParamBo setCommUserHisBo(DynamicObject userObj, Date currentDate, Date quitDate) {
        HisVersionParamBo bo = new HisVersionParamBo();
        userObj.set("userstatus", (Object)CommUserStatusEnum.EXIT.getNumber());
        userObj.set("quitdate", (Object)quitDate);
        userObj.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
        userObj.set("brled", (Object)currentDate);
        userObj.set("modifytime", (Object)currentDate);
        userObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        bo.setEntityNumber("tdcs_commorguser");
        bo.setHisDyns(new DynamicObject[]{userObj});
        return bo;
    }

    public List<Long> quit(Long employeeId) {
        Map empMap;
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(8);
        ArrayList idList = Lists.newArrayList((Object[])new Long[]{employeeId});
        idMaps.put("employee", idList);
        Map<Long, Object> bosUserMap = this.externalService.queryBosUserBy(idMaps);
        Long bosUserId = 0L;
        if (!CollectionUtils.isEmpty(bosUserMap) && !CollectionUtils.isEmpty((Map)(empMap = (Map)bosUserMap.get(employeeId)))) {
            bosUserId = (Long)empMap.get("user");
        }
        Map<String, Object> empentrel = this.externalService.getEmpentrel(employeeId);
        Date quitDate = new Date();
        if (empentrel != null && empentrel.get(END_DATE) != null) {
            quitDate = (Date)empentrel.get(END_DATE);
        }
        return this.commOrgUserDomainService.quit(employeeId, bosUserId, quitDate);
    }

    public DynamicObject[] queryCertMemberByPersonId(String selectProperties, Long personId) {
        CommUserApplicationService commUserApplicationService = new CommUserApplicationService();
        DynamicObject[] commOrgUserArr = commUserApplicationService.queryByPersonId("id", personId);
        List<Long> commOrgUserIds = Arrays.stream(commOrgUserArr).map(p -> p.getLong("id")).collect(Collectors.toList());
        DynamicObject[] certMembers = this.certGroupDomainService.queryByCtteeperId(selectProperties, commOrgUserIds);
        return certMembers;
    }

    public DynamicObject[] queryCerGroupByAnyFilter(String selectProperties, List<QFilter> filters) {
        return this.certGroupDomainService.queryCerGroupByAnyFilter(selectProperties, filters);
    }
}

