/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.CertGroupApplicationService;
import kd.tdc.tdcs.bussiness.application.CommOrgApplicationService;
import kd.tdc.tdcs.bussiness.domain.commorguser.service.CommOrgUserDomainService;

public class CommUserApplicationService {
    private final CommOrgApplicationService commOrgApplicationService = new CommOrgApplicationService();
    private final CertGroupApplicationService certGroupApplicationService = ServiceFactory.getServiceNoNeedRegister(CertGroupApplicationService.class);
    private final CommOrgUserDomainService commOrgUserService = ServiceFactory.getService(CommOrgUserDomainService.class);
    private static final Log logger = LogFactory.getLog(CommUserApplicationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit(Long employeeId) {
        try (TXHandle txhandle = TX.required();){
            List<Long> quitCommOrgUserBoIds = this.commOrgApplicationService.quit(employeeId);
            this.certGroupApplicationService.quit(employeeId, quitCommOrgUserBoIds);
        }
    }

    public List<Map<String, Object>> queryCommUserWorkExpByEmployeeIdAndEffectDate(Long employeeId, Date startEffectDate, Date endEffectDate) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(8);
        DynamicObject[] dynamicObjects = this.commOrgUserService.queryCommUserWorkExpByEmployeeIdAndEffectDate(employeeId, startEffectDate, endEffectDate);
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return resultList;
        }
        for (DynamicObject resutObj : dynamicObjects) {
            DynamicObjectCollection roleEntry = resutObj.getDynamicObjectCollection("roleentry");
            if (!HRCollUtil.isNotEmpty((Collection)roleEntry)) continue;
            for (DynamicObject roleObj : roleEntry) {
                Date roleeffectdate = roleObj.getDate("roleeffectdate");
                if (!startEffectDate.before(roleeffectdate) || !endEffectDate.after(roleeffectdate)) continue;
                HashMap<String, Object> objMap = new HashMap<String, Object>(8);
                objMap.put("commOrgId", resutObj.getLong("comm_id"));
                objMap.put("commOrgName", resutObj.getString("comm.name"));
                objMap.put("roleId", roleObj.getLong("commrole.id"));
                objMap.put("roleName", roleObj.getString("commrole.name"));
                objMap.put("effectDate", roleeffectdate);
                objMap.put("expireDate", roleObj.getDate("roleexpiredate"));
                objMap.put("userstatus", resutObj.getString("userstatus"));
                resultList.add(objMap);
            }
        }
        return resultList;
    }

    public void updateNumberByPersonId(String number, Long personId) {
        this.commOrgUserService.updateNumberByPersonId(number, personId);
    }

    public void updateNameByPersonId(String name, Long personId) {
        this.commOrgUserService.updateNameByPersonId(name, personId);
    }

    public DynamicObject[] queryByPersonId(String selectProperties, Long personId) {
        return this.commOrgUserService.queryByPersonId(selectProperties, personId);
    }
}

