/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.domain.fieldmap.FieldMapDomainService;

public class FieldMapMangerApplicationService {
    private static final FieldMapMangerApplicationService FIELD_MAP_MANGER_APPLICATION_SERVICE = new FieldMapMangerApplicationService();
    private static final Log LOGGER = LogFactory.getLog(FieldMapMangerApplicationService.class);

    public static FieldMapMangerApplicationService getInstance() {
        return FIELD_MAP_MANGER_APPLICATION_SERVICE;
    }

    public void copyByFieldMap(DynamicObject source, DynamicObject target, long fieldMapId) {
        String entitySource = source.getDynamicObjectType().getName();
        String entityTarget = target.getDynamicObjectType().getName();
        DynamicObjectCollection fieldMapCollection = this.getFieldCollectionByFieldMap(entitySource, entityTarget, fieldMapId);
        this.mapByFieldMap(source, target, fieldMapCollection, entitySource, entityTarget);
    }

    public void copyByFieldMap(DynamicObject source, DynamicObject target, DynamicObjectCollection fieldMapCollection) {
        String entitySource = source.getDynamicObjectType().getName();
        String entityTarget = target.getDynamicObjectType().getName();
        this.mapByFieldMap(source, target, fieldMapCollection, entitySource, entityTarget);
    }

    private void mapByFieldMap(DynamicObject source, DynamicObject target, DynamicObjectCollection fieldMapCollection, String entitySource, String entityTarget) {
        DataEntityPropertyCollection propertiesSource = source.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection propertiesTarget = target.getDynamicObjectType().getProperties();
        fieldMapCollection.forEach(map -> {
            String sourceField = map.getString("sourcefield");
            String targetField = map.getString("targetfield");
            if (propertiesSource.get((Object)sourceField) == null || propertiesTarget.get((Object)targetField) == null) {
                LOGGER.error("copyByFieldMap.sourceField-or-targetField-not-existed,entitySource:{},sourceField:{},entityTarget:{},targetField:{}", new Object[]{entitySource, sourceField, entityTarget, targetField});
                return;
            }
            target.set(targetField, source.get(sourceField));
        });
    }

    public DynamicObjectCollection getFieldCollectionByFieldMap(String entitySource, String entityTarget, long fieldMapId) {
        QFilter qFilter = new QFilter("id", "=", (Object)fieldMapId);
        DynamicObject fieldMap = FieldMapDomainService.queryOne("", new QFilter[]{qFilter});
        if (HRObjectUtils.isEmpty((Object)fieldMap)) {
            LOGGER.warn("copyByFieldMap.fieldMap_is_empty");
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection tableCollection = fieldMap.getDynamicObjectCollection("entryentity");
        DynamicObject tableMap = tableCollection.stream().filter(row -> HRStringUtils.equals((String)entitySource, (String)row.getString("sourceentity.number")) && HRStringUtils.equals((String)entityTarget, (String)row.getString("targetentity.number"))).findFirst().orElse(null);
        if (tableMap == null) {
            LOGGER.warn("copyByFieldMap.tableMap_is_empty");
            return new DynamicObjectCollection();
        }
        return tableMap.getDynamicObjectCollection("subentryentity");
    }
}

