/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.domain.talentpool.pool.TalentPoolDomainService;
import kd.tdc.tdcs.bussiness.domain.talentpool.reservetalent.ReserveTalentDomainService;
import kd.tdc.tdcs.bussiness.queryhelper.TalentPoolQueryHelper;

public class TalentPoolApplicationService {
    private static final Log LOG = LogFactory.getLog(TalentPoolApplicationService.class);
    private static final ReserveTalentDomainService RESERVE_TALENT_SERVICE = ServiceFactory.getService(ReserveTalentDomainService.class);
    private static final TalentPoolDomainService TALENT_POOL_SERVICE = ServiceFactory.getService(TalentPoolDomainService.class);

    public void refreshInPoolTime() {
        RESERVE_TALENT_SERVICE.refreshInPoolTime();
    }

    public void generateReserveTalentColl(DynamicObject[] entryPoolBillColl) {
        RESERVE_TALENT_SERVICE.generateReserveTalentColl(entryPoolBillColl);
    }

    public void updateReserveTalentColl(DynamicObject[] exitPoolBillColl) {
        RESERVE_TALENT_SERVICE.updateReserveTalentColl(exitPoolBillColl);
    }

    public static FormShowParameter buildPersonInfoFSP(String targetKey, long empId, long perId, String pageId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setTargetKey(targetKey);
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.setStatus(OperationStatus.VIEW);
        fsp.setFormId("tdcs_talentpoolpersoninfo");
        fsp.setCustomParam("employee", (Object)empId);
        fsp.setCustomParam("person", (Object)perId);
        fsp.setCustomParam("pageId", (Object)pageId);
        return fsp;
    }

    public static FormShowParameter buildTalentPoolInfoFSP(String targetKey, Object poolId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setTargetKey(targetKey);
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.setStatus(OperationStatus.VIEW);
        fsp.setFormId("tdcs_talentpoolbaseinfo");
        fsp.setCustomParam("talentpool", poolId);
        return fsp;
    }

    public static FormShowParameter buildInPoolInfoFSP(String targetKey, Map<String, Object> customMap) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setTargetKey(targetKey);
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.setStatus(OperationStatus.VIEW);
        fsp.setFormId("tdcs_inpoolinfo");
        fsp.setCustomParams(customMap);
        return fsp;
    }

    public static FormShowParameter buildOutPoolInfoFSP(String targetKey, Map<String, Object> customMap) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setTargetKey(targetKey);
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.setStatus(OperationStatus.VIEW);
        fsp.setFormId("tdcs_outpoolinfo");
        fsp.setCustomParams(customMap);
        return fsp;
    }

    public static FormShowParameter buildRecommendInfoFSP(String targetKey, Map<String, Object> customMap) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setTargetKey(targetKey);
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.setStatus(OperationStatus.VIEW);
        fsp.setFormId("tdcs_recommendinfo");
        fsp.setCustomParams(customMap);
        return fsp;
    }

    public void checkAndAddInPoolNum(long poolId) {
        int inPoolTalentNum = TalentPoolQueryHelper.countInPoolTalentByPoolId(poolId);
        TALENT_POOL_SERVICE.checkAndAddInPoolNum(poolId, inPoolTalentNum);
    }

    public void batchAddInPoolNum(Map<Long, List<DynamicObject>> poolSubtractNumMap) {
        TALENT_POOL_SERVICE.batchAddInPoolNum(poolSubtractNumMap);
    }

    public void checkAndSubtractInPoolNum(long poolId) {
        int inPoolTalentNum = TalentPoolQueryHelper.countInPoolTalentByPoolId(poolId);
        TALENT_POOL_SERVICE.checkAndSubtractInPoolNum(poolId, inPoolTalentNum);
    }

    public void batchSubtractInPoolNum(Map<Long, List<DynamicObject>> poolSubtractNumMap) {
        TALENT_POOL_SERVICE.batchSubtractInPoolNum(poolSubtractNumMap);
    }

    public void updateReserveTalentNameByPersonId(String name, Long personId) {
        RESERVE_TALENT_SERVICE.updateReserveTalentNameByPersonId(name, personId);
    }

    public void updateReserveTalentNumberByPersonId(String number, Long personId) {
        RESERVE_TALENT_SERVICE.updateReserveTalentNumberByPersonId(number, personId);
    }

    public void leaveExitPool(Long employee, String billNo) {
        DynamicObject[] dys = RESERVE_TALENT_SERVICE.queryInPoolTalentByEmp(employee);
        if (dys == null || dys.length < 1) {
            LOG.info("TalentPoolApplicationService.leaveExitPool execute info : dys is null");
            return;
        }
        LOG.info("TalentPoolApplicationService.leaveExitPool execute info : dys = {}", Arrays.stream(dys).map(item -> item.getLong("id")).collect(Collectors.toList()));
        RESERVE_TALENT_SERVICE.saveExitPoolInfo(dys, billNo);
        Map<Long, List<DynamicObject>> group = Arrays.stream(dys).collect(Collectors.groupingBy(e -> e.getLong("talentpool.id")));
        TALENT_POOL_SERVICE.batchSubtractInPoolNum(group);
    }

    public Map<Long, Map<String, Object>> queryRecommendInfoByIds(String selectField, List<Long> recommendIds) {
        return (Map)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"queryRecommendInfoByIds", (Object[])new Object[]{selectField, recommendIds});
    }

    public void savePoolDy(DynamicObject poolDy) {
        TALENT_POOL_SERVICE.save(poolDy);
    }
}

