/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.service.smartsearch.SearchSceneService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.enums.smartsearch.FilterFieldTypeEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchKeyLogicEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchModeEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchTargetTypeEnum;
import kd.hr.hbp.common.model.smartsearch.scene.SearchCustomFilterBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFieldBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchFilterBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchRangFieldBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchRangeBo;
import kd.hr.hbp.common.model.smartsearch.scene.SearchSceneBo;
import kd.hr.hbp.common.model.smartsearch.search.LabelValCompResp;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchData;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchResp;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchRowData;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tdc.tdcs.search.ITalentSearchExtendService;
import kd.tdc.tdcs.bussiness.application.CommCfgParamApplicationService;
import kd.tdc.tdcs.bussiness.application.PermissionApplicationService;
import kd.tdc.tdcs.bussiness.application.TalentFileApplicationService;
import kd.tdc.tdcs.bussiness.application.external.ExtSearchService;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.bussiness.domain.talentfile.TalentFileDomainService;
import kd.tdc.tdcs.bussiness.domain.talentsearch.MyAttentionDomainService;
import kd.tdc.tdcs.bussiness.domain.talentsearch.MyFilterSchemeDomainService;
import kd.tdc.tdcs.bussiness.queryhelper.SearchFilterSchemeQueryHelper;
import kd.tdc.tdcs.bussiness.search.SearchBuryPointService;
import kd.tdc.tdcs.common.bo.talentsearch.FilterConditionVo;
import kd.tdc.tdcs.common.bo.talentsearch.FilterOptionVo;
import kd.tdc.tdcs.common.bo.talentsearch.SearchPage;
import kd.tdc.tdcs.common.bo.talentsearch.SearchRangeFiledVo;
import kd.tdc.tdcs.common.bo.talentsearch.SearchRangeVo;
import kd.tdc.tdcs.common.bo.talentsearch.SearchResultTableHead;
import kd.tdc.tdcs.common.bo.talentsearch.SearchResultVO;
import kd.tdc.tdcs.common.bo.talentsearch.SearchSceneVo;
import kd.tdc.tdcs.common.constants.talentsearch.TalentSearchConstants;
import kd.tdc.tdcs.enums.talentsearch.TableSizeEnum;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TalentSearchApplicationService {
    private static final Log logger = LogFactory.getLog(TalentSearchApplicationService.class);
    private static final String SCENE_NUMBER = "sceneNumber";
    private static final String LABEL = "label";
    private HrpiService hrpiService = new HrpiService();
    private TalentFileApplicationService talentFileApplicationService = new TalentFileApplicationService();
    private TalentFileDomainService talentFileDomainService = new TalentFileDomainService();
    private CommCfgParamApplicationService commCfgParamService = new CommCfgParamApplicationService();
    private final MyFilterSchemeDomainService filterSchemeDomainService = new MyFilterSchemeDomainService();
    private static final ExecutorService executor = ThreadPools.newExecutorService((String)"TDCS-TALENTSEARCH", (int)20);

    public String getEmployeeNameById(Long employeeId) {
        Map<String, Object> employee = this.hrpiService.getEmployee(employeeId);
        if (ObjectUtils.isNotEmpty(employee)) {
            return (String)employee.get("person");
        }
        return null;
    }

    public DynamicObject[] getAttention(List<Long> employeeList) {
        Long currentUserId = RequestContext.get().getCurrUserId();
        return MyAttentionDomainService.getAttention(employeeList, currentUserId);
    }

    public List<Map<String, Object>> getMyFilterSchemes(long sceneId) {
        return SearchFilterSchemeQueryHelper.getMyFilterSchemes(sceneId, RequestContext.get().getCurrUserId());
    }

    public Long saveScheme(Long schemeId, long sceneId, String sceneName, String schemeSelectedFilter) {
        return this.filterSchemeDomainService.saveFilerScheme(schemeId, sceneId, sceneName, schemeSelectedFilter, RequestContext.get().getCurrUserId());
    }

    public void deleteFilterScheme(long schemeId) {
        this.filterSchemeDomainService.deleteFilterScheme(schemeId);
    }

    public DynamicObject[] getAttentionByUserId(Long currentUserId) {
        return MyAttentionDomainService.getAttentionByUserId(currentUserId);
    }

    public DynamicObject getAttention(Long empId) {
        ArrayList<Long> employeeList = new ArrayList<Long>();
        employeeList.add(empId);
        DynamicObject[] attentions = this.getAttention(employeeList);
        if (attentions != null && attentions.length > 0) {
            return attentions[0];
        }
        return null;
    }

    public void attentionByEmpIds(AbstractFormPlugin plugin, List<Long> employeeList, String eventName) {
        IFormView view = plugin.getView();
        if (ObjectUtils.isEmpty(employeeList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5931\u53c2\u6570", (String)"TalentSearchApplicationService_6", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        Boolean needReason = this.commCfgParamService.getNeedReason();
        if (needReason.booleanValue()) {
            this.showAttentionReasonForm(plugin, employeeList, eventName);
        } else {
            this.attention(employeeList, null);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5173\u6ce8\u6210\u529f\u3002", (String)"TalentSearchAttentionSuccess", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
    }

    public void tableAttentionByEmpIds(AbstractFormPlugin plugin, String eventArgs, String eventName) {
        IFormView view = plugin.getView();
        Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        List employees = (List)eventParam.get("employeeids");
        List<Long> employeeList = employees.stream().map(item -> Long.valueOf(item)).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(employeeList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5931\u53c2\u6570", (String)"TalentSearchApplicationService_6", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        Boolean needReason = this.commCfgParamService.getNeedReason();
        if (needReason.booleanValue()) {
            this.showAttentionReasonFormWithCloseback(plugin, employeeList, eventArgs, eventName);
        } else {
            this.attention(employeeList, null);
            this.setSearchFowareData(view, eventName, eventArgs, employeeList);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5173\u6ce8\u6210\u529f\u3002", (String)"TalentSearchAttentionSuccess", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
    }

    public void setSearchFowareData(IFormView view, String eventName, String eventArgs, List<Long> employeeList) {
        SearchPage page = (SearchPage)JSON.parseObject((String)eventArgs, (TypeReference)new TypeReference<SearchPage<SearchResultVO>>(){}, (Feature[])new Feature[0]);
        Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        this.search((SearchPage<SearchResultVO>)page, eventParam, view);
        this.dealShowTable((SearchPage<SearchResultVO>)page);
        this.setTableAttenionFowareData(view, eventName, employeeList, (SearchPage<SearchResultVO>)page);
    }

    public void dealShowTable(SearchPage<SearchResultVO> page) {
        if ("0".equals(this.commCfgParamService.showSearchLine())) {
            List tableHead = ((SearchResultVO)page.getSmartSearchResp()).getTableHead();
            ArrayList tableHeadNew = new ArrayList();
            if (HRCollUtil.isNotEmpty((Collection)tableHead)) {
                tableHead.forEach(searchResultTableHead -> {
                    if (!"search".equals(searchResultTableHead.getCode())) {
                        tableHeadNew.add(searchResultTableHead);
                    }
                });
            }
            ((SearchResultVO)page.getSmartSearchResp()).setTableHead(tableHeadNew);
        }
    }

    public OperationResult attention(List<Long> employeeIds, DynamicObject sourceDynamicObject) {
        OperateOption operateOption = OperateOption.create();
        Long currentUserId = RequestContext.get().getCurrUserId();
        List<DynamicObject> myattentions = MyAttentionDomainService.getAttentionDynamicObjects(sourceDynamicObject, currentUserId, employeeIds);
        return OperationServiceHelper.executeOperate((String)"save", (String)"tdcs_myattention", (DynamicObject[])myattentions.toArray(new DynamicObject[0]), (OperateOption)operateOption);
    }

    public void showAttentionReasonForm(AbstractFormPlugin plugin, List<Long> employeeList, String eventName) {
        IFormView view = plugin.getView();
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>(8);
        params.put("customEmployeeIds", employeeList);
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("tdcs_myattention");
        billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCustomParams(params);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, eventName));
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void showAttentionReasonFormWithCloseback(AbstractFormPlugin plugin, List<Long> employeeList, String eventArgs, String eventName) {
        IFormView view = plugin.getView();
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("customEmployeeIds", employeeList);
        params.put("attentionEventArgs", eventArgs);
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("tdcs_myattention");
        billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCustomParams(params);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, eventName));
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void cancelAttention(IFormView view, List<Long> employeeList) {
        this.cancelAttentionOpera(employeeList);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u5173\u6ce8\u3002", (String)"TalentSearchAttentionCancel", (String)"tdc-tdcs-business", (Object[])new Object[0]));
    }

    public void cancelAttentionOpera(List<Long> employeeList) {
        if (ObjectUtils.isEmpty(employeeList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5931\u53c2\u6570", (String)"TalentSearchApplicationService_6", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        OperateOption operateOption = OperateOption.create();
        DynamicObject[] myattentions = this.getAttention(employeeList);
        if (myattentions != null && myattentions.length > 0) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"tdcs_myattention", (DynamicObject[])myattentions, (OperateOption)operateOption);
        }
    }

    public void tableCancelAttention(IFormView view, String eventArgs, String eventName) {
        Map eventParam = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        List employees = (List)eventParam.get("employeeids");
        List<Long> employeeList = employees.stream().map(item -> Long.valueOf(item)).collect(Collectors.toList());
        this.cancelAttentionOpera(employeeList);
        this.setSearchFowareData(view, eventName, eventArgs, employeeList);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u5173\u6ce8\u3002", (String)"TalentSearchAttentionCancel", (String)"tdc-tdcs-business", (Object[])new Object[0]));
    }

    private void setTableAttenionFowareData(IFormView view, String eventName, List<Long> employeeList, SearchPage<SearchResultVO> page) {
        if (HRStringUtils.isNotEmpty((String)eventName)) {
            IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("eventKey", eventName);
            data.put("type", "1");
            data.put("random", System.currentTimeMillis());
            List employees = employeeList.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
            data.put("employeeList", employees);
            data.put("data", page);
            proxy.setEntryProperty("tdcstalentsearchresult", "data", data);
        }
    }

    public Boolean hasNewEntryPoolPerm() {
        boolean perm = false;
        try {
            perm = (Boolean)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"hasNewEntryPoolPerm", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            logger.error("invoke hasNewEntryPoolPerm error", (Throwable)exception);
        }
        return perm;
    }

    public BillShowParameter getTalentPoolBillShowParameter() {
        return (BillShowParameter)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"buildEntryExitPoolFsp", (Object[])new Object[]{"new_entry"});
    }

    public void showTalentPoolForm(IFormView view, List<Long> empIds) {
        Long empId = empIds.get(0);
        Long currentOrg = RequestContext.get().getOrgId();
        Long talentFileId = new TalentSearchApplicationService().queryTalentFile(currentOrg, empId);
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("talentfile", talentFileId);
        BillShowParameter bsp = this.getTalentPoolBillShowParameter();
        bsp.setCustomParams(param);
        view.showForm((FormShowParameter)bsp);
    }

    public Boolean hasNewRecommendPerm() {
        boolean perm = false;
        try {
            perm = (Boolean)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"hasNewRecommendPerm", (Object[])new Object[0]);
        }
        catch (Exception exception) {
            logger.error("invoke hasNewRecommendPerm error", (Throwable)exception);
        }
        return perm;
    }

    public BillShowParameter getTalentRecommendBillShowParameter(Map<String, Object> param) {
        return (BillShowParameter)HRMServiceHelper.invokeBizService((String)"tdc", (String)"talp", (String)"ITALPService", (String)"getTalentRecommendForm", (Object[])new Object[]{param});
    }

    public void showTalpTalentrecommend(IFormView view, List<Long> empIds) {
        Long empId = empIds.get(0);
        Long currentOrg = RequestContext.get().getOrgId();
        Long talentFileId = new TalentSearchApplicationService().queryTalentFile(currentOrg, empId);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("talentfile", talentFileId);
        BillShowParameter bsp = this.getTalentRecommendBillShowParameter(param);
        view.showForm((FormShowParameter)bsp);
    }

    public Long queryTalentFile(Long orgId, Long empId) {
        Map<String, Long> talentFile;
        Long talentFileId = 0L;
        ArrayList<Long> empIds = new ArrayList<Long>();
        empIds.add(empId);
        Map<Long, Map<String, Long>> talentFileMap = this.talentFileApplicationService.queryTalentFileByEmpIds(0L, empIds);
        if (talentFileMap != null && !talentFileMap.isEmpty() && (talentFile = talentFileMap.get(empId)) != null && !talentFile.isEmpty() && orgId.equals(talentFile.get("org"))) {
            talentFileId = talentFile.get("id");
        }
        return talentFileId;
    }

    public Boolean hasOpenTalentFilePerm(Long empId) {
        Boolean permFlag = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"250E313JJAPH", (String)"tlmg_talentfile", (String)"47150e89000000ac");
        logger.info("hasOpenTalentFilePerm1 empId={} permFlag={}", (Object)empId, (Object)permFlag);
        if (permFlag.booleanValue()) {
            boolean isSuper = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
            logger.info("hasOpenTalentFilePerm empId={} isSuper={}", (Object)empId, (Object)isSuper);
            DynamicObject[] list = this.getTalentFileDynamicArray(empId, isSuper);
            permFlag = list != null && list.length > 0;
            logger.info("hasOpenTalentFilePerm2 empId={} permFlag={}", (Object)empId, (Object)permFlag);
        }
        return permFlag;
    }

    public HRMServiceResult getTalentPortraitForm(Long employeeId) {
        HashMap customParamMap = Maps.newHashMap();
        customParamMap.put("employee", employeeId);
        Map<String, Object> employeeMap = new HrpiService().getEmployee(employeeId);
        Long personId = (Long)employeeMap.get("person_id");
        customParamMap.put("person", personId);
        customParamMap.put(SCENE_NUMBER, "TALA_1010_S");
        logger.info("customParamMap->{}", (Object)JSON.toJSONString((Object)customParamMap));
        return (HRMServiceResult)HRMServiceHelper.invokeHRMPService((String)"hrti", (String)"IHRTIService", (String)"showTalentPortrait", (Object[])new Object[]{customParamMap});
    }

    public DynamicObject[] getTalentFileDynamicArray(Long empId, boolean isSuper) {
        QFilter qFilter = new QFilter("employee", "=", (Object)empId);
        if (!isSuper) {
            QFilter qFilterPerm = PermissionApplicationService.getDataRule("tlmg", "tlmg_talentfile", "47150e89000000ac");
            qFilter.and(qFilterPerm);
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"34", (String)"250E313JJAPH", (String)"tlmg_talentfile", (String)"47150e89000000ac");
            logger.info("getTalentFileDynamicArray hasAllOrgPerm={}", (Object)hasPermOrgResult.hasAllOrgPerm());
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                List bus = hasPermOrgResult.getHasPermOrgs();
                qFilter.and(new QFilter("org", "in", (Object)bus));
            }
        }
        QFilter isCurrentVersionStatus = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilter, isCurrentVersionStatus};
        return this.talentFileApplicationService.query("id,employee,isprimary,datastatus,bsled", qFilters);
    }

    public Long getTalentFileIdByEmployeeId(Long employeeId) {
        Long talentFileId = 0L;
        boolean isSuper = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        logger.info("getTalentFileIdByEmployeeId isSuper={}", (Object)isSuper);
        Object[] dynamicObjects = this.getTalentFileDynamicArray(employeeId, isSuper);
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            if (dynamicObjects.length == 1) {
                talentFileId = dynamicObjects[0].getLong("id");
            } else {
                Long primaryAndEffectId = 0L;
                Long effectId = 0L;
                Long invalidId = 0L;
                Date bsledDate = null;
                for (Object dynamicObject : dynamicObjects) {
                    Boolean isprimary = dynamicObject.getBoolean("isprimary");
                    String datastatus = dynamicObject.getString("datastatus");
                    if ("1".equals(datastatus)) {
                        if (Boolean.TRUE.equals(isprimary)) {
                            primaryAndEffectId = dynamicObject.getLong("id");
                            continue;
                        }
                        effectId = dynamicObject.getLong("id");
                        continue;
                    }
                    if (bsledDate == null) {
                        bsledDate = dynamicObject.getDate("bsled");
                        invalidId = dynamicObject.getLong("id");
                        continue;
                    }
                    if (dynamicObject.getDate("bsled") == null || !bsledDate.before(dynamicObject.getDate("bsled"))) continue;
                    bsledDate = dynamicObject.getDate("bsled");
                    invalidId = dynamicObject.getLong("id");
                }
                talentFileId = primaryAndEffectId != 0L ? primaryAndEffectId : (effectId != 0L ? effectId : invalidId);
            }
        }
        return talentFileId;
    }

    public Map<String, Object> querySearchScene(String name, String appNumber) {
        HrApiResponse<SearchSceneBo> response = ExtSearchService.querySearchScene(name, appNumber);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("errorMessage", response.getErrorMessage());
        data.put("code", response.getCode());
        data.put("eventKey", "init");
        data.put("random", System.currentTimeMillis());
        if (!response.getCode().equals("200")) {
            return data;
        }
        data.put("data", this.setResultData((SearchSceneBo)response.getData()));
        data.put("hasNewEntryPoolPerm", this.hasNewEntryPoolPerm());
        data.put("hasNewRecommendPerm", this.hasNewRecommendPerm());
        data.put("leftLabel", "<span class='highLight' style='color: red'>");
        data.put("rightLabel", "</span>");
        data.put("hasTalentpool", this.commCfgParamService.hasTalentpool());
        data.put("hasTalentrecommend", this.commCfgParamService.hasTalentrecommend());
        data.put("hasAttention", this.commCfgParamService.hasAttention());
        return data;
    }

    public Map<String, Object> querySearchSceneHome(HrApiResponse<SearchSceneBo> response, String eventKey) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (response.getCode().equals("200")) {
            data.put("data", this.setResultData((SearchSceneBo)response.getData()));
            data.put("hasAttention", this.commCfgParamService.hasAttention());
            data.put("homeType", this.commCfgParamService.hasHome());
            data.put("errorMessage", response.getErrorMessage());
            data.put("code", response.getCode());
            data.put("eventKey", eventKey);
            data.put("random", System.currentTimeMillis());
        }
        return data;
    }

    private SearchSceneVo setResultData(SearchSceneBo searchSceneBo) {
        SearchSceneVo searchSceneTestVo = new SearchSceneVo();
        searchSceneTestVo.setDisplayname(searchSceneBo.getSceneName());
        searchSceneTestVo.setSceneId(searchSceneBo.getSceneId().toString());
        searchSceneTestVo.setSceneName(searchSceneBo.getSceneName());
        searchSceneTestVo.setSearchObjId(searchSceneBo.getSearchObjId().toString());
        searchSceneTestVo.setSearchFieldList(searchSceneBo.getSearchFieldList());
        searchSceneTestVo.setDefSearchPrompt(searchSceneBo.getDefSearchPrompt());
        searchSceneTestVo.setSceneVersion(String.valueOf(searchSceneBo.getSceneVersion()));
        SearchCategoryEnum defCategory = searchSceneBo.getDefCategory();
        searchSceneTestVo.setDefCategory(defCategory.getValue());
        SearchKeyLogicEnum defSearchKeyLogic = searchSceneBo.getDefSearchKeyLogic();
        searchSceneTestVo.setDefSearchKeyLogic(defSearchKeyLogic.getValue());
        this.setFilterList(searchSceneBo, searchSceneTestVo);
        this.setRangeList(searchSceneBo, searchSceneTestVo);
        return searchSceneTestVo;
    }

    private void setRangeList(SearchSceneBo searchSceneBo, SearchSceneVo searchSceneTestVo) {
        List searchRangeList = searchSceneBo.getSearchRangeList();
        ArrayList searchRangeVos = Lists.newArrayListWithCapacity((int)16);
        SearchRangeVo searchRangeVoOne = new SearchRangeVo();
        searchRangeVoOne.setDisplayName(ResManager.loadKDString((String)"\u5168\u6587\u68c0\u7d22", (String)"TalentSearchApplicationService_5", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        searchRangeVoOne.setPrimaryKey("1");
        searchRangeVos.add(searchRangeVoOne);
        for (SearchRangeBo searchRangeBo : searchRangeList) {
            SearchRangeVo searchRangeVo = new SearchRangeVo();
            searchRangeVo.setDisplayName(searchRangeBo.getDisplayName());
            searchRangeVo.setSearchTargetType(searchRangeBo.getSearchTargetType().getValue());
            searchRangeVo.setPrimaryKey(searchRangeBo.getPrimaryKey().toString());
            searchRangeVo.setDefSearchPrompt(searchRangeBo.getDefSearchPrompt());
            ArrayList<SearchRangeFiledVo> searchRangeFieldList = new ArrayList<SearchRangeFiledVo>(searchRangeBo.getSearchRangFieldList().size());
            for (SearchRangFieldBo bo : searchRangeBo.getSearchRangFieldList()) {
                SearchRangeFiledVo vo = new SearchRangeFiledVo();
                vo.setRangeNumber(bo.getRangeNumber());
                vo.setSearchMode(bo.getSearchMode().getValue());
                searchRangeFieldList.add(vo);
            }
            searchRangeVo.setSearchRangFieldList(searchRangeFieldList);
            searchRangeVos.add(searchRangeVo);
        }
        searchSceneTestVo.setSearchRange((List)searchRangeVos);
    }

    private void setFilterList(SearchSceneBo searchSceneBo, SearchSceneVo searchSceneTestVo) {
        ArrayList filterConditions = Lists.newArrayListWithCapacity((int)16);
        List searchFilterList = searchSceneBo.getSearchFilterList();
        for (SearchFilterBo searchFilterBo : searchFilterList) {
            FilterConditionVo filterConditionVo = new FilterConditionVo();
            List searchCustomFilterList = searchFilterBo.getSearchCustomFilterList();
            filterConditionVo.setDisplayName(searchFilterBo.getDisplayName());
            filterConditionVo.setFiledType(searchFilterBo.getFilterFieldType().getValue());
            filterConditionVo.setNumber(searchFilterBo.getFieldAlias());
            filterConditionVo.setRealEntityNumber(searchFilterBo.getRealEntityNumber());
            filterConditionVo.setCommonFilter(searchFilterBo.isCommonFilter());
            ArrayList filterOptionVos = Lists.newArrayListWithCapacity((int)16);
            FilterOptionVo filterOptionVoNoLimit = new FilterOptionVo();
            filterOptionVoNoLimit.setId("0");
            filterOptionVoNoLimit.setFilterName(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"TalentSearchApplicationService_0", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            filterOptionVos.add(filterOptionVoNoLimit);
            String fileType = filterConditionVo.getFiledType();
            Map partFilterValMap = searchFilterBo.getPartFilterValMap();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)searchCustomFilterList)) {
                if (fileType.equals(FilterFieldTypeEnum.NUMBER.getValue()) || fileType.equals(FilterFieldTypeEnum.DATETIME.getValue()) || fileType.equals(FilterFieldTypeEnum.MONEY.getValue())) {
                    this.setCustomInterval(filterOptionVos);
                } else if (!CollectionUtils.isEmpty((Map)partFilterValMap)) {
                    partFilterValMap.forEach((key, value) -> {
                        if (Objects.nonNull(value)) {
                            FilterOptionVo filterOptionVo = new FilterOptionVo();
                            filterOptionVo.setId(key.toString());
                            filterOptionVo.setFilterName(value.toString());
                            filterOptionVos.add(filterOptionVo);
                        }
                    });
                }
            } else {
                for (SearchCustomFilterBo searchCustomFilterBo : searchCustomFilterList) {
                    FilterOptionVo filterOptionVo = new FilterOptionVo();
                    filterOptionVo.setId(searchCustomFilterBo.getKey());
                    filterOptionVo.setFilterName(searchCustomFilterBo.getName());
                    filterOptionVo.setFilterRule(searchCustomFilterBo.getFilterRule());
                    filterOptionVos.add(filterOptionVo);
                }
                filterConditionVo.setCustomFilter(true);
                if (fileType.equals(FilterFieldTypeEnum.NUMBER.getValue()) || fileType.equals(FilterFieldTypeEnum.DATETIME.getValue()) || fileType.equals(FilterFieldTypeEnum.MONEY.getValue())) {
                    this.setCustomInterval(filterOptionVos);
                }
            }
            filterConditionVo.setFilterOption((List)filterOptionVos);
            filterConditions.add(filterConditionVo);
        }
        searchSceneTestVo.setFilterCondition((List)filterConditions);
        this.trimFilterOptionByFiledTypeString(searchSceneTestVo);
    }

    private void setCustomInterval(ArrayList<FilterOptionVo> filterOptionVos) {
        FilterOptionVo customOptionVoNoLimit = new FilterOptionVo();
        customOptionVoNoLimit.setId("-1");
        customOptionVoNoLimit.setFilterName(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"TalentSearchApplicationService_1", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        filterOptionVos.add(customOptionVoNoLimit);
    }

    private void trimFilterOptionByFiledTypeString(SearchSceneVo searchSceneVo) {
        if (searchSceneVo != null && searchSceneVo.getFilterCondition() != null) {
            for (FilterConditionVo filterConditionVo : searchSceneVo.getFilterCondition()) {
                if (filterConditionVo.getFilterOption() == null) continue;
                String filedType = filterConditionVo.getFiledType();
                if (!FilterFieldTypeEnum.STRING.getValue().equals(filedType)) continue;
                for (int i = 1; i < filterConditionVo.getFilterOption().size(); ++i) {
                    filterConditionVo.getFilterOption().remove(i);
                    --i;
                }
            }
        }
    }

    public HrApiResponse<QFilter> getPermQFilters(Long sceneId, String fieldAlias, String searchEntityNumber, String appNumber) {
        return SearchSceneService.getPermQFilters((Long)sceneId, (String)fieldAlias, (String)searchEntityNumber, (String)appNumber);
    }

    public SearchResultVO setPageData(SearchResultVO searchResultVO, HrApiResponse<SmartSearchResp> response, SearchSceneVo searchSceneVo, Map eventParam) {
        SmartSearchResp searchData = (SmartSearchResp)response.getData();
        if (Objects.isNull(searchData) || searchData.getTotalHits() == 0L) {
            return searchResultVO;
        }
        this.setTableHead(searchResultVO, searchSceneVo);
        this.handleResponse(searchResultVO, searchData, searchSceneVo, eventParam);
        return searchResultVO;
    }

    private void setTableHead(SearchResultVO searchResultVO, SearchSceneVo searchSceneVo) {
        ArrayList tableHeadList = Lists.newArrayListWithCapacity((int)10);
        List searchFieldBoList = searchSceneVo.getSearchFieldList();
        for (SearchFieldBo searchFieldBo : searchFieldBoList) {
            if (searchFieldBo.isLabelField() || !searchFieldBo.isDisplayView()) continue;
            SearchResultTableHead searchResultTableHead = new SearchResultTableHead();
            searchResultTableHead.setCode(searchFieldBo.getFieldAlias());
            searchResultTableHead.setName(searchFieldBo.getDisplayName());
            List<String> hyperlinkParam = this.commCfgParamService.getHyperlinkPropertiesConfigParam();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(hyperlinkParam) && hyperlinkParam.contains(searchFieldBo.getFieldAlias())) {
                searchResultTableHead.setHyperlink(true);
            }
            if (TableSizeEnum.getEnumByCode((String)searchFieldBo.getFieldAlias()) != null) {
                searchResultTableHead.setLock(true);
                searchResultTableHead.setWidth(TableSizeEnum.getEnumByCode((String)searchFieldBo.getFieldAlias()).getSize());
                tableHeadList.add(searchResultTableHead);
                this.setLockLabelAndSearch(searchFieldBo.getFieldAlias(), tableHeadList);
                continue;
            }
            tableHeadList.add(searchResultTableHead);
        }
        searchResultVO.setTableHead((List)tableHeadList);
    }

    private void setLockLabelAndSearch(String fieldAlias, ArrayList<SearchResultTableHead> tableHeadList) {
        if (fieldAlias.equals(TableSizeEnum.PERSON_NUMBER.getNumber())) {
            SearchResultTableHead labelHead = new SearchResultTableHead();
            labelHead.setCode(LABEL);
            labelHead.setName(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"TalentSearchApplicationService_2", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            tableHeadList.add(labelHead);
            SearchResultTableHead searchHead = new SearchResultTableHead();
            searchHead.setCode("search");
            searchHead.setName(ResManager.loadKDString((String)"\u641c\u7d22\u5339\u914d", (String)"TalentSearchApplicationService_3", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            tableHeadList.add(searchHead);
        }
    }

    private void handleResponse(SearchResultVO searchResultVO, SmartSearchResp searchData, SearchSceneVo searchSceneVo, Map eventParam) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)searchData.getRowDataList())) {
            Boolean isAll = (Boolean)eventParam.get("isAll");
            ArrayList resultFieldList = Lists.newArrayListWithCapacity((int)10);
            List sourceList = searchData.getRowDataList();
            logger.info("Search handleResponse one-{}", (Object)JSON.toJSONString(sourceList.get(0)));
            List tableHeadList = searchResultVO.getTableHead();
            List<String> heads = tableHeadList.stream().map(SearchResultTableHead::getCode).collect(Collectors.toList());
            List searchFieldBoList = searchSceneVo.getSearchFieldList();
            HrApiResponse labelFields = null;
            String searchObjId = searchSceneVo.getSearchObjId();
            if (HRStringUtils.isNotEmpty((String)searchObjId)) {
                labelFields = SearchSceneService.queryAllLabelFields((Long)Long.parseLong(searchObjId));
            }
            Map searchFieldMap = searchFieldBoList.stream().collect(Collectors.toMap(SearchFieldBo::getFieldAlias, dy -> dy, (a, b) -> a, LinkedHashMap::new));
            for (SmartSearchRowData smartSearchRowData : sourceList) {
                LinkedHashMap resultFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
                Map rowData = smartSearchRowData.getRowData();
                this.setValueList(resultFieldMap, rowData);
                Map highLightData = smartSearchRowData.getHighLightData();
                this.setHighLightDataSplit(highLightData, searchFieldMap, resultFieldMap, (HrApiResponse<List<SearchFieldBo>>)labelFields);
                Map nestEntityData = smartSearchRowData.getNestEntityData();
                this.setChildValue(resultFieldMap, nestEntityData);
                resultFieldMap.put("searchFieldMap", searchFieldMap);
                this.rowRender(smartSearchRowData, resultFieldMap);
                this.alignValueMap(heads, resultFieldMap);
                resultFieldList.add(resultFieldMap);
            }
            resultFieldList.forEach(o -> this.setListOrder(heads, (Map<String, Object>)o));
            this.setIsAtentionByData(isAll, resultFieldList);
            List<Map<String, Object>> valueList = this.getValueList(resultFieldList);
            List<Map<String, Object>> cardList = this.getCardListByValueList(heads, resultFieldList, searchFieldMap);
            searchResultVO.setValueList(valueList);
            searchResultVO.setCardList(cardList);
            searchResultVO.setSearchLineSeq(this.commCfgParamService.getSearchLineSeq());
            searchResultVO.setShowSearchLine(this.commCfgParamService.showSearchLine());
        }
    }

    private void setChildValue(Map<String, Object> resultFieldMap, Map<String, List<SmartSearchRowData>> nestEntityData) {
        for (Map.Entry<String, List<SmartSearchRowData>> entry : nestEntityData.entrySet()) {
            List<SmartSearchRowData> value = entry.getValue();
            String key = entry.getKey();
            value = this.getTalentFileSearchRowData(value, key);
            for (SmartSearchRowData rowDataItem : value) {
                Map rowData1 = rowDataItem.getRowData();
                if (key.equals("hrpi_empposorgrel")) {
                    if (!rowData1.containsKey("isprimary") || !rowData1.containsKey("businessstatus")) continue;
                    this.setEmpposorgrelData(resultFieldMap, rowData1);
                    continue;
                }
                if (key.equals("hrpi_empjobrel")) {
                    String businessStatus;
                    if (!rowData1.containsKey("businessstatus") || !HRStringUtils.isNotEmpty((String)(businessStatus = ((SmartSearchData)rowData1.get("businessstatus")).getDbStoreValue())) || !businessStatus.equals("1")) continue;
                    this.setValueList(resultFieldMap, rowData1);
                    continue;
                }
                this.setValueList(resultFieldMap, rowData1);
            }
        }
    }

    public void rowRender(SmartSearchRowData smartSearchRowData, Map<String, Object> resultFieldMap) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, ITalentSearchExtendService.class, (String)"kd.sdk.tdc.tdcs.search.ITalentSearchExtendService", null);
        pluginProxy.callAfter(plugin -> {
            if (plugin != null) {
                plugin.rowRender(smartSearchRowData, resultFieldMap);
            }
            return null;
        });
    }

    private void packSearchResult(SearchResultVO page) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, ITalentSearchExtendService.class, (String)"kd.sdk.tdc.tdcs.search.ITalentSearchExtendService", null);
        pluginProxy.callAfter(plugin -> {
            if (plugin != null) {
                // empty if block
            }
            return null;
        });
    }

    private void setEmpposorgrelData(Map<String, Object> resultFieldMap, Map<String, SmartSearchData> rowData1) {
        String isPrimary = rowData1.get("isprimary").getDbStoreValue();
        String businessStatus = rowData1.get("businessstatus").getDbStoreValue();
        if (HRStringUtils.isNotEmpty((String)isPrimary) && isPrimary.equals("1")) {
            if (HRStringUtils.isNotEmpty((String)businessStatus) && businessStatus.equals("1")) {
                this.setValueList(resultFieldMap, rowData1);
            } else if (((Boolean)rowData1.get("islatestrecord").getValue()).booleanValue()) {
                this.setValueList(resultFieldMap, rowData1);
            }
        }
    }

    private void alignValueMap(List<String> heads, Map<String, Object> resultFieldMap) {
        heads.forEach(key -> {
            if (!resultFieldMap.containsKey(key)) {
                resultFieldMap.put((String)key, null);
            }
        });
    }

    private List<SmartSearchRowData> getTalentFileSearchRowData(List<SmartSearchRowData> value, String key) {
        if (key.equals("tlmg_talentfile")) {
            Optional<SmartSearchRowData> maxJoinComDateOnbrd;
            boolean datastatus = value.stream().filter(o -> HRStringUtils.isNotEmpty((String)((SmartSearchData)o.getRowData().get("datastatus")).getDbStoreValue())).anyMatch(o -> ((SmartSearchData)o.getRowData().get("datastatus")).getDbStoreValue().equals("1"));
            value = !datastatus ? ((maxJoinComDateOnbrd = value.stream().filter(perser -> perser.getRowData().containsKey("brled") && ((SmartSearchData)perser.getRowData().get("brled")).getValue() != null).max(Comparator.comparing(dy -> KDDateUtils.parseDate((String)((SmartSearchData)dy.getRowData().get("brled")).getValue().toString())))).isPresent() ? Collections.singletonList(maxJoinComDateOnbrd.get()) : Collections.singletonList(value.get(value.size() - 1))) : value.stream().filter(o -> HRStringUtils.isNotEmpty((String)((SmartSearchData)o.getRowData().get("datastatus")).getDbStoreValue()) && ((SmartSearchData)o.getRowData().get("datastatus")).getDbStoreValue().equals("1")).collect(Collectors.toList());
        }
        return value;
    }

    private void setIsAtentionByData(Boolean isAll, List<Map<String, Object>> resultFieldList) {
        if (isAll.booleanValue()) {
            List<Long> empIds = resultFieldList.stream().map(o -> this.setBoid(((SmartSearchData)o.get("boid")).getValue())).collect(Collectors.toList());
            DynamicObject[] dys = this.getAttention(empIds);
            List selectEmpIds = Arrays.stream(dys).map(o -> o.getLong("employeeid.id")).collect(Collectors.toList());
            resultFieldList.forEach(map -> {
                Long empId = this.setBoid(((SmartSearchData)map.get("boid")).getValue());
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)selectEmpIds)) {
                    map.put("isAttention", "2");
                } else {
                    map.put("isAttention", selectEmpIds.contains(empId) ? "1" : "2");
                }
            });
        } else {
            resultFieldList.forEach(map -> map.put("isAttention", "1"));
        }
    }

    private Long setBoid(Object val) {
        if (val instanceof Integer) {
            return ((Integer)val).longValue();
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        return 0L;
    }

    private void setHighLightDataSplit(Map<String, Object> highLightData, Map<String, SearchFieldBo> searchFieldMap, Map<String, Object> resultFieldMap, HrApiResponse<List<SearchFieldBo>> listHrApiResponse) {
        HashSet<String> labelSet = new HashSet<String>(16);
        HashSet<String> baseSet = new HashSet<String>(16);
        logger.info("setHighLightDataSplit###highLightData:{}", highLightData);
        for (Map.Entry<String, Object> entry : highLightData.entrySet()) {
            List labelData;
            SearchFieldBo searchFieldBo;
            String key = entry.getKey();
            if (!Objects.isNull(listHrApiResponse) && !Objects.isNull(searchFieldBo = (SearchFieldBo)(labelData = (List)listHrApiResponse.getData()).stream().filter(item -> item.getFieldAlias().equals(key)).findAny().orElse(null))) {
                String displayName = searchFieldBo.getDisplayName();
                this.setBaseHighLight(baseSet, entry, displayName);
                continue;
            }
            if (key.equals("all_label_val_txt")) {
                this.setLabelHighLight(labelSet, entry);
                continue;
            }
            SearchFieldBo field = searchFieldMap.get(key);
            if (Objects.isNull(field)) continue;
            String name = field.getDisplayName();
            if (field.isLabelField()) {
                this.setLabelHighLight(labelSet, entry);
                continue;
            }
            this.setBaseHighLight(baseSet, entry, name);
        }
        ArrayList<String> highList = new ArrayList<String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(labelSet)) {
            String highLabelName = ResManager.loadKDString((String)"\u4eba\u624d\u6807\u7b7e", (String)"TalentSearchApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]);
            ArrayList newList = new ArrayList(labelSet);
            String editHigh = newList.size() == 1 ? (String)newList.get(0) : String.join((CharSequence)"\u3001", newList);
            highList.add(highLabelName + "-" + editHigh);
        }
        highList.addAll(baseSet);
        resultFieldMap.put("search", highList);
    }

    private void setLabelHighLight(Set<String> labelSet, Map.Entry<String, Object> entry) {
        if (entry.getValue() instanceof String) {
            labelSet.add((String)entry.getValue());
        } else if (entry.getValue() instanceof List) {
            List list = (List)entry.getValue();
            labelSet.addAll(list);
        }
    }

    private void setBaseHighLight(Set<String> baseSet, Map.Entry<String, Object> entry, String name) {
        if (entry.getValue() instanceof String) {
            baseSet.add(name + "-" + entry.getValue());
        } else if (entry.getValue() instanceof List) {
            List list = (List)entry.getValue();
            HashSet set = new HashSet(list);
            ArrayList newList = new ArrayList(set);
            String editHigh = newList.size() == 1 ? (String)newList.get(0) : String.join((CharSequence)"\u3001", newList);
            baseSet.add(name + "-" + editHigh);
        }
    }

    private void setListOrder(final List<String> heads, Map<String, Object> allData) {
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>(allData.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                int io1 = heads.indexOf(o1.getKey());
                int io2 = heads.indexOf(o2.getKey());
                return io1 == -1 || io2 == -1 ? io2 - io1 : io1 - io2;
            }
        });
        allData.clear();
        for (Map.Entry entry : list) {
            allData.put((String)entry.getKey(), entry.getValue());
        }
    }

    private List<Map<String, Object>> getCardListByValueList(List<String> heads, List<Map<String, Object>> resultFieldList, Map<String, SearchFieldBo> searchFieldMap) {
        ArrayList<Map<String, Object>> valueList = new ArrayList<Map<String, Object>>(resultFieldList.size());
        Map<String, String> iconMap = this.commCfgParamService.getCardPropsConfigParam();
        String cardFieldDefaultIcon = this.commCfgParamService.getCardFieldDefaultIcon();
        for (Map<String, Object> map : resultFieldList) {
            LinkedHashMap resultFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            ArrayList detailList = Lists.newArrayListWithExpectedSize((int)16);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String value;
                String key = entry.getKey();
                if (TalentSearchConstants.SPECIFIC_FIELD_LIST.contains(key) || CollectionUtils.isEmpty(iconMap) && HRStringUtils.isEmpty((String)cardFieldDefaultIcon)) {
                    resultFieldMap.put(key, entry.getValue());
                    continue;
                }
                if ("searchFieldMap".equals(key)) continue;
                SearchFieldBo field = searchFieldMap.get(key);
                String val = this.setValueObject(key, entry.getValue());
                String string = value = HRStringUtils.isEmpty((String)val) ? "-" : val;
                if (Objects.isNull(field) || TalentSearchConstants.NOT_ICON_FIELD_LIST.contains(key)) {
                    resultFieldMap.put(key, val);
                    continue;
                }
                if (TalentSearchConstants.QUERY_LIST.contains(key) && !heads.contains(key)) continue;
                LinkedHashMap detailMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
                detailMap.put("code", key);
                detailMap.put("val", value);
                detailMap.put("desc", field.getDisplayName());
                detailMap.put("icon", iconMap.getOrDefault(key, cardFieldDefaultIcon));
                detailList.add(detailMap);
            }
            resultFieldMap.put("detailList", detailList);
            valueList.add(resultFieldMap);
        }
        return valueList;
    }

    private List<Map<String, Object>> getValueList(List<Map<String, Object>> resultFieldList) {
        ArrayList<Map<String, Object>> valueList = new ArrayList<Map<String, Object>>(resultFieldList.size());
        for (Map<String, Object> map : resultFieldList) {
            LinkedHashMap resultFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                if (key.equals("search") || key.equals("isAttention") || key.equals(LABEL) || key.equals("customline")) {
                    resultFieldMap.put(key, entry.getValue());
                    continue;
                }
                if ("searchFieldMap".equals(key)) continue;
                resultFieldMap.put(key, this.setValueObject(key, entry.getValue()));
            }
            valueList.add(resultFieldMap);
        }
        return valueList;
    }

    private String setValueObject(String key, Object value) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (value instanceof SmartSearchData) {
            SmartSearchData o = (SmartSearchData)value;
            return SerializationUtils.toJsonString((Object)o.getValue()).replaceAll("\"", "");
        }
        if (value instanceof List && TalentSearchConstants.MORE_LIST.contains(key)) {
            List list = (List)value;
            HashSet set = new HashSet(list);
            ArrayList newList = new ArrayList(set);
            String editHigh = newList.size() == 1 ? (String)newList.get(0) : String.join((CharSequence)"\u3001", newList);
            return editHigh;
        }
        return SerializationUtils.toJsonString((Object)value).replaceAll("\"", "");
    }

    private void setValueList(Map<String, Object> resultFieldMap, Map<String, SmartSearchData> rowData) {
        rowData.values().forEach(o -> {
            if (o.getFieldAlias().equals("hrpi_pernontsprop.headsculpture")) {
                o.setValue((Object)HRImageUrlUtil.getImageFullUrl((String)((String)o.getValue())));
                resultFieldMap.put(o.getFieldAlias(), o);
                return;
            }
            if (o.getFieldAlias().equals("id")) {
                resultFieldMap.put("boid", o);
                return;
            }
            if (o.isLabel()) {
                Set<String> set = (HashSet<String>)resultFieldMap.get(LABEL);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)set)) {
                    set = new HashSet<String>(16);
                }
                if (o.isArray()) {
                    List list = (List)o.getValue();
                    set.addAll(list);
                } else {
                    set.add((String)o.getValue());
                }
                set = set.stream().filter(string -> !string.isEmpty()).collect(Collectors.toSet());
                resultFieldMap.put(LABEL, set);
                return;
            }
            Object existField = resultFieldMap.get(o.getFieldAlias());
            if (Objects.isNull(existField)) {
                resultFieldMap.put(o.getFieldAlias(), o);
            } else if (existField instanceof SmartSearchData && HRStringUtils.equals((String)"string", (String)o.getValueType())) {
                o.setValue((Object)String.join((CharSequence)"\u3001", (String)o.getValue(), (String)((SmartSearchData)existField).getValue()));
                resultFieldMap.put(o.getFieldAlias(), o);
            }
        });
    }

    public SearchPage<SearchResultVO> search(SearchPage<SearchResultVO> page, Map eventParam, IFormView view) {
        List qFilters = eventParam.getOrDefault("qFilters", null);
        if (HRCollUtil.isNotEmpty((Collection)qFilters)) {
            for (Map qFilter : qFilters) {
                List valueList;
                boolean idIsZero;
                Object filedType = qFilter.get("filedType");
                if (!FilterFieldTypeEnum.ENUM.getValue().equals(filedType) || !(idIsZero = (valueList = (List)qFilter.get("selected")).stream().anyMatch(valueMap -> "idiszero".equals(valueMap.get("id"))))) continue;
                valueList.removeIf(valueMap -> "idiszero".equals(valueMap.get("id")));
                HashMap valueMap2 = Maps.newHashMap();
                valueMap2.put("id", "0");
                valueList.add(valueMap2);
            }
        }
        Long time = System.currentTimeMillis();
        SearchSceneVo searchSceneVo = this.getSearchFieldListByView(view);
        String defCategory = view.getPageCache().get("defCategory");
        if (HRStringUtils.isNotEmpty((String)defCategory)) {
            searchSceneVo.setDefCategory(defCategory);
            searchSceneVo.setDefSearchKeyLogic(view.getPageCache().get("defSearchKeyLogic"));
            SearchParam searchParam = page.getSearchParam();
            searchParam.setSearchKeyLogic(SearchKeyLogicEnum.of((String)view.getPageCache().get("defSearchKeyLogic")));
            searchParam.setCategory(SearchCategoryEnum.of((String)view.getPageCache().get("defCategory")));
        }
        page.getSearchParam().setPageId(view.getPageId());
        List filters = (List)eventParam.get("qFilters");
        if (HRCollUtil.isNotEmpty((Collection)filters)) {
            List filterConditionList = searchSceneVo.getFilterCondition();
            Map<String, String> fieldEntityMapping = filterConditionList.stream().filter(item -> FilterFieldTypeEnum.BASE_DATA.getValue().equals(item.getFiledType())).collect(Collectors.toMap(FilterConditionVo::getNumber, FilterConditionVo::getRealEntityNumber, (v1, v2) -> v1));
            HashMap idNameMapping = Maps.newHashMap();
            for (Map filter : filters) {
                String filedType = (String)filter.get("filedType");
                String type = (String)filter.get("type");
                if (!"1".equals(type)) continue;
                String property = (String)filter.get("number");
                if (FilterFieldTypeEnum.BASE_DATA.getValue().equals(filedType)) {
                    List ids;
                    HRBaseServiceHelper helper;
                    Object[] dys;
                    List select;
                    String realEntityNumber = fieldEntityMapping.get(property);
                    if (!HRStringUtils.isNotEmpty((String)realEntityNumber) || !HRCollUtil.isNotEmpty((Collection)(select = (List)filter.get("selected"))) || !HRArrayUtils.isNotEmpty((Object[])(dys = (helper = new HRBaseServiceHelper(realEntityNumber)).query("id,name", new QFilter[]{new QFilter("id", "in", ids = select.stream().map(item -> Long.parseLong((String)item.get("id"))).collect(Collectors.toList()))})))) continue;
                    Arrays.stream(dys).forEach(dy -> idNameMapping.put(String.valueOf(dy.getLong("id")), dy.getString("name")));
                    continue;
                }
                if (!FilterFieldTypeEnum.LABEL.getValue().equals(filedType)) continue;
                List select = (List)filter.get("selected");
                List ids = select.stream().map(item -> Long.parseLong((String)item.get("id"))).collect(Collectors.toList());
                Map<String, String> labelValue = ExtSearchService.getLabelValue(ids);
                idNameMapping.putAll(labelValue);
            }
            page.setIdNameMapping((Map)idNameMapping);
        }
        this.setPageParm(page, eventParam, searchSceneVo);
        String type = (String)eventParam.get("type");
        Boolean isAll = (Boolean)eventParam.get("isAll");
        SearchResultVO searchResultVO = new SearchResultVO();
        page.setEventKey("search_result");
        page.setRandom(System.currentTimeMillis());
        String primaryKey = view.getPageCache().get("primaryKey");
        if (HRStringUtils.isNotEmpty((String)primaryKey)) {
            page.setPrimaryKey(primaryKey);
        }
        if (!this.commCfgParamService.hasAttention().booleanValue()) {
            this.searchAllPage(page, eventParam, searchSceneVo, searchResultVO, isAll);
            page.setSmartSearchResp((Object)searchResultVO);
            SearchBuryPointService.search(page, view);
            logger.info("talentSearch-{} cost = {} ms", (Object)time, (Object)(System.currentTimeMillis() - time));
            return page;
        }
        if (type.equals("2") || !isAll.booleanValue() && HRStringUtils.isEmpty((String)page.getSearchParam().getSearchContent()) && HRArrayUtils.isEmpty((Object[])page.getqFilters())) {
            this.searchMyAttentionPage(page, eventParam, searchSceneVo, searchResultVO, true);
            page.setSmartSearchResp((Object)searchResultVO);
            if ("2".equals(type) && isAll.booleanValue()) {
                ((SearchResultVO)page.getSmartSearchResp()).setCardList(new ArrayList());
                return page;
            }
            return page;
        }
        String traceId = RequestContext.get().getTraceId();
        logger.info("countDownLatch-traceId={} start", (Object)traceId);
        CountDownLatch countDownLatch = new CountDownLatch(2);
        executor.submit(() -> {
            try {
                logger.info("countDownLatch-traceId={} task-1 start", (Object)traceId);
                this.searchAllPage(page, eventParam, searchSceneVo, searchResultVO, isAll);
                logger.info("countDownLatch-traceId={} task-1 end", (Object)traceId);
            }
            catch (Exception e) {
                logger.error("Search all error!", (Throwable)e);
                if (e instanceof KDBizException) {
                    view.showTipNotification(e.getMessage());
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u4ee5\u83b7\u53d6\u65b0\u7684\u641c\u7d22\u573a\u666f\u914d\u7f6e\u3002", (String)"TalentSearchApplicationService_7", (String)"tdc-tdcs-business", (Object[])new Object[0]));
                }
            }
            finally {
                countDownLatch.countDown();
            }
        });
        executor.submit(() -> {
            try {
                logger.info("countDownLatch-traceId={} task-2 start", (Object)traceId);
                Boolean isShowMyAttentionList = isAll == false;
                this.searchMyAttentionPage(page, eventParam, searchSceneVo, searchResultVO, isShowMyAttentionList);
                logger.info("countDownLatch-traceId={} task-2 end", (Object)traceId);
            }
            catch (Exception e) {
                logger.error("Search my attention error!", (Throwable)e);
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
            logger.info("countDownLatch-traceId={} end", (Object)traceId);
        }
        catch (InterruptedException e) {
            logger.error("Search await error!", (Throwable)e);
        }
        page.setSmartSearchResp((Object)searchResultVO);
        SearchBuryPointService.search(page, view);
        logger.info("talentSearch-traceId={} cost = {} ms", (Object)traceId, (Object)(System.currentTimeMillis() - time));
        return page;
    }

    private void searchAllPage(SearchPage<SearchResultVO> page, Map eventParam, SearchSceneVo searchSceneVo, SearchResultVO searchResultVO, Boolean isAll) {
        SearchPage copyPage = new SearchPage();
        this.copySearchPageProperties(page, (SearchPage<SearchResultVO>)copyPage);
        copyPage.getSearchParam().setRecordSearchLog(isAll.booleanValue());
        logger.info("searchAllPage[isAll={}]", (Object)isAll);
        HrApiResponse<SmartSearchResp> response = ExtSearchService.search(copyPage.getSearchParam(), page.getSearchField(), copyPage.getqFilters(), "<span class='highLight' style='color: red'>", "</span>", page.getStart().intValue(), page.getPagerows().intValue());
        page.setDatacount(Long.valueOf(((SmartSearchResp)response.getData()).getTotalHits()));
        if (isAll.booleanValue()) {
            this.setPageData(searchResultVO, response, searchSceneVo, eventParam);
        }
    }

    private void searchMyAttentionPage(SearchPage<SearchResultVO> page, Map eventParam, SearchSceneVo searchSceneVo, SearchResultVO searchResultVO, boolean flag) {
        SearchPage copyPage = new SearchPage();
        this.copySearchPageProperties(page, (SearchPage<SearchResultVO>)copyPage);
        copyPage.getSearchParam().setRecordSearchLog(false);
        copyPage.setqFilters(this.setUserQfilter(page.getqFilters()));
        if (HRArrayUtils.isEmpty((Object[])copyPage.getqFilters())) {
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(Arrays.asList(copyPage.getqFilters()));
        List selectfield = qFilters.stream().map(o -> o.getProperty()).collect(Collectors.toList());
        if (!selectfield.contains("id")) {
            return;
        }
        HrApiResponse<SmartSearchResp> myAttionResponse = ExtSearchService.search(copyPage.getSearchParam(), page.getSearchField(), copyPage.getqFilters(), "<span class='highLight' style='color: red'>", "</span>", page.getStart().intValue(), page.getPagerows().intValue());
        page.setMyattiondatacount(Long.valueOf(((SmartSearchResp)myAttionResponse.getData()).getTotalHits()));
        logger.info("searchMyAttentionPage 1 flag = {}", (Object)flag);
        if (flag) {
            if (((SmartSearchResp)myAttionResponse.getData()).getTotalHits() > 0L && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((SmartSearchResp)myAttionResponse.getData()).getRowDataList())) {
                page.setPageindex(Long.valueOf(page.getPageindex() - 1L));
                myAttionResponse = ExtSearchService.search(copyPage.getSearchParam(), page.getSearchField(), copyPage.getqFilters(), "<span class='highLight' style='color: red'>", "</span>", page.getStart().intValue(), page.getPagerows().intValue());
                logger.info("searchMyAttentionPage 2 flag = true");
            }
            this.setPageData(searchResultVO, myAttionResponse, searchSceneVo, eventParam);
        }
    }

    private SearchSceneVo getSearchFieldListByView(IFormView view) {
        String searchSceneBoStr = view.getPageCache().get("searchSceneBo");
        return (SearchSceneVo)SerializationUtils.fromJsonString((String)searchSceneBoStr, SearchSceneVo.class);
    }

    public QFilter[] setUserQfilter(QFilter[] getqFilters) {
        DynamicObject[] dys;
        List selectEmpIds;
        ArrayList<Object> qFilters = new ArrayList();
        if (HRArrayUtils.isNotEmpty((Object[])getqFilters)) {
            qFilters = new ArrayList<QFilter>(Arrays.asList(getqFilters));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(selectEmpIds = Arrays.stream(dys = this.getAttentionByUserId(RequestContext.get().getCurrUserId())).map(o -> o.getLong("employeeid.id")).collect(Collectors.toList()))) {
            qFilters.add(new QFilter("id", "in", selectEmpIds));
        }
        return qFilters.toArray(new QFilter[0]);
    }

    public String getAppNumber() {
        String formNum = "tdcs_talentsearch";
        ArrayList<String> numbers = new ArrayList<String>();
        String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        PermissionControlType permissionControlType = EntityMetadataCache.getPermissionControlType((String)entityNum);
        List publishApps = permissionControlType.getPublishApps();
        for (String appId : publishApps) {
            String appNumber = AppMetadataCache.getAppNumberById((String)appId);
            if (!HRStringUtils.isNotEmpty((String)appNumber)) continue;
            numbers.add(appNumber);
        }
        return org.apache.commons.collections.CollectionUtils.isEmpty(numbers) ? null : (String)numbers.get(0);
    }

    private void setPageParm(SearchPage<SearchResultVO> page, Map eventParam, SearchSceneVo searchSceneVo) {
        String associationId;
        Map searchPar = (Map)eventParam.get("searchParam");
        SearchParam par = page.getSearchParam();
        par.setSearchContent((String)searchPar.get("searchContent"));
        par.setCategory(SearchCategoryEnum.of((String)((String)searchPar.get("category"))));
        par.setSearchKeyLogic(SearchKeyLogicEnum.of((String)((String)searchPar.get("searchKeyLogic"))));
        par.setSearchTargetType(SearchTargetTypeEnum.of((String)((String)searchPar.get("searchTargetType"))));
        String sceneVersion = (String)searchPar.get("sceneVersion");
        if (HRStringUtils.isNotEmpty((String)sceneVersion)) {
            par.setSceneVersion(Long.parseLong(sceneVersion));
        }
        if (HRStringUtils.isNotEmpty((String)(associationId = (String)searchPar.get("associationId")))) {
            LabelValCompResp labelValCompResp = new LabelValCompResp();
            labelValCompResp.setDisplayName((String)searchPar.get("associationText"));
            labelValCompResp.setLabelValKey(Long.valueOf(Long.parseLong(associationId)));
            labelValCompResp.setFieldAlias((String)searchPar.get("fieldAlias"));
            labelValCompResp.setLabelFilterProp((String)searchPar.get("labelFilterProp"));
            ArrayList labelValCompRespList = Lists.newArrayList((Object[])new LabelValCompResp[]{labelValCompResp});
            par.setLabelValCompSelList((List)labelValCompRespList);
        }
        par.setPermCtlDymNum("tdcs_talentsearch");
        par.setPermCtlAppNum(this.getAppNumber());
        List list = (List)searchPar.get("searchRangFieldList");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList<SearchRangFieldBo> fieldLists = new ArrayList<SearchRangFieldBo>(list.size());
            for (Map stringObjectMap : list) {
                SearchRangFieldBo bo = new SearchRangFieldBo();
                bo.setRangeNumber(stringObjectMap.get("rangeNumber").toString());
                bo.setSearchMode(SearchModeEnum.of((String)stringObjectMap.get("searchMode").toString()));
                fieldLists.add(bo);
            }
            par.setSearchRangFieldList(fieldLists);
        }
        List qfilter = (List)eventParam.get("qFilters");
        this.handleQfilter(page, qfilter);
        page.getSearchField().clear();
        List searchFieldBoList = searchSceneVo.getSearchFieldList();
        List<String> searchField = searchFieldBoList.stream().filter(o -> o.isDisplayView()).map(o -> o.getFieldAlias()).collect(Collectors.toList());
        searchField.addAll(TalentSearchConstants.QUERY_LIST);
        this.setSearchField(searchField);
        page.setSearchField(searchField);
        this.setOpenQfilter(page);
    }

    private void handleQfilter(SearchPage<SearchResultVO> page, List<Map<String, Object>> qfilter) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(qfilter)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            logger.info("TalentSearchApplicationService###handleQfilter:{}", qfilter);
            for (Map<String, Object> p : qfilter) {
                String selectedValue;
                String filedType = p.get("filedType").toString();
                List selectedList = (List)p.get("selected");
                if (p.get("type").equals("1")) {
                    List ids;
                    String key = p.get("number").toString();
                    if (filedType.equals(FilterFieldTypeEnum.BASE_DATA.getValue())) {
                        key = key.substring(0, key.lastIndexOf(".")) + ".id";
                        ids = selectedList.stream().map(o -> Long.parseLong(o.get("id").toString())).collect(Collectors.toList());
                        qFilters.add(new QFilter(key, "in", ids));
                        continue;
                    }
                    if (filedType.equals(FilterFieldTypeEnum.LABEL.getValue())) {
                        ids = selectedList.stream().map(o -> Long.parseLong(o.get("id").toString())).collect(Collectors.toList());
                        qFilters.add(new QFilter(key, "in", ids));
                        continue;
                    }
                    ids = selectedList.stream().map(o -> o.get("id")).collect(Collectors.toList());
                    qFilters.add(new QFilter(key, "in", ids));
                    continue;
                }
                if (p.get("type").equals("2")) {
                    QFilter filter = null;
                    for (int i = 0; i < selectedList.size(); ++i) {
                        Map b = (Map)selectedList.get(i);
                        if (HRMapUtils.isEmpty((Map)b)) continue;
                        String key = p.get("number").toString() + "$" + b.get("id");
                        if (i == 0 || filter == null) {
                            filter = new QFilter(key, "=", b.get("filterRule"));
                            continue;
                        }
                        filter.or(key, "=", b.get("filterRule"));
                    }
                    qFilters.add(filter);
                    continue;
                }
                if (p.get("type").equals("3")) {
                    Map map = (Map)selectedList.get(0);
                    String small = String.valueOf(map.get("small"));
                    String large = String.valueOf(map.get("large"));
                    if (filedType.equals("datetime")) {
                        Date smallDate = KDDateUtils.parseDate((String)(small + " 00:00:00"));
                        Date largeDate = KDDateUtils.parseDate((String)(large + " 23:59:59"));
                        qFilters.add(new QFilter(p.get("number").toString(), ">=", (Object)smallDate));
                        qFilters.add(new QFilter(p.get("number").toString(), "<=", (Object)largeDate));
                        continue;
                    }
                    if (filedType.equals(FilterFieldTypeEnum.NUMBER.getValue()) || filedType.equals(FilterFieldTypeEnum.MONEY.getValue())) {
                        BigDecimal smallnum = new BigDecimal(small);
                        BigDecimal largenum = new BigDecimal(large);
                        qFilters.add(new QFilter(p.get("number").toString(), ">=", (Object)smallnum));
                        qFilters.add(new QFilter(p.get("number").toString(), "<=", (Object)largenum));
                        continue;
                    }
                    qFilters.add(new QFilter(p.get("number").toString(), ">=", (Object)small));
                    qFilters.add(new QFilter(p.get("number").toString(), "<=", (Object)large));
                    continue;
                }
                if (!p.get("type").equals("4") || selectedList == null || selectedList.size() <= 0 || (selectedValue = String.valueOf(((Map)selectedList.get(0)).get("value"))) == null || selectedValue.trim().length() <= 0) continue;
                selectedValue = "%" + selectedValue + "%";
                qFilters.add(new QFilter(p.get("number").toString(), "like", (Object)selectedValue));
            }
            page.setqFilters(qFilters.toArray(new QFilter[0]));
            logger.info("TalentSearchApplicationService###handleQfilter:{}", qfilter);
        }
    }

    private void setOpenQfilter(SearchPage<SearchResultVO> page) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (HRArrayUtils.isNotEmpty((Object[])page.getqFilters())) {
            qFilters = new ArrayList<QFilter>(Arrays.asList(page.getqFilters()));
        }
        this.setSearchQFilter(qFilters);
        page.setqFilters(qFilters.toArray(new QFilter[0]));
    }

    public void setSearchQFilter(List<QFilter> qFilters) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, ITalentSearchExtendService.class, (String)"kd.sdk.tdc.tdcs.search.ITalentSearchExtendService", null);
        pluginProxy.callAfter(plugin -> {
            if (plugin != null) {
                plugin.setSearchQFilter(qFilters);
            }
            return null;
        });
    }

    public void setSearchField(List<String> searchField) {
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, ITalentSearchExtendService.class, (String)"kd.sdk.tdc.tdcs.search.ITalentSearchExtendService", null);
        pluginProxy.callAfter(plugin -> {
            if (plugin != null) {
                plugin.setSearchField(searchField);
            }
            return null;
        });
    }

    public HRMServiceResult getTalentForm(Long talentFileId) {
        HashMap customParamMap = Maps.newHashMap();
        customParamMap.put("talentfile", talentFileId);
        customParamMap.put("source", "search");
        return (HRMServiceResult)HRMServiceHelper.invokeBizService((String)"tdc", (String)"tlmg", (String)"ITLMGPortraitService", (String)"showTalentForm", (Object[])new Object[]{customParamMap});
    }

    private void copySearchPageProperties(SearchPage<SearchResultVO> source, SearchPage<SearchResultVO> target) {
        target.setRandom(source.getRandom());
        target.setEventKey(source.getEventKey());
        target.setErrorMessage(source.getErrorMessage());
        target.setPagerows(source.getPagerows());
        target.setPageindex(source.getPageindex());
        if (source.getDatacount() != null) {
            target.setDatacount(source.getDatacount());
        }
        target.setMyattiondatacount(source.getMyattiondatacount());
        target.setPageCount(source.getPageCount());
        target.setCustomParam(source.getCustomParam());
        target.setObjSortValues(source.getObjSortValues());
        try {
            SearchParam searchParam = new SearchParam();
            BeanUtils.copyProperties((Object)searchParam, (Object)source.getSearchParam());
            target.setSearchParam(searchParam);
            if (source.getSearchField() != null) {
                ArrayList searchField = new ArrayList(source.getSearchField().size());
                searchField.addAll(source.getSearchField());
                target.setSearchField(searchField);
            }
            if (source.getqFilters() != null) {
                target.setqFilters(Arrays.copyOf(source.getqFilters(), source.getqFilters().length));
            }
            target.setSmartSearchResp(source.getSmartSearchResp());
        }
        catch (Exception e) {
            logger.error("copySearchPageProperties error!", (Throwable)e);
        }
    }
}

