/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.enums.smartsearch.SearchCategoryEnum;
import kd.hr.hbp.common.enums.smartsearch.SearchKeyLogicEnum;
import kd.hr.hbp.common.model.smartsearch.scene.SearchSceneBo;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchData;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchResp;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchRowData;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tdc.tdcs.bussiness.application.TalentSearchApplicationService;
import kd.tdc.tdcs.bussiness.application.external.ExtSearchService;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;
import kd.tdc.tdcs.common.bo.talentsearch.AnalysisObj;
import kd.tdc.tdcs.common.bo.talentsearch.AnalysisResult;
import kd.tdc.tdcs.common.bo.talentsearch.SearchPage;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TalentSearchCalculatorApplication {
    private static final Log logger = LogFactory.getLog(TalentSearchCalculatorApplication.class);
    private TalentSearchApplicationService applicationService = new TalentSearchApplicationService();
    private static final String JOBSEQID = "jobseqId";
    private static final String JOBLEVELID = "joblevelId";
    private static final String COMPANYAGE = "companyAge";
    private static final String AGE = "age";
    private static final String DIPLOMAID = "diplomaId";
    private static final String LABEL = "label";
    private static final char EN_SEPARATOR = ',';
    private static final char CN_SEPARATOR = '\uff0c';

    public Map<String, Object> getTalentSearchStatistics(HrApiResponse<SearchSceneBo> response) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(16);
        Long batchSize = 5000L;
        AnalysisResult analysisResult = new AnalysisResult(Integer.valueOf(batchSize.intValue()));
        SearchPage searchPage = new SearchPage();
        this.setSearchParam((SearchPage<SmartSearchResp>)searchPage, response);
        this.setSearchField((SearchPage<SmartSearchResp>)searchPage);
        searchPage.setPagerows(batchSize);
        boolean existAttention = this.setqFilters((SearchPage<SmartSearchResp>)searchPage);
        logger.info("getTalentSearchStatistics->existAttention={}", (Object)existAttention);
        if (!existAttention) {
            return returnData;
        }
        do {
            this.searchAfter((SearchPage<SmartSearchResp>)searchPage);
            searchPage.setPageindex(Long.valueOf(searchPage.getPageindex() + 1L));
            List<AnalysisObj> data = this.convertAnalysisObjList((SmartSearchResp)searchPage.getSmartSearchResp());
            this.calculateTalentSearch(analysisResult, data);
            logger.info("search after pageIndex = {} pageCount = {}", (Object)searchPage.getPageindex(), (Object)searchPage.getPageCount());
        } while (searchPage.getPageindex().intValue() <= searchPage.getPageCount().intValue());
        analysisResult.calacTotal();
        this.sortAndTopTalentSearch(analysisResult);
        logger.info("response:{}", (Object)JSON.toJSONString((Object)analysisResult));
        List<String> dimList = this.getDimStaticLocaleStr(analysisResult);
        List<Map<String, Object>> labelList = this.getHighFrequentLabelLocalStr(analysisResult);
        returnData.put("dim", dimList);
        returnData.put(LABEL, labelList);
        returnData.put("total", searchPage.getDatacount());
        return returnData;
    }

    private void setSearchParam(SearchPage<SmartSearchResp> page, HrApiResponse<SearchSceneBo> searchSceneConfig) {
        if (searchSceneConfig.getCode().equals("200")) {
            SearchSceneBo searchSceneBo = (SearchSceneBo)searchSceneConfig.getData();
            Long sceneId = searchSceneBo.getSceneId();
            Long searchObjId = searchSceneBo.getSearchObjId();
            SearchCategoryEnum category = searchSceneBo.getDefCategory();
            SearchParam searchParam = new SearchParam(sceneId, searchObjId, category, SearchKeyLogicEnum.OR);
            searchParam.setPermCtlDymNum("tdcs_talentsearch");
            searchParam.setPermCtlAppNum(this.applicationService.getAppNumber());
            searchParam.setSearchContent("");
            page.setSearchParam(searchParam);
        }
    }

    private void setSearchField(SearchPage<SmartSearchResp> page) {
        ArrayList<String> searchFieldList = new ArrayList<String>();
        searchFieldList.add("id");
        searchFieldList.add("hrpi_pereduexp.education.id");
        searchFieldList.add("hrpi_pereduexp.ishighestdegree");
        searchFieldList.add("hrpi_pereduexp.iscurrentversion");
        searchFieldList.add("hrpi_pereduexp.education.status");
        searchFieldList.add("hrpi_empjobrel.jobseq.id");
        searchFieldList.add("hrpi_empjobrel.businessstatus");
        searchFieldList.add("hrpi_empjobrel.joblevel.id");
        searchFieldList.add("hrpi_pernontsprop.age");
        searchFieldList.add("hrpi_pernontsprop.entservicelen");
        this.applicationService.setSearchField(searchFieldList);
        page.setSearchField(searchFieldList);
    }

    private boolean setqFilters(SearchPage<SmartSearchResp> page) {
        Object[] qFilterArray = this.applicationService.setUserQfilter(page.getqFilters());
        boolean existAttention = qFilterArray != null && qFilterArray.length > 0;
        ArrayList<Object> qFilters = new ArrayList<QFilter>();
        if (HRArrayUtils.isNotEmpty((Object[])qFilterArray)) {
            qFilters = new ArrayList<Object>(Arrays.asList(qFilterArray));
        }
        this.applicationService.setSearchQFilter(qFilters);
        page.setqFilters(qFilters.toArray(new QFilter[0]));
        return existAttention;
    }

    public SearchPage<SmartSearchResp> searchAfter(SearchPage<SmartSearchResp> page) {
        page.setDatacount(Long.valueOf(0L));
        page.setSmartSearchResp(null);
        page.getSearchParam().setRecordSearchLog(false);
        HrApiResponse<SmartSearchResp> response = ExtSearchService.searchAfter(page.getSearchParam(), page.getSearchField(), page.getqFilters(), "<span class='highLight' style='color: red'>", "</span>", page.getObjSortValues(), page.getPagerows().intValue());
        if (response.getCode().equals("200")) {
            page.setSmartSearchResp(response.getData());
            page.setDatacount(Long.valueOf(((SmartSearchResp)response.getData()).getTotalHits()));
            page.setObjSortValues(((SmartSearchResp)response.getData()).getObjSortValues());
        }
        logger.info("response:{}", (Object)JSON.toJSONString(response));
        return page;
    }

    public List<AnalysisObj> convertAnalysisObjList(SmartSearchResp smartSearchResp) {
        if (smartSearchResp != null && smartSearchResp.getRowDataList() != null && smartSearchResp.getRowDataList().size() > 0) {
            List rowDataList = smartSearchResp.getRowDataList();
            ArrayList<AnalysisObj> list = new ArrayList<AnalysisObj>(rowDataList.size());
            for (SmartSearchRowData row : rowDataList) {
                AnalysisObj item = this.convertAnalysisObj(row);
                if (item == null) continue;
                list.add(item);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public AnalysisObj convertAnalysisObj(SmartSearchRowData row) {
        AnalysisObj analysisObj = new AnalysisObj();
        Map nestEntitys = row.getNestEntityData();
        if (nestEntitys != null && nestEntitys.size() > 0) {
            Pair<Long, Long> pair = this.getJobSeq(nestEntitys);
            analysisObj.setJobseqId((Long)pair.getLeft());
            analysisObj.setJoblevelId((Long)pair.getRight());
            Pair<String, String> person = this.getHrpiPernontsprop(nestEntitys);
            analysisObj.setAge((String)person.getLeft());
            analysisObj.setCompanyAge((String)person.getRight());
            analysisObj.setDiplomaId(this.getHighHrpiPereduexp(nestEntitys));
            analysisObj.setLabel(this.getLabelList(row));
        }
        return analysisObj;
    }

    public Long getHighHrpiPereduexp(Map<String, List<SmartSearchRowData>> nestEntitys) {
        Long educationId = 0L;
        List<SmartSearchRowData> pereduexpList = nestEntitys.get("hrpi_pereduexp");
        if (CollectionUtils.isNotEmpty(pereduexpList)) {
            for (SmartSearchRowData item : pereduexpList) {
                Boolean flag;
                Map data = item.getRowData();
                SmartSearchData ishighestdegreeSSD = (SmartSearchData)data.get("ishighestdegree");
                SmartSearchData iscurrentversionSSD = (SmartSearchData)data.get("iscurrentversion");
                SmartSearchData educationIdSSD = (SmartSearchData)data.get("education.id");
                SmartSearchData educationStatusSSD = (SmartSearchData)data.get("education.status");
                String ishighestdegree = null;
                if (ishighestdegreeSSD != null) {
                    ishighestdegree = (String)ishighestdegreeSSD.getValue();
                }
                if (educationIdSSD != null) {
                    educationId = Long.valueOf(educationIdSSD.getValue().toString());
                }
                String educationStatus = null;
                if (educationStatusSSD != null) {
                    educationStatus = (String)educationStatusSSD.getValue();
                }
                Boolean iscurrentversion = Boolean.FALSE;
                if (iscurrentversionSSD != null) {
                    iscurrentversion = (Boolean)iscurrentversionSSD.getValue();
                }
                if (!(flag = Boolean.valueOf("1".equals(ishighestdegree) && iscurrentversion != false && "C".equals(educationStatus))).booleanValue() || educationId == null || educationId <= 0L) continue;
                break;
            }
        }
        return educationId;
    }

    public Pair<Long, Long> getJobSeq(Map<String, List<SmartSearchRowData>> nestEntitys) {
        Long jobSeqId = 0L;
        Long jobLevelId = 0L;
        List<SmartSearchRowData> pereduexpList = nestEntitys.get("hrpi_empjobrel");
        if (CollectionUtils.isNotEmpty(pereduexpList)) {
            for (SmartSearchRowData item : pereduexpList) {
                Map data = item.getRowData();
                SmartSearchData jobSeqIdSSD = (SmartSearchData)data.get("jobseq.id");
                SmartSearchData jobLevelIdSSD = (SmartSearchData)data.get("joblevel.id");
                SmartSearchData businessstatusSSD = (SmartSearchData)data.get("businessstatus");
                String businessstatus = null;
                if (businessstatusSSD != null) {
                    businessstatus = (String)businessstatusSSD.getValue();
                }
                if (jobSeqIdSSD != null) {
                    jobSeqId = (Long)jobSeqIdSSD.getValue();
                }
                if (jobLevelIdSSD != null) {
                    jobLevelId = (Long)jobLevelIdSSD.getValue();
                }
                if (!"1".equals(businessstatus)) continue;
                break;
            }
        }
        return Pair.of((Object)jobSeqId, (Object)jobLevelId);
    }

    public Pair<String, String> getHrpiPernontsprop(Map<String, List<SmartSearchRowData>> nestEntitys) {
        Integer age = 0;
        BigDecimal entservicelen = new BigDecimal(0);
        List<SmartSearchRowData> pereduexpList = nestEntitys.get("hrpi_pernontsprop");
        if (CollectionUtils.isNotEmpty(pereduexpList)) {
            for (SmartSearchRowData item : pereduexpList) {
                Map data = item.getRowData();
                SmartSearchData ageSSD = (SmartSearchData)data.get(AGE);
                SmartSearchData entservicelenSSD = (SmartSearchData)data.get("entservicelen");
                if (ageSSD != null) {
                    age = (Integer)ageSSD.getValue();
                }
                if (entservicelenSSD == null) continue;
                entservicelen = BigDecimal.valueOf((Double)entservicelenSSD.getValue());
            }
        }
        return Pair.of((Object)this.getFormatAge(age), (Object)this.getFormatCompanyAge(entservicelen));
    }

    private String getFormatAge(Integer age) {
        if (age != null) {
            String ageStr = "";
            if (age >= 50) {
                ageStr = ResManager.loadKDString((String)"%s\u5c81\u4ee5\u4e0a", (String)"TalentSearchStatistics_21", (String)"tdc-tdcs-business", (Object[])new Object[]{50});
            } else if (age >= 45) {
                ageStr = ResManager.loadKDString((String)"%s\u5c81", (String)"TalentSearchStatistics_22", (String)"tdc-tdcs-business", (Object[])new Object[]{"45-50"});
            } else if (age >= 40) {
                ageStr = ResManager.loadKDString((String)"%s\u5c81", (String)"TalentSearchStatistics_22", (String)"tdc-tdcs-business", (Object[])new Object[]{"40-45"});
            } else if (age >= 35) {
                ageStr = ResManager.loadKDString((String)"%s\u5c81", (String)"TalentSearchStatistics_22", (String)"tdc-tdcs-business", (Object[])new Object[]{"35-40"});
            } else if (age >= 30) {
                ageStr = ResManager.loadKDString((String)"%s\u5c81", (String)"TalentSearchStatistics_22", (String)"tdc-tdcs-business", (Object[])new Object[]{"30-35"});
            } else if (age >= 25) {
                ageStr = ResManager.loadKDString((String)"%s\u5c81", (String)"TalentSearchStatistics_22", (String)"tdc-tdcs-business", (Object[])new Object[]{"25-30"});
            } else if (age > 0) {
                ageStr = ResManager.loadKDString((String)"%s\u5c81\u4ee5\u4e0b", (String)"TalentSearchStatistics_23", (String)"tdc-tdcs-business", (Object[])new Object[]{"25"});
            }
            return ageStr;
        }
        return "";
    }

    private String getFormatCompanyAge(BigDecimal age) {
        if (age != null) {
            String ageStr = "";
            if (age.compareTo(new BigDecimal(10)) >= 0) {
                ageStr = ResManager.loadKDString((String)"%s\u5e74\u4ee5\u4e0a", (String)"TalentSearchStatistics_11", (String)"tdc-tdcs-business", (Object[])new Object[]{10});
            } else if (age.compareTo(new BigDecimal(5)) >= 0) {
                ageStr = ResManager.loadKDString((String)"%s\u5e74", (String)"TalentSearchStatistics_12", (String)"tdc-tdcs-business", (Object[])new Object[]{"5-10"});
            } else if (age.compareTo(new BigDecimal(3)) >= 0) {
                ageStr = ResManager.loadKDString((String)"%s\u5e74", (String)"TalentSearchStatistics_12", (String)"tdc-tdcs-business", (Object[])new Object[]{"3-5"});
            } else if (age.compareTo(new BigDecimal(1)) >= 0) {
                ageStr = ResManager.loadKDString((String)"%s\u5e74", (String)"TalentSearchStatistics_12", (String)"tdc-tdcs-business", (Object[])new Object[]{"1-3"});
            } else if (age.compareTo(BigDecimal.ZERO) > 0) {
                ageStr = ResManager.loadKDString((String)"%s\u5e74", (String)"TalentSearchStatistics_12", (String)"tdc-tdcs-business", (Object[])new Object[]{"0-1"});
            }
            return ageStr;
        }
        return "";
    }

    public List<String> getLabelList(SmartSearchRowData smartSearchRowData) {
        List<String> lableList = new ArrayList<String>(64);
        Map smartSearchRowDataMap = smartSearchRowData.getRowData();
        for (SmartSearchData smartSearchData : smartSearchRowDataMap.values()) {
            if (!smartSearchData.isLabel()) continue;
            if (smartSearchData.isArray()) {
                List list = (List)smartSearchData.getValue();
                lableList.addAll(list);
            } else {
                lableList.add((String)smartSearchData.getValue());
            }
            lableList = lableList.stream().filter(string -> !string.isEmpty()).collect(Collectors.toList());
        }
        return lableList;
    }

    public void calculateTalentSearch(AnalysisResult result, List<AnalysisObj> data) {
        for (AnalysisObj analysisObj : data) {
            if (analysisObj.getJobseqId() != null && analysisObj.getJobseqId() > 0L) {
                result.sumDim(JOBSEQID, (Object)analysisObj.getJobseqId());
            }
            if (analysisObj.getJoblevelId() != null && analysisObj.getJoblevelId() > 0L) {
                result.sumDim(JOBLEVELID, (Object)analysisObj.getJoblevelId());
            }
            if (StringUtils.isNotBlank((String)analysisObj.getCompanyAge())) {
                result.sumDim(COMPANYAGE, (Object)analysisObj.getCompanyAge());
            }
            if (StringUtils.isNotBlank((String)analysisObj.getAge())) {
                result.sumDim(AGE, (Object)analysisObj.getAge());
            }
            if (analysisObj.getDiplomaId() != null && analysisObj.getDiplomaId() > 0L) {
                result.sumDim(DIPLOMAID, (Object)analysisObj.getDiplomaId());
            }
            if (CollectionUtils.isNotEmpty((Collection)analysisObj.getLabel())) {
                result.sumDim(LABEL, analysisObj.getLabel());
            }
            result.plusRowCount();
        }
    }

    public void sortAndTopTalentSearch(AnalysisResult result) {
        result.sortDim(JOBSEQID, Integer.valueOf(1), Integer.valueOf(1));
        result.sortDim(JOBLEVELID, Integer.valueOf(1), Integer.valueOf(1));
        result.sortDim(COMPANYAGE, Integer.valueOf(1), Integer.valueOf(1));
        result.sortDim(AGE, Integer.valueOf(1), Integer.valueOf(1));
        result.sortDim(DIPLOMAID, Integer.valueOf(1), Integer.valueOf(1));
        result.sortDim(LABEL, Integer.valueOf(2), Integer.valueOf(5));
    }

    public List<String> getDimStaticLocaleStr(AnalysisResult result) {
        String description;
        String percentStr;
        String description2;
        String percentStr2;
        DecimalFormat decimalFormat = new DecimalFormat("#0%");
        ArrayList list = new ArrayList(16);
        ArrayList<String> dimList = new ArrayList<String>(16);
        String jobseqidRes = ResManager.loadKDString((String)"%1s\u5206\u5e03\u5728%2s", (String)"TalentSearchStatistics_1", (String)"tdc-tdcs-business", (Object[])new Object[0]);
        List jobseqidDimList = (List)result.getSortdata().get(JOBSEQID);
        if (CollectionUtils.isNotEmpty((Collection)jobseqidDimList)) {
            StringBuilder localStr = new StringBuilder();
            List<Long> jobseqids = jobseqidDimList.stream().map(x -> (Long)x.getLeft()).collect(Collectors.toList());
            DynamicObject[] jobSeqDynamicObjects = ExternalService.getJobSeq(jobseqids);
            Map<Long, String> map = Arrays.stream(jobSeqDynamicObjects).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("name")));
            for (int i = 0; i < jobseqidDimList.size(); ++i) {
                Pair row = (Pair)jobseqidDimList.get(i);
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("id", row.getLeft());
                String name = map.get(row.getLeft());
                name = name == null ? "" : name;
                percentStr2 = decimalFormat.format(row.getRight());
                description2 = String.format(jobseqidRes, percentStr2, name);
                localStr.append(description2);
                if (i < jobseqidDimList.size() - 1) {
                    localStr.append(this.getSeparator());
                }
                item.put("description", description2);
                item.put("percent", row.getRight());
                list.add(item);
            }
            dimList.add(localStr.toString());
        }
        String joblevelidRes = ResManager.loadKDString((String)"%1s\u804c\u7ea7\u4e3a%2s", (String)"TalentSearchStatistics_2", (String)"tdc-tdcs-business", (Object[])new Object[0]);
        List joblevelidDimList = (List)result.getSortdata().get(JOBLEVELID);
        if (CollectionUtils.isNotEmpty((Collection)joblevelidDimList)) {
            StringBuilder localStr = new StringBuilder();
            List<Long> jobLevelids = joblevelidDimList.stream().map(x -> (Long)x.getLeft()).collect(Collectors.toList());
            DynamicObject[] jobLevelDynamicObject = ExternalService.getJobLevel(jobLevelids);
            Map<Long, String> jobLevelMap = Arrays.stream(jobLevelDynamicObject).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("name")));
            for (int i = 0; i < joblevelidDimList.size(); ++i) {
                Pair row = (Pair)joblevelidDimList.get(i);
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("id", row.getLeft());
                String name = jobLevelMap.get(row.getLeft());
                percentStr = decimalFormat.format(row.getRight());
                description = String.format(joblevelidRes, percentStr, name);
                localStr.append(description);
                if (i < joblevelidDimList.size() - 1) {
                    localStr.append(this.getSeparator());
                }
                item.put("description", description);
                item.put("percent", row.getRight());
                list.add(item);
            }
            dimList.add(localStr.toString());
        }
        String companyageRes = ResManager.loadKDString((String)"%1s\u53f8\u9f84\u4e3a%2s", (String)"TalentSearchStatistics_3", (String)"tdc-tdcs-business", (Object[])new Object[0]);
        List companyAgeDimList = (List)result.getSortdata().get(COMPANYAGE);
        if (CollectionUtils.isNotEmpty((Collection)companyAgeDimList)) {
            StringBuilder localStr = new StringBuilder();
            for (int i = 0; i < companyAgeDimList.size(); ++i) {
                Pair row = (Pair)companyAgeDimList.get(i);
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("name", row.getLeft());
                percentStr2 = decimalFormat.format(row.getRight());
                description2 = String.format(companyageRes, percentStr2, row.getLeft());
                localStr.append(description2);
                if (i < companyAgeDimList.size() - 1) {
                    localStr.append(this.getSeparator());
                }
                item.put("description", description2);
                item.put("percent", row.getRight());
                list.add(item);
            }
            dimList.add(localStr.toString());
        }
        String ageRes = ResManager.loadKDString((String)"%1s\u5e74\u9f84\u4e3a%2s", (String)"TalentSearchStatistics_4", (String)"tdc-tdcs-business", (Object[])new Object[0]);
        List ageDimList = (List)result.getSortdata().get(AGE);
        if (CollectionUtils.isNotEmpty((Collection)ageDimList)) {
            StringBuilder localStr = new StringBuilder();
            for (int i = 0; i < ageDimList.size(); ++i) {
                Pair row = (Pair)ageDimList.get(i);
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("name", row.getLeft());
                percentStr = decimalFormat.format(row.getRight());
                description = String.format(ageRes, percentStr, row.getLeft());
                localStr.append(description);
                if (i < ageDimList.size() - 1) {
                    localStr.append(this.getSeparator());
                }
                item.put("description", description);
                item.put("percent", row.getRight());
                list.add(item);
            }
            dimList.add(localStr.toString());
        }
        String diplomaidStr = ResManager.loadKDString((String)"%1s\u5b66\u5386\u4e3a%2s", (String)"TalentSearchStatistics_5", (String)"tdc-tdcs-business", (Object[])new Object[0]);
        List diplomaidDimList = (List)result.getSortdata().get(DIPLOMAID);
        if (CollectionUtils.isNotEmpty((Collection)diplomaidDimList)) {
            StringBuilder localStr = new StringBuilder();
            List<Long> diplomaids = diplomaidDimList.stream().map(x -> (Long)x.getLeft()).collect(Collectors.toList());
            DynamicObject[] diplomaDynamicOject = ExternalService.getDiploma(diplomaids);
            Map<Long, String> diplomaMap = Arrays.stream(diplomaDynamicOject).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("name")));
            for (int i = 0; i < diplomaidDimList.size(); ++i) {
                Pair row = (Pair)diplomaidDimList.get(i);
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("id", row.getLeft());
                String name = diplomaMap.get(row.getLeft());
                String percentStr3 = decimalFormat.format(row.getRight());
                String descritpion = String.format(diplomaidStr, percentStr3, name);
                localStr.append(descritpion);
                if (i < diplomaidDimList.size() - 1) {
                    localStr.append(this.getSeparator());
                }
                item.put("description", descritpion);
                item.put("percent", row.getRight());
                list.add(item);
            }
            dimList.add(localStr.toString());
        }
        logger.info("getStaticLocaleString-> list= {}", (Object)JSON.toJSONString(list));
        logger.info("getStaticLocaleString-> dimList= {}", (Object)JSON.toJSONString(dimList));
        return dimList;
    }

    public List<Map<String, Object>> getHighFrequentLabelLocalStr(AnalysisResult analysisResult) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        List labels = (List)analysisResult.getSortdata().get(LABEL);
        if (CollectionUtils.isEmpty((Collection)labels)) {
            return list;
        }
        for (Pair row : labels) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("description", (String)row.getLeft());
            list.add(item);
        }
        return list;
    }

    public char getSeparator() {
        Lang lang = RequestContext.get().getLang();
        if (lang == Lang.zh_CN || lang == Lang.zh_TW) {
            return '\uff0c';
        }
        return ',';
    }
}

