/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;
import kd.tdc.tdcs.bussiness.domain.tenure.service.OutRepRecordDomainService;
import kd.tdc.tdcs.bussiness.domain.tenure.service.TenureDomainService;
import kd.tdc.tdcs.common.constants.coordination.CoordTaskStatusEnum;
import kd.tdc.tdcs.common.perchange.ChangeTypeEnum;
import kd.tdc.tdcs.common.perchange.PositionTypeEnum;

public class TenureApplicationService {
    private static final Log LOG = LogFactory.getLog(TenureApplicationService.class);
    private final TenureDomainService TENURE_DOMAIN_SERVICE = ServiceFactory.getService(TenureDomainService.class);
    private final OutRepRecordDomainService outRepRecordDomainService = ServiceFactory.getService(OutRepRecordDomainService.class);
    private static final HRBaseServiceHelper PERFORMANCE_HELPER = new HRBaseServiceHelper("tdcs_performance");
    private final ExternalService externalService = ServiceFactory.getService(ExternalService.class);
    private static final String HANDLER_INPUT = "10";
    private static final String POSITION = "1";
    private static final String STANDARD_POSITION = "0";
    private static final String JOB = "2";
    private static final String POSITION_TYPE = "positiontype";
    private static final String STANDARD_POSITION_STR = "standardposition";
    private static final String IS_PULL = "ispull";

    public ApiResult updateRelationalConfig4Message(Map<String, Object> paramMap) {
        Object standardPosition;
        Object job;
        LOG.info("tdcs-updateRelationalConfig4Message,paramMap:{}", paramMap);
        Object person = paramMap.get("person");
        Object employee = paramMap.get("employee");
        long adminOrgId = paramMap.get("adminorg") == null ? 0L : (Long)paramMap.get("adminorg");
        Object position = paramMap.get("position");
        Object positionType = paramMap.get(POSITION_TYPE);
        DynamicObjectCollection relationals = null;
        if (null != position && POSITION.equals(positionType)) {
            relationals = this.TENURE_DOMAIN_SERVICE.queryByPersonAndOrgAndPosition4Message(person, adminOrgId, position, POSITION);
        }
        if (null != (job = paramMap.get("job")) && JOB.equals(positionType)) {
            relationals = this.TENURE_DOMAIN_SERVICE.queryByPersonAndOrgAndJob4Message(person, adminOrgId, job, JOB, paramMap.get("empposrel"));
        }
        if (null != (standardPosition = paramMap.get(STANDARD_POSITION_STR)) && STANDARD_POSITION.equals(positionType)) {
            relationals = this.TENURE_DOMAIN_SERVICE.queryByPersonAndOrgAndStdPosition4Message(person, adminOrgId, standardPosition, STANDARD_POSITION, paramMap.get("empposrel"));
        }
        if (null == relationals || relationals.isEmpty()) {
            this.insertRelationalData(paramMap);
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        List list = relationals.stream().sorted(Comparator.comparing(relational -> relational.getDate("modifytime"), Comparator.reverseOrder())).collect(Collectors.toList());
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        DynamicObject dy = (DynamicObject)list.get(0);
        dy.set("modifier", (Object)currUserId);
        dy.set("modifytime", (Object)date);
        dy.set("employee", employee);
        paramMap.forEach((key, value) -> {
            if (!"person".equals(key) && !"adminorg".equals(key)) {
                dy.set(key, value);
            }
        });
        this.TENURE_DOMAIN_SERVICE.updateRelational(dy);
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
    }

    public ApiResult updateRelationalConfig4Nominate(Map<String, Object> paramMap) {
        LOG.info("tdcs-updateRelationalConfig4Nominate,paramMap:{}", paramMap);
        Object empPosOrgRel = paramMap.get("empposrel");
        Object person = paramMap.get("person");
        long adminOrgId = paramMap.get("adminorg") == null ? 0L : (Long)paramMap.get("adminorg");
        Object position = paramMap.get("position");
        Object positionType = paramMap.get(POSITION_TYPE);
        if (empPosOrgRel != null && (Long)empPosOrgRel != 0L) {
            long empPosOrgRelId = (Long)empPosOrgRel;
            DynamicObject[] dynamicObjects = this.TENURE_DOMAIN_SERVICE.queryByEmpposrelId(empPosOrgRelId);
            if (dynamicObjects != null && dynamicObjects.length != 0) {
                DynamicObject dy = dynamicObjects[0];
                dy.set("modifytime", (Object)new Date());
                dy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                dy.set("employee", paramMap.get("employee"));
                dy.set("appointid", paramMap.get("appointid"));
                this.TENURE_DOMAIN_SERVICE.updateRelational(dy);
            } else {
                Map<Long, DynamicObject> empPosOrgRelMap = this.externalService.getEmpPosOrgRel("apositiontype,position,job,stdposition", Collections.singletonList(empPosOrgRelId));
                if (empPosOrgRelMap != null && empPosOrgRelMap.get(empPosOrgRelId) != null) {
                    DynamicObject empPosOrgRelDy = empPosOrgRelMap.get(empPosOrgRelId);
                    paramMap.put(POSITION_TYPE, empPosOrgRelDy.get("apositiontype"));
                    paramMap.put("position", empPosOrgRelDy.get("position"));
                    paramMap.put("job", empPosOrgRelDy.get("job"));
                    paramMap.put(STANDARD_POSITION_STR, empPosOrgRelDy.get("stdposition"));
                    paramMap.put("empposrel", null);
                    this.insertRelationalData(paramMap);
                } else {
                    LOG.info("externalService.getEmpPosOrgRel is null empposorgrelid:{}", (Object)empPosOrgRelId);
                }
            }
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        return this.finalScheme(paramMap, person, adminOrgId, position, positionType);
    }

    private ApiResult finalScheme(Map<String, Object> paramMap, Object person, long adminOrgId, Object position, Object positionType) {
        Object standardPosition;
        Object job;
        DynamicObject[] relationals = null;
        if (null != position && POSITION.equals(positionType)) {
            relationals = this.TENURE_DOMAIN_SERVICE.queryByPersonAndOrgAndPosition(person, adminOrgId, position, positionType);
        }
        if (null != (job = paramMap.get("job")) && JOB.equals(positionType)) {
            relationals = this.TENURE_DOMAIN_SERVICE.queryByPersonAndOrgAndJob(person, adminOrgId, job, positionType);
        }
        if (null != (standardPosition = paramMap.get(STANDARD_POSITION_STR)) && STANDARD_POSITION.equals(positionType)) {
            relationals = this.TENURE_DOMAIN_SERVICE.queryByPersonAndOrgAndStdPosition(person, adminOrgId, standardPosition, positionType);
        }
        if (null == relationals || relationals.length == 0) {
            this.insertRelationalData(paramMap);
        } else {
            long currUserId = RequestContext.get().getCurrUserId();
            Date date = new Date();
            List list = Arrays.stream(relationals).sorted(Comparator.comparing(relational -> relational.getDate("modifytime"), Comparator.reverseOrder())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                this.insertRelationalData(paramMap);
                return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            }
            DynamicObject dynamicObject = (DynamicObject)list.get(0);
            paramMap.forEach((key, value) -> {
                if (!("person".equals(key) || "adminorg".equals(key) || "empposrel".equals(key))) {
                    dynamicObject.set(key, value);
                }
            });
            dynamicObject.set("modifier", (Object)currUserId);
            dynamicObject.set("modifytime", (Object)date);
            this.TENURE_DOMAIN_SERVICE.updateRelational(dynamicObject);
        }
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
    }

    public ApiResult updateRelationalConfig(Map<String, Object> paramMap) {
        Object standardPosition;
        Object job;
        LOG.info("tdcs-updateRelationalConfig,paramMap:{}", paramMap);
        long empPosOrgRelId = (Long)paramMap.get("empposrel");
        long nominateId = (Long)paramMap.get("appointid");
        Object employee = paramMap.get("employee");
        Object position = paramMap.get("position");
        Object positionType = paramMap.get(POSITION_TYPE);
        if (empPosOrgRelId != 0L && nominateId != 0L) {
            DynamicObject[] dynamicObjects = this.TENURE_DOMAIN_SERVICE.queryByEmpposrelId(empPosOrgRelId);
            if (dynamicObjects != null && dynamicObjects.length != 0) {
                DynamicObject dynamicObject = dynamicObjects[0];
                dynamicObject.set("modifytime", (Object)new Date());
                dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("employee", paramMap.get("employee"));
                dynamicObject.set("appointid", paramMap.get("appointid"));
                this.TENURE_DOMAIN_SERVICE.updateRelational(dynamicObject);
                return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            }
            this.insertRelationalData(paramMap);
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        DynamicObject[] relationals = null;
        if (null != position && POSITION.equals(positionType)) {
            relationals = this.TENURE_DOMAIN_SERVICE.queryByEmpAndPosition(employee, position, POSITION);
        }
        if (null != (job = paramMap.get("job")) && JOB.equals(positionType)) {
            relationals = this.TENURE_DOMAIN_SERVICE.queryByEmpAndJob(employee, job, JOB);
        }
        if (null != (standardPosition = paramMap.get(STANDARD_POSITION_STR)) && STANDARD_POSITION.equals(positionType)) {
            relationals = this.TENURE_DOMAIN_SERVICE.queryByEmpAndStandardPosition(employee, standardPosition, STANDARD_POSITION);
        }
        if (null == relationals || relationals.length == 0) {
            this.insertRelationalData(paramMap);
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        Object empRelObj = paramMap.get("empposrel") == null ? Long.valueOf(0L) : paramMap.get("empposrel");
        long empRelId = (Long)empRelObj;
        List currentEmpPosList = Arrays.stream(relationals).filter(relational -> empRelId == relational.getLong("empposrel.id")).collect(Collectors.toList());
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        if (CollectionUtils.isEmpty(currentEmpPosList)) {
            List list = Arrays.stream(relationals).filter(relational -> !relational.getBoolean(IS_PULL)).sorted(Comparator.comparing(relational -> relational.getDate("modifytime"), Comparator.reverseOrder())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                this.insertRelationalData(paramMap);
                return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            }
            DynamicObject dynamicObject = (DynamicObject)list.get(0);
            dynamicObject.set("modifytime", (Object)date);
            paramMap.forEach((arg_0, arg_1) -> ((DynamicObject)dynamicObject).set(arg_0, arg_1));
            this.TENURE_DOMAIN_SERVICE.updateRelational(dynamicObject);
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = (DynamicObject)currentEmpPosList.get(0);
        if (!dynamicObject.getBoolean(IS_PULL)) {
            dynamicObject.set("modifier", (Object)currUserId);
            dynamicObject.set("modifytime", (Object)date);
            paramMap.forEach((arg_0, arg_1) -> ((DynamicObject)dynamicObject).set(arg_0, arg_1));
            this.TENURE_DOMAIN_SERVICE.updateRelational(dynamicObject);
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u4efb\u547d\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_4", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u4e0d\u9700\u8981\u66f4\u65b0\u3002", (String)"TenureApplicationService_8", (String)"tdc-tdcs-business", (Object[])new Object[0]));
    }

    private void insertRelationalData(Map<String, Object> paramMap) {
        DynamicObject emptyDy = this.TENURE_DOMAIN_SERVICE.getRelationalEmptyDy();
        this.buildDynamicObject(paramMap, emptyDy);
        this.TENURE_DOMAIN_SERVICE.saveRelational(emptyDy);
    }

    private void buildDynamicObject(Map<String, Object> paramMap, DynamicObject emptyDy) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        emptyDy.set("modifier", (Object)currUserId);
        emptyDy.set("modifytime", (Object)date);
        emptyDy.set("creator", (Object)currUserId);
        emptyDy.set("createtime", (Object)date);
        List<String> notDyFieldList = Arrays.asList("person", "adminorg");
        paramMap.forEach((key, value) -> {
            if (!notDyFieldList.contains(key)) {
                emptyDy.set(key, value);
            }
        });
        emptyDy.set(IS_PULL, (Object)Boolean.FALSE);
    }

    public void deleteOutRepRecord(long pkId) {
        this.outRepRecordDomainService.deleteOne(pkId);
    }

    public ApiResult updateDismissRelationalConfig4Dismiss(Map<String, Object> paramMap) {
        LOG.info("updateDismissRelationalConfig4Dismiss, paramMap:{}", paramMap);
        Object employee = paramMap.get("employee");
        Object person = paramMap.get("person");
        long adminOrgId = paramMap.get("adminorg") == null ? 0L : (Long)paramMap.get("adminorg");
        long empPosOrgRelId = paramMap.get("empposrel") == null ? 0L : (Long)paramMap.get("empposrel");
        DynamicObject dismissRelation = this.TENURE_DOMAIN_SERVICE.queryDismissRelationByEmpPosOrgRel(empPosOrgRelId);
        if (null == dismissRelation) {
            Object standardPosition;
            Object job;
            Object position = paramMap.get("position");
            Object positionType = paramMap.get(POSITION_TYPE);
            DynamicObject[] dismissRelationDys = new DynamicObject[]{};
            if (null != position && POSITION.equals(positionType)) {
                dismissRelationDys = this.TENURE_DOMAIN_SERVICE.queryDismissByPersonAndOrgAndPosition(person, adminOrgId, position, positionType);
            }
            if (null != (job = paramMap.get("job")) && JOB.equals(positionType)) {
                dismissRelationDys = this.TENURE_DOMAIN_SERVICE.queryDismissByPersonAndOrgAndJob(person, adminOrgId, job, positionType);
            }
            if (null != (standardPosition = paramMap.get(STANDARD_POSITION_STR)) && STANDARD_POSITION.equals(positionType)) {
                dismissRelationDys = this.TENURE_DOMAIN_SERVICE.queryDismissByPersonAndOrgAndStdPosition(person, adminOrgId, standardPosition, positionType);
            }
            if (null == dismissRelationDys || dismissRelationDys.length == 0) {
                paramMap.put("empposrel", null);
                this.insertDismissRelationData(paramMap);
                LOG.info("insertDismissRelationData :{}", paramMap);
            } else {
                long currUserId = RequestContext.get().getCurrUserId();
                Date date = new Date();
                dismissRelation = dismissRelationDys[0];
                dismissRelation.set("modifier", (Object)currUserId);
                dismissRelation.set("modifytime", (Object)date);
                dismissRelation.set("employee", employee);
                for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                    if ("person".equals(entry.getKey()) || "adminorg".equals(entry.getKey()) || "empposrel".equals(entry.getKey())) continue;
                    dismissRelation.set(entry.getKey(), entry.getValue());
                }
                this.TENURE_DOMAIN_SERVICE.updateDismissRelation(dismissRelation);
                LOG.info("updateDismissRelation :{}", (Object)dismissRelation);
            }
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u514d\u804c\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_3", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        dismissRelation.set("modifier", (Object)currUserId);
        dismissRelation.set("modifytime", (Object)date);
        dismissRelation.set("employee", employee);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if ("person".equals(entry.getKey()) || "adminorg".equals(entry.getKey()) || "empposrel".equals(entry.getKey())) continue;
            dismissRelation.set(entry.getKey(), entry.getValue());
        }
        this.TENURE_DOMAIN_SERVICE.updateDismissRelation(dismissRelation);
        LOG.info("updateDismissRelation :{}", (Object)dismissRelation);
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u514d\u804c\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_3", (String)"tdc-tdcs-business", (Object[])new Object[0]));
    }

    public ApiResult updateDismissRelationalConfig4Message(Map<String, Object> paramMap) {
        Object standardPosition;
        Object job;
        LOG.info("updateDismissRelationalConfig4Message, paramMap:{}", paramMap);
        Object employee = paramMap.get("employee");
        Object person = paramMap.get("person");
        Object position = paramMap.get("position");
        Object positionType = paramMap.get(POSITION_TYPE);
        Object adminOrg = paramMap.get("adminorg");
        DynamicObject[] dismissRelations = null;
        if (null != position && POSITION.equals(positionType)) {
            dismissRelations = this.TENURE_DOMAIN_SERVICE.queryDismissByPersonAndOrgAndPosition4Message(person, adminOrg, position, POSITION);
        }
        if (null != (job = paramMap.get("job")) && JOB.equals(positionType)) {
            dismissRelations = this.TENURE_DOMAIN_SERVICE.queryDismissByPersonAndOrgAndJob4Message(person, adminOrg, job, JOB);
        }
        if (null != (standardPosition = paramMap.get(STANDARD_POSITION_STR)) && STANDARD_POSITION.equals(positionType)) {
            dismissRelations = this.TENURE_DOMAIN_SERVICE.queryDismissByPersonAndOrgAndStdPosition4Message(person, adminOrg, standardPosition, STANDARD_POSITION);
        }
        if (null == dismissRelations || dismissRelations.length == 0) {
            this.insertDismissRelationData(paramMap);
            LOG.info("insertDismissRelationData,paramMap:{}", paramMap);
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u514d\u804c\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_3", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        DynamicObject dismissRelation = dismissRelations[0];
        dismissRelation.set("modifier", (Object)currUserId);
        dismissRelation.set("modifytime", (Object)date);
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            if ("person".equals(entry.getKey()) || "adminorg".equals(entry.getKey())) continue;
            dismissRelation.set(entry.getKey(), entry.getValue());
        }
        this.TENURE_DOMAIN_SERVICE.updateDismissRelation(dismissRelation);
        LOG.info("updateDismissRelation:{}", (Object)dismissRelation);
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u514d\u804c\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_3", (String)"tdc-tdcs-business", (Object[])new Object[0]));
    }

    public ApiResult updateDismissRelationalConfig(Map<String, Object> paramMap) {
        Object standardPosition;
        Object job;
        LOG.info("updateDismissRelationalConfig, paramMap:{}", paramMap);
        Object employee = paramMap.get("employee");
        Object position = paramMap.get("position");
        Object positionType = paramMap.get(POSITION_TYPE);
        DynamicObject dismissRelation = null;
        if (null != position && POSITION.equals(positionType)) {
            dismissRelation = this.TENURE_DOMAIN_SERVICE.queryDismissRelationByEmpAndPosition(employee, position, POSITION);
        }
        if (null != (job = paramMap.get("job")) && JOB.equals(positionType)) {
            dismissRelation = this.TENURE_DOMAIN_SERVICE.queryDismissRelationByEmpAndJob(employee, job, JOB);
        }
        if (null != (standardPosition = paramMap.get(STANDARD_POSITION_STR)) && STANDARD_POSITION.equals(positionType)) {
            dismissRelation = this.TENURE_DOMAIN_SERVICE.queryDismissRelationByEmpAndStandardPosition(employee, standardPosition, STANDARD_POSITION);
        }
        if (null == dismissRelation) {
            this.insertDismissRelationData(paramMap);
            LOG.info("insertDismissRelationData");
            return ApiResult.success((Object)ResManager.loadKDString((String)"\u514d\u804c\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_3", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        dismissRelation.set("modifier", (Object)currUserId);
        dismissRelation.set("modifytime", (Object)date);
        paramMap.forEach((arg_0, arg_1) -> ((DynamicObject)dismissRelation).set(arg_0, arg_1));
        this.TENURE_DOMAIN_SERVICE.updateDismissRelation(dismissRelation);
        LOG.info("updateDismissRelation");
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u514d\u804c\u4efb\u804c\u7ecf\u5386\u7ba1\u7406\u5173\u7cfb\u8868\u66f4\u65b0\u6210\u529f\u3002", (String)"TenureApplicationService_3", (String)"tdc-tdcs-business", (Object[])new Object[0]));
    }

    private void insertDismissRelationData(Map<String, Object> paramMap) {
        DynamicObject emptyDy = this.TENURE_DOMAIN_SERVICE.getDismissRelationEmptyDy();
        this.buildDynamicObject(paramMap, emptyDy);
        this.TENURE_DOMAIN_SERVICE.saveDismissRelation(emptyDy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(DynamicObjectCollection dynamicObjectCollection, long employeeId, String deleteRowIdList) {
        boolean result = true;
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        List<DynamicObject> list = dynamicObjectCollection.stream().filter(dynamicObject -> HANDLER_INPUT.equals(dynamicObject.getString("source"))).collect(Collectors.toList());
        ArrayList addList = Lists.newArrayList();
        ArrayList pkIdList = Lists.newArrayList();
        ConcurrentMap map = Maps.newConcurrentMap();
        list.forEach(dynamicObject -> {
            long id = dynamicObject.getLong("performance.id");
            DynamicObject emptyDynamic = PERFORMANCE_HELPER.generateEmptyDynamicObject();
            if (id != 0L) {
                pkIdList.add(id);
                map.put(id, dynamicObject);
            } else {
                this.setValue((DynamicObject)dynamicObject, emptyDynamic, employeeId, currUserId, now);
                addList.add(emptyDynamic);
            }
        });
        ArrayList updateList = Lists.newArrayList();
        DynamicObject[] dataBaseData = PERFORMANCE_HELPER.query("id,employee,check_startdate,check_enddate,checkmode,score,level,source,checkname,rangetype,modifier,modifytime,creator,createtime", new QFilter[]{new QFilter("id", "in", (Object)pkIdList)});
        if (dataBaseData != null && dataBaseData.length > 0) {
            Arrays.stream(dataBaseData).forEach(dynamicObject -> {
                long pkId = dynamicObject.getLong("id");
                DynamicObject currentDynamic = (DynamicObject)map.get(pkId);
                if (null == currentDynamic) {
                    return;
                }
                this.setValue(currentDynamic, (DynamicObject)dynamicObject, employeeId, dynamicObject.getLong("creator.id"), dynamicObject.getDate("createtime"));
                updateList.add(dynamicObject);
            });
        }
        try (TXHandle required = TX.required();){
            List deleteList;
            if (HRStringUtils.isNotEmpty((String)deleteRowIdList) && !CollectionUtils.isEmpty((Collection)(deleteList = (List)SerializationUtils.deSerializeFromBase64((String)deleteRowIdList)))) {
                PERFORMANCE_HELPER.delete(deleteList.toArray());
            }
            if (addList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])addList.toArray(new DynamicObject[0]));
            }
            if (updateList.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
            }
        }
        return result;
    }

    private void setValue(DynamicObject source, DynamicObject target, long employeeId, long currUserId, Date now) {
        target.set("employee", (Object)employeeId);
        target.set("check_startdate", (Object)source.getDate("check_startdate"));
        target.set("check_enddate", (Object)source.getDate("check_enddate"));
        target.set("checkmode", (Object)source.getString("checkmode"));
        target.set("score", (Object)source.getBigDecimal("score"));
        target.set("level", (Object)source.getString("level"));
        target.set("source", (Object)source.getString("source"));
        target.set("checkname", (Object)source.getString("checkname"));
        target.set("rangetype", (Object)source.getString("rangetype"));
        target.set("modifier", (Object)currUserId);
        target.set("modifytime", (Object)now);
        target.set("creator", (Object)currUserId);
        target.set("createtime", (Object)now);
    }

    private ApiResult buildParam(long chgCategoryId, Object depEmpId) {
        HashMap paramMap = Maps.newHashMap();
        DynamicObject empExpInfo = this.externalService.empPosOrgRelQueryOneByQFilter("id,employee.id,position.id,stdposition.id,apositiontype,job.id,adminorg.id", new QFilter[]{new QFilter("depemp", "=", depEmpId), new QFilter("iscurrentversion", "=", (Object)POSITION)});
        if (Objects.isNull(empExpInfo)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u90e8\u95e8\u4eba\u65e0\u6cd5\u67e5\u8be2\u5230\u4efb\u804c\u7ecf\u5386\u3002", (String)"TenureApplicationService_10", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        boolean isDismiss = ChangeTypeEnum.TURNOVER.getNumber() == chgCategoryId || ChangeTypeEnum.RETIRED.getNumber() == chgCategoryId;
        long adminOrgId = empExpInfo.getLong("adminorg.id");
        long positionId = empExpInfo.getLong("position.id");
        long jobId = empExpInfo.getLong("job.id");
        long stdPositionId = empExpInfo.getLong("stdposition.id");
        String positionType = empExpInfo.getString("apositiontype");
        DynamicObject dynamicObject = null;
        boolean isManageType = false;
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            dynamicObject = this.externalService.queryPositionById("id,positiontype.ismanagetype", positionId);
            if (null != dynamicObject) {
                isManageType = dynamicObject.getBoolean("positiontype.ismanagetype");
            }
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            dynamicObject = this.externalService.queryJobById("id,jobseq.id", jobId);
            if (null == dynamicObject) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u5458\u5de5\u4efb\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u804c\u4f4d\uff0c\u4f46\u65e0\u6cd5\u6839\u636e\u804c\u4f4dID\u67e5\u8be2\u5230\u76f8\u5e94\u804c\u4f4d\u3002", (String)"TenureApplicationService_5", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            }
            long jobSeqId = dynamicObject.getLong("jobseq.id");
            isManageType = this.externalService.isJobManager(jobSeqId);
        } else if (PositionTypeEnum.STANDARD_POSITION.getNumber().equals(positionType)) {
            dynamicObject = this.externalService.queryStdPositionById("id,positiontype.id", stdPositionId);
            if (null == dynamicObject) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u5458\u5de5\u4efb\u804c\u4efb\u5c97\u6a21\u5f0f\u4e3a\u6807\u51c6\u5c97\u4f4d\uff0c\u4f46\u65e0\u6cd5\u6839\u636e\u6807\u51c6\u5c97\u4f4dID\u67e5\u8be2\u5230\u76f8\u5e94\u6807\u51c6\u5c97\u4f4d\u3002", (String)"TenureApplicationService_6", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            }
            long positionTypeId = dynamicObject.getLong("positiontype.id");
            isManageType = this.externalService.isManager(positionTypeId);
        }
        if (isDismiss || !HRObjectUtils.isEmpty((Object)dynamicObject)) {
            LOG.info("tlmg-position-id:{} job-id {} ,standardposition-id {},ismanagetype:{}", new Object[]{positionId, jobId, stdPositionId, isManageType});
            if (isDismiss || isManageType) {
                paramMap.put("empposrel", empExpInfo.getLong("id"));
                paramMap.put("employee", empExpInfo.getLong("employee.id"));
                paramMap.put(POSITION_TYPE, positionType);
                paramMap.put("adminorg", adminOrgId);
                if (positionId != 0L) {
                    paramMap.put("position", positionId);
                }
                if (jobId != 0L) {
                    paramMap.put("job", jobId);
                }
                if (stdPositionId != 0L) {
                    paramMap.put(STANDARD_POSITION_STR, stdPositionId);
                }
                paramMap.put("employee", empExpInfo.getLong("employee.id"));
                return ApiResult.success((Object)paramMap);
            }
        }
        return ApiResult.fail((String)ResManager.loadKDString((String)"\u4ec5\u7ba1\u7406\u5c97\u53ef\u751f\u6210\u4efb\u671f\u6570\u636e\u3002", (String)"TenureApplicationService_7", (String)"tdc-tdcs-business", (Object[])new Object[0]));
    }

    private ApiResult buildMessageBody(Map<String, Object> messageBody, long chgCategoryId) {
        Map<String, Object> returnData = this.externalService.getPerIdByChgCategoryId((Long)messageBody.get("recordId"));
        if (CollectionUtils.isEmpty(returnData) || !((Boolean)returnData.get("success")).booleanValue()) {
            LOG.error("Changed-transaction-records-cannot-be-queried-by-recordId,errorMsg:{}", returnData.get("errorMsg"));
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u8be2\u201c\u4eba\u4e8b\u4e8b\u52a1\u53d8\u52a8\u8bb0\u5f55\u4fe1\u606f\u201d\u5931\u8d25\u3002", (String)"TenureApplicationService_2", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        }
        Map data = (Map)returnData.get("data");
        LOG.info("tlmg-getPerIdByChgCategoryId:{}", (Object)data);
        List perIdList = (List)data.get("data");
        perIdList.forEach(perIdMap -> {
            Object value;
            Map empMap = (Map)perIdMap.get("hrpi_employee");
            Map depMap = (Map)perIdMap.get("hrpi_depemp");
            Map personMap = (Map)perIdMap.get("hrpi_person");
            if (!CollectionUtils.isEmpty((Map)empMap) && !Objects.isNull(value = empMap.get("boid")) && (Long)value != 0L) {
                messageBody.put("newEmployeeId", value);
                messageBody.put("oldEmployeeId", value);
            }
            if (!CollectionUtils.isEmpty((Map)personMap) && !Objects.isNull(value = personMap.get("boid")) && (Long)value != 0L) {
                messageBody.put("newPersonId", value);
                messageBody.put("oldPersonId", value);
            }
            if (!CollectionUtils.isEmpty((Map)depMap)) {
                String dmpChgMode;
                switch (dmpChgMode = (String)depMap.get("chgmode")) {
                    case "0": {
                        messageBody.put("newDepEmpId", depMap.get("boid"));
                        break;
                    }
                    case "2": {
                        messageBody.put("oldDepEmpId", depMap.get("boid"));
                        break;
                    }
                }
            }
        });
        if (ChangeTypeEnum.RETIRED.getNumber() == chgCategoryId || ChangeTypeEnum.TURNOVER.getNumber() == chgCategoryId) {
            Set depEmpSet = perIdList.stream().filter(item -> !CollectionUtils.isEmpty((Map)((Map)item.get("hrpi_depemp"))) && !Objects.isNull(((Map)item.get("hrpi_depemp")).get("boid"))).map(item -> Long.parseLong(String.valueOf(((Map)item.get("hrpi_depemp")).get("boid")))).collect(Collectors.toSet());
            DynamicObject[] orderByStartDate = this.externalService.queryEmpExpOrderByStartDate("id,depemp,isprimary", new QFilter[]{new QFilter("iscurrentversion", "=", (Object)POSITION), new QFilter("depemp", "in", depEmpSet)});
            long depEmpId = Arrays.stream(orderByStartDate).filter(item -> POSITION.equals(item.getString("isprimary"))).findFirst().orElseGet(() -> orderByStartDate[0]).getLong("depemp");
            messageBody.put("oldDepEmpId", depEmpId);
        }
        LOG.info("tlmg-messageBody:{}", messageBody);
        return null;
    }

    public void updateDismissRelationalConfig(Map<String, Object> messageBody, Map<String, Object> coordinationMap) {
        Long chgCategoryId = this.preCheck(messageBody, coordinationMap);
        if (chgCategoryId == null) {
            return;
        }
        if (ChangeTypeEnum.isFailureRelational((long)chgCategoryId)) {
            ApiResult apiResult = this.buildParam(chgCategoryId, messageBody.get("oldDepEmpId"));
            if (apiResult.getSuccess()) {
                Map paramMap = (Map)apiResult.getData();
                paramMap.put("variationtypeid", chgCategoryId);
                paramMap.put("person", messageBody.get("newPersonId"));
                apiResult = this.updateDismissRelationalConfig4Message(paramMap);
            }
            LOG.info("updateDismissRelationalConfig,apiResult:{}", (Object)apiResult);
            this.buildResultMap(coordinationMap, apiResult);
        }
    }

    public void updateRelationalConfig(Map<String, Object> messageBody, Map<String, Object> coordinationMap) {
        Long chgCategoryId = this.preCheck(messageBody, coordinationMap);
        if (chgCategoryId == null) {
            return;
        }
        if (ChangeTypeEnum.isUpdateRelational((long)chgCategoryId)) {
            long personId = messageBody.get("newPersonId") == null ? 0L : (Long)messageBody.get("newPersonId");
            ApiResult apiResult = this.buildParam(chgCategoryId, messageBody.get("newDepEmpId"));
            if (apiResult.getSuccess()) {
                Map paramMap = (Map)apiResult.getData();
                paramMap.put("person", personId);
                apiResult = this.updateRelationalConfig4Message(paramMap);
            }
            LOG.info("updateRelationalConfig,apiResult:{}", (Object)apiResult.toString());
            this.buildResultMap(coordinationMap, apiResult);
        }
    }

    private Long preCheck(Map<String, Object> messageBody, Map<String, Object> coordinationMap) {
        Object chgCategoryIdOb = messageBody.get("chgcategoryId");
        long chgCategoryId = Long.parseLong(String.valueOf(chgCategoryIdOb));
        if (Objects.isNull(ChangeTypeEnum.getEnumByNumber((long)chgCategoryId))) {
            this.buildResultMap(coordinationMap, CoordTaskStatusEnum.NOT_EXECUTE, ResManager.loadKDString((String)"\u5f53\u524d\u4e0d\u662f\u5f85\u5904\u7406\u7684\u53d8\u52a8\u7c7b\u578b\u3002", (String)"TenureApplicationService_1", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            return null;
        }
        ApiResult returnData = this.buildMessageBody(messageBody, chgCategoryId);
        if (returnData != null) {
            this.buildResultMap(coordinationMap, CoordTaskStatusEnum.FALSE, returnData.getMessage());
            return null;
        }
        LOG.info(MessageFormat.format("message-body-parameter-chgCategoryId:{0}", chgCategoryIdOb));
        if (Objects.isNull(chgCategoryIdOb)) {
            this.buildResultMap(coordinationMap, CoordTaskStatusEnum.NOT_EXECUTE, ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578bID\u4e3a\u7a7a\u3002", (String)"TenureApplicationService_0", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            return null;
        }
        return chgCategoryId;
    }

    private void buildResultMap(Map<String, Object> map, CoordTaskStatusEnum taskStatus, String taskInfo) {
        map.put("taskStatus", taskStatus.getStatus());
        map.put("taskInfo", taskInfo);
    }

    private void buildResultMap(Map<String, Object> map, ApiResult apiResult) {
        CoordTaskStatusEnum statusEnum = apiResult.getSuccess() ? CoordTaskStatusEnum.SUCCESS : CoordTaskStatusEnum.NOT_EXECUTE;
        String msg = apiResult.getSuccess() ? String.valueOf(apiResult.getData()) : apiResult.getMessage();
        this.buildResultMap(map, statusEnum, msg);
    }

    public DynamicObject queryRelationByAppointId(String selectedProperties, long appointId) {
        return this.TENURE_DOMAIN_SERVICE.queryRelationByAppointId(selectedProperties, appointId);
    }

    public DynamicObject queryDismissRelationByDismissId(String selectedProperties, long dismissBillId) {
        return this.TENURE_DOMAIN_SERVICE.queryDismissRelationByDismissId(selectedProperties, dismissBillId);
    }

    public DynamicObject[] queryRelationalByEmpPosRelId(List<Long> empPosRelIdList) {
        return this.TENURE_DOMAIN_SERVICE.queryRelationalByEmpPosRelId(empPosRelIdList);
    }
}

