/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application.external;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.smartsearch.HRSmartSearchService;
import kd.hr.hbp.business.service.smartsearch.LabelValCompletionService;
import kd.hr.hbp.business.service.smartsearch.SearchLogQueryService;
import kd.hr.hbp.business.service.smartsearch.SearchSceneService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.enums.smartsearch.FilterFieldTypeEnum;
import kd.hr.hbp.common.model.smartsearch.scene.SearchSceneBo;
import kd.hr.hbp.common.model.smartsearch.search.LabelValCompParam;
import kd.hr.hbp.common.model.smartsearch.search.LabelValCompResp;
import kd.hr.hbp.common.model.smartsearch.search.SearchParam;
import kd.hr.hbp.common.model.smartsearch.search.SmartSearchResp;
import kd.hr.hbp.common.util.HRStringUtils;

public class ExtSearchService {
    private static final Log log = LogFactory.getLog(ExtSearchService.class);

    public static HrApiResponse<SearchSceneBo> querySearchScene(String searchEntityNumber, String appNumber) {
        log.info("ExtSearchService.querySearchScene start searchEntityNumber={},appNumber={}", (Object)searchEntityNumber, (Object)appNumber);
        Long startTime = System.currentTimeMillis();
        HrApiResponse data = SearchSceneService.querySearchScene((String)searchEntityNumber, (String)appNumber);
        Long endTime = System.currentTimeMillis();
        log.info("ExtSearchService.querySearchScene cost = {} ms", (Object)(endTime - startTime));
        if (data.isSuccess()) {
            ExtSearchService.updateSthFromData((HrApiResponse<SearchSceneBo>)data);
        }
        return data;
    }

    public static HrApiResponse<SearchSceneBo> querySearchScene(long sceneId) {
        log.info("ExtSearchService.querySearchScene start sceneId={}", (Object)sceneId);
        Long startTime = System.currentTimeMillis();
        HrApiResponse data = SearchSceneService.querySearchScene((Long)sceneId);
        Long endTime = System.currentTimeMillis();
        log.info("ExtSearchService.querySearchScene cost = {} ms", (Object)(endTime - startTime));
        if (data.isSuccess()) {
            ExtSearchService.updateSthFromData((HrApiResponse<SearchSceneBo>)data);
        }
        return data;
    }

    public static HrApiResponse<SmartSearchResp> search(SearchParam searchParam, List<String> searchField, QFilter[] qFilters, String highLightPreTag, String highLightPostTag, int start, int limit) {
        log.info("ExtSearchService.search -> start");
        log.info("ExtSearchService.search -> searchParam={}", (Object)JSON.toJSONString((Object)searchParam));
        log.info("ExtSearchService.search -> searchField={}", (Object)JSON.toJSONString(searchField));
        if (qFilters != null) {
            log.info("ExtSearchService.search -> qFilters={}", (Object)JSON.toJSONString((Object)qFilters));
        }
        Long startTime = System.currentTimeMillis();
        HrApiResponse data = HRSmartSearchService.search((SearchParam)searchParam, searchField, (QFilter[])qFilters, (String)highLightPreTag, (String)highLightPostTag, (int)start, (int)limit);
        Long endTime = System.currentTimeMillis();
        log.info("ExtSearchService.search code = {} cost = {} ms", (Object)data.getCode(), (Object)(endTime - startTime));
        if (!"200".equals(data.getCode())) {
            log.info("ExtSearchService.search error!");
            String errorMessage = data.getErrorMessage();
            if (HRStringUtils.isNotEmpty((String)errorMessage) && errorMessage.contains("custom filter error")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8fc7\u6ee4\u65b9\u6848\u7684\u6761\u4ef6\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u5df2\u9009\u6761\u4ef6\u65e0\u8bef\uff0c\u5e76\u91cd\u65b0\u4fdd\u5b58\u540e\u518d\u6267\u884c\u67e5\u8be2\u3002", (String)"ExtSearchService_0", (String)"tdc-tdcs-business", (Object[])new Object[0]));
            }
            throw new KDBizException(errorMessage);
        }
        return data;
    }

    public static HrApiResponse<SmartSearchResp> searchAfter(SearchParam searchParam, List<String> searchField, QFilter[] qFilters, String highLightPreTag, String highLightPostTag, Object[] objSortValues, int limit) {
        log.info("ExtSearchService.searchAfter -> start");
        log.info("ExtSearchService.searchAfter -> searchParam={}", (Object)JSON.toJSONString((Object)searchParam));
        Long startTime = System.currentTimeMillis();
        HrApiResponse data = HRSmartSearchService.searchAfter((SearchParam)searchParam, searchField, (QFilter[])qFilters, (String)highLightPreTag, (String)highLightPostTag, (Object[])objSortValues, (int)limit);
        Long endTime = System.currentTimeMillis();
        log.info("ExtSearchService.searchAfter code = {} cost = {} ms", (Object)data.getCode(), (Object)(endTime - startTime));
        if (!"200".equals(data.getCode())) {
            log.info("ExtSearchService.searchAfter error!");
            throw new KDBizException(data.getErrorMessage());
        }
        return data;
    }

    public static HrApiResponse<List<String>> getHisRecords(long sceneId, String searchEntityNumber) {
        log.info("ExtSearchService-getHisRecords-start-sceneId:{},searchEntityNumber:{}", (Object)sceneId, (Object)searchEntityNumber);
        Long startTime = System.currentTimeMillis();
        HrApiResponse data = SearchLogQueryService.queryUserTopKeywords((Long)sceneId, (String)searchEntityNumber, (Long)RequestContext.get().getCurrUserId());
        Long endTime = System.currentTimeMillis();
        log.info("ExtSearchService-getHisRecords-cost:{} ms,data:{}", (Object)(endTime - startTime), (Object)data);
        return data;
    }

    public static void deleteHisRecord(long sceneId, String searchEntityNumber, String hisRecord) {
        log.info("ExtSearchService-deleteHisRecord-start-sceneId:{},searchEntityNumber:{},hisRecord:{}", new Object[]{sceneId, searchEntityNumber, hisRecord});
        Long startTime = System.currentTimeMillis();
        SearchLogQueryService.removeUserKeywords((Long)sceneId, (String)searchEntityNumber, (Long)RequestContext.get().getCurrUserId(), (String)hisRecord);
        Long endTime = System.currentTimeMillis();
        log.info("ExtSearchService-deleteHisRecord-cost:{} ms", (Object)(endTime - startTime));
    }

    public static void clearHisRecords(long sceneId, String searchEntityNumber) {
        log.info("ExtSearchService-clearHisRecords-start-sceneId:{},searchEntityNumber:{}", (Object)sceneId, (Object)searchEntityNumber);
        Long startTime = System.currentTimeMillis();
        SearchLogQueryService.removeUserKeywords((Long)sceneId, (String)searchEntityNumber, (Long)RequestContext.get().getCurrUserId());
        Long endTime = System.currentTimeMillis();
        log.info("ExtSearchService-clearHisRecords-cost:{} ms", (Object)(endTime - startTime));
    }

    public static HrApiResponse<List<LabelValCompResp>> searchAnnotation(LabelValCompParam labelValCompParam) {
        log.info("ExtSearchService-searchAnnotation-start-labelValCompParam:{}", (Object)labelValCompParam.toString());
        Long startTime = System.currentTimeMillis();
        HrApiResponse completion = LabelValCompletionService.completion((LabelValCompParam)labelValCompParam);
        Long endTime = System.currentTimeMillis();
        log.info("ExtSearchService-searchAnnotation-cost:{} ms,completion:{}", (Object)(endTime - startTime), (Object)completion);
        return completion;
    }

    private static void updateSthFromData(HrApiResponse<SearchSceneBo> data) {
        List searchFilterList = ((SearchSceneBo)data.getData()).getSearchFilterList();
        searchFilterList.forEach(searchFilterBo -> {
            Map valMap;
            Object idIsZero;
            if (FilterFieldTypeEnum.ENUM.equals((Object)searchFilterBo.getFilterFieldType()) && !Objects.isNull(idIsZero = (valMap = searchFilterBo.getPartFilterValMap()).get("0"))) {
                valMap.put("idiszero", idIsZero);
                valMap.remove("0");
            }
        });
    }

    public static Map<String, String> getLabelValue(Object entryIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_label");
        DynamicObject[] dys = helper.query("entryentitylabelvalue.labelvalue,entryentitylabelvalue.id", new QFilter[]{new QFilter("entryentitylabelvalue.id", "in", entryIds)});
        HashMap idNameMapping = Maps.newHashMap();
        for (DynamicObject dy : dys) {
            DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("entryentitylabelvalue");
            for (DynamicObject entryDy : entryEntity) {
                idNameMapping.put(String.valueOf(entryDy.getLong("id")), entryDy.getString("labelvalue"));
            }
        }
        return idNameMapping;
    }
}

