/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application.external;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.param.ParamOperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.time.TimeService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class ExternalService {
    private static final Log logger = LogFactory.getLog(ExternalService.class);
    private static final HRBaseServiceHelper HRPI_EMPPOSORGREL = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final HRBaseServiceHelper HRPI_EMPJOBREL_HELPER = new HRBaseServiceHelper("hrpi_empjobrel");
    private static final HRBaseServiceHelper HRPI_PERSON_HELPER = new HRBaseServiceHelper("hrpi_person");
    private static final HRBaseServiceHelper JOB_HELPER = new HRBaseServiceHelper("hbjm_jobhr");
    private static final HRBaseServiceHelper JOB_MANAGER_HELPER = new HRBaseServiceHelper("hbjm_standardjobseqhr");
    private static final HRBaseServiceHelper JOB_SEQ_HELPER = new HRBaseServiceHelper("hbjm_jobseqhr");
    private static final HRBaseServiceHelper HBJM_JOB_LEVEL_HELPER = new HRBaseServiceHelper("hbjm_joblevelhr");
    private static final HRBaseServiceHelper STD_POSITION_HELPER = new HRBaseServiceHelper("hbpm_stposition");
    private static final HRBaseServiceHelper TYPE_HELPER = new HRBaseServiceHelper("hbpm_positiontype");
    private static final HRBaseServiceHelper POSITION_HELPER = new HRBaseServiceHelper("hbpm_positionhr");
    private static final HRBaseServiceHelper HBSS_POS_TYPE_HELPER = new HRBaseServiceHelper("hbss_postype");
    private static final HRBaseServiceHelper HBSS_DIPLOMA_HELPER = new HRBaseServiceHelper("hbss_diploma");
    private static final String JOB_MANAGER = "1010_S";
    private static final long BUSINESS_FIELD = 1180L;
    private static final String HRPI = "hrpi";
    private static final String LIST_PERSON_ATTACHS = "listPersonAttachs";
    private static final String IHRPI_PERSON_SERVICE = "IHRPIPersonService";

    public static List<QFilter> buildDataPermFilters(String appId, String entityNumber) {
        QFilter specialDataPermissionFilter;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId());
        if (superUser) {
            return qFilterList;
        }
        QFilter dataRuleFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{RequestContext.get().getCurrUserId(), AppMetadataCache.getAppInfo((String)appId).getId(), entityNumber, "47150e89000000ac", null});
        if (dataRuleFilter != null) {
            qFilterList.add(dataRuleFilter);
        }
        if ((specialDataPermissionFilter = PermissionFilterUtil.getSpecialDataPermissionFilter((String)appId, (String)entityNumber, (String)"view", (ITimeService)new TimeService(), (IUserService)new UserService())) != null) {
            qFilterList.add(specialDataPermissionFilter);
        }
        return qFilterList;
    }

    public static Map<String, Object> getSystemParam(String appKey) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appKey);
        String appId = appInfo.getId();
        AppParam appParam = new AppParam(appId, "34", Long.valueOf(OrgUnitServiceHelper.getRootOrgId()), Long.valueOf(0L));
        Map appParameterMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return appParameterMap;
    }

    public static Object getSystemParam(String appKey, String paramKey) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appKey);
        String appId = appInfo.getId();
        AppParam appParam = new AppParam(appId, "34", Long.valueOf(OrgUnitServiceHelper.getRootOrgId()), Long.valueOf(0L));
        Object result = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)paramKey);
        logger.info("getSystemParam {} - {} , result : {}", new Object[]{appKey, paramKey, result});
        return result;
    }

    public static boolean updateSystemParam(String appKey, Map<String, Object> param) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appKey);
        String appId = appInfo.getId();
        ParamOperationResult paramOperationResult = SystemParamServiceHelper.saveAppParameter((String)"34", (Long)OrgUnitServiceHelper.getRootOrgId(), (Long)0L, (String)appId, param);
        return paramOperationResult.isSuccess();
    }

    public Map<Long, DynamicObject> getEmpPosOrgRel(String selectProperties, List<Long> pkIds) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return Collections.emptyMap();
        }
        QFilter idFilter = new QFilter("id", "in", pkIds);
        DynamicObject[] empPosArr = HRPI_EMPPOSORGREL.query(selectProperties, new QFilter[]{idFilter});
        if (Objects.isNull(empPosArr) || empPosArr.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(empPosArr).collect(Collectors.toMap(value -> value.getLong("id"), value -> value, (v1, v2) -> v1));
    }

    public Map<Long, DynamicObject> getEmpPosOrgRel(String selectProperties, List<Long> pkIds, String positionType) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return Collections.emptyMap();
        }
        QFilter idFilter = new QFilter("id", "in", pkIds);
        QFilter positionTypeFilter = new QFilter("apositiontype", "=", (Object)positionType);
        DynamicObject[] empPosArr = HRPI_EMPPOSORGREL.query(selectProperties, new QFilter[]{idFilter, positionTypeFilter});
        if (Objects.isNull(empPosArr) || empPosArr.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(empPosArr).collect(Collectors.toMap(value -> value.getLong("id"), value -> value, (v1, v2) -> v1));
    }

    public Map<String, Object> getHRBUFromManageEmpStrategy(Long orgId, Long personId, Long perGroupId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrbuFromManageEmpStrategy", (Object[])new Object[]{orgId, personId, 1180L, perGroupId});
    }

    public long getBuIdByAdminOrgId(long adminOrgId, long personId, long perGroupId) {
        Map map = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrbuFromManageEmpStrategy", (Object[])new Object[]{adminOrgId, personId, 1180L, perGroupId});
        return CollectionUtils.isEmpty((Map)map) ? 0L : (map.get("hrbu") == null ? 0L : ((DynamicObject)map.get("hrbu")).getLong("id"));
    }

    public List<Map<String, Object>> getEmpTrainInfo(long personId) {
        logger.info("hrpi-->IHRPIPersonService-->listPersonAttachs-->hrpi_emptrainfile-->personId:{}", (Object)personId);
        List result = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)LIST_PERSON_ATTACHS, (Object[])new Object[]{personId, "hrpi_emptrainfile"});
        if (CollectionUtils.isEmpty((Collection)result)) {
            logger.info("hrpi-->IHRPIPersonService-->listPersonAttachs-->hrpi_emptrainfile-->return is null");
            return new ArrayList<Map<String, Object>>();
        }
        logger.info("hrpi-->IHRPIPersonService-->listPersonAttachs-->hrpi_emptrainfile-->return:{}", (Object)result);
        return result;
    }

    public Map<String, Object> getPersonInfo(long personId) {
        logger.info("hrpi-->getPersonInfo-->personId:{}", (Object)personId);
        Map personInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)"getPersonInfo", (Object[])new Object[]{personId});
        return personInfoMap;
    }

    public DynamicObject getPositionInfo(long employeeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_empjobrel");
        QFilter qFilterPersonId = new QFilter("employee", "=", (Object)employeeId);
        QFilter qFilterIsCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter qFilterDataStatus = new QFilter("datastatus", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{qFilterPersonId, qFilterIsCurrentVersion, qFilterDataStatus};
        String selectFiled = "job,joblevel,jobgrade,jobclass,jobfamily,jobseq";
        DynamicObject result = helper.queryOne(selectFiled, qFilters);
        logger.info("hrpi-->getPositionInfo-->result:{}", (Object)result);
        return result;
    }

    public List<Map<String, Object>> listPersonAttachs(long personId, String metaString) {
        logger.info("ExternalService-->listPersonAttachs->personId:{},metaString:{}", (Object)personId, (Object)metaString);
        List resultList = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)LIST_PERSON_ATTACHS, (Object[])new Object[]{personId, metaString});
        logger.info("ExternalService-->listPersonAttachs->personId:{},metaString:{}", (Object)personId, (Object)metaString);
        return resultList;
    }

    public long getHrBuByBusinessType(Map<Long, Set<Long>> orgId2BusinessType, Long businessObjectId) {
        Map map = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, 1180L, businessObjectId});
        return CollectionUtils.isEmpty((Map)map) ? 0L : ((DynamicObject)map.get("hrbu")).getLong("id");
    }

    public DynamicObject[] queryEmpJobLevelByEmpIds(Set<Long> idSet) {
        return HRPI_EMPJOBREL_HELPER.queryOriginalArray("id,employee,jobgrade,joblevel", new QFilter[]{new QFilter("employee", "in", idSet), new QFilter("datastatus", "=", (Object)"1"), new QFilter("iscurrentversion", "=", (Object)"1")});
    }

    public Map<Long, Object> queryBosUserBy(Map<String, List<Long>> idMaps) {
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        Map dataResult = (Map)result.get("data");
        return dataResult;
    }

    public Map<Long, Map<String, Object>> getUserIdByPersonInfo(Map<String, List<Long>> idMaps) {
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (!CollectionUtils.isEmpty((Map)result) && result.getOrDefault("success", Boolean.FALSE).booleanValue()) {
            return (Map)result.get("data");
        }
        return Maps.newHashMap();
    }

    public Map<String, Object> queryPersonalInfo(Long personId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)"getPersonBaseInfo", (Object[])new Object[]{personId});
    }

    public Map<String, Object> getPerIdByChgRecordId(Long chgRecordId) {
        return (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoByRecordId", (Object[])new Object[]{chgRecordId});
    }

    public Map<String, Object> getEmpentrel(long employeeId) {
        logger.info("IHRPIEmployeeService-->getEmpentrel-->employeeId:{}", (Object)employeeId);
        Map empentrelMap = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIEmployeeService", (String)"getEmpentrel", (Object[])new Object[]{employeeId});
        logger.info("HRApplicationService-->getEmpentrel-->returnMap:{}", (Object)empentrelMap);
        return empentrelMap;
    }

    public Map<String, Object> getPerIdByChgCategoryId(Long chgCategoryId) {
        try {
            logger.info("IHPFSPersonChgService###getChgInfoByRecordId:#chgCategoryId:{}", (Object)chgCategoryId);
            Map returnMap = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoByRecordId", (Object[])new Object[]{chgCategoryId});
            logger.info("IHPFSPersonChgService###getChgInfoByRecordId:#returnData:{}", (Object)returnMap);
            return returnMap;
        }
        catch (Exception exception) {
            logger.error("IHPFSPersonChgService###getChgInfoByRecordId:#chgCategoryId:{};exception:{}", (Object)chgCategoryId, (Object)exception);
            return Maps.newHashMap();
        }
    }

    public Map<String, Object> getChgInfoDetailByRecordId(long recordId) {
        try {
            logger.info("IHPFSPersonChgService###getChgInfoDetailByRecordId:#recordId:{}", (Object)recordId);
            Map returnMap = (Map)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgInfoDetailByRecordId", (Object[])new Object[]{recordId});
            logger.info("IHPFSPersonChgService###getChgInfoDetailByRecordId:#returnData:{}", (Object)returnMap);
            return returnMap;
        }
        catch (Exception exception) {
            logger.error("IHPFSPersonChgService###getChgInfoDetailByRecordId:#recordId:{};exception:{}", (Object)recordId, (Object)exception);
            return Maps.newHashMap();
        }
    }

    public DynamicObject queryPositionById(String selectProperties, Object pkValue) {
        return POSITION_HELPER.queryOne(selectProperties, new QFilter[]{new QFilter("id", "=", pkValue)});
    }

    public DynamicObject queryJobById(String selectProperties, Object pkId) {
        return JOB_HELPER.queryOne(selectProperties, new QFilter[]{new QFilter("id", "=", pkId)});
    }

    public boolean isJobManager(Object pkId) {
        DynamicObject seqDynamic = JOB_SEQ_HELPER.queryOne("standardjobseq", new QFilter[]{new QFilter("id", "=", pkId)});
        if (null == seqDynamic) {
            return false;
        }
        return 1010L == seqDynamic.getLong("standardjobseq.id");
    }

    public DynamicObject queryStdPositionById(String selectProperties, Object pkId) {
        return STD_POSITION_HELPER.queryOne(selectProperties, new QFilter[]{new QFilter("id", "=", pkId)});
    }

    public boolean isManager(Object pkId) {
        DynamicObject dynamicObject = TYPE_HELPER.queryOne("ismanagetype", new QFilter[]{new QFilter("id", "=", pkId)});
        if (null == dynamicObject) {
            return false;
        }
        return "1".equals(dynamicObject.getString("ismanagetype"));
    }

    public DynamicObject empPosOrgRelQueryOneByQFilter(String selectProperties, QFilter[] filters) {
        return HRPI_EMPPOSORGREL.queryOne(selectProperties, filters);
    }

    public DynamicObject[] queryEmpExpOrderByStartDate(String selectProperties, QFilter[] filters) {
        return HRPI_EMPPOSORGREL.queryOriginalArray(selectProperties, filters, "startdate desc");
    }

    public void updateConsumeMsgInfo(DynamicObject coordinationLog) {
        HashMap consumeMsgMap = Maps.newHashMap();
        consumeMsgMap.put("msgCenterId", coordinationLog.getLong("msgcenterbo"));
        consumeMsgMap.put("msgsubno", coordinationLog.get("msgsubno"));
        consumeMsgMap.put("businessTypeId", 106010L);
        consumeMsgMap.put("handleStatus", "1");
        consumeMsgMap.put("consumeMsg", ResManager.loadKDString((String)"\u5168\u90e8\u6210\u529f", (String)"ExternalService_1", (String)"tdc-tdcs-business", (Object[])new Object[0]));
        HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"updateConsumeMsgInfo", (Object[])new Object[]{consumeMsgMap});
    }

    public DynamicObject[] queryFormInfoByFormIds(List<String> formIds, List<String> cardNumber) {
        HRBaseServiceHelper formMeta = new HRBaseServiceHelper("bos_formmeta");
        QFilter qFilter = new QFilter("id", "in", formIds);
        if (!CollectionUtils.isEmpty(cardNumber)) {
            qFilter.and(new QFilter("number", "in", cardNumber));
        }
        return formMeta.query("id,number,inheritpath,type", new QFilter[]{qFilter});
    }

    public Map<Long, DynamicObject> queryPersonInfoByIds(String selectProperties, List<Long> ids) {
        QFilter idsQFilter = new QFilter("id", "in", ids);
        DynamicObject[] result = HRPI_PERSON_HELPER.query(selectProperties, new QFilter[]{idsQFilter});
        Map<Long, DynamicObject> map = Arrays.stream(result).collect(Collectors.toMap(p -> p.getLong("id"), p -> p, (v1, v2) -> v1));
        return map;
    }

    public Map<String, Object> getChgPersonNumberInfo(long recordId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("isChange", Boolean.FALSE);
        result.put("success", Boolean.TRUE);
        Map<String, Object> returnData = this.getChgInfoDetailByRecordId(recordId);
        if (CollectionUtils.isEmpty(returnData) || !((Boolean)returnData.get("success")).booleanValue()) {
            result.put("success", Boolean.FALSE);
            return result;
        }
        Map data = (Map)returnData.get("data");
        List chgInfoData = (List)data.get("data");
        List personDataList = chgInfoData.stream().filter(p -> p.get("entity").equals("hrpi_person")).collect(Collectors.toList());
        if (personDataList == null || personDataList.size() < 2) {
            return result;
        }
        Optional<Map> oldDataOptional = personDataList.stream().filter(p -> p.get("chgmode").equals("1")).findFirst();
        Optional<Map> newDataOptional = personDataList.stream().filter(p -> p.get("chgmode").equals("0")).findFirst();
        if (!oldDataOptional.isPresent() || !newDataOptional.isPresent()) {
            return result;
        }
        Map oldDataMap = oldDataOptional.get();
        Map newDataMap = newDataOptional.get();
        Long oldPersonId = Long.valueOf(oldDataMap.get("idafter").toString());
        Long newPersonId = Long.valueOf(newDataMap.get("idafter").toString());
        List<Long> personIds = Arrays.asList(oldPersonId, newPersonId);
        Map<Long, DynamicObject> personInfoMap = this.queryPersonInfoByIds("id,number", personIds);
        DynamicObject oldPersonInfo = personInfoMap.get(oldPersonId);
        DynamicObject newPersonInfo = personInfoMap.get(newPersonId);
        String oldNumber = "";
        String newNumber = "";
        if (!Objects.isNull(oldPersonInfo) && !Objects.isNull(newPersonInfo)) {
            oldNumber = oldPersonInfo.getString("number");
            newNumber = newPersonInfo.getString("number");
            if (newNumber != null && !newNumber.equals(oldNumber)) {
                result.put("isChange", Boolean.TRUE);
            }
        }
        result.put("oldPersonId", oldPersonId);
        result.put("newPersonId", newPersonId);
        result.put("oldNumber", oldNumber);
        result.put("newNumber", newNumber);
        return result;
    }

    public Map<String, Object> getChgPersonNameInfo(long recordId) {
        String afterName;
        Long afterPersonId;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("isChange", Boolean.FALSE);
        result.put("success", Boolean.TRUE);
        Map<String, Object> returnData = this.getChgInfoDetailByRecordId(recordId);
        if (CollectionUtils.isEmpty(returnData) || !((Boolean)returnData.get("success")).booleanValue()) {
            result.put("success", Boolean.FALSE);
            return result;
        }
        Map data = (Map)returnData.get("data");
        List chgInfoData = (List)data.get("data");
        List personDataList = chgInfoData.stream().filter(p -> p.get("entity").equals("hrpi_person")).collect(Collectors.toList());
        if (personDataList == null) {
            return result;
        }
        Optional<Map> optional = personDataList.stream().filter(p -> p.get("chgmode").equals("1")).findFirst();
        if (!optional.isPresent()) {
            return result;
        }
        Map changeDataMap = optional.get();
        Long beforePersonId = Long.valueOf(changeDataMap.get("vidbefore").toString());
        Map<Long, DynamicObject> personInfoMap = this.queryPersonInfoByIds("id,name", Arrays.asList(beforePersonId, afterPersonId = Long.valueOf(changeDataMap.get("idafter").toString())));
        String beforeName = personInfoMap.get(beforePersonId).getString("name");
        if (beforeName.equals(afterName = personInfoMap.get(afterPersonId).getString("name"))) {
            return result;
        }
        result.put("isChange", Boolean.TRUE);
        result.put("beforePersonId", beforePersonId);
        result.put("afterPersonId", afterPersonId);
        result.put("beforeName", beforeName);
        result.put("afterName", afterName);
        return result;
    }

    public static List<Map<String, Object>> listDataEmpOrgrels(List<Long> depempIds) {
        return (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIDepempService", (String)"listDataEmpOrgrels", (Object[])new Object[]{depempIds});
    }

    public static DynamicObject[] queryPosTypeByIds(String selectProperties, List<Long> pkIds) {
        QFilter idsFilter = new QFilter("id", "in", pkIds);
        return HBSS_POS_TYPE_HELPER.query(selectProperties, new QFilter[]{idsFilter});
    }

    public static Map<Long, Boolean> checkEmployeeStatusByPersonIds(List<Long> personIds) {
        logger.info("checkEmployeeStatusByPersonIds###personIds:{}", personIds);
        Map map = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIEmployeeService", (String)"checkEmployeeStatus", (Object[])new Object[]{personIds, "person"});
        logger.info("checkEmployeeStatusByPersonIds###result:{}", (Object)map);
        return map;
    }

    public static DynamicObject[] getJobSeq(List<Long> ids) {
        return JOB_SEQ_HELPER.loadDynamicObjectArray(ids.toArray());
    }

    public static DynamicObject[] getJobLevel(List<Long> ids) {
        return HBJM_JOB_LEVEL_HELPER.loadDynamicObjectArray(ids.toArray());
    }

    public static DynamicObject[] getDiploma(List<Long> ids) {
        return HBSS_DIPLOMA_HELPER.loadDynamicObjectArray(ids.toArray());
    }

    public static Map<String, Object> listPersonServiceAge(List<Long> employeeIds) {
        Map result;
        HashMap params = Maps.newHashMap();
        params.put("sign", "employee");
        params.put("signList", employeeIds);
        params.put("dateTime", new Date());
        logger.info("ExternalService###listPersonServiceAge###params:{}", (Object)params);
        try {
            result = (Map)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)"IHRPIEmployeeService", (String)"listPersonServiceAge", (Object[])new Object[]{params});
        }
        catch (Exception exception) {
            logger.error("ExternalService###listPersonServiceAge###error:", (Throwable)exception);
            return Maps.newHashMap();
        }
        logger.info("ExternalService###listPersonServiceAge###result:{}", (Object)result);
        return Optional.ofNullable(result).orElseGet(HashMap::new);
    }

    public static List<Map<String, Object>> listEmpposorgrels(Long personId) {
        List result;
        logger.info("ExternalService###listEmpposorgrels###personId:{}", (Object)personId);
        try {
            result = (List)HRMServiceHelper.invokeHRMPService((String)HRPI, (String)IHRPI_PERSON_SERVICE, (String)"listEmpposorgrels", (Object[])new Object[]{personId});
        }
        catch (Exception exception) {
            logger.error("ExternalService###listEmpposorgrels###error:", (Throwable)exception);
            return Lists.newArrayList();
        }
        logger.info("ExternalService###listEmpposorgrels###result:{}", (Object)result);
        return Optional.ofNullable(result).orElseGet(ArrayList::new);
    }

    public static DynamicObject[] getEmpPosOrgRelByEmployee(Long employeeId) {
        String selectProperties = "adminorg,isprimary,employee,startdate,enddate,businessstatus,person,company,position,job,stdposition,apositiontype,depemp";
        DynamicObject[] empPosArr = HRPI_EMPPOSORGREL.query(selectProperties, new QFilter[]{new QFilter("employee", "=", (Object)employeeId), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("businessstatus", "=", (Object)"1")});
        return empPosArr;
    }
}

