/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application.external;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HrpiService {
    private static final Log logger = LogFactory.getLog(HrpiService.class);
    private static final HRBaseServiceHelper HRPI_EMPPOSORGREL = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final HRBaseServiceHelper HRPI_PERSERLEN_HELPER = new HRBaseServiceHelper("hrpi_perserlen");
    private static final HRBaseServiceHelper HRPI_EDU_EPX_HELPER = new HRBaseServiceHelper("hrpi_pereduexp");
    private static final QFilter IS_CURRENT_VERSION = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
    private static final QFilter EFFECTIVE_DATA_STATUS = new QFilter("datastatus", "=", (Object)"1");

    public Map<Object, Object> checkEmployeeStatus(List<Object> empIds) {
        Map employeeStatus = Maps.newHashMap();
        try {
            employeeStatus = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"checkEmployeeStatus", (Object[])new Object[]{empIds, "employee"});
        }
        catch (Exception exception) {
            logger.error("IHRPIEmployeeService###checkEmployeeStatus#throw-exception,empId:{}", empIds, (Object)exception);
        }
        logger.info("IHRPIEmployeeService###checkEmployeeStatus#empId:{},personBaseInfoMap:{}", empIds, (Object)employeeStatus);
        return employeeStatus;
    }

    public Map<String, Object> getPersonInfo(long personId) {
        Map personBaseInfoMap = Maps.newHashMap();
        try {
            personBaseInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonInfo", (Object[])new Object[]{personId});
        }
        catch (Exception exception) {
            logger.error("IHRPIPersonService###getPersonInfo#throw-exception,personId:{}", (Object)personId, (Object)exception);
        }
        return personBaseInfoMap;
    }

    public Map<String, Object> getPersonBaseInfo(Long personId) {
        Map personBaseInfoMap = Maps.newHashMap();
        try {
            personBaseInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonBaseInfo", (Object[])new Object[]{personId});
        }
        catch (Exception exception) {
            logger.error("IHRPIPersonService###getPersonBaseInfo#throw-exception,personId:{}", (Object)personId, (Object)exception);
        }
        logger.info("IHRPIPersonService###getPersonBaseInfo#personId:{},personBaseInfoMap:{}", (Object)personId, (Object)personBaseInfoMap);
        return personBaseInfoMap;
    }

    public List<Map<String, Object>> listPersonInfo(List<Long> personIds) {
        List listPersonInfo = Lists.newArrayList();
        try {
            listPersonInfo = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listPersonInfos", (Object[])new Object[]{personIds});
        }
        catch (Exception exception) {
            logger.error("IHRPIPersonService###listPersonInfos#throw-exception,personIds:{}", personIds, (Object)exception);
        }
        return listPersonInfo;
    }

    public Map<String, Object> getEmployee(Long employeeId) {
        Map resultMap = Maps.newHashMap();
        try {
            resultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployee", (Object[])new Object[]{employeeId});
        }
        catch (Exception exception) {
            logger.info("IHRPIEmployeeService###getEmployee#throw-exception#employeeId:{}", (Object)employeeId, (Object)exception);
        }
        logger.info("IHRPIEmployeeService###getEmployee#employeeId:{} ,resultMap:{}", (Object)employeeId, (Object)resultMap);
        return resultMap;
    }

    public List<Map<String, Object>> listEmployees(List<Long> employeeIds) {
        List resultList = Lists.newArrayList();
        try {
            resultList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployees", (Object[])new Object[]{employeeIds});
        }
        catch (Exception exception) {
            logger.info("IHRPIEmployeeService###listEmployees#throw-exception#employeeIds:{}", employeeIds, (Object)exception);
        }
        logger.info("IHRPIEmployeeService###listEmployees#employeeIds:{} ,resultList:{}", employeeIds, (Object)resultList);
        return resultList;
    }

    public List<Map<String, Object>> listBatchPropPersonAttach(List<Long> personIds, String selectProps, QFilter qFilter, String attachEntityName) {
        List resultList = Lists.newArrayList();
        try {
            resultList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPropPersonAttachs", (Object[])new Object[]{personIds, selectProps, qFilter, attachEntityName});
        }
        catch (Exception exception) {
            logger.info("IHRPIEmployeeService###listBatchPropPersonAttachs#throw-exception#employeeIds:{}", personIds, (Object)exception);
        }
        logger.info("IHRPIEmployeeService###listBatchPropPersonAttachs#personIds:{} ,resultList:{}", personIds, (Object)resultList);
        return resultList;
    }

    public List<Map<String, Object>> listBatchPropEmployeeAttach(List<Long> employeeIds, String selectProps, String attachEntityName) {
        return (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchPropEmployeeAttachs", (Object[])new Object[]{employeeIds, selectProps, attachEntityName});
    }

    public Map<String, Object> getPersonInfoByUserId(long userId) {
        Map personBaseInfoMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelIdByUserId", (Object[])new Object[]{userId});
        if (CollectionUtils.isEmpty((Map)personBaseInfoMap) || !((Boolean)personBaseInfoMap.get("success")).booleanValue()) {
            logger.info("===========HrpiService=== call getPersonInfoByUserId fail===");
            return new HashMap<String, Object>();
        }
        Map dataMap = (Map)personBaseInfoMap.get("data");
        if (CollectionUtils.isEmpty((Map)dataMap)) {
            logger.info("===========HrpiService=== getPersonInfoByUserId data is null===");
            return new HashMap<String, Object>();
        }
        return dataMap;
    }

    public List<Map<String, Object>> getMainChargeInfoByOrg(long orgId) {
        List mainChargeInfoList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getMainChargeByOrg", (Object[])new Object[]{Lists.newArrayList((Object[])new Long[]{orgId})});
        return mainChargeInfoList;
    }

    public Map<Long, List<Map<String, Object>>> getDirectSuperiorByDepempId(long depEmpLongId) {
        long startTime = System.currentTimeMillis();
        Map directSuperiorList = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getDirectSuperiorByDepempId", (Object[])new Object[]{Lists.newArrayList((Object[])new Long[]{depEmpLongId})});
        logger.info("invoke hrpi getDirectSuperiorByDepempId param:{},return data :{} ,cost time:{}", new Object[]{Lists.newArrayList((Object[])new Long[]{depEmpLongId}), directSuperiorList, System.currentTimeMillis() - startTime});
        return directSuperiorList;
    }

    public List<Long> getUserIdByPersonInfo(Map<String, List<Long>> idMaps) {
        Map userInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (!((Boolean)userInfo.get("success")).booleanValue()) {
            return new ArrayList<Long>();
        }
        HashMap personMap = (HashMap)userInfo.get("data");
        ArrayList<Long> idList = new ArrayList<Long>();
        Iterator iterator = personMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map value = (Map)iterator.next().getValue();
            List userList = value.entrySet().stream().filter(x -> "user".equals(x.getKey())).map(a -> (Long)a.getValue()).collect(Collectors.toList());
            idList.addAll(userList);
        }
        return idList;
    }

    public DynamicObject getEmpJobRelByEmpProsel(String fields, long pkValue) {
        return HRPI_EMPPOSORGREL.queryOne(fields, (Object)pkValue);
    }

    public DynamicObject perSerLenQueryOne(String selectProperties, QFilter[] qFilters) {
        return HRPI_PERSERLEN_HELPER.queryOne(selectProperties, qFilters);
    }

    public DynamicObject queryEducation(String selectProperties, QFilter[] qFilters) {
        return HRPI_EDU_EPX_HELPER.queryOne(selectProperties, qFilters);
    }

    public double getCompanyServiceAge(long employeeId) {
        QFilter idFilter = new QFilter("employee", "=", (Object)employeeId);
        DynamicObject dynamicObject = this.perSerLenQueryOne("firstjoincomdate,joinworktime,adjustcomtime", new QFilter[]{idFilter});
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return 0.0;
        }
        Date firstJoinComDate = dynamicObject.getDate("firstjoincomdate");
        BigDecimal diffCom = firstJoinComDate == null ? BigDecimal.ZERO : BigDecimal.valueOf(HRDateTimeUtils.dateDiff((String)"yyyy", (Date)firstJoinComDate, (Date)new Date()));
        BigDecimal comSerCount = dynamicObject.getBigDecimal("adjustcomtime").add(diffCom);
        return comSerCount.setScale(2, 4).doubleValue();
    }

    public DynamicObject getEducation(long personId) {
        QFilter personIdFilter = new QFilter("person", "=", (Object)personId);
        QFilter highestEduFilter = new QFilter("ishighestdegree", "=", (Object)"1");
        DynamicObject eduDy = this.queryEducation("id,education,education.name", new QFilter[]{personIdFilter, highestEduFilter});
        return eduDy;
    }

    public String getPrimaryEmposorgrels(long personId) {
        List mainChargeInfoList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listEmpposorgrels", (Object[])new Object[]{personId});
        if (CollectionUtils.isEmpty((Collection)mainChargeInfoList)) {
            return "";
        }
        String deptId = mainChargeInfoList.stream().filter(charInfo -> "1".equals(charInfo.get("isprimary"))).map(charInfo -> charInfo.get("depemp_id")).findFirst().orElse("").toString();
        return deptId;
    }

    public Map<String, Object> getSupervisor(long personId) {
        String deptId = this.getPrimaryEmposorgrels(personId);
        logger.info("deptId ====" + deptId);
        HashMap<String, Object> dsrMap = new HashMap<String, Object>(16);
        if (HRStringUtils.isEmpty((String)deptId)) {
            return dsrMap;
        }
        Map<Long, List<Map<String, Object>>> dirextSuperMap = this.getDirectSuperiorByDepempId(Long.parseLong(deptId));
        logger.info("direct ====" + dirextSuperMap);
        if (CollectionUtils.isEmpty(dirextSuperMap)) {
            return dsrMap;
        }
        List<Map<String, Object>> dsrList = dirextSuperMap.get(Long.parseLong(deptId));
        if (CollectionUtils.isEmpty(dsrList)) {
            return dsrMap;
        }
        return dsrList.get(0);
    }

    public List<Long> getUserIdFromPersonId(long personId, String selectType) {
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>(16);
        ArrayList<Long> pids = new ArrayList<Long>();
        pids.add(personId);
        idMaps.put(selectType, pids);
        return this.getUserIdByPersonInfo(idMaps);
    }

    public Map<String, Object> queryPersonInfoByUserIds(List<Long> userIds) {
        Map idMappingMap = Maps.newHashMap();
        try {
            idMappingMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"queryPersonInfoByUserIds", (Object[])new Object[]{userIds});
        }
        catch (Exception exception) {
            logger.error("IHRPIPersonService###queryPersonInfoByUserIds#throw-exception,userId:{}", userIds, (Object)exception);
        }
        logger.info("IHRPIPersonService###queryPersonInfoByUserIds#userId:{},idMappingMap:{}", userIds, (Object)idMappingMap);
        return idMappingMap;
    }

    public Map<String, Object> getPrimaryEmpInfo(Long personId) {
        Map primaryEmpInfo = Maps.newHashMap();
        try {
            primaryEmpInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPrimaryEmpposorgrel", (Object[])new Object[]{personId});
        }
        catch (Exception exception) {
            logger.error("IHRPIPersonService###getPrimaryEmpposorgrel#throw-exception,personId:{}", (Object)personId, (Object)exception);
        }
        logger.info("IHRPIPersonService###getPrimaryEmpposorgrel#personId:{},primaryEmpInfo:{}", (Object)personId, (Object)primaryEmpInfo);
        return primaryEmpInfo;
    }

    public Map<Long, Map<String, Long>> queryPrimaryEmpInfoByEmpIds(List<Long> empIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
        DynamicObject[] primaryEmpInfo = serviceHelper.queryOriginalArray("id,person,employee,adminorg,position,stdposition,job", new QFilter[]{new QFilter("employee", "in", empIds), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("businessstatus", "=", (Object)"1"), new QFilter("isprimary", "=", (Object)"1")});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)primaryEmpInfo.length);
        Arrays.stream(primaryEmpInfo).forEach(item -> {
            HashMap idMapping = Maps.newHashMap();
            idMapping.put("person", item.getLong("person"));
            idMapping.put("adminorg", item.getLong("adminorg"));
            idMapping.put("position", item.getLong("position"));
            idMapping.put("stdposition", item.getLong("stdposition"));
            idMapping.put("job", item.getLong("job"));
            resultMap.put(item.getLong("employee"), idMapping);
        });
        return resultMap;
    }

    public static Map<String, Long> queryPrimaryEmpInfoByEmpId(Long empId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
        DynamicObject primaryEmpInfo = serviceHelper.queryOriginalOne("id,person,employee,adminorg,position,stdposition,job", new QFilter[]{new QFilter("employee", "=", (Object)empId), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("businessstatus", "=", (Object)"1"), new QFilter("isprimary", "=", (Object)"1")});
        HashMap resultMap = Maps.newHashMap();
        if (!Objects.isNull(primaryEmpInfo)) {
            resultMap.put("person", primaryEmpInfo.getLong("person"));
            resultMap.put("adminorg", primaryEmpInfo.getLong("adminorg"));
            resultMap.put("position", primaryEmpInfo.getLong("position"));
            resultMap.put("stdposition", primaryEmpInfo.getLong("stdposition"));
            resultMap.put("job", primaryEmpInfo.getLong("job"));
        }
        return resultMap;
    }

    public Map<Long, List<DynamicObject>> getPrimaryEmpPosOrgRelByPersonIds(String selectProperties, List<Long> personIds) {
        if (CollectionUtils.isEmpty(personIds)) {
            return Collections.emptyMap();
        }
        QFilter personIdsFilter = new QFilter("person.id", "in", personIds);
        QFilter isPrimaryFilter = new QFilter("isprimary", "=", (Object)"1");
        DynamicObject[] empPosArr = HRPI_EMPPOSORGREL.query(selectProperties, new QFilter[]{personIdsFilter, IS_CURRENT_VERSION, EFFECTIVE_DATA_STATUS, isPrimaryFilter}, "startdate DESC");
        if (Objects.isNull(empPosArr) || empPosArr.length == 0) {
            return Collections.emptyMap();
        }
        Map<Long, List<DynamicObject>> result = Arrays.stream(empPosArr).collect(Collectors.groupingBy(p -> p.getLong("person.id")));
        return result;
    }

    public Map<String, Object> listEmpJobRel(List<Long> employeeIds) {
        Map data = Maps.newHashMap();
        try {
            data = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmpJobRel", (Object[])new Object[]{employeeIds});
        }
        catch (Exception exception) {
            logger.error("IHRPIEmployeeService###listEmpJobRel#throw-exception,employeeIds:{}", employeeIds, (Object)exception);
        }
        return data;
    }
}

