/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.application.external;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.tdc.tdcs.bussiness.ServiceFactory;
import kd.tdc.tdcs.bussiness.application.external.HrpiService;
import kd.tdc.tdcs.common.util.UrlBuilder;

public class MessageService {
    private static final Log logger = LogFactory.getLog(MessageService.class);
    private static final HrpiService HRPI_SERVICE = ServiceFactory.getService(HrpiService.class);

    private long sendTemplateMessage(String contentUrl, List<Long> userIds, Long nominateId, String entityNumber, String tempNumber, Long bizDataId, boolean showFastDealBtn) {
        try {
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setTitle("title");
            messageInfo.setBizDataId(nominateId);
            messageInfo.setEntityNumber(entityNumber);
            messageInfo.setTemplateNumber(tempNumber);
            messageInfo.setType("message");
            if (showFastDealBtn) {
                messageInfo.setContentUrl(contentUrl);
            }
            messageInfo.setUserIds(userIds);
            Long senderId = RequestContext.get().getCurrUserId();
            messageInfo.setSenderId(senderId);
            messageInfo.setSendTime(new Date());
            return MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        }
        catch (Exception e) {
            logger.error("send mess eror === " + e.getCause());
            return 0L;
        }
    }

    public static void retractMessage(Long messageId) {
        MessageCenterServiceHelper.retractMessage((Long)messageId);
    }

    public void deleteMessage(Long messageId) {
        ArrayList<Long> msgIds = new ArrayList<Long>();
        msgIds.add(messageId);
        MessageCenterServiceHelper.deleteMessage(msgIds);
    }

    public void sendTemplateMessageWithPersonId(Long pkId, Long personId, String billEntity, String messageTemplate) {
        ArrayList<Long> newIdList = new ArrayList<Long>(2);
        newIdList.add(personId);
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>();
        idMaps.put("person", newIdList);
        List<Long> handlerIdList = HRPI_SERVICE.getUserIdByPersonInfo(idMaps);
        String contentSelfUrl = new UrlBuilder(UrlService.getDomainContextUrl(), billEntity).setParameter("formPkId", String.valueOf(pkId)).builder();
        this.sendTemplateMessage(contentSelfUrl, handlerIdList, pkId, billEntity, messageTemplate, pkId, true);
    }

    public void sendTemplateMessage(Long pkId, Long handlerId, String billEntity, String messageTemplate) {
        String contentSelfUrl = new UrlBuilder(UrlService.getDomainContextUrl(), billEntity).setParameter("formPkId", String.valueOf(pkId)).builder();
        long[] hangdlerIdArr = new long[]{handlerId};
        List<Long> handlerIdList = Arrays.stream(hangdlerIdArr).boxed().collect(Collectors.toList());
        this.sendTemplateMessage(contentSelfUrl, handlerIdList, pkId, billEntity, messageTemplate, pkId, true);
    }

    public void sendTemplateMessageNoBtn(Long pkId, Long handlerId, String billEntity, String messageTemplate) {
        String contentSelfUrl = new UrlBuilder(UrlService.getDomainContextUrl(), billEntity).setParameter("formPkId", String.valueOf(pkId)).builder();
        long[] hangdlerIdArr = new long[]{handlerId};
        List<Long> handlerIdList = Arrays.stream(hangdlerIdArr).boxed().collect(Collectors.toList());
        this.sendTemplateMessage(contentSelfUrl, handlerIdList, pkId, billEntity, messageTemplate, pkId, false);
    }

    public void sendTemplateMessage(Long pkId, List<Long> handlerIdList, String billEntity, String messageTemplate) {
        String contentSelfUrl = new UrlBuilder(UrlService.getDomainContextUrl(), billEntity).setParameter("formPkId", String.valueOf(pkId)).builder();
        this.sendTemplateMessage(contentSelfUrl, handlerIdList, pkId, billEntity, messageTemplate, pkId, true);
    }

    public void sendTemplateMessageNoBtn(Long pkId, List<Long> handlerIdList, String billEntity, String messageTemplate) {
        String contentSelfUrl = new UrlBuilder(UrlService.getDomainContextUrl(), billEntity).setParameter("formPkId", String.valueOf(pkId)).builder();
        this.sendTemplateMessage(contentSelfUrl, handlerIdList, pkId, billEntity, messageTemplate, pkId, false);
    }
}

