/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.certgroup.service;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class CertGroupDomainService {
    private static final HRBaseServiceHelper CERT_HELPER = new HRBaseServiceHelper("tdcs_certificationgroup");
    private static final HRBaseServiceHelper CERT_USER_HELPER = new HRBaseServiceHelper("tdcs_certmemberentry");

    public DynamicObject queryOne(Long certGroupId) {
        return CERT_HELPER.queryOne("name,certcentry,certcentry.person,certcentry.ctteeper,certcentry.certmbrrole,certcentry.source", (Object)certGroupId);
    }

    public DynamicObject[] queryCerGroup(String selectProperties, QFilter[] qFilters) {
        return HRStringUtils.isEmpty((String)selectProperties) ? CERT_HELPER.loadDynamicObjectArray(qFilters) : CERT_HELPER.query(selectProperties, qFilters);
    }

    public void saveCerGroup(DynamicObject[] cerGroups) {
        CERT_HELPER.save(cerGroups);
    }

    public DynamicObject[] queryCerGroupByAnyFilter(String selectProperties, List<QFilter> filters) {
        return CERT_HELPER.query(selectProperties, filters.toArray(new QFilter[0]));
    }

    public DynamicObjectCollection queryCertMember(Long certGroupId) {
        DynamicObject certGroupDyObject = CERT_HELPER.queryOne("certcentry,certcentry.person,certcentry.ctteeper", (Object)certGroupId);
        if (certGroupDyObject == null) {
            return new DynamicObjectCollection();
        }
        return certGroupDyObject.getDynamicObjectCollection("certcentry");
    }

    public int getCertGroupSize(Long id) {
        QFilter qFilter = new QFilter("commorg", "=", (Object)id);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{qFilter, statusFilter};
        return CERT_HELPER.count("tdcs_certificationgroup", filters);
    }

    public DynamicObject[] getCertGroupSizes(List<Long> ids) {
        QFilter qFilter = new QFilter("commorg", "in", ids);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{qFilter, statusFilter};
        return CERT_HELPER.query("id,commorg", filters);
    }

    public void quit(Long employeeId, List<Long> quitCommOrgUserBoIds) {
        QFilter personFilter = new QFilter("certcentry.person", "=", (Object)employeeId);
        QFilter commOrgUserFilter = new QFilter("certcentry.ctteeper", "in", quitCommOrgUserBoIds);
        QFilter queryFilter = quitCommOrgUserBoIds.isEmpty() ? personFilter : personFilter.or(commOrgUserFilter);
        HashSet<Long> quitCommOrgUserBoIdSet = new HashSet<Long>(quitCommOrgUserBoIds);
        DynamicObject[] certGroups = CERT_HELPER.query("modifier,modifytime,total,certcentry.person,certcentry.ctteeper,certcentry.userstatus", new QFilter[]{queryFilter});
        Date modifyTime = new Date();
        for (DynamicObject certGroup : certGroups) {
            boolean modified = false;
            DynamicObjectCollection certEntry = certGroup.getDynamicObjectCollection("certcentry");
            for (DynamicObject certRow : certEntry) {
                DynamicObject employee = certRow.getDynamicObject("person");
                DynamicObject commOrgUser = certRow.getDynamicObject("ctteeper");
                String userStatus = certRow.getString("userstatus");
                if ("0".equals(userStatus)) continue;
                if (employee != null && employeeId.equals(employee.getLong("id"))) {
                    certRow.set("userstatus", (Object)"0");
                    modified = true;
                }
                if (commOrgUser == null || !quitCommOrgUserBoIdSet.contains(commOrgUser.getLong("id"))) continue;
                certRow.set("userstatus", (Object)"0");
                modified = true;
            }
            if (!modified) continue;
            int total = certEntry.stream().mapToInt(row -> "1".equals(row.getString("userstatus")) ? 1 : 0).sum();
            certGroup.set("total", (Object)total);
            certGroup.set("modifytime", (Object)modifyTime);
            certGroup.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        CERT_HELPER.updateDatas(certGroups);
    }

    public void quit(Map<Long, List<Long>> certmemberMap) {
    }

    private void batchesQuit(Long commOrgId, List<Long> ctteeperIds) {
        QFilter commOrgFilter = new QFilter("commorg", "=", (Object)commOrgId);
        QFilter commOrgUserFilter = new QFilter("certcentry.ctteeper", "in", ctteeperIds);
        DynamicObject[] certGroups = CERT_HELPER.query("modifier,modifytime,total,certcentry.ctteeper,certcentry.userstatus", new QFilter[]{commOrgFilter, commOrgUserFilter});
        Date modifyTime = new Date();
        for (DynamicObject certGroup : certGroups) {
            boolean modified = false;
            DynamicObjectCollection certEntry = certGroup.getDynamicObjectCollection("certcentry");
            for (DynamicObject certRow : certEntry) {
                DynamicObject commOrgUser = certRow.getDynamicObject("ctteeper");
                String userStatus = certRow.getString("userstatus");
                if ("0".equals(userStatus) || commOrgUser == null || !ctteeperIds.contains(commOrgUser.getLong("id"))) continue;
                certRow.set("userstatus", (Object)"0");
                modified = true;
            }
            if (!modified) continue;
            int total = certEntry.stream().mapToInt(row -> "1".equals(row.getString("userstatus")) ? 1 : 0).sum();
            certGroup.set("total", (Object)total);
            certGroup.set("modifytime", (Object)modifyTime);
            certGroup.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        CERT_HELPER.updateDatas(certGroups);
    }

    public DynamicObject[] queryByCtteeperId(String selectProperties, List<Long> ctteeperIds) {
        QFilter qFilter = new QFilter("ctteeper.id", "in", ctteeperIds);
        return CERT_USER_HELPER.query(selectProperties, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryByPersonId(String selectProperties, Long personId) {
        QFilter idFilter = new QFilter("person.person.id", "=", (Object)personId);
        QFilter ctteeperFilter = new QFilter("ctteeper.person.person.id", "=", (Object)personId);
        return CERT_USER_HELPER.query(selectProperties, new QFilter[]{idFilter.or(ctteeperFilter)});
    }

    public DynamicObject[] queryCertGroupEntry(String selectProperties, QFilter[] qFilters) {
        if (HRStringUtils.isEmpty((String)selectProperties)) {
            return CERT_USER_HELPER.loadDynamicObjectArray(qFilters);
        }
        return CERT_USER_HELPER.query(selectProperties, qFilters);
    }
}

