/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.commorguser.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.tdcs.bussiness.domain.commorguser.enums.CommUserStatusEnum;

public class CommOrgUserDomainService {
    private static final String USER_STATUS_QUIT = "00";
    private static final ThreadPool COMM_ORG_USER_NAME_SYN = ThreadPools.newCachedThreadPool((String)"commOrgUserNameSyn", (int)1, (int)10);
    private final HRBaseServiceHelper COMM_ORG_USER_HELPER = new HRBaseServiceHelper("tdcs_commorguser");

    public void checkNameIsChange(Long userId) {
        if (userId == null || userId.equals(0L)) {
            return;
        }
        Runnable runnable = () -> {
            DynamicObject commUser = this.COMM_ORG_USER_HELPER.queryOne("person, name", (Object)userId);
            String name = commUser.getString("name");
            String personName = commUser.getString("person.person.name");
            if (HRStringUtils.isNotEmpty((String)personName) && !HRStringUtils.equals((String)name, (String)personName)) {
                commUser.set("name", (Object)personName);
                this.COMM_ORG_USER_HELPER.updateDatas(Lists.newArrayList((Object[])new DynamicObject[]{commUser}).toArray(new DynamicObject[0]));
            }
        };
        COMM_ORG_USER_NAME_SYN.execute(runnable, RequestContext.get());
    }

    public DynamicObject queryOne(String selectProperties, Object pk) {
        return this.COMM_ORG_USER_HELPER.queryOne(selectProperties, pk);
    }

    public boolean isExists(QFilter[] qFilters) {
        return this.COMM_ORG_USER_HELPER.isExists(qFilters);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] qFilters) {
        return this.COMM_ORG_USER_HELPER.query(selectProperties, qFilters);
    }

    public void updateDatas(List<DynamicObject> successList) {
        this.COMM_ORG_USER_HELPER.updateDatas(successList.toArray(new DynamicObject[0]));
    }

    public DynamicObject[] queryOriginalArray(String selectProperties, QFilter[] qFilters) {
        return this.COMM_ORG_USER_HELPER.queryOriginalArray(selectProperties, qFilters);
    }

    public DynamicObject[] loadDynamicObjectArray(QFilter[] qFilters) {
        return this.COMM_ORG_USER_HELPER.loadDynamicObjectArray(qFilters);
    }

    public int getCommOrgUserSize(Long id) {
        QFilter qFilter1 = new QFilter("comm", "=", (Object)id);
        QFilter qFilter2 = new QFilter("userstatus", "=", (Object)"1");
        QFilter qFilter3 = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter qFilter4 = new QFilter("datastatus", "!=", (Object)"-4");
        QFilter qFilter5 = new QFilter("datastatus", "!=", (Object)"-1");
        QFilter[] filters = new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4, qFilter5};
        return this.COMM_ORG_USER_HELPER.count("tdcs_commorguser", filters);
    }

    public DynamicObject[] getCommOrgUserSizes(List<Long> ids) {
        QFilter qFilter1 = new QFilter("comm", "in", ids);
        QFilter qFilter2 = new QFilter("userstatus", "=", (Object)"1");
        QFilter qFilter3 = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter qFilter4 = new QFilter("datastatus", "!=", (Object)"-4");
        QFilter qFilter5 = new QFilter("datastatus", "!=", (Object)"-1");
        QFilter[] filters = new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4, qFilter5};
        return this.queryOriginalArray("id,comm", filters);
    }

    public DynamicObject[] getPersonCommWorkRecord(Long personId) {
        QFilter qFilter = new QFilter("person", "=", (Object)personId);
        QFilter qFilter1 = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.COMM_ORG_USER_HELPER.query("comm,commrole,userstatus,roleentry.roleeffectdate,roleentry.roleexpiredate", new QFilter[]{qFilter, qFilter1});
    }

    public DynamicObject[] getNeedEffectCommUser(Date effectDate) {
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter userStatusFilter = new QFilter("userstatus", "=", (Object)CommUserStatusEnum.WAIT_EFFECT.getNumber());
        QFilter effectDateFilter = new QFilter("joindate", "<=", (Object)effectDate);
        return this.COMM_ORG_USER_HELPER.query("name,comm,userstatus,quitdate,joindate,datastatus,brled,bsled,roleentry,roleentry.roleeffectdate,roleentry.roleexpiredate", new QFilter[]{currentVersionFilter, userStatusFilter, effectDateFilter});
    }

    public DynamicObject[] getNeedExpireCommUser(Date expireDate) {
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter userStatusFilter = new QFilter("userstatus", "=", (Object)CommUserStatusEnum.EFFECT.getNumber());
        QFilter lessExpireDateFilter = new QFilter("quitdate", "<=", (Object)expireDate);
        QFilter nullExpireDateFilter = new QFilter("quitdate", "is null", (Object)expireDate);
        QFilter expireDateFilter = lessExpireDateFilter.or(nullExpireDateFilter);
        return this.COMM_ORG_USER_HELPER.loadDynamicObjectArray(new QFilter[]{currentVersionFilter, userStatusFilter, expireDateFilter});
    }

    public List<Long> quit(Long employeeId, Long bosUserId, Date quitDate) {
        QFilter queryFilter;
        QFilter statusFilter = new QFilter("userstatus", "!=", (Object)"0");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        QFilter personFilter = new QFilter("person", "=", (Object)employeeId);
        if (bosUserId != null && bosUserId != 0L) {
            QFilter bosUserFilter = new QFilter("bosuser", "=", (Object)bosUserId);
            queryFilter = personFilter.or(bosUserFilter);
        } else {
            queryFilter = personFilter;
        }
        DynamicObject[] commOrgUsers = this.COMM_ORG_USER_HELPER.loadDynamicObjectArray(new QFilter[]{queryFilter, statusFilter, isCurrentVersionFilter});
        if (commOrgUsers == null || commOrgUsers.length == 0) {
            return Collections.emptyList();
        }
        ArrayList quitCommOrgUserBoIds = Lists.newArrayListWithCapacity((int)commOrgUsers.length);
        ArrayList hisVersionParamBos = Lists.newArrayListWithCapacity((int)commOrgUsers.length);
        Date modifyTime = new Date();
        for (DynamicObject commOrgUser : commOrgUsers) {
            commOrgUser.set("userstatus", (Object)USER_STATUS_QUIT);
            commOrgUser.set("quitdate", (Object)quitDate);
            commOrgUser.set("datastatus", (Object)EnumHisDataVersionStatus.TEMP.getStatus());
            commOrgUser.set("brled", (Object)modifyTime);
            commOrgUser.set("modifytime", (Object)modifyTime);
            commOrgUser.set("modifier", (Object)RequestContext.get().getCurrUserId());
            this.handleRoleEntry(commOrgUser, quitDate);
            HisVersionParamBo paramBo = new HisVersionParamBo();
            paramBo.setEntityNumber("tdcs_commorguser");
            paramBo.setHisDyns(new DynamicObject[]{commOrgUser});
            hisVersionParamBos.add(paramBo);
            quitCommOrgUserBoIds.add(commOrgUser.getLong("boid"));
        }
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setEffImmediately(true);
        hisVersionParamListBo.setAtomicTrans(true);
        hisVersionParamListBo.setMainEntityNumber("tdcs_commorguser");
        hisVersionParamListBo.setListHisVersionParamBo((List)hisVersionParamBos);
        HisModelController hisModelController = new HisModelController();
        hisModelController.batchHisVersionChange(hisVersionParamListBo);
        return quitCommOrgUserBoIds;
    }

    private void handleRoleEntry(DynamicObject commOrgUser, Date quitDate) {
        Date now = new Date();
        DynamicObjectCollection roleEntry = commOrgUser.getDynamicObjectCollection("roleentry");
        for (DynamicObject row : roleEntry) {
            Date roleExpireDate = row.getDate("roleexpiredate");
            if (roleExpireDate != null && roleExpireDate.getTime() <= now.getTime()) continue;
            row.set("roleexpiredate", (Object)quitDate);
        }
    }

    public void saveComUserHisVersion(List<HisVersionParamBo> hisVersionParamBos, String mainEntityNumber) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setEffImmediately(true);
        hisVersionParamListBo.setAtomicTrans(true);
        hisVersionParamListBo.setMainEntityNumber(mainEntityNumber);
        hisVersionParamListBo.setListHisVersionParamBo(hisVersionParamBos);
        HisModelController hisModelController = new HisModelController();
        hisModelController.batchHisVersionChange(hisVersionParamListBo);
    }

    public DynamicObject[] queryCommUserWorkExpByEmployeeIdAndEffectDate(Long employeeId, Date startEffectDate, Date endEffectDate) {
        QFilter employeeFilter = new QFilter("person", "=", (Object)employeeId);
        QFilter startEffectDateFilter = new QFilter("roleentry.roleeffectdate", ">=", (Object)startEffectDate);
        QFilter endEffectDateFilter = new QFilter("roleentry.roleeffectdate", "<=", (Object)endEffectDate);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.COMM_ORG_USER_HELPER.query("id,comm,roleentry,roleentry.commrole,roleentry.roleeffectdate,roleentry.roleexpiredate,userstatus", new QFilter[]{employeeFilter, startEffectDateFilter, endEffectDateFilter, currentVersionFilter}, "roleentry.roleeffectdate desc,roleentry.roleexpiredate desc");
    }

    public void updateNumberByPersonId(String number, Long personId) {
        QFilter employeeFilter = new QFilter("person.person.id", "=", (Object)personId);
        QFilter diffNumberQFilter = new QFilter("number", "!=", (Object)number);
        DynamicObject[] result = this.COMM_ORG_USER_HELPER.query("id,number", new QFilter[]{employeeFilter, diffNumberQFilter});
        if (result.length > 0) {
            Arrays.stream(result).forEach(p -> p.set("number", (Object)number));
            this.COMM_ORG_USER_HELPER.save(result);
        }
    }

    public void updateNameByPersonId(String name, Long personId) {
        QFilter employeeFilter = new QFilter("person.person.id", "=", (Object)personId);
        QFilter diffNameQFilter = new QFilter("name", "!=", (Object)name);
        DynamicObject[] result = this.COMM_ORG_USER_HELPER.query("id,name", new QFilter[]{employeeFilter, diffNameQFilter});
        if (result.length > 0) {
            Arrays.stream(result).forEach(p -> p.set("name", (Object)name));
            this.COMM_ORG_USER_HELPER.save(result);
        }
    }

    public DynamicObject[] queryByPersonId(String selectProperties, Long personId) {
        QFilter employeeFilter = new QFilter("person.person.id", "=", (Object)personId);
        DynamicObject[] result = this.COMM_ORG_USER_HELPER.query(selectProperties, new QFilter[]{employeeFilter});
        return result;
    }
}

