/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.tdcs.bussiness.domain.coordination.service;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class CoordTaskLogDomainService {
    private static final HRBaseServiceHelper REPOSITORY = new HRBaseServiceHelper("tdcs_coordtasklog");

    public void log(DynamicObject taskDy, String exectype, String taskInfo) {
        ORM orm = ORM.create();
        long id = orm.genLongId(REPOSITORY.getEntityName());
        DynamicObject logDy = REPOSITORY.generateEmptyDynamicObject();
        logDy.set("id", (Object)id);
        logDy.set("task", (Object)taskDy);
        logDy.set("taskstatus", (Object)taskDy.getString("taskstatus"));
        logDy.set("exectype", (Object)exectype);
        if (HRStringUtils.isNotEmpty((String)taskInfo)) {
            logDy.set("description", (Object)taskInfo);
        }
        logDy.set("traceid", (Object)RequestContext.get().getTraceId());
        logDy.set("startdate", (Object)taskDy.getDate("startdate"));
        logDy.set("enddate", (Object)taskDy.getDate("enddate"));
        HRBaseUtils.setSysField((DynamicObject)logDy);
        logDy.set("enable", (Object)"1");
        logDy.set("status", (Object)"C");
        REPOSITORY.saveOne(logDy);
    }

    public DynamicObject[] queryLogByTaskNumber(String taskNumber) {
        String selectFields = "task,taskstatus,traceid,exectype,creator,startdate,enddate,description";
        return REPOSITORY.query(selectFields, new QFilter[]{new QFilter("task.number", "=", (Object)taskNumber)}, "enddate desc");
    }
}

